'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbResizeKeySyms __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbResizeKeySyms \- Change the number of symbols bound to a key
.SH SYNOPSIS
.B KeySym * XkbResizeKeySyms
(
.I xkb,
.I key,
.I needed
)
.br
      XkbDescRec * \fIxkb\fP\^;
.br
      int \fIkey\fP\^;
.br
      int \fIneeded\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description to be changed
.TP
.I \- key
keycode for key to modify
.TP
.I \- needed
new number of keysyms required for key
.SH DESCRIPTION
.LP
.I XkbResizeKeySyms 
reserves the space needed for 
.I needed 
keysyms and returns a pointer to the beginning of the new array that holds the 
keysyms. It adjusts the 
.I offset 
field of the 
.I key_sym_map 
entry for the key if necessary and can also change the 
.I syms, num_syms, 
and 
.I size_syms 
fields of 
.I xkb->map 
if it is necessary to reallocate the 
.I syms 
array. 
.I XkbResizeKeySyms 
does not modify either the width or number of groups associated with the key.

If 
.I needed 
is greater than the current number of keysyms for the key, 
.I XkbResizeKeySyms 
initializes all new keysyms in the array to NoSymbol.

Because the number of symbols needed by a key is normally computed as width * 
number of groups, and 
.I XkbResizeKeySyms 
does not modify either the width or number of groups for the key, a discrepancy 
exists upon return from 
.I XkbResizeKeySyms 
between the space allocated for the keysyms and the number required. The unused 
entries in the list of symbols returned by 
.I XkbResizeKeySyms 
are not preserved across future calls to any of the map editing functions, so 
you must update the key symbol mapping (which updates the width and number of 
groups for the key) before calling another allocator function. A call to
.I XkbChangeTypesOfKey 
will update the mapping.

If any allocation errors occur while resizing the number of symbols bound to the 
key, 
.I XkbResizeKeySyms 
returns NULL.
.SH "SEE ALSO"
.BR XkbChangeTypesOfKey (__libmansuffix__),
.BR XkbResizeKeyActions (__libmansuffix__)
.SH NOTES
.LP
A change to the number of symbols bound to a key should be accompanied by a 
change in the number of actions bound to a key. Refer to XkbResizeKeyActions for 
more information on changing the number of actions bound to a key.
