/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.jupyter.core.core.api.actions.NotebookEditorRunActionsHandler;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListenerKt;
import com.intellij.jupyter.core.jupyter.actions.JupyterExecutionData;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterRunner;
import com.intellij.jupyter.core.jupyter.connections.execution.notifier.JupyterCellRunUserNotifier;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAware;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.PopupUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorRunActionsHandler;", "Lcom/intellij/jupyter/core/core/api/actions/NotebookEditorRunActionsHandler;", "<init>", "()V", "runCell", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "runAll", "runAllAbove", "runAllBelow", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterEditorRunActionsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterEditorRunActionsHandler.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterEditorRunActionsHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1563#2:92\n1634#2,3:93\n1761#2,3:96\n*S KotlinDebug\n*F\n+ 1 JupyterEditorRunActionsHandler.kt\ncom/intellij/jupyter/core/jupyter/actions/JupyterEditorRunActionsHandler\n*L\n36#1:92\n36#1:93,3\n44#1:96,3\n*E\n"})
public final class JupyterEditorRunActionsHandler
implements NotebookEditorRunActionsHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public void runCell(@NotNull DataContext dataContext) {
        boolean anyMarkdownCells;
        block14: {
            void $this$mapTo$iv$iv;
            List intervalsToRun;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
            if (editorImpl == null) {
                return;
            }
            EditorImpl editor = editorImpl;
            if (editor.getEditorKind() == EditorKind.DIFF) {
                return;
            }
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
            List selectedCellIntervals = JupyterHelper.INSTANCE.getSelectedIntervals((Editor)editor);
            List list = selectedCellIntervals;
            if (list == null) {
                list = CollectionsKt.listOfNotNull((Object)JupyterHelper.INSTANCE.getHoveredInterval((Editor)editor));
            }
            if ((intervalsToRun = list).isEmpty()) {
                return;
            }
            Iterable $this$map$iv = intervalsToRun;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                NotebookIntervalPointerFactory factory = NotebookIntervalPointerFactory.Companion.get((Editor)editor);
                collection.add(factory.create((NotebookCellLines.Interval)it));
            }
            List intervalPointers = (List)destination$iv$iv;
            JupyterCellRunUserNotifier jupyterCellRunUserNotifier = JupyterCellRunUserNotifier.Companion.get((Editor)editor);
            if (jupyterCellRunUserNotifier != null) {
                jupyterCellRunUserNotifier.setLastCellRunClickPoint(PopupUtilsKt.getBestBalloonPosition((DataContext)dataContext));
            }
            JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project2, intervalPointers, (Editor)editor, jupyterVirtualFile, null, 16, null);
            JupyterNotebook jupyterNotebook = jupyterVirtualFile.getNotebookOrNull();
            Iterable $this$any$iv = intervalPointers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v5 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl;
                    NotebookIntervalPointer it = (NotebookIntervalPointer)element$iv;
                    boolean bl2 = false;
                    if (it.get() == null) {
                        bl = false;
                    } else {
                        NotebookCellLines.Interval interval;
                        JupyterMetadataAware<JsonNode> jupyterMetadataAware = jupyterNotebook;
                        JupyterCellType cellType = jupyterMetadataAware != null && (jupyterMetadataAware = jupyterMetadataAware.getCellOrNull(interval.getOrdinal())) != null ? jupyterMetadataAware.getCellType() : null;
                        bl = cellType == JupyterCellType.MARKDOWN;
                    }
                    if (!bl) continue;
                    v5 = true;
                    break block14;
                }
                v5 = anyMarkdownCells = false;
            }
        }
        if (anyMarkdownCells) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("jupyter.preview.markdown.cell");
        }
    }

    @Override
    public void runAll(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterExecutionData jupyterExecutionData = CellExecutionListenerKt.getJupyterExecutionData(dataContext);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData executionData = jupyterExecutionData;
        Project project = executionData.getProject();
        BackedNotebookVirtualFile jupyterVirtualFile = executionData.getNotebookVirtualFile();
        List<NotebookIntervalPointer> cellPointers = NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)editor);
        JupyterCellRunUserNotifier jupyterCellRunUserNotifier = JupyterCellRunUserNotifier.Companion.get((Editor)editor);
        if (jupyterCellRunUserNotifier != null) {
            jupyterCellRunUserNotifier.setLastCellRunClickPoint(PopupUtilsKt.getBestBalloonPosition((DataContext)dataContext));
        }
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project, cellPointers, (Editor)editor, jupyterVirtualFile, null, 16, null);
    }

    @Override
    public void runAllAbove(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterExecutionData jupyterExecutionData = CellExecutionListenerKt.getJupyterExecutionData(dataContext);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData result = jupyterExecutionData;
        Project project = result.component1();
        Integer cellIndex = result.component2();
        BackedNotebookVirtualFile jupyterVirtualFile = result.component3();
        if (cellIndex == null) {
            return;
        }
        List cellPointers = CollectionsKt.take((Iterable)NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)editor), (int)cellIndex);
        JupyterCellRunUserNotifier jupyterCellRunUserNotifier = JupyterCellRunUserNotifier.Companion.get((Editor)editor);
        if (jupyterCellRunUserNotifier != null) {
            jupyterCellRunUserNotifier.setLastCellRunClickPoint(PopupUtilsKt.getBestBalloonPosition((DataContext)dataContext));
        }
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project, cellPointers, (Editor)editor, jupyterVirtualFile, null, 16, null);
    }

    @Override
    public void runAllBelow(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        JupyterExecutionData jupyterExecutionData = CellExecutionListenerKt.getJupyterExecutionData(dataContext);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData result = jupyterExecutionData;
        Project project = result.component1();
        Integer cellIndex = result.component2();
        BackedNotebookVirtualFile jupyterVirtualFile = result.component3();
        Integer n = cellIndex;
        int firstIndex = n != null ? n : 0;
        List cellPointers = CollectionsKt.drop((Iterable)NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)editor), (int)firstIndex);
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project, cellPointers, (Editor)editor, jupyterVirtualFile, null, 16, null);
    }
}

