/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout.quads;

import com.openhtmltopdf.pdfboxout.quads.Triangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class KongAlgo {
    private static final boolean isDebug = false;
    private final List<Point2D.Float> points = new ArrayList<Point2D.Float>();
    private final List<Point2D.Float> nonconvexPoints;
    private final List<Triangle> triangles;
    private boolean isCw;

    public KongAlgo(List<Point2D.Float> points) {
        for (Point2D.Float point : points) {
            this.points.add(new Point2D.Float(point.x, point.y));
        }
        this.nonconvexPoints = new ArrayList<Point2D.Float>();
        this.triangles = new ArrayList<Triangle>();
        this.calcPolyOrientation();
        this.calcNonConvexPoints();
    }

    private void calcNonConvexPoints() {
        if (this.points.size() <= 3) {
            if (this.points.size() == 3) {
                this.triangles.add(new Triangle(this.points.get(0), this.points.get(1), this.points.get(2)));
            }
            return;
        }
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D.Float p = this.points.get(i);
            Point2D.Float tmp = this.points.get(i + 1);
            Point2D.Float v = new Point2D.Float();
            v.x = tmp.x - p.x;
            v.y = tmp.y - p.y;
            Point2D.Float u = i == this.points.size() - 2 ? this.points.get(0) : this.points.get(i + 2);
            float res = u.x * v.y - u.y * v.x + v.x * p.y - v.y * p.x;
            if (!(res > 0.0f && this.isCw) && (!(res <= 0.0f) || this.isCw)) continue;
            this.nonconvexPoints.add(tmp);
        }
    }

    private void calcPolyOrientation() {
        if (this.points.size() < 3) {
            return;
        }
        int index = 0;
        Point2D.Float pointOfIndex = this.points.get(0);
        for (int i = 1; i < this.points.size(); ++i) {
            if (this.points.get((int)i).x < pointOfIndex.x) {
                pointOfIndex = this.points.get(i);
                index = i;
                continue;
            }
            if (this.points.get((int)i).x != pointOfIndex.x || !(this.points.get((int)i).y > pointOfIndex.y)) continue;
            pointOfIndex = this.points.get(i);
            index = i;
        }
        Point2D.Float prevPointOfIndex = index == 0 ? this.points.get(this.points.size() - 1) : this.points.get(index - 1);
        Point2D.Float v1 = new Point2D.Float(pointOfIndex.x - prevPointOfIndex.x, pointOfIndex.y - prevPointOfIndex.y);
        Point2D.Float succPointOfIndex = index == this.points.size() - 1 ? this.points.get(0) : this.points.get(index + 1);
        float res = succPointOfIndex.x * v1.y - succPointOfIndex.y * v1.x + v1.x * prevPointOfIndex.y - v1.y * prevPointOfIndex.x;
        this.isCw = res <= 0.0f;
    }

    private boolean isEar(Point2D.Float p1, Point2D.Float p2, Point2D.Float p3) {
        if (!this.isConvex(p1, p2, p3)) {
            return false;
        }
        for (Point2D.Float nonconvexPoint : this.nonconvexPoints) {
            if (!Triangle.isInside(p1, p2, p3, nonconvexPoint)) continue;
            return false;
        }
        return true;
    }

    private boolean isConvex(Point2D.Float p1, Point2D.Float p2, Point2D.Float p3) {
        Point2D.Float v = new Point2D.Float(p2.x - p1.x, p2.y - p1.y);
        float res = p3.x * v.y - p3.y * v.x + v.x * p1.y - v.y * p1.x;
        return !(res > 0.0f && this.isCw || res <= 0.0f && !this.isCw);
    }

    private int getIndex(int index, int offset) {
        int newindex = index + offset >= this.points.size() ? this.points.size() - (index + offset) : (index + offset < 0 ? this.points.size() + (index + offset) : index + offset);
        return newindex;
    }

    public void runKong() {
        if (this.points.size() <= 3) {
            return;
        }
        this.triangles.clear();
        int index = 1;
        while (this.points.size() > 3) {
            if (this.isEar(this.points.get(this.getIndex(index, -1)), this.points.get(index), this.points.get(this.getIndex(index, 1)))) {
                this.triangles.add(new Triangle(this.points.get(this.getIndex(index, -1)), this.points.get(index), this.points.get(this.getIndex(index, 1))));
                this.points.remove(this.points.get(index));
                index = this.getIndex(index, -1);
                continue;
            }
            index = this.getIndex(index, 1);
        }
        this.triangles.add(new Triangle(this.points.get(0), this.points.get(1), this.points.get(2)));
    }

    public List<Triangle> getTriangles() {
        return this.triangles;
    }
}

