/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] =
"@(#)trace.c	1.5 07/13/94 CERN CN-SW/DC Frederic Hemmer";
#endif /* not lint */

/* trace.c      General tracing facility                                */

#include <stdio.h>              /* standard input/output definitions    */
#include <varargs.h>            /* variable argument list definitions   */
#if defined(vms)
#include <stdlib.h>             /* General utility definitions          */
#endif /* vms */

#if defined(vms) && defined(__alpha) && defined(COMPILE_NOPREFIX)
#define atoi    DECC$ATOI
#define fflush  DECC$FFLUSH
#define getenv  DECC$GETENV
#endif /* vms && __alpha && COMPILE_NOPREFIX */

static int      trace_initialized = 0;  /* trace initialized flag       */
static int      trace_level = 0;        /* dynamic trace level          */
static int      indent_level = 0;       /* dynamic indentation level    */

#if !defined(vms)
extern  char* getenv();         /* get environment variable             */
#endif /* vms */

/*VARARGS*/

void print_trace(va_alist)    va_dcl
{
	va_list args;           /* arguments                            */
	register char *label;   /* leading label                        */
	register char *format;  /* print format string                  */
	register int level;     /* trace level                          */
	register int i;         /* general purpose index                */

	va_start(args);         /* initialize to beginning of list      */
	level = va_arg(args, int);
	if (trace_level < level) return;
	label = va_arg(args, char *);
	for (i=0; i< level+indent_level ; i++)       {
		fprintf(stdout," "); /* indentation                    */
	}
	fprintf(stdout,"%s: ", label);
	format = va_arg(args, char *);
	(void) vfprintf(stdout, format, args);
	fprintf(stdout,"\n");
	va_end(args);
	fflush(stdout);
}

void    init_trace(name)        /* initialize trace level               */
char    *name;                  /* environment variable name            */
{
	register char    *p;    /* general purpose char. string pointer */

	if (!trace_initialized) {
		if ((p = getenv(name)) != NULL)       {
			if (atoi(p) != 0)       {
				trace_level = atoi(p);
				print_trace(0, "    **** ", "trace level set to %d", trace_level);
			}
		}
		trace_initialized++;
	}
	indent_level++;
}

void    end_trace()             /* end trace level                      */
{
	if (indent_level > 0) indent_level--;
}
