.\" @(#)europen91.ms	1.1 01/15/93
.ad
.ds LH
.ds CH \fB-%-\fR
.ds RH
.B
.TL
Scalable Mainframe Power at Workstation Cost
.AU
J-P. Baud, J. Bunn, F. Cane, F. Hemmer, E. Jagel, G. Lee,
L. Robertson, B. Segal, A. Trannoy, I. Zacharov
.AI
CERN - Computing & Networking Division
Geneva, Switzerland.
.I
ben@cernvax.cern.ch
.R
.AB
Until very recently, big mainframes  were  considered  essential
for  the  provision  of  large-scale  scientific batch computing
services, requiring intensive tape and  file  space  management,
high throughput and maximum reliability.

However, RISC-based workstations have outstripped mainframes  in
CPU  price/performance  by an order of magnitude for some years,
and  workstation-class  disk   systems   have   finally   become
cost-competitive  with mainframe disk storage.  The last missing
elements preventing mainframe replacement by cheaper distributed
systems  have been  the  software  to enhance their (Unix-based)
operating systems, and a powerful  enough networking technology.

Over the last year at CERN, two services have  been  established
to prove  the  feasibility  of  physics  batch  processing using
off-the-shelf   high-end  workstations.   The  initial  service,
called  "HOPE",  uses   a   single   4-CPU   HP-Apollo   DN10000
workstation,  and achieves well over 80% utilization for periods
of many months.  The  second service addresses  the  scalability
issue, using a modest number of heterogeneous workstations on  a
high-speed  network,  connected  and  managed  by   a   portable
distributed set of user-level software.  The CPU, disk, and tape
services are functionally separated, and individually subject to
price-performance   optimization.   This   system   is   already
comparable in CPU capacity to  the  full  CERN  computer  center
(including   a  Cray  X-MP/48  and  an  IBM  3090-600E), and  is
scalable to several times that size.

The system is called  the
"Scalable Heterogeneous Integrated FaciliTy" or "SHIFT".
.AE
.NH 1
Introduction
.LP
Until quite recently, say five years ago, UNIX was considered to be limited
in scope to "small" computer systems, whereas "big mainframes" running
serious amounts of scientific/engineering problems would run only
proprietary operating systems. There were good reasons for this state
of affairs, primarily the lack of important system features in the UNIXes
of that period. To cite the most crucial: lack of acceptable FORTRAN; lack
of a batch scheduler subsystem; lack of magnetic tape handling and scheduling
features for a multiple job stream; lack of management and backup features
for very large disk file systems; lack of serious user accounting features.
.LP
The first computer manufacturers to remedy some or all of these shortcomings
were Amdahl (UTS) and Cray (UNICOS). The presence of a Cray X-MP/48 system
running UNICOS at CERN since early 1988, and the joint development work that
CERN carried out with Cray on the enhancement of UNICOS around that time,
proved to us that the addition of "big mainframe features" to UNIX was not
only possible but actually straightforward.
.LP
Over the same five-year period we have witnessed an extraordinary surge in
the CPU power and price-performance of workstation-class systems,
and over the last year or two a less
spectacular but just as significant advance in the price-performance of
workstation-class disk systems.
Thus it has recently become possible to think of providing "mainframe
computer power" at workstation cost; the major question to be answered was
"how?".
.LP
Certain groups in the High Energy Physics (HEP) community have pursued the
idea of "computer farms", taking advantage of one basic characteristic
of their computing load: it is presented in units of work called "events"
that are largely independent of each other and can be processed by a set of
uncoupled or loosely-coupled parallel processors.
In the early days, such processors were often special-purpose, but recently
UNIX workstations with RISC CPU's have been used in farms. Some farms also
explored the use of heterogeneous elements, including mixtures of UNIX and
VMS systems.
.LP
However, computer farms were
usually just simple task-dispatching systems, lacking the full robustness,
flexibility
and operability of a mature batch system. As relatively special-purpose
systems they could generate impressive performance over limited periods
but required considerable attention and support from their users in order
to be properly exploited. In particular, they usually needed to be "fed"
their data in a non-automatic fashion from a mainframe or other separate
data storage facility.
.NH 1
What is "Mainframe Power"?
.NH 2
What is "CERN"?
.LP
CERN is the European Laboratory for Particle Physics, a collaboration
between 15 European member states to carry out fundamental research
in the physics of very high energy particle interactions.
This research uses very large accelerators, in conjunction with extremely
complex detectors and chains of data reduction hardware and software.
CERN's facilities are not restricted to member-state physicists but
are also open to the world-wide physics community. CERN's users normally
operate in "collaborations", each of which will carry out a given
set of experiments and typically consist of 50-200 physicists from 5-20
universities in 2-10 countries. Around the latest (and largest) CERN
accelerator, known as LEP, there are four such large collaborations
with the names ALEPH, OPAL, L3 and DELPHI; much of the work
described in this paper was carried out in conjunction with OPAL.
.NH 2
CERN's Mainframes
.LP
Currently CERN's central computing service consists of four major
elements:
.sp 1
.TS
tab(#), box, center;
cb | s |s
c | c | c
l | c | c
l | c | c.
CERN - Central Mainframes
=
Mainframe#CPU(CERN Units)#Disk(GBytes)
_
Cray X/MP-48  #32 # 50
IBM 3090-600E #39 #250
Siemens 7890  #13 #  5
Vax 9000-410  # 9 # 50
=
TOTAL:        #93 #355
.TE
.LP
Note that a "CERN CPU Unit" is equivalent to an IBM 370/168,
a Vax 8600, or about 4 Vax 11/780's. Note also that only \fBscalar\fR
CPU power is compared in this paper, as HEP problems are not very
susceptible to vectorization.
.NH 2
LEP's Computing Requirements
.LP
Each LEP collaboration records its physics measurements on magnetic tape,
and requires that this data be processed (sometimes repeatedly) in
various "offline" modes to extract the physics results that are published.
Each collaboration also generates large quantities of \fIsimulated\fR
physics data, plus \fIreconstructed\fR data from partial analysis steps.
The total quantity of such recorded data for 1991 will be 20 Terabytes,
mostly held on about 100,000 IBM 3480 cartridges. Occasional access
to the whole of this vast data store, together with frequent access to
a few hundred Gigabytes of it, must be provided by any computer system
proposed for its reduction or analysis.
.LP
The requirements estimated for LEP data reduction (in 1991)
amount to 100 CERN Units and 200 Gigabytes of online disk storage,
whereas only 40 CERN Units and 50 Gigabytes of central mainframe
capacity have been made available to LEP
experiments. The LEP collaborations have therefore equipped themselves
with additional private computing facilities to the extent they could.
However, the quantity of data that will arrive from LEP in future years
will completely swamp the computing resources now available,
and exceed any extensions that are affordable at current mainframe prices.
.NH 1
The "HOPE" Project
.LP
In mid-1989, CERN's Computing & Networking Division and the OPAL
physics collaboration made a proposal to
HP/Apollo for a joint project to develop a reliable batch service for
physics production computing on an HP/Apollo DN10000 system with four
tightly-coupled \fBPrism\fR RISC processors and 4 Gigabytes of disk space.
CERN benchmark codes show that each such CPU is equivalent to between
4 and 5 CERN Units; in what follows we rate a 4-CPU system
conservatively at 16 Units.
The resulting project was named the "H-P Opal Physics Environment"
(or "HOPE").
.NH 2
Goals
.LP
The "HOPE" project's goals were as follows:
.IP \(bu
\fIAchieve "mainframe-class" service quality overall\fR
.br
.IP \(bu
\fIPort and run realistic physics production codes\fR
.br
.IP \(bu
\fIPort and develop the public domain batch system NQS\fR
.br
.IP \(bu
\fIProvide IBM 3480 and Exabyte magnetic tape support\fR
.br
.IP \(bu
\fIEstablish high-speed access to a central data robot\fR
.br
.IP \(bu
\fIIntegrate HOPE operation and accounting into CERN central services\fR
.br
.IP \(bu
\fILater expand service to manage multiple clones\fR
.br
.NH 2
Timetable
.LP
The DN10000 machine for the "HOPE" project was delivered to CERN in
January 1990. The first steps taken were to set up the environment for
CERN HEP physics computing, including installation of the CERN Program
Library and other local utilities.
Physics users from the large LEP collaborations OPAL and L3 were then
allowed to get familiar with the system and port their applications.
.LH
The public domain version of NQS, a batch system for the UNIX
environment, was ported to the DN10000 in early May, 1990.  Accounting
procedures were established by mid-May at which time the batch facility was
officially opened to the public.  In June, an
FDDI connection was installed, enabling faster access to 
data on Cray disks via NFS and ftp.  Over the summer
months, the accounting scripts were improved and work began on providing
local tape support software.
.LP
In September, the HOPE1 service was integrated into the main 
Computer Center operation.  24-hour operator surveillance together
with a file backup program were initiated. System and user accounting
were also merged with those of the Cray, IBM and DEC central computers.
.LP
In early October, an 8mm Exabyte unit was installed on the HOPE1
workstation.  Production analysis of data stored on 8mm tapes began
shortly thereafter.  In mid-November, dual IBM 3480 compatible 
tape drives (STK 4280) were installed on HOPE1.  Work is now
in progress to provide a
complete set of software library routines for support of locally 
attached tape units. Also in November, NQS job submission scripts for VMS and
VM/CMS platforms were written, and a distributed version of NQS which
provides for intelligent load-sharing across a network of NQS machines 
was developed.
.NH 2
Results
.LP
Over the last seven months of 1990, the HOPE1 workstation delivered an
average of 69% of its available CPU cycles. Over
the last three and a half months of 1990
this availability figure was 84%, with only 12% of available
CPU time going idle; the mean time between failure
was 8 days, the mean time between interruptions 4.5 days and
the mean time to repair 30 minutes.
These figures fully attain the project's goals, in fact exceeding typical
experience with the central mainframe batch systems at CERN.
The total CPU delivered from September 1990 to mid-January 1991 was 39700
CERN Unit/hours, equal to 29% of the CERN IBM3090-600E and Cray X-MP/48
combined.
.LP
The batch work on HOPE1 has been primarily submitted by physics users
running simulation, reconstruction and analysis jobs.
HOPE1 has also served
the CERN Program Library with approximately 400 CERN Unit hours for
interactive code development and debugging.  The "HOPE"
project has attracted a wide interest at the CERN Computer Center,
within the broad community of CERN physicists, and  at other HEP
institutes around the world.
.NH 1
The "SHIFT" Project
.LP
While the early results of HOPE1 were extremely encouraging,
amply confirming
the feasibility of running a high-quality batch service on a workstation,
the service still provided less than 20 CERN CPU Units, and well under 10
GigaBytes of disk space. Simply cloning HOPE1 would not provide an
\fBintegrated\fR solution offering
\fBhundreds\fR rather than \fBtens\fR
of CERN CPU Units and  disk Gigabytes. A much more ambitious set of goals
was drawn up for a new project, named the "\fBScalable Heterogeneous
Integrated FaciliTy\fR", or "\fBSHIFT\fR".
.NH 2
Goals
.LP
.IP \(bu
\fIProvide an INTEGRATED system of CPU, disk and tape servers
capable of supporting a large-scale physics batch service\fR
.br
.IP \(bu
\fIThe system must be constructed from HETEROGENEOUS but OPEN system
components, to retain flexibility towards new technology and products\fR
.br
.IP \(bu
\fIThe system must be SCALABLE, both to small sizes for
individual collaborations/small institutes,
or upwards to at least twice the current size of the CERN computer center\fR
.br
.IP \(bu
\fIThe architecture should also be capable of supporting interactive
physics applications\fR
.br
.IP \(bu
\fIThe batch service quality should be at least as good as
mainframe batch quality\fR
.br
.IP \(bu
\fIThe batch system must operate in a distributed environment, using a
single set of queues for each class of CPU servers, and a unified
priority scheduling scheme\fR
.br
.IP \(bu
\fIAutomated disk file space control to be provided, including a tape
staging service\fR
.br
.IP \(bu
\fISupport for 3480-compatible cartridge tapes as well as Exabyte tapes
must be provided, including access
to the CERN automatic cartridge-mounting robot\fR
.br
.IP \(bu
\fISHIFT operation and accounting to be integrated into
the CERN central computer services\fR
.br
.NH 2
Architecture
.LP
The SHIFT system consists of sets of
\fICPU servers, disk servers and tape staging servers\fR, with
\fIdistributed software\fR which is
responsible for managing the disk space, moving data between tape and
disk, locating staged files, batch scheduling and accounting.
The main motivations in choosing this design, which stresses
separation of function, are
\fBsimplicity, flexibility\fR, and the
ability to \fBoptimize\fR the various components for
their specific functions.
.LP
The servers are interconnected by two networks: the
\fIbackplane\fR,
a very fast network used for optimized special purpose
data transfer,
and the \fIsecondary network\fR,
used for control, operations and general purpose
file access. The backplane is connected to the site's general
purpose network infrastructure by means of an \fIIP router\fR,
thus providing file and batch services
to workstations distributed throughout CERN with the
same functionality (though with lower performance) as the services
available to systems connected directly to the backplane.
.NH 2
Strategy & Feasibility
.LP
The strategy adopted with the above architecture involves \fIstaging\fR
the very large offline physics data sets upon demand between their
magnetic tape "homes" and the fast SHIFT online disks,
permitting them to be accessed via the \fIbackplane\fR by any of the
SHIFT CPU's. The staging process is performed automatically,
efficiently, and in as transparent
a manner as possible for a physics user.
.LP
However, the multiple transits of these large data sets across the SHIFT
backplane produce a potential system bottleneck. Calculations,
supported by a detailed simulation of the SHIFT design, showed that
backplanes built using conventional LAN's would not be adequate:
for a moderate size system of 100 CERN CPU Units, consuming 20 KBytes/sec.
of physics data per CPU Unit per second,
we computed peak backplane rates approaching 18 MBytes/sec. Additionally,
to keep the number of SHIFT components for this system to a manageable number
(e.g. 3 tape servers, 3 CPU servers and 6 disk servers)
we required peak per-server backplane rates of around 3 MBytes/sec.
Even if these estimates are for I/O intensive jobs,
they are very revealing: 3 MBytes/sec. interface rates are
far beyond Ethernet and currently just attainable on FDDI at the price
of a full RISC CPU for protocol processing.
This led us to another unexpected conclusion: with conventional LAN's,
\fIthe associated amount of protocol processing\fR
was shown to absorb \fIan unacceptable fraction\fR of SHIFT's CPU resources.
.NH 2
The Backplane
.LP
To permit SHIFT to handle a balanced load, including I/O intensive work,
the solution found for the backplane is a proprietary hub-based
network called \fBUltraNet\fR. This provides a switched total sustained
bandwidth of over 100 MBytes/second, per-interface sustained rates of
between 3  and 12 MBytes/second, and built-in protocol processing
with particular efficiency for stream-type applications. The associated
CPU load of an Ultra-connected node is under 10% of that used by current FDDI
implementations, while the application interface is completely standard
(TCP/IP stream sockets). UltraNet hardware interfaces exist for most of
the currently desirable SHIFT components. Finally, an IP gateway exists to
connect an UltraNet backbone to external conventional LAN's.
.NH 3
Fast Remote File Access
.LP
SHIFT supports two modes of file access between its CPU and disk servers:
.IP \(bu
transparent access using NFS; this also applies to files external to
SHIFT.
.br
.IP \(bu
very high performance access
using \fIRemote File Access\fR routines operating across the backplane
(preferentially), or other available socket-based transport services.
A \fIRemote File Access Library\fR, must be used explicitly
by applications wishing to benefit from this high performance, low
overhead facility. Both C and FORTRAN library calls are supported.
A \fIRemote File Access server\fR process runs
on every SHIFT disk server.
.br
.NH 2
File Base and File Pools
.LP
The SHIFT file space is organized as a series of logical \fIpools\fR.
A SHIFT disk pool is a set of UNIX file systems on one or more
disk servers. Each of these file systems is mounted by NFS on every
CPU server, using a convention for the names of the mount points which
ensures that files may be referred to by the same UNIX
pathname on all CPU, disk and tape server nodes in a SHIFT configuration.
.LP
As mentioned above, the SHIFT file space is
intended principally for \fIphysics data\fR files.
The pools of data files are \fImanaged\fR by
special SHIFT software utilities, under user and system control.
A distinction
is made between such data files and \fIuser files\fR
(programs, scripts, source code, etc.).
.NH 3
User Files
.LP
User files normally reside on remote file systems, but
if they are of general interest (e.g. library files) they could reside
on SHIFT servers.
(CPU servers automatically mount both the SHIFT and any
remote file systems constituting the user file base).
Apart from optional
file quotas, implemented using standard UNIX facilities,
no special SHIFT management is done for user files.
.NH 3
Physics Data Files
.LP
SHIFT utilities manage the SHIFT data file pools,
allocating files within pools, locating previously staged files on
behalf of users, moving data between magnetic tape and disk, and
performing garbage collection within each pool.
Each staged disk file consists of a copy of all or part of an existing tape,
or of data which will eventually be written to a pre-defined file
on a specific tape.
.LP
Pools may be \fIpublic\fR
or \fIprivate\fR for accounting purposes;  \fIpermanent\fR and
\fItemporary\fR pools are also distinguished.
Temporary files are eventually
deleted by a garbage collector using a "least-recently-used"
algorithm to maintain adequate free space within the system, but
a user may specify that the file should be deleted at the end of
a job if it is known that it will not be re-used.
Files in permanent pools
are not subject to automatic garbage collection.
.NH 2
SHIFT System Components
.LP
The SHIFT system software has been implemented as a set of separate
components in the UNIX spirit. These are the \fIDisk Pool
Manager\fR, the \fITape Copy Scheduler\fR and the \fIBatch Scheduler\fR,
which in turn rely on the
\fITape Allocator\fR and  \fIRemote Tape Copy\fR
utilities, together with the Remote File Access routines.
The user interface is via a small set of \fISHIFT Commands\fR.
.NH 3
Disk Pool Manager
.LP
The Disk Pool Manager (DPM) allocates files to pools,
creates files and associated directories, locates existing files,
deletes files on request and performs garbage collection on temporary
pools. The DPM user interface is through the
\fIsfget, sfrm, sfsh\fR commands, which are described below.
.LP
An important component of the Disk Pool Manager is the
\fITable Manager\fR, which maintains static and dynamic configuration
information. It is responsible
for locating SHIFT files, making disk pool selection
decisions and serializing access to the data when necessary.
In the initial implementation
the Table Manager is centralized,
but the design permits functions to be distributed
in later versions, if necessary for performance or reliability reasons.
In general the data used by the Table Manager
can be recreated in the event
of a serious failure of the node on which it executes.
.NH 3
Tape Copy Scheduler
.LP
The Tape Copy Scheduler organizes the copying of data between disk files
and magnetic tapes. On request from a user through a \fItpread\fR
or \fItpwrite\fR
command, it selects an appropriate tape server depending on
the device type required, location of the tape and current tape activity.
It then initiates
a tape copy using the SHIFT  \fIcptpdsk\fR or \fIcpdsktp\fR program
on the tape server node. The Tape Copy
Scheduler informs the user when the operation is complete, queues
concurrent requests for the same tape, and deals with error recovery.
The \fItpread\fR and \fItpwrite\fR commands are described below.
.NH 3
Remote Tape Copy
.LP
The \fIcptpdsk\fR and \fIcpdsktp\fR commands copy data
from tape to disk or disk to tape, respectively.
They execute on the computer to which the
tape unit is attached, but can access a local or remote disk file, normally
using the Remote File Access system.
These commands are described below.
.NH 3
Tape Allocation and Control
.LP
The remote tape copy programs use the facilities available
on the local machine
to allocate a tape unit, mount the tape, and handle labels.
These facilities are generally provided in the form of
a \fItape daemon\fR in conjunction with a \fItape driver\fR, and
a user interface. For example under
UNICOS (which is used as a SHIFT tape server at CERN)
the user interface is called \fItpmnt\fR.
SHIFT user commands permit the passing of certain arguments directly to
the tpmnt interface.
.NH 3
Batch Scheduler and Accounting
.LP
The batch scheduler used by SHIFT is the \fINetwork Queueing System (NQS)\fR,
originally developed
for NASA and which is now in the public domain.
Although NQS is an important facility used by SHIFT, it is entirely
independent of it. CERN has extended NQS to cater for
centralized batch queues which feed clusters of
CPU servers.
.LP
A number of utilities are also available to provide resource consumption
reports and controls. 
.NH 3
SHIFT User Interface
.LP
.NH 4
Disk Pools and Files
.LP
The pathname used to access files uniformly over a SHIFT configuration
is referred to as the \fInfs_pathname\fR, and has the form:
.LP
\fB/shift/\fR\fIshift_node/file_system_name/group/user/\fBusppn\fR
.LP
e.g. \fB/shift/shift1/data1/c3/les/tape23\fR
.LP
Here \fIusppn\fR is a "user_supplied_partial_pathname":
this may be a single term (e.g. tape23),
or it may include directories (e.g. period21/run7/file26).
Except for \fIusppn\fR, all other components of the \fInfs_pathname\fR
are managed for the user by SHIFT via the following user commands.
.LP
The \fBsfget\fR command is used to allocate a file. This is a call to the
Disk Pool Manager (DPM), which selects a suitable file system within the
pool specified by the user, creates any necessary directory structure within
the file system, creates an empty file, and echoes its full
\fInfs_pathname\fR. Thus the \fInfs_pathname\fR returned by:
.LP
\fBsfget -p opalpool  period21/run7/file26\fR
.LP
might have the form:
.LP
\fB/shift/shd01/data3/c3/les/period21/run7/file26\fR
.LP
This name may be used by the user in subsequent commands, such as
\fItpread\fR or a call to a FORTRAN program. The user does not need to
remember the full pathname between sessions, as a 
subsequent sfget call using the same \fIusppn\fR
will locate the file and return the full pathname again.
The sfget command  sets the UNIX command status to indicate if the file was
created (status value 1) or simply located (value 0). This
may be useful in shell scripts.
If the user only wishes to locate the file if it is present, but not to
create it, he may use the \fB-k\fR option of sfget:
.LP
\fBsfget -p opalpool -k period21/run8/file41\fR
.LP
This example will return a status of 0, and echo the
\fInfs_pathname\fR
if the file exists
in the specified pool, but merely return a status of 1 if it does not exist.
.LP
A user may list ("show") all of his files in a particular pool by means of the
\fBsfsh\fR command.
.LP
e.g.  \fBsfsh -p opalpool ls period21/run7\fR
.LP
This \fIsfsh\fR command performs a \fIcd\fR to the user's directory
in each of the file systems in the pool in turn, issuing the \fIls\fR command
in each of these directories. (The \fIsfsh\fR command is actually much
more general, and can issue any shell command specified by the user
in each of the file systems in the pool).
.LP
Files are removed from SHIFT pools by means of the \fBsfrm\fR command.
.LP
e.g.  \fBsfrm -p opalpool period21/run7/file26\fR
.LP
In addition to the \fB-p\fR option, specifying the disk pool to be used,
all of the DPM commands support \fB-g\fR and \fB-u\fR options,
which allow the
caller to specify the group and user associated with the file. By default
these are the group and user names of the user who issues the command.
.NH 4
File Access
.LP
Once a file has been created or located by the the Disk Pool Manager,
and the user knows the full nfs_pathname, it may be used
exactly like any other file. For example, suppose that we have a program
called \fIgendata\fR which writes to FORTRAN Unit 10. We can allocate a
file and connect it to the program as follows:
.LP
 \fBln -s `sfget sample45` fort.10
 gendata\fR
.LP
The first line uses \fIsfget\fR to generate the full pathname for the
file, and creates a logical link to it called \fIfort.10\fR
in the current directory.
(FORTRAN automatically connects Logical Unit 10 to any file
named \fIfort.10\fR).
Normally, however, the SHIFT Remote File Access System (RFAS) will be used to
access these files, in order to obtain the best possible performance.
The RFAS routines are callable by the user, and have also been incorporated
into certain popular CERN Program Library packages.
In order to connect a file to RFAS, the \fBassign\fR command
would be used. In fact, assign sets up a connection for both RFAS and
for FORTRAN. The above example becomes:
.LP
 \fBassign `sfget sample45` 10
 gendata\fR
.NH 4
File Staging and Tape-Disk Copying
.LP
As mentioned above, users often need to stage their data
files to and from tape; on a typical mainframe job control commands are
provided for this. SHIFT provides  \fBstagein\fR and  \fBstageout\fR
commands in the form of a shell scripts that simply issues calls to the SHIFT
commands \fIsfget\fR, \fIassign\fR, \fItpread\fR and \fItpwrite\fR.
This approach is again in the UNIX spirit: taking these scripts as examples,
individual users can develop their own scripts to customize their particular
staging requirements or develop their own file and tape handling techniques.
.NH 2
SHIFT Project Status
.LP
The configuration of the pilot SHIFT system in the CERN computer
center is as follows:
.sp 1
.TS
tab(#), box, center;
cb | s |s |s
c | c | c |c
l | c | c |c
l | c | c |c.
CERN - Pilot SHIFT System
=
Node Type#Name#CPU(CERN Units)#Disk(GBytes)
_
Apollo DN10K  #hope1 #16 #  4
Apollo DN10K  #hope2 #16 #  5
Apollo DN10KTX#hope3 #32 #  5
SGI 340S      #shift1#24 #  1
SGI 320S      #shd01 #12 # 20
DEC5000/200   #shd03 # 4 # 10
DEC5000/200   #shd04 # 4 # 10
=
TOTAL:        #      #108# 55
.TE
.LP
The addition of further system types to this pilot configuration
is under review, including IBM RS6000 and Sun machines.
No difficulties are foreseen in
incorporating these or other UNIX based systems to SHIFT.
.LP
The system is running a wide variety of physics production jobs, and has
confirmed our belief that such an approach is entirely practical and
economic for many physics computing applications. We intend to develop
the SHIFT approach to handle interactive as well as batch applications,
and work has already begun in this direction.
.NH 1
Trademarks
.LP
\fBUltraNet\fR is a trademark of Ultra Corporation.
\fBPrism\fR is a trademark of HP-Apollo.
\fBUNICOS\fR is a trademark of Cray Research Inc.
\fBUTS\fR is a trademark of Amdahl Corp.
\fBVax\fR and \fBVMS\fR are trademarks of Digital Equipment Corp.
\fBVM/CMS\fR is a trademark of IBM Corp.
