/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)dosfrm.c	3.6 10/15/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <shift_types.h>
#include <strutil.h>
#include <parser.h>
#include <table.h>
#include <dpmutil.h>

/*
 *  Do sfrm
 *
 *  INPUT
 *	pool		pool name
 *	pathuid		uid of the user whose home directory is in the nfs-pathname
 *	clientuid	the uid of the user calling sfrm
 *	verbose		verbose mode
 *	filename	the file to remove
 *	atomic		atomic/noatomic flag
 *
 *  RETURN
 *	EXFND		
 *	EXNFND
 *	EXPERM
 *	EXSYS
 *	EXOPT
 */
int dosfrm(pool,pathuid,clientuid,filename,atomic,msg)
char *pool;
int pathuid;
int clientuid;
char *filename;
boolean atomic;
char *msg;
{
  int nofs;
  poolfs_t *poolfs	= NULL;
  scanp_t *scan		= NULL;
  int length		= 0;
  user_t client,user;
  int clientgid,pathgid;
  int found,perm,error;
  int reply,idx;

 /*
  *  Get the group ids
  */
    if ( getgroupids(clientuid,&clientgid,client,pathuid,&pathgid,user) < 0 )
        return(EXSYS);

 /*
  *  Build the nfs-path list
  */
    if ( (reply = getnfspaths(pool,pathuid,-1,&nofs,&poolfs)) != 1 ) return(reply);

 /*
  *  Scan the shift disk pool
  */
    if ( scandiskpool(0,clientuid,pathuid,pathgid,filename,nofs,poolfs,&scan,atomic,&length) < 0 )
	return(EXSYS);

 /*
  *  Scan the shift disk pool structure
  */
    found = -1;
    perm = -1;
    error = -1;

    for (idx=0; idx<nofs; idx++) {

#if defined( CREATMP )
     /*
      *  Remove the temporary file
      */
	if ( scan[idx].tmp > 0 ) remove_file(scan[idx].p_tmp);
#endif

     /*
      *  Remove the shift file
      */
	switch ( scan[idx].file ) {
	    case -1 :
	    case 0 :
		break;
	    case 1 :
	     /*
	      *  'found' points to the most recent copy of file
	      */
		if ( found < 0 || scan[found].stat.st_mtime > scan[idx].stat.st_mtime )
		    found = idx;
	     /*
	      *  'perm' points to the last copy of file leading on authorization failure
	      */
		if ( !scan[idx].perm )
		    perm = idx;
		else
	     /*
	      *  'error' points to the last copy of file leading on remove failure
	      */
		if ( (scan[idx].error = remove_file(scan[idx].p_file)) < 0 ) {
		    error = idx;
		    scan[idx].scerrno = errno;
		}
	} /* switch - is_file_there() reply */
    }

 /*
  *  No file was found
  */
    if ( found == -1 ) {
	vperror(0,"File <%s> not found in pool <%s>",filename,pool);
	setgid(clientgid);
	setuid(clientuid);
	return(EXNFND);
    }

 /*
  *  Print the last copy of file leading on an authorization failure
  */
    if ( perm != -1 ) {
	if ( get_userbyid(client,clientuid,NULL) < 0 )
	    sprintf(client,"uid %d",clientuid);
	vperror(0,"You (%s) are not authorized to remove <%s>",
		client,
		scan[perm].p_file);
	return(EXPERM);
    }

 /*
  *  Print the last copy of file leading on a remove failure
  */
    if ( error != -1 ) {
	vperror(0,"Can't remove <%s>: %s",scan[error].p_file,strerror(scan[error].scerrno));
	return(EXSYS);
    }

 /*
  *  Return the nfs-pathname of the most recent file removed
  */
    strcpy(msg,scan[found].p_file);
    setgid(clientgid);
    setuid(clientuid);
    return(EXFND);
}
