.\"@(#)dpm.man	3.4 09/29/94 CERN-SW/DC Fabrizio Cane
.\ Copyright (C) 1992 by CERN/CN/SW/DC
.\ All rights reserved
.\"
.nh
.TH DPM l "20/10/92"
.SH NAME
sfget sfrm sfsh \- Disk Pool Manager (DPM)
.SH SYNOPSIS
.B sfget
.B "  "\-help
\ | [
.BI \-p " poolname"
] [
.BI \-u " name"
] [
.BI \-s " value"
] [
.B \-l
] [
.B \-k
] [
.B \-t
] [
.B \-r
] 
.br
             [
.BI \-link "path"
] [
.B \-q
]
.B filename
.br
.B sfrm
.B "  "\-help
\ | [
.BI \-p " poolname"
] [
.BI \-u " name"
] [
.BI \-v
] [
.BI \-link "path"
]
.B filename
.br
.B sfsh
.B "   "\-help
] [
.BI \-p " poolname"
] [
.BI \-u " name"
] [
.BI \-g " name"
] [
.BI \-c
] [
.BI \-r
] [
.BI \-v
] 
.br
             [
.BI \-s
] [
.BI \-d
] 
.BR command " [ " arguments " ]"
.br
.SH DESCRIPTION
These commands provide an interface to the 
.I shift disk pool management 
(DPM) system. The commands are issued by users on a 
.I shift cpu server. 
.B sfget 
creates a file in a disk pool, or finds a file which has already been created. 
.B sfrm 
deletes a file from a disk pool.
.B sfsh 
issues a shell command in each file system of a disk pool.
.br
.LP
The commands can be executed either locally (
.B local mode
) or on a remote host (
.B remote mode
).
In the latter case the sfget and sfrm are forwarded to the sfdpmd(1) daemon 
while sfsh selects the rshell option.
Moreover sfget can be executed in either the 
.B atomic 
or 
.BR "noatomic mode" "."
When more than one sfget are issued in the same time with the same pool name, 
the same user name and filename and the associated file doesn't exist and the look 
option is not used then the atomic
mode garantee ( if the underlaying configuration is correct ) that all sfget 
echo the same nfs-pathname (i.e only one copy of the associated file is created).
The mode is selected by mean of the item
.BR SFGETMODE " in the category " DPM " ( see sfsyntax(1) )."
.br
.SH OPTIONS
.TP
.B \-help 
.br
to show the available options and a brief description ( sfoptions(1) ).
.TP
.B filename
.br
The filename parameter normally specifies a 
.I user_supplied_partial_pathname
which is associated with a disk pool ( see pool option ) and a user name ( see user
option ). This partial pathname is
used to search for an existing copy of the file within the disk pool. The partial
pathname will be appended to a 
.IR shift "-generated"
path to form an 
.I nfs-pathname 
( see the user guide ). The partial pathname may include
directory names. If the file is created the directories will also be created if
necessary. 
.B sfget
echos on the standard output the nfs-pathname of the file unless the quiet option is
used. 
.B sfrm 
echos the nfs-pathname of the file if the verbose option is used.
.br
.TP
.BR \-(p)ool " name"
to specify the shift disk pool to be used. A default pool name can be provided in the
shift configuration by mean of the item 
.BR DEFPOOL " in the category " DPM " ( see sfsyntax(1) )."
.TP
.BR \-(u)ser " name"
to specify the user name to be used when searching for the file (sfegt and sfrm) or
executing the shell command (sfsh). The default is the 
name of the user issuing the dpm command. This option also implies a group name, that of
the user.
.TP
.BR \-(g)roup " name"
to specify the group name to be used when executing the shell command.
.TP 
.BR \-(s)ize " value"
to specify the anticipated size of the file. The value is a positive integer
optionally followed by a unit character that can be either M ( megabytes ) or K
( kilobytes ). A default value can be provided in the shift configuration by mean of
the item
.BR DEFSIZE " in the category " DPM " ( see sfsyntax(1) )."
The default unit character is M.
.br
.TP
.B \-(l)ook " ( " -k " )"
to specify that the file should not be created. Thus if the file doesn't exist 
an error is returned. The old name of this option is -k.
.TP
.B \-(r)emove
.br
to specify that an existing files should first be deleted.
.TP
.B \-(t)est 
.br
to specify that the file should not be created by sfget. The former name of this option is "table". This is not the same as for the
-look option because in this case if the file doesn't exist a valid nfs-pathname is 
returned.
This is useful when the file has to be created by the user issuing the command. 
For example ( let be oldname a existing file in the shift disk pool test and newname 
a non-existing file ) :
.br
.B "mv -i `sfget -p test -l oldname`  `sfget -p test -t -s 0 newname`"
.br
does not ask for a confirmation while it would do if the table option wasn't used 
because the file newname would have been created by the sfget.
.br
.TP
.B \-(q)uiet
.br
to specify that the nfs-pathname should not be echoed.
.TP
.B \-(v)erbose
.br
to echo the nfs-pathname of the file removed (sfrm).
.br
to echo the standard error stream that by default is suppressed (sfsh).
.TP
.B \-(c)shell
.br
to use the C shell executing the sfsh command specified.
.TP
.B \-(r)shell 
.br
to use the remote shell executing the sfsh command specified (see sfdpmd(1)).
.TP
.B \-(d)irectory
.br
to echo the nfs-pathname of the file system before issuing the sfsh command.
.TP
.B \-(s)pace
.br
to show the space statistic of the file system before issuing the optional sfsh command.
.TP
.BR \-link "path"
.br
to create (sfget) and remove (sfrm) the symbolic link to the shift file. Links are located
in the directory specified by path. The word link has to be fully specified.
.TP
.BR command " [ " arguments " ]"
any shell command with its arguments to be executed by sfsh. By default the Bourne
shell is used in the local mode and the remote shell in the remote mode. The command
is always required unless the space option is used.
.br
.SH RETURN CODES
.B sfget 
returns 0 when the file already exists and returns 1 when either the file is 
successfully created or the file doesn't exist and the -look option is specified.
.br
.B sfrm
returns 0 if successful, 1 if options are uncorrectly 
specified, 2 if the dpm configuration is uncorrect, 4 if user is denied 
permission to remove a file.
.br
.B sfsh
returns 0 if successful and 1 if at least one file system wasn't accessible or id options are wrongly specified, 2 if the dpm configuration is uncorrect,
5 if a system error occured (such as a malloc() failure or a file system not accessible).
.br
.SH SEE ALSO
sfmake(1), sfsyntax(1), sfoptions(1), sfdpmd(1)
.SH AUTHOR
Fabrizio Cane, CERN-CN Division CH-1211 Geneva 23, Switzerland (cane@cernvm.cern.ch)
