/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)option.c	3.3 07/27/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined( apollo )
#include <limits.h>
#else
#include <values.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <shift_types.h>
#include <strdup.h>
#include <strtok.h>
#include <strutil.h>
#include <getconfent.h>
#include <parser.h>
#include <table.h>
#include <dpmutil.h>
#ifndef vms
#include <serrno.h>                     /* Special Error numbers        */
#else
#include "serrno.h"                     /* Special Error numbers        */
#endif

#define MEGABYTE		(long)1024*1024
#define UNDEFINED_FILESIZE	(long)-1
#if defined( apollo )
#define MAX_FILESIZE            (long)LONG_MAX
#else
#define MAX_FILESIZE		(long)MAXLONG
#endif

/*
 *  Get the option style setup ( used by sfget sfrm sfsh )
 *
 *  OUTPUT
 *	style		1 / Unix style ( by default )	  0 / X Windown System style
 */
void getoptstyle(style)
int *style;
{
#if !defined( VMSOPTS ) && !defined( UNIXOPTS )
  char *options_style;

 /*
  *  Get the option style setup
  */
    if ( (options_style = getenv("DPMOPTIONSTYLE")) == NULL &&
		(options_style = getconfent("DPM","OPTIONSTYLE",0)) == NULL ) {
	vperror(0,"getconfent(DPM,OPTIONSTYLE): not found\nincomplete installation");
	sfexit(EXCONF);
    }
    *style = (options_style == NULL) || strcasecmp(options_style,"XWINDOW") ;
#else
#if defined( UNIXOPTS )
    *style = 1;
#else
    *style = 0;
#endif
#endif
}

/*
 *  Get the default pool name ( used by sfget sfrm sfsh )
 *
 *  INPUT
 *	pool	pool name specified in the command line
 *	argv	main()'s argument vector
 *	usage	usage function
 *
 *  OUPUT
 *	pool	default pool name unless the pool was specified in the command line
 */
void getoptpool(pool,argv,usage)
char **pool;
char *argv[];
void (*usage)();
{
  char *ent;

 /*
  *  If no pool name is specified in the command line then get the default pool name
  */
    if ( *pool == NULL )
	if ( (ent = getconfent("DPM","DEFPOOL",0)) == NULL ) {
	    vperror(0,"pool name required");
	    (*usage)(argv,FALSE);
	    sfexit(EXOPT);
	}
	else
	if ( (*pool = strdup(ent)) == NULL ) {
	    vperror(1,"strdup(%s)",ent);
	    sfexit(EXSYS);
	}
}

/*
 *  Get the uid used to build the nfs-pathname ( used by sfget sfrm sfsh )
 */
void getoptuser(user,group,uid,gid)
char *user,*group;
int *uid,*gid;
{
 /*
  *  The group and user options cannot be both specified
  */
    if ( group != NULL && user != NULL ) {
	vperror(0,"user and group options cannot be both specified");
	sfexit(EXOPT);
    }

    *uid = -1;
    if ( group ) *gid = -1;

 /*
  *  If no user and group name are specified then get the uid of the client
  */
    if ( user == NULL && group == NULL )
	*uid = getuid();
    else
    if ( user != NULL ) {
	if ( get_userbyname(user,uid,(int*)NULL) < 0 ) {
	    vperror(0,"unknown user name <%s>",user);
	    sfexit(EXOPT);
	}
    }
    else
    if ( get_groupbyname(group,gid) < 0 ) {
	vperror(0,"unknown group name <%s>",group);
	sfexit(EXOPT);
    }
}

/*
 *  Convert the size option in bytes ( used by sfget only )
 *
 *  INPUT
 *	strsz	    size option specified in the command line
 *
 *  OUTPUT
 *	size	    size value in bytes ( the default value is used if no input )
 */
void getoptsize(strsz,size)
char *strsz;
long *size;
{
  float	fsz;
  char *ent;

 /*
  *  If no size is specified in the command line then get the default value
  *  and if no default value is provided then size is undefined
  */
    if ( strsz == NULL )
	if ( (ent = getconfent("DPM","DEFSIZE",0)) == NULL )
	    *size = UNDEFINED_FILESIZE;
	else
	if ( (strsz = strdup(ent)) == NULL ) {
	    vperror(1,"strdup(%s)",ent);
	    sfexit(EXSYS);
	}

 /*
  *  Convert the size in bytes unless it's undefined
  */
    if ( strsz != NULL ) {
	if ( (fsz=anutof(strsz)) < 0 || fsz > MAX_FILESIZE ) {
	    switch ( (long)fsz ) {
		case -1 : vperror(0,"invalid unit character in size");
			  break;
		case -2 :
		default : vperror(0,"invalid size");
	    }
	    sfexit(EXOPT);
	}
	*size = isdigit(strsz[strlen(strsz)-1]) ? (long)fsz * MEGABYTE : (long)fsz ;
    }
}

/*
 *
 */
int is_debug_mode()
{
  char *ent;
    return( (ent = getconfent("DPM","SFDEBUG",0)) != NULL && !strcmp(ent,"yes") );
}

/*
 *  Look for the keyword 'local' and/or 'remote' in the given string
 */
void getmode(str,local,atomic)
char *str;
boolean *local,*atomic;
{
  char *p;

     p = strtok(str," \t");
     while( p != NULL && ( (local && *local < 0) || (atomic && *atomic < 0) ) ) {
	if ( local && *local < 0 ) {
	    if ( !strcmp(p,"local") ) *local = 1;
	    if ( !strcmp(p,"remote") ) *local = 0;
	}
	if ( atomic && *atomic < 0 ) {
	    if ( !strcmp(p,"atomic") ) *atomic = 1;
	    if ( !strcmp(p,"noatomic") ) *atomic = 0;
	}
	p = strtok(NULL," \t");
    }
    if ( local && *local < 0 ) {
	vperror(0,"local/remote mode required\nincomplete installation");
	sfexit(EXCONF);
    }
    if ( atomic && *atomic < 0 ) {
	vperror(0,"atomic/noatomic mode required\nincomplete installation");
	sfexit(EXCONF);
    }
}

/*
 *  Get the configuration flags local/remote and atomic/noatomic
 */
void getsfmode(code,local,atomic)
int code;
boolean *local;
boolean *atomic;
{
  char *ent,*str;
  char sfname[10];

    switch ( code ) {
	case 0 : strcpy(sfname,"SFSHMODE");
		 break;
	case 1 : strcpy(sfname,"SFRMMODE");
		 break;
	case 2 : strcpy(sfname,"SFGETMODE");
		 break;
        default : vperror(0,"Internal: unknown code in getsfmode()");
		  sfexit(EXINT);
    }

    if ( (ent = getconfent("DPM",sfname,1)) == NULL ) {
	vperror(0,"getconfent(DPM,%s): not found\nincomplete installation",sfname);
	sfexit(EXCONF);
    }
    if ( (str = strdup(ent)) == NULL ) {
	vperror(1,"strdup(%s)",ent);
	sfexit(EXSYS);
    }
    *local = -1;
    getmode(str,local,NULL);

    if ( code == 0 ) return;

    if ( (ent = getconfent("DPM","SFGETMODE",1)) == NULL ) {
	vperror(0,"getconfent(DPM,%s): not found\nincomplete installation",sfname);
	sfexit(EXCONF);
    }
    free(str);
    if ( (str = strdup(ent)) == NULL ) {
	vperror(1,"strdup(%s)",ent);
	sfexit(EXSYS);
    }
    *atomic = -1;
    getmode(str,NULL,atomic);
}

#if defined( CREATMP )

extern int maxtmpattempts;
extern int tmpsleep;

/*
 *  Get the parameters used reading the tmp files ( used by sfget and sfdpmd )
 */
int getreadtmpmode()
{
  char *ent,*p;
  int val;

    if ( (ent = getconfent("DPM","TMPRETRY",0)) == NULL ) {
	vperror(0,"getconfent(DPM,TMPRETRY): not found\nincomplete installation");
	return(-1);
    }
    if ( (val = strtol(ent,&p,0)) < 0 || *p != EOS || val < 0 ) {
	vperror(0,"invalid value for DPM TMPRETRY\nincomplete installation");
	return(-1);
    }
    maxtmpattempts = val+1;

    if ( (ent = getconfent("DPM","TMPTIMEOUT",0)) == NULL ) {
	vperror(0,"getconfent(DPM,TMPTIMEOUT): not found\nincomplete installation");
	return(-1);
    }
    if ( (val = strtol(ent,&p,0)) < 0 || *p != EOS || val <= 0 ) {
	vperror(0,"invalid value for DPM TMPTIMEOUT\nincomplete installation");
	return(-1);
    }
    tmpsleep = val;
    return(1);
}

#endif
