/*
 * Copyright (C) 1990,1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)scandir.c	3.3 07/30/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#if defined( cray ) || defined( apollo ) || defined( sgi )
#include <sys/statfs.h>
#endif
#if defined( sun )
#include <sys/vfs.h>
#endif
#include <errno.h>
#include <sys/stat.h>
#ifdef __DIRENT__
#include <dirent.h>
#endif
#ifdef __DIRECT__
#include <sys/dir.h>
#endif
#ifndef apollo
#include <malloc.h>
#endif
#include <stdlib.h>
#include <shift_types.h>
#include <strutil.h>
#include <scandir.h>
#include <parser.h>
#include <table.h>
#include <dpmutil.h>

#ifdef __DIRENT__
struct dirent	*dirstruct_;
#endif
#ifdef __DIRECT__
struct direct *dirstruct_;
#endif

int		scanerrno		= 	0 ;

linklist_t 	*link_list		=	NULL ;
char	   	*linkname[NOLINKTYPE+1] = 	{ "", "soft", "hard", " ?? " } ;

/*
 *   Structure of the root directory and any subdirectory to scan
 */
typedef struct cdir_t {
	DIR	*fd;		/* file descriptor of the directory	*/
	path_t	path;		/* relative path of the directory	*/
	int	level;		/* subdirectory depth level		*/ 
} cdir_t;

/*
 *   Structure used by the scandir_open(), scandir_close() 
 *   and scandir_next() functions
 */
typedef struct scandir_t {
	cdir_t	*fdir;		/* array of sub-directories to scan		*/
	int	size;		/* size of the 'fdir' array			*/ 
	int	idx;		/* array index of the current directory to scan	*/
	int	level;		/* max scan depth allowed			*/
	boolean (*select)();	/* select() function				*/
	path_t  mountpath;	/* file system where directories are placed	*/
} scandir_t ;

boolean	(*scandir_select[MAXSCANSELECT])() = {
						select_000,
						select_001,
						select_002,
						select_100,
						select_110
					     } ;

/*
 *  Return the link type of the selected file
 *
 *  INPUT
 *	buffer		the stat() reply called on the selected file
 *	lbuffer		the lstat() reply called on the selected file
 *
 *  OUTPUT
 *	nlink		return the number of links remaining plus one
 *
 *  RETURN
 *	link type code ( NOLINK, SOFTLINK, HARDLINK )
 */
int get_link_info(buffer,lbuffer,nlink)
struct stat	*buffer;
struct stat	*lbuffer;
int		*nlink;
{

	if ( lbuffer->st_ino != buffer->st_ino  ||  lbuffer->st_dev != buffer->st_dev )
	{
      /*
       *  it's a SOFT LINK ( i.e. device or inode number are not the same )
       */
		*nlink = lbuffer->st_nlink;
		return( SOFTLINK );
	}
	else

      /*
       *  it's not a SOFT LINK ( inode and device numbers are the same )
       */ 
	{

	  /*
	   *  if this is not an HARD LINK ( i.e. st_nlink == 1 )
           */ 
	    if ( buffer->st_nlink == 1 )
	    {
			*nlink = 1;
			return( NOLINK );
	    }
	    else
	  /*
	   *  if this is an HARD LINK ( st_nlink > 1 )
           */ 
	    {
		linklist_t	  *node = link_list;

	      /*
	       *  Search the same <device,inode> in the list of hard links
	       */
		while ( node != NULL  &&  
			  !( buffer->st_dev==node->dev  &&  buffer->st_ino==node->ino )
		      )
				node = node -> next;

		if ( node != NULL )
	      /*
	       *  If an hard link has been found then just decrement the number of
	       *  link remaining ( if then it's one this is the last hard link )
	       */

			--node->nlink ;

		else
	      /*
	       *  if this is a new hard link then store it in the list
	       */
		{
			node = (linklist_t*)malloc(sizeof(linklist_t));
			if ( node == NULL ) {
				vperror(1,"malloc()");
				return( -1 );
			}

			node->next = link_list;
			node->dev = buffer->st_dev;
			node->ino = buffer->st_ino;
			node->nlink = buffer->st_nlink;

			link_list = node;
		}
 
		*nlink = node->nlink;

		return(HARDLINK);
	    }
	}
}

/*
 *
 */
int remove_link_info()
{
  linklist_t	  *node;

  while ( link_list != NULL ) {
	node = link_list;
	link_list = link_list -> next ;
	free(node);
  }
}

/*
 *  Remove empty directories that are a component of the path 'dirpath'
 *  Two parameters are provided to specify how to select directories 
 *  that can be deleted if empty : 'level' and 'len'
 *	
 *   -  level
 *	  -1		delete all directories in the path ( if empty )
 *	  0		delete the last directory only ( if empy )
 *	  n > 0		delete max n+1 directory ( if empty )
 *
 *   -  len
 *	  n > 0		the 'dirpath' cannot be shorter then n+1 characters,
 *			so all empty direcotries included in a longer path
 *			are deleted
 *
 *	RETURN
 *	  -1		error - scanerrno can be set to
 *			  rmdir()'s errno  : rmdir() call failed
 *	  n >= 0	number of empty directories deleted
 */
int rm_emptydir(dirpath,level,len)
char	*dirpath;
int	level;
int	len;
{
  path_t	path;		/* working path				*/
  char		*ptr;		/* pointer to '/' character		*/
  int		nodir;		/* number of empty directories deleted	*/

    strcpy(path,dirpath);
    nodir = 0;

    while ( path[0] != EOS  &&  strlen(path) > len ) {

	if ( rmdir(path) )

	    switch ( errno ) {

		case EEXIST :			/* the directory is not empty     */

			return( nodir );

		case ENOENT :			/* the path can be invalid 	  */

			break;			/* just ignore it and continue	  */

		default :			/* rmdir() error */

			scanerrno = errno;
			vperror(1,"rmdir(%s)",path);
			return( -1 );

	    } /* switch - rmdir() errno */

	if ( ++nodir > level  &&  level != -1 )
		break;			/* exit the loop if max level is reached  */ 

	ptr = strrchr(path,'/');
	if ( ptr != NULL )
		*ptr = EOS;
	else
		break;			/* exit the loop if that was the last dir */
    }
    return( nodir );
}

#if defined( apollo )

#define 	S_IRUSR		S_IREAD
#define		S_IWUSR		S_IWRITE
#define		S_IXUSR		S_IEXEC
#define		S_IRGRP		0000040
#define		S_IWGRP		0000020
#define		S_IXGRP		0000010
#define		S_IROTH		0000004
#define		S_IWOTH		0000002
#define		S_IXOTH		0000001

#endif

/*
 *  Convert the file mode into a string
 *
 *  INPUT
 *
 *	str		string containg at least 12 characters
 */
char *fmodetos(str,mode)
char	*str;
u_short	mode;
{
	str[0] = ' ';

	if ( (mode & S_IFMT) == S_IFDIR )   str[1] = 'd';
#if !( defined( cray ) && !defined( UNICOS60 ) )
	if ( (mode & S_IFMT) == S_IFLNK )   str[1] = 'l'; 
#endif
	if ( (mode & S_IFMT) == S_IFSOCK )  str[1] = 's';
	if ( (mode & S_IFMT) == S_IFIFO )   str[1] = 'f';
        if ( (mode & S_IFMT) == S_IFREG )   str[1] = '-';
	if ( (mode & S_IFMT) == S_IFBLK )   str[1] = 'b';
	if ( (mode & S_IFMT) == S_IFCHR )   str[1] = 'c';

	str[2]  = mode & S_IRUSR  ?  'r'  :  '-' ;
	str[3]  = mode & S_IWUSR  ?  'w'  :  '-' ;
	str[4]  = mode & S_IXUSR  ?  'x'  :  '-' ;
	str[5]  = mode & S_IRGRP  ?  'r'  :  '-' ;
	str[6]  = mode & S_IWGRP  ?  'w'  :  '-' ;
	str[7]  = mode & S_IXGRP  ?  'x'  :  '-' ;
	str[8]  = mode & S_IROTH  ?  'r'  :  '-' ;
	str[9]  = mode & S_IWOTH  ?  'w'  :  '-' ;
	str[10] = mode & S_IXOTH  ?  'x'  :  '-' ;
	str[11] = '\0';
    return( str );
}

/*
 *  Return TURE if the input path 'name' and stat() informations 'buffer' referes
 *  to a valid directory that be neither '.' nor '..'
 */
boolean is_subdirectory(name,buffer)
char		*name;
struct stat	*buffer;
{
	return( (buffer->st_mode & S_IFMT) == S_IFDIR  && 
		    	strcmp(name,".")!=0  &&  strcmp(name,"..")!=0 );
}

/*
 *  Initialize the data structure before scanning a directory
 *
 *  INPUT
 *	dirpath		directory path to be scanned
 *	level		max depth level allowed during scanning
 *	select		function used to select files and directories
 *
 *  OUTPUT
 *	NONE
 *
 *  RETURN
 *	NULL		error - scanerrno can be set to 
 *			  malloc() errrno : malloc() failed to allocate structure
 *			  opendir() errno : opendir() call failed
 *  
 *	n > 0		structure address to be used as index for scandir_next()
 *			and scandir_close() calls
 */
scandir_t *scandir_open(mountpath,dirpath,level,select,reply)
char	 *mountpath;
char	 *dirpath;
int	 level;
boolean  (*select)();
int *reply;
{
  scandir_t	*scan_dir;

	*reply = -1;
	if ( (scan_dir=(scandir_t *)malloc(sizeof(scandir_t))) == NULL ) {
		scanerrno = errno;
		return( NULL );
	}
		
	scan_dir->size   = 1;
	scan_dir->fdir   = (cdir_t*)malloc(sizeof(cdir_t)*scan_dir->size);
	if ( scan_dir->fdir==NULL ) {
		scanerrno = errno;
		return( NULL );
	}
	scan_dir->idx    = 0;
	scan_dir->level  = level;
	scan_dir->select = select;
	strcpy(scan_dir->mountpath,mountpath);
	strcpy(scan_dir->fdir[scan_dir->idx].path,dirpath);
	scan_dir->fdir[scan_dir->idx].level = 0;

	scan_dir->idx    = -1;
	scanerrno = errno;
	if ( (*reply=scandir_opendir(scan_dir)) <= 0 /* ||  scan_dir->idx */ ) {
		return( NULL );
	}
	return( scan_dir );
}

/*
 *  Deallocate a structure previously allocate by scandir_open()
 */
int scandir_close(scan_dir)
scandir_t	*scan_dir;
{
	free(scan_dir->fdir);
	free(scan_dir);
	return(1);
}

/*
 *
 */
int scandir_opendir(scan_dir)
scandir_t  *scan_dir;
{

    while ( ++scan_dir->idx < scan_dir->size ) {

	scan_dir->fdir[scan_dir->idx].fd = opendir(scan_dir->fdir[scan_dir->idx].path);
	if ( scan_dir->fdir[scan_dir->idx].fd != NULL ) 
	      /*
	      **  Done
              */
		return( 1 );
	else {
		scanerrno = errno;
/*		vperror(1,"opendir(%s) failed",scan_dir->fdir[scan_dir->idx].path); */
		if ( is_filesystem(scan_dir->mountpath,NULL,scanerrno) != FSMNTD ) {
			scanerrno = ENOENT;
			return( -1 );		/* device not mounted */
		}
		if ( scanerrno != ENOENT ) {
		    vperror(1,"opendir(%s) failed",scan_dir->fdir[scan_dir->idx].path);
		    return( -1 );		/* opendir error */
		}
	     /*
             **  The directory is not there - it has been deleted by someone
	     */
	}

    } /* while - there are directories to open */

  /* 
  **  no more directories to open 
  */
    return( 0 );
}

/*
 *  Get the next file/directory from the scan structure created by scandir_open() 
 *
 *  INPUT
 *	scandir		is the index returned by a previous scandir_open() call
 *
 *  OUTPUT
 *	path		is the path of the next file/directory as returned by
 *			the select() function given in input to the scandir_open()
 *	buffer		pointer to the structure returned by the stat() call on
 *			the 'path'
 *	lbuffer		pointer to the structure returned by the lstat() call on
 *			the 'path'
 *	puid		uid of the user if any whose directory is in the path
 *
 *  RETURN
 *	-1		error - scanerrno can be set to 
 *			  EOF		   : end of scandir
 *			  realloc() errno  : realloc() failed
 *			  opendir() errno  : opendir() failed ( except ENOENT )
 *			  ENOENT	   : file system not mounted
 */
int scandir_next(scan_dir,path,buffer,lbuffer,puid)
scandir_t	*scan_dir;
char		*path;
struct stat 	*buffer;
struct stat	*lbuffer;
int		*puid;
{
  int  		reply;
  path_t	cpath;		/*  complete path of the next entry found  */

  do {

  /*
   *  get the next file from readdir() function
   *  close the current directory and open the next one if 
   *  readdir() fails
   */ 
    do {

	dirstruct_ = readdir(scan_dir->fdir[scan_dir->idx].fd);
	if ( dirstruct_ == NULL ) {
		closedir(scan_dir->fdir[scan_dir->idx].fd);
		if ( scandir_opendir(scan_dir) < 0 )
			return( -1 );
	}

    } while ( dirstruct_ == NULL  &&  scan_dir->idx < scan_dir->size );

  /*
   *  if there are no more directories to scan return
   */
    if ( dirstruct_ == NULL ) {
		scanerrno = EOF;
		return( -1 );
    }

  /*
   *  the complete entry path is made concatenating the complete path of the
   *  directory and the relative path of the entry
   */
    strcpy(cpath,scan_dir->fdir[scan_dir->idx].path);
    strcat(cpath,"/"); 
    strcat(cpath,dirstruct_->d_name);

  /*
   *  get information about the file ( stat() ) and the link ( lstat() )
   */  
   reply = stat(cpath,buffer);
   if ( reply < 0 ) 
		continue;

#if !( defined( cray ) && !defined( UNICOS60 ) )
    reply = lstat(cpath,lbuffer);
    if ( reply < 0 )
		continue;
#else
    memcpy(lbuffer,buffer,sizeof(struct stat));
#endif

  /*
   *  IF 'this is a sub-directory' and 'the depth level is correct' and 'the select()
   *  function selects the sub-directory' 
   *  THEN insert the subdirectory in the list of new directory to scan
   */ 
    if ( is_subdirectory(dirstruct_->d_name,buffer) &&
	 (scan_dir->level==-1 || scan_dir->level>scan_dir->fdir[scan_dir->idx].level) &&
	 (scan_dir->select == NULL || 
	    	(*scan_dir->select)( 
			scan_dir->fdir[0].path,		     /* root directory path */
			cpath,				     /* complete entry path */
			buffer,				     /* stat() info	   */
			lbuffer,			     /* lstat() info	   */
			TRUE,				     /* select subdirectory */
			scan_dir->fdir[scan_dir->idx].level, /* subdirectory depth  */
			path,
			puid ) 
	 ) 
       ) 
    {

      /*
       *  insert the new subdirectory in the list of directories to scan
       */
	scan_dir->fdir = (cdir_t*)realloc(scan_dir->fdir,sizeof(cdir_t)*(scan_dir->size+1));
	if ( scan_dir->fdir == NULL )  {
		scanerrno = errno;
		vperror(1,"realloc()");
		return( -1 );
	}

	strcpy(scan_dir->fdir[scan_dir->size].path,cpath);
	scan_dir->fdir[scan_dir->size].level = scan_dir->fdir[scan_dir->idx].level + 1;
	scan_dir->size++;

    }

  /*
   *  see if the select() function selects the current entry path as a valid
   *  answer to return to the calling process
   *  if it's so return otherwise get next entry
   */
  } while ( scan_dir->select != NULL  &&  
			!( (*scan_dir->select)(  scan_dir->fdir[0].path,
						cpath,
						buffer,
						lbuffer,
						FALSE,
						scan_dir->fdir[scan_dir->idx].level,
						path,
						puid ) 
			 ) 
	);

  return(1);
}

/*
**
*/

boolean select_ZXY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,z,x,y)
char		*fspath;	/* file system path */
char		*cfpath;	/* complete file path */
struct stat	*buffer;	/* stat record about the file cfpath */
struct stat	*lbuffer;	/* lstat record about the file cfpath */
boolean		dir;		/* select directory (T) select answer (F) */
int		level;		/* level of the file - 0 is the first level */
char		*rpath;		/* return path to use if selected */
int		*puid;
int		z;
int		x;
int		y;
{
  boolean	isdir;
  char		*fpath;
  char  	*group,*grpidx;
  char  	*user,*usridx;
  int		uid,gid;
  int		reply;

	strcpy(rpath,"");

	if ( cmpstrings(cfpath,fspath,TRUE,TRUE) )  {
		 vperror(0,"file system path (%s) is not a prefix of the file path (%s)",
				fspath,cfpath);
		return( 0 );
	} 

	fpath = cfpath + strlen(fspath) + 1;

	strcpy(rpath,fpath);

	if ( z==1 )
	{
      /*
       *  check if the first element of the path is a valid group directory
       *  (i.e. check if fpath is :
       *	either	(1)	<group name> / <rest of the path> 
       *	or	(2)	<group name>
       */
	group = fpath;
  	grpidx = (char*)strchr(group,'/');
  	if ( grpidx != NULL )   *grpidx = '\0';
  	reply = get_groupbyname(group,&gid);
  	if ( grpidx != NULL )   *grpidx = '/';
  	if ( reply < 0 )	return( 0 );		/* no valid group name  */
	if ( grpidx == NULL )	return( dir );		/* case (2)		*/

      /* this is case (1) */

	}

      /*
       *  check if the second element of the path is a valid user directory
       *  (i.e. check if fpath is :
       *  	either	(3)	<group name> / <user name> / <rest of the path>
       *	or	(4)	<group name> / <user name>
       */
	if ( z==1 )
	  	user = grpidx+1;
	else
		user = fpath;

  	usridx = (char*)strchr(user,'/');
  	if ( usridx != NULL )  *usridx = '\0';
	reply = get_userbyname(user,&uid,&gid);
	if ( usridx != NULL )  *usridx = '/';
	if ( reply < 0 )	return( 0 );		/* no valid user name	*/
	if ( usridx == NULL )	return( dir );   	/* case (4) 		*/


      /* this is case (3) */

      /* 
       *  if this is a 'subdirectory scan selection' then return 'selected'
       *  (i.e. the path is :
       *		<group name> / <user name> / <partial path> / <subdirectory>
       *	or 
       *		<group name> / <user name> / <subdirectory>
       */
  	if ( dir )
		return( 1 );	

	if ( level < 2+1-z )
		return( 0 );

      /*
       *  this is a 'file/dir selection'
       *  (i.e the path is :
       *		<group name> / <user name> / <partial path> / <user file | dir>
       *	or
       *		<group name> / <user name> / <user file | dir >
       */

	isdir = ((buffer->st_mode & 192*256) >> 14) == 1;

      /*
       *  
       */
	switch ( x ) {
	    case 1 :
		strcpy(rpath,fpath);
		*puid = uid;
		break;

	    case 0 :
	    default :
		strcpy(rpath,usridx+1);
		*puid = uid;
	}

      /*
       *  
       */
	switch ( y )
	{
	    case 0 :
	    default :
		return( !isdir );
	}
}

/*
 *
 */
boolean select_0XY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,x,y)
char		*fspath;	/* file system path */
char		*cfpath;	/* complete file path */
struct stat	*buffer;	/* stat record about the file cfpath */
struct stat	*lbuffer;	/* lstat record about the file cfpath */
boolean		dir;		/* select directory (T) select answer (F) */
int		level;		/* level of the file - 0 is the first level */
char		*rpath;		/* return path to use if selected */
int		*puid;
int		x;
int		y;
{
  boolean    isdir;

	if ( cmpstrings(cfpath,fspath,TRUE,TRUE) ) {
		vperror(0,"file system path (%s) is not a prefix of the file path (%s)",
						fspath,cfpath);
		strcpy(rpath,"");
		return( 0 );
	} 

	isdir = ((buffer->st_mode & 192*256) >> 14) == 1;

      /*
       *
       */
	switch ( x ) {
	    case 0 :
	    default :
		strcpy(rpath,cfpath+strlen(fspath)+1);
	}

      /*
       *
       */
	switch ( y ) {

	    case 2 :
		return( !isdir  ||  dir );

	    case 1 :
		return( !isdir );

	    case 0 :
	    default :
		return( 1 );
	}
}

boolean select_000(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid)
char		*fspath;
char		*cfpath;
struct stat	*buffer;
struct stat	*lbuffer;
boolean		dir;
int		level;
char		*rpath;
int		*puid;
{
	return( select_0XY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,0,0) );
}

boolean select_001(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid)
char		*fspath;
char		*cfpath;
struct stat	*buffer;
struct stat	*lbuffer;
boolean		dir;
int		level;
char		*rpath;
int		*puid;
{
	return( select_0XY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,0,1) );
}

boolean select_002(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid)
char		*fspath;
char		*cfpath;
struct stat	*buffer;
struct stat	*lbuffer;
boolean		dir;
int		level;
char		*rpath;
int		*puid;
{
	return( select_0XY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,0,2) );
}

boolean select_100(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid)
char		*fspath;
char		*cfpath;
struct stat	*buffer;
struct stat	*lbuffer;
boolean		dir;
int		level;
char		*rpath;
int		*puid;
{
	return( select_ZXY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,1,0,0) );
}

boolean select_110(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid)
char		*fspath;
char		*cfpath;
struct stat	*buffer;
struct stat	*lbuffer;
boolean		dir;
int		level;
char		*rpath;
int		*puid;
{
	return( select_ZXY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,1,1,0) );
}

boolean select_200(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid)
char		*fspath;
char		*cfpath;
struct stat	*buffer;
struct stat	*lbuffer;
boolean		dir;
int		level;
char		*rpath;
int		*puid;
{
	return( select_ZXY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,2,0,0) );
}

boolean select_210(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid)
char		*fspath;
char		*cfpath;
struct stat	*buffer;
struct stat	*lbuffer;
boolean		dir;
int		level;
char		*rpath;
int		*puid;
{
	return( select_ZXY(fspath,cfpath,buffer,lbuffer,dir,level,rpath,puid,2,1,0) );
}

