/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)select.c	3.8 09/30/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#ifndef apollo
#include <malloc.h>
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <shift_types.h>
#include <strutil.h>
#include <strerror.h>
#include <flock.h>
#include <parser.h>
#include <table.h>
#include <dpmutil.h>

/* #define DEBUG */

#define FLAGS	O_RDWR | O_SYNC | O_CREAT
#define MODE	384 						  /*  -rw-------  */
#define LOCK	LOCK_EX

/*
 *
 */
typedef struct sort_t {
    int fd;		/* file descriptor 		  */
    int cursor;		/* index in the file system list  */
    int start;		/* last file system selected 	  */
    int idx;		/* offset in the file system list */
    time_t time;	/* time stamp 			  */
} sort_t ;

/*
 *
 */
void swap_sort(s1,s2)
sort_t *s1,*s2;
{
  static sort_t swap;

    memcpy((char*)&swap, (char*)s1,    sizeof(sort_t));
    memcpy((char*)s1,	 (char*)s2,    sizeof(sort_t));
    memcpy((char*)s2,	 (char*)&swap, sizeof(sort_t));
}

/*
 *
 */
char *get_select_name(idx)
int idx;
{
  extern pool_t *pool_table;
  extern path_t shift_binary;
  static char name[PATH_LENGTH+8+POOL_LENGTH];

    sprintf(name,"%s.select.%s",shift_binary,pool_table[idx].name);
    return(name);
}

/*
 *
 */
int read_select_file(pidx,sort)
int pidx;
sort_t *sort;
{
  char *select_file;
  int mask;

    select_file = get_select_name(pidx);
    mask = umask(0);
    sort->fd = open(select_file,FLAGS,MODE);
    umask(mask);

    if ( sort->fd < 0 ) {
	vperror(1,"open(%s,%x,%x)",select_file,FLAGS,MODE);
	return(EXSYS);
    }

    switch ( read(sort->fd,(char*)&sort->cursor,sizeof(int)) ) {
	case -1 :
	    vperror(1,"read(%s,%x,%d)",select_file,&sort->cursor,sizeof(int));
	    return(EXSYS);
	case 0 :
	    sort->cursor = 0;
	    break;
	default :
	    if ( sort->cursor < 0 ) sort->cursor = 0;
	    break;
    }

    sort->start = sort->cursor;

    switch ( read(sort->fd,(char*)&sort->time,sizeof(time_t)) ) {
	case -1 :
	    vperror(1,"read(%s,%x,%d)",select_file,&sort->time,sizeof(time_t));
	    return(EXSYS);
	case 0 :
	    sort->time = 0;
	    break;
	default :
	    if ( sort->time < 0 ) sort->time = 0;
	    break;
    }

    return(1);
}

/*
 *
 */
int nextpool(poolfs,length,pool)
poolfs_t *poolfs;
int length,pool;
{
  static int k;

    for (k=pool+1; k<length; k++)
	if ( poolfs[k].pidx != poolfs[pool].pidx )
	    return(k);

    return(length);
}

/*
 *
 */
boolean select_fsys(poolfs,scan,sort,space)
poolfs_t *poolfs;
scanp_t *scan;
sort_t *sort;
long space;
{
  extern fsys_t *fsys_table;
  extern pool_t *pool_table;
  static long tot,free,block;
  static int idx;

    sort->cursor = sort->cursor < poolfs[sort->idx].num - 1 ? sort->cursor + 1 : 0 ;

    idx = sort->cursor + sort->idx ;

    if ( sort->cursor == sort->start ) sort->start = -1;

    if ( fsys_table[poolfs[idx].fsidx].poolidx != poolfs[idx].pidx ) return(1);

    if ( space > pool_table[fsys_table[poolfs[idx].fsidx].poolidx].size ) {
	sort->start = -1;
	return(1);
    }

    if ( !(scan[idx].tmp < 1 || scan[idx].file < 1 ) ||
		is_filesystem(poolfs[idx].mount,NULL,scan[idx].scerrno) != FSMNTD )
	return(1);

    return( 
	    getfsystat(poolfs[idx].mount,&tot,&free,&block,NULL) < 0 ||
			( fsys_table[poolfs[idx].fsidx].bits & FSYSWLOCK ) ||
				     ( space != 0 && space/block+1 > free )
	  );
}

/*
 *  Select a file system where to create the shift file
 *
 *  INPUT
 *	space		space required
 *	nofs		length of poolfs and scan
 *	poolfs		file system list making the pool
 *	scan		scan disk pool structure
 *
 *  OUTPUT
 *	fsidx		the table index of the selected file system
 *	scidx		the scan index of the selected file system
 *
 *  RETURN
 *	1		successful completion
 *     < 0		an error occured ( EXSEL - EXSYS )
 */
int select_file_system(space,nofs,poolfs,scan,fsidx,scidx)
long space;
int nofs;
poolfs_t *poolfs;
scanp_t *scan;
int *fsidx,*scidx;
{
  static sort_t *sort		= NULL ;
  static int sort_length	= 0 ;
  boolean loop			= 1 ;
  int pool			= 0 ;
  int nopool			= 0 ;
  int selected_pool;
  sort_t *ptr;
  int j,k,reply,np;

#if defined( TRACE )
    if ( TRACE_dosfget ) printf("selecting file system\n");
#endif

    while ( pool < nofs && loop ) {

	nopool ++ ;

	if ( nopool > sort_length ) {
	    sort_length = nopool;
	    if ( sort == NULL ) {
		if ( (sort=(sort_t*)malloc(sizeof(sort_t)*sort_length)) == NULL ) {
		    vperror(1,"malloc()");
		    return(EXSYS);
		}
	    }
	    else {
		if ( (ptr=(sort_t*)realloc(sort,sizeof(sort_t)*sort_length)) == NULL ) {
		    free(sort);
		    vperror(1,"realloc()");
		    return(EXSYS);
		}
		sort = ptr;
	    }
	}

	sort[nopool-1].idx = pool;

     /*
      *  Get cursor and time stamp
      */
	if ( (reply = read_select_file(poolfs[pool].pidx,&sort[nopool-1])) < 0 )
	    return(reply);

     /*
      *  Get the next pool if it's the same priority
      */
	if ( poolfs[pool].level != 1 && nextpool(poolfs,nofs,pool) < nofs ) {
	    pool = nextpool(poolfs,nofs,pool);
	    continue;
	}

     /*
      *  If there are at least two pools than sort the list by time
      */
	if ( nopool > 1 )
	    for (k=nopool; k>1; k--)
		for (j=0; j<k-1; j++)
		    if ( sort[j].time > sort[j+1].time )
			swap_sort(&sort[j],&sort[j+1]);

#ifdef DEBUG
	printf("load\n");
	for(k=0;k<nopool;k++)
	    printf("%20s : %2d %2d %s\n",
		    pool_table[poolfs[sort[k].idx].pidx].name,
		    sort[k].cursor,
		    sort[k].start,
		    ctimeln(&sort[k].time));
#endif

	for (k=0; k<nopool && loop; k++)
	    while ( loop && sort[k].start > -1 )
		if ( sort[k].start > -1 )
		    loop = select_fsys(poolfs,scan,&sort[k],space);

	if ( loop ) {
	    nopool = 0;
	    pool = nextpool(poolfs,nofs,pool);
	}

    } /* while */

 /*
  *  Get the index of the pool selected
  */
    selected_pool = loop ? -1 : k - 1;

 /*
  *  Close the selection files and update the time and index of the pool selected
  */
    for ( k=0; k<nopool; k++) {
	if ( k == selected_pool ) {
	    lseek(sort[k].fd,0,SEEK_SET);
	    write(sort[k].fd,(char*)&sort[k].cursor,sizeof(int));
	    time(&sort[k].time);
	    write(sort[k].fd,(char*)&sort[k].time,sizeof(time_t));
	}
    	close(sort[k].fd);
    }

 /*
  *  If no pool has been selected then return an error
  */
    if ( loop ) {
	vperror(0,"no suitable file system to select");
	return(EXSEL);
    }

#ifdef DEBUG
    printf("save\n");
    for(k=0;k<nopool;k++)
	printf("%20s : %2d %2d %s %s\n",
		pool_table[poolfs[sort[k].idx].pidx].name,
		sort[k].cursor,
		sort[k].start,
		ctimeln(&sort[k].time),
		k == selected_pool ? "*" : "");
#endif

 /*
  *  Set the output values
  */
    *scidx = sort[selected_pool].cursor + sort[selected_pool].idx ;
    *fsidx = poolfs[*scidx].fsidx;

    return(1);
}
