/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sfdpmd.c	3.9 05/16/94  CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <errno.h>
#ifndef apollo
#include <malloc.h>
#endif
#if defined( sgi )
#define _BSD_SIGNALS
#endif
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#if defined( sgi )
#include <sys/prctl.h>
#endif
#include <netinet/in.h>
#include <netdb.h>
#include <shift_types.h>
#include <osdep.h>
#include <marshall.h>
#include <sockutil.h>
#include <pktutil.h>
#include <strerror.h>
#include <optutil.h>
#include <getconfent.h>
#include <parser.h>
#include <table.h>
#include <sfdpmd.h>
#include <dpmutil.h>
#ifndef vms
#include <serrno.h>				       /* Special Error numbers	*/
#else
#include "serrno.h"                     	       /* Special Error numbers	*/
#endif

#define SHIFTPORT_DESCR	 "service port number"
#define SHIFTLOG_DESCR   "max log file size"

#define SFREQ_TIMEOUT	 30,0			       /* shift request timeout	*/

extern path_t shift_binary;

int serrno;         /* required because this is not linked to the shift library	*/

int maxtmpattempts; /* attempts to read the tmp files */
int tmpsleep;	    /* timeout used to read the tmp files */

boolean dpmdquit = FALSE; /* sfdpmd quit request */

/*
 *  sfdpmd usage
 */
int usage(argv,help)
char *argv[];
boolean help;
{
    printf("usage: %s -help | [-options] [-shiftport]\n",argv[0]);
    if ( help ) {
        printf("where:\n");
        HELP_options();
    }
}

/*
 *  SIGCHLD handler
 */
#if (defined( sgi ) && !defined(IRIX5)) || defined( apollo ) 
static int 
#else
static void 
#endif
sigchld_handler()
{
#if defined( ultrix ) || (defined(sgi) && defined(__EXTENSIONS__) && !defined(IRIX5) ) 
  union wait status;
#else
  int status;
#endif
  int pid;

#if defined( TRACE )
    if ( TRACE_sfdpmd ) printf("signal SIGCHLD received\n");
#endif
    while( 
#if defined( CRAY ) ||  defined (SOLARIS) || defined(IRIX5) || ( defined(__osf__) && defined(__alpha) )
	   (pid = waitpid(-1,&status,WNOHANG)) > 0
#else
	   (pid = wait3(&status,WNOHANG,NULL)) > 0
#endif
						   || ( pid < 0 && errno == EINTR ) ) {
#if defined( TRACE )
	if ( TRACE_sfdpmd ) if ( pid > 0 ) printf("wait3(): child %d\n",pid);
#endif
	continue;
    }

#if defined( hpux )
    signal((int)SIGCHLD,sigchld_handler);    
#endif
}

/*
 *  SIGQUIT handler
 */
#if ( defined( sgi ) && !defined(IRIX5) ) || defined( apollo )
static int 
#else
static void 
#endif
sigquit_handler()
{
    dpmdquit = TRUE;
}

/*
 *  Shift DPM Daemon ( sfdpmd )
 */
main(argc,argv)
int argc;
char *argv[];
{
  extern boolean reloadconfiguration;
  boolean show_help,show_options;
  int sock,newsock;
  struct sockaddr name;
  int namelen;
  port_t shiftport;
  int shift_log_size;
  path_t shiftlog;
  char *ent;
  char errmsg[VPERROR_MSGLENGTH];
#if (defined(__osf__) && defined(__alpha))
  struct sigaction sa;
#endif

    clear_vperror();

 /*
  *  Load the SHIFT configuration ( getconfent() will not do that )
  */
    reloadconfiguration = FALSE;
    if ( load_configuration(TRUE,TRUE,TRUE) < 0 ) {
	vperror(0,"Can't load the configuration");
	sfexit(1);
    }

 /*
  *  Define the options available
  */
    INIT_options();
    DEFAULT_mask(FIXED_MASK);
    DEFAULT_mask(EXTVAL);

    ADD_OPT_options(&show_help,&show_options);
/*
 * Trap signal SIGHUP
 */
#if defined(hpux) || ( defined(__osf__) && defined(__alpha) )
        if ( signal(SIGHUP,SIG_IGN) == SIG_ERR) {
                vperror(0,"signal (SIGHUP)");
                sfexit(1);
        }
#endif


#if defined( TRACE )
    ADD_options("trace",HIDDEN,INT,&tracemode);
#endif

    DEFAULT_mask(DESCR | ENVIR | NAMENV); 
    ADD_options("shiftport",0,INT,"SHIFTDPMPORT",&shiftport,SHIFTPORT_DESCR);
    ADD_options("shiftlog",HIDDEN,INT,"SHIFTDPMLOG",&shift_log_size,SHIFTLOG_DESCR);

 /*
  *  Initialize the options value before calling READ_options()
  */
    shiftport = UNDEF_PORT;
    shift_log_size = -1;

 /*
  *  Get the option values
  */
    if ( READ_options(argc,argv) < 0 ) {
        usage(argv,FALSE);
        sfexit(1);
    }

    if ( show_help && NO_opts()==1 ) {
        usage(argv,TRUE);
        sfexit(0);
    }

    if ( show_options )
        LIST_options();

 /*
  *  Load some missing options from the "/etc/shift.conf" file
  */
    getshiftconf((char**)NULL,(char**)NULL,NULL,&shiftport,NULL,&shift_log_size,(char**)NULL);

 /*
  *  It must be root
  */
    if ( beroot() < 0 && !is_debug_mode() ) {
	vperror(1,"Can't be root");
	sfexit(EXCONF);
    }

 /*
  *  Bind the SHIFT DPM Daemon
  */
    sock = bind_sfdpmd(shiftport);

 /*
  *  Listen on the socket
  */
    if ( listen(sock,5) < 0 ) {
	vperror(1,"listen()");
	sfexit(1);
    }

 /*
  *  Load the parameters required to execute locally the shift requests
  */
    if ( reload_parameters() < 0 )
	sfexit(1);

 /*
  *  Handle the signal SIGCHLD
  */
#ifdef CRAY
    bsdsignal((int)SIGCHLD,sigchld_handler);
#else
#if defined(SOLARIS)
    signal((int)SIGCHLD,(void (*)())sigchld_handler) ;
#else
#if ( defined(__osf__) && defined(__alpha) )
    sa.sa_handler = sigchld_handler;
    sa.sa_flags = SA_RESTART;
    sigaction (SIGCHLD, &sa, NULL);
#else
    signal((int)SIGCHLD,sigchld_handler);
#endif /* SOLARIS */
#endif /* CRAY */
#endif /* __osf__ && __alpha */

 /*
  *  Handle the signal SIGQUIT
  */
#ifdef CRAY
    bsdsignal((int)SIGQUIT,sigquit_handler);
#else
#if defined(SOLARIS)
    signal((int)SIGCHLD,(void (*)())sigchld_handler) ;
#else
    signal((int)SIGQUIT,sigquit_handler);
#endif /* SOLARIS */
#endif /* CRAY */

#if defined( sgi )
 /*
  *  Make the sfdpmd resident in memory
  */
    if ( (ent = getconfent("DPM","RESIDENT",0)) && 
			!strcmp(ent,"yes") && prctl(PR_RESIDENT) < 0 ) {
	vperror(1,"prctl()");
	sfexit(1);
    }
#endif

 /*
  *  Log error messages on disk if required
  */
    if ( shift_log_size > 0 ) { char *p;
	strcpy(shiftlog,shift_binary);
	p = (char*)strrchr(shiftlog,'/');
	strcpy(p ? p+1 : shiftlog,"sfdpmd.log");
	ctrl_vperror(VPLOGFILE,shiftlog,shift_log_size);
    }

 /*
  *  Daemon loop
  */
    for(;;) {

     /*
      *  Exit the loop
      */
        if ( dpmdquit ) break;

     /*
      *  Accept a new connection
      */
	namelen = sizeof(struct sockaddr);
	if ( (newsock = accept(sock,&name,&namelen)) < 0 ) {
	    if ( errno == EINTR ) continue;
	    vperror(1,"accept()");
	    sfexit(1);
	}

     /*
      *  Reload the SHIFT configuration from disk if it was modified
      */
        switch ( load_configuration(TRUE,TRUE,TRUE) ) {
	    case 1 :
		if ( reload_parameters() < 0 ) {
		    send_error(newsock,str_vperror());
		    continue;
		}
	    case 0 :
		break;
	    default :
		strcpy(errmsg,str_vperror());
		vperror(0,"can't load the configuration: %s",errmsg);
		send_error(newsock,str_vperror());
		continue;
	}

     /*
      *  Fork a child to accept the next connection
      */
	switch ( fork() ) {
	    case -1 :
		vperror(1,"fork()");
		send_error(newsock,str_vperror());
		continue;
	    case 0 : 						       /* child	*/
		exit(handle_sfrequest(newsock));
	    default : 						      /* parent	*/
		close(newsock);
		break;
	} /* switch */

    } /* loop */

    return(0);
}

/*
 *  Bind the Shift DPM Daemon
 *
 *  INPUT
 *	shiftport		port number
 *
 *  RETURN
 *	socket created
 */
int bind_sfdpmd(port)
port_t port;
{
  struct servent *server;
  struct sockaddr_in name;
  int namelen,sock;
  host_t localhost;
  int optval		  = 1;

 /*
  *  Create the socket
  */
    if ( (sock = socket(AF_INET,SOCK_STREAM,0)) < 0 ) {
        vperror(1,"socket()");
        sfexit(1);
    }

 /*
  *  Set the REUSEADDR socket option
  */
    if ( setsockopt(sock,SOL_SOCKET,SO_REUSEADDR,(char*)&optval,sizeof(int)) < 0 ) {
        vperror(1,"setsockopt()");
        sfexit(1);
    }

 /*
  *  Get the local host name and assigned port number
  */
    gethostname(localhost,sizeof(host_t));

    if ( port == UNDEF_PORT ) {
	if ( (server = getservbyname("shiftdpm","tcp")) == NULL ) {
	    vperror(1,"getservbyname(shiftdpm,tcp)");
	    sfexit(1);
	}
	port = ntohs(server->s_port);
    }

 /*
  *  Bind the socket
  */
    if ( create_sockaddr_in(localhost,port,&name) < 0 )
        sfexit(1);

    if ( bind(sock,(struct sockaddr *)&name,sizeof(struct sockaddr_in)) < 0 ) {
        vperror(1,"bind()");
        sfexit(1);
    }

 /*
  *  Return the socket
  */
    printf("Listening on ip:%s[%d]\n",localhost,port);
    return(sock);
}

/*
 *  Load the SHIFT configuration parameters required to execute sfget and sfrm
 *
 *  RETURN
 *	1		successful completion
 *     < 0		an error occured
 */
int reload_parameters()
{
  int reply;

    if ( (reply = getreadtmpmode()) < 0 )
	return(reply);

    return(1);
}

/*
 *  Handle a SHIFT request
 *
 *  INPUT
 *	sock		socket connected to the remote client
 *
 *  RETURN
 *	0		successful completion
 *	1		an error occured
 */
int handle_sfrequest(sock)
int sock;
{
  pkt_t pkt;
  int reply;

 /*
  *  Initialize the packet structure and the timeout
  */
    pktinit(&pkt);
    set_timeout(TIME,SFREQ_TIMEOUT);

 /*
  *  Read the Shift request
  */
    switch ( (reply = read_packet(sock,&pkt)) ) {
	case EPKTOK :
		break;
	case EPKTZERO :
		pktfree(&pkt);
		close(sock);
		return(1);
	default :
		vperror(0,"unexpected read_packet() reply (%d)",reply);
	case EPKTWAIT :
	case EPKTFAIL :
	case EPKTSIZE :
	case EPKTVERS :
		exception(ebad);
    } /* switch */

 /*
  *  Dispatch the request
  */
    pkt.ptr = pkt.netbody;
    switch ( pkt.request ) {
	case PKT_SFGET :
		return(handle_sfget(sock,&pkt));
	case PKT_SFRM :
		return(handle_sfrm(sock,&pkt));
	default :
		break;
    }

    vperror(0,"unknown packet request (%d)",pkt.request);

handle_exception(ebad) :
		send_error(sock,str_vperror());
		pktfree(&pkt);
		return(1);
}

/*
 *  Handle the sfget request
 *
 *  INPUT
 *	sock		socket connected to the remote client
 *	pkt		sfget packet received by the remote client
 *
 *  RETURN
 *	0		successful completion
 *	1		an error occured
 */
int handle_sfget(sock,pkt)
int sock;
pkt_t *pkt;
{
  pool_name_t pool;
  path_t file;
  int sfreply,pathuid,clientuid;
  long size;
  byte look,table,remove,atomic;
  int mask,clientmask;
  path_t msg;

#if defined ( TRACE )
    if ( TRACE_connect )
	printf("sfget request received\n");
#endif

 /*
  *  Unmarshall the sfget request
  */
    unmarshall_LONG(pkt->ptr,pathuid);
    unmarshall_LONG(pkt->ptr,clientuid);
    unmarshall_LONG(pkt->ptr,size);
    unmarshall_LONG(pkt->ptr,clientmask);
    unmarshall_STRING(pkt->ptr,pool);
    unmarshall_STRING(pkt->ptr,file);
    unmarshall_BYTE(pkt->ptr,look);
    unmarshall_BYTE(pkt->ptr,table);
    unmarshall_BYTE(pkt->ptr,remove);
    unmarshall_BYTE(pkt->ptr,atomic);

#if defined ( TRACE )
    if ( TRACE_connect ) {
	printf("unmarshall pathuid   : %d\n",pathuid);
	printf("unmarshall clientuid : %d\n",clientuid);
	printf("unmarshall size      : %d\n",size);
	printf("unmarshall mask      : %o\n",clientmask);
	printf("unmarshall pool      : %s\n",pool);
	printf("unmarshall file      : %s\n",file);
	printf("unmarshall look      : %s\n",(boolean)look ? "yes" : "no");
	printf("unmarshall table     : %s\n",(boolean)table ? "yes" : "no");
	printf("unmarshall remove    : %s\n",(boolean)remove ? "yes" : "no");
	printf("unmarshall atomic    : %s\n",(boolean)atomic ? "yes" : "no");
    }
#endif

 /*
  *  Do sfget ( locally )
  */
    mask = umask(clientmask);
    sfreply = dosfget(pool,
		      pathuid,clientuid,
		      (boolean)look,(boolean)table,(boolean)remove,
		      size,
		      file,
		      (boolean)atomic,
		      msg);
    umask(mask);

 /*
  *  Send back the reply
  */
    switch ( sfreply ) {
	case EXFND :
		break;
	case EXCREA :
		if ( !(boolean)look ) break;
	default :
		strcpy(msg,str_vperror());
		break;
    }

    return(send_sfreply(sock,pkt,sfreply,msg));
}

/*
 *  Handle the sfrm request
 *
 *  INPUT
 *	sock		socket connected to the remote client
 *	pkt		sfrm packet received by the remote client
 *
 *  RETURN
 *	0		successful completion
 *	1		an error occured
 */
int handle_sfrm(sock,pkt)
int sock;
pkt_t *pkt;
{
  pool_name_t pool;
  path_t file;
  int sfreply,pathuid,clientuid;
  byte atomic;
  path_t msg;

#if defined ( TRACE )
    if ( TRACE_connect )
	printf("sfrm request received\n");
#endif

 /*
  *  Unmarshall the sfrm request
  */
    unmarshall_LONG(pkt->ptr,pathuid);
    unmarshall_LONG(pkt->ptr,clientuid);
    unmarshall_STRING(pkt->ptr,pool);
    unmarshall_STRING(pkt->ptr,file);
    unmarshall_BYTE(pkt->ptr,atomic);

#if defined( TRACE )
    if ( TRACE_connect ) {
	printf("unmarshall pathuid   : %d\n",pathuid);
	printf("unmarshall clientuid : %d\n",clientuid);
	printf("unmarshall pool      : %s\n",pool);
	printf("unmarshall file      : %s\n",file);
	printf("unmarshall atomic    : %s\n",(boolean)atomic ? "yes" : "no");
    }
#endif

 /*
  *  Do sfrm ( locally )
  */
    sfreply = dosfrm(pool,
		     pathuid,clientuid,
		     file,
		     (boolean)atomic,
		     msg);

 /*
  *  Send back the reply
  */
    switch ( sfreply ) {
	case EXFND :
		break;
	default :
		strcpy(msg,str_vperror());
		break;
    }

    return(send_sfreply(sock,pkt,sfreply,msg));
}

/*
 *  Send the reply of a SHIFT request
 *
 *  INPUT
 *	sock		socket connected to the remote client
 *	pkt		packet structure to be used
 *	reply		reply code to send
 *	msg		message to send
 */
int send_sfreply(sock,pkt,reply,msg)
int sock;
pkt_t *pkt;
int reply;
char *msg;
{
 /*
  *  Allocate the packet body
  */
    pkt->length = sizeof(LONG)+strlen(msg)+1;
    if ( (pkt->ptr = pktalloc(pkt,pkt->length)) == NULL )
	exception(ebad);

#if defined( TRACE )
    if ( TRACE_connect ) {
	printf("sending shift reply\n");
	printf("marshall reply   : %d\n",reply);
	printf("marshall message : %s\n",msg);
    }
#endif

 /*
  *  Build the SFREPLY packet
  */
    pkt->request = PKT_SFREPLY;
    marshall_LONG(pkt->ptr,reply);
    marshall_STRING(pkt->ptr,msg);

 /*
  *  Send the packet
  */
    switch ( (reply = write_packet(sock,pkt)) ) {
	case EPKTOK :
		break;
	default :
		vperror(0,"unexpected write_packet() reply (%d)",reply);
	case EPKTPIPE :
	case EPKTWAIT :
	case EPKTFAIL :
		break;
    }

 /*
  *  Deallocate memory and close the connection
  */
    pktfree(pkt);
    close(sock);
    return(reply == EPKTOK ? 0 : 1);

handle_exception(ebad) :
		send_error(sock,str_vperror());
		pktfree(pkt);
		return(1);
}

/*
 *  Send an error message
 *
 *  INPUT
 *	sock		socket connected to the remote client
 *	message		error message to send
 */
int send_error(sock,message)
int sock;
char *message;
{
  pkt_t pkt;

#if defined( TRACE )
    if ( TRACE_connect )
	printf("send error %s\n",message);
#endif
    pktinit(&pkt);
    pkt.request = PKT_BADSTATUS;
    pkt.netbody = message;
    pkt.length = strlen(pkt.netbody)+1;
    write_packet(sock,&pkt);
    close(sock);
}
