.\"@(#)sfdpmd.man	3.2 08/20/93 CERN-SW/DC Fabrizio Cane
.\ Copyright (C) 1993 by CERN/CN/SW/DC
.\ All rights reserved
.\"
.nh
.TH sfdpmd l "24/04/92"
.SH NAME
sfdpmd \- Shift DPM daemon
.SH SYNOPSIS
sfdpmd 
.B " "\-help 
\ |  [ 
.B \-shiftport 
port ] 
.br
.SH DESCRIPTION
sfdpmd starts the daemon handling the shift remote dpm operations ( sfget(1), sfrm(1) ).
The port number required by the daemon to listen for the remote requests can be specified
by mean of either the 
.B shiftport option
or the 
.B shell environment 
variable SHIFTDPMPORT or the 
.B /etc/shift.conf 
file ( SHIFT DPMPORT <number> ) or the 
.B /etc/services 
file ( shiftdpm <number>/tcp ). Send a quit signal, SIGQUIT, to properly stop 
the sfdpm daemon.
.br
.SH REMOTE SHIFT OPERATIONS
The sfget and sfrm commands can be executed either locally to the 
.I cpu server 
where they are issued or remotely by a sfdpmd daemon. The mode is selected by mean 
of the items SFGETMODE and SFRMMODE in the 
category DPM ( see sfsyntax(1) ). In case the remote mode is specified the sfget 
and sfrm commands connect the sfdpm daemons running on the host listed in the item
SFDAEMONS. The shift request is sent to the first daemon 
answering to the connect request.
.LP
.B EXAMPLE
.LP
Here is an example of shift dpm installation for a shift
environment formed by host_1, host_2, host_3 and host_4. Let be host_4 a host having
no NFS file system mounted and 
let be host_2 a host that cannot properly get the size of some NFS file systems.
.LP
.ps -2
category DPM
  SFGETMODE  : local noatomic
  (
    host_2   : remote noatomic
    host_4   : remote atomic
  )
  SFRMMODE   : local
  (
    host_2   : remote
  )
  SFSHMODE   : local
  (
    host_2   : remote
    host_4   : remote
  )
  SFDAEMONS  : host_1 host_3
  REMOTESFSH : yes
  RHOSTSFSH  : host_1
.br
.LP
The sfget and sfrm requests issued on host_4 are sent to either host_1 or host_3 
(when host_1 is not available). The
sfrm is the only request that is executed locally but on host_2 ( sfrm doesn't need 
the file system size to remove a file ). The sfsh requests issued on host_2 and
host_4 are sent to host_1 through the rsh function.
.SH SEE ALSO
sfmake(1), sfsyntax(1), sfoptions(1), sfget(1), sfrm(1), sfsh(1)
.SH AUTHORS
Fabrizio Cane, CERN-CN Division CH-1211 Geneva 23, Switzerland (cane@cernvm.cern.ch)
.LP
Felix Hassine, CERN-CN Division CH-1211 Geneva 23, Switzerland (acher@sun2.cern.ch)
.LP
