/*
 * Copyright (C) 1990,1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sfgc.c	1.44 07/22/94 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#if defined( sgi )
#define _BSD_SIGNALS
#ifdef __STDC__
#undef __STDC__
#define __WAS_STDC__
#endif
#endif
#include <signal.h>
#if defined( sgi )
#ifdef __WAS_STDC__
#define __STDC__
#endif
#endif
#include <math.h>
#include <varargs.h>
#if defined( _AIX ) && defined( _IBMR2 )
#include <sys/select.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <shift_types.h>
#include <strtok.h>
#include <strdup.h>
#include <strutil.h>
#include <optutil.h>
#include <parser.h>
#include <table.h>
#include <dpmutil.h>
#include <sfgc2.h>
#ifndef maximum
#define maximum(a,b)      (((a)<(b)) ? (b):(a))
#endif

#define DPMAVAIL
#undef  TRACE
#undef  TRACE_2
#define  TEST
#undef  TRACE_4
#undef  TRACE_5
#undef  TRACE_6

#if defined( TRACE_3 ) || defined( TRACE_4 ) || defined( TRACE_5 )

void printsfgcopt(options,cmp)
sfgcopt_t *options,*cmp;
{
  int field = -20;

#define DIFOPT(s1,s2,f)	(s2 != NULL && s1->f != s2->f ? "*" : " ")

    printf("\nPRINT SFGC OPTIONS\n");
    printf("%*s %s : %s\n",field,"pool",DIFOPT(options,cmp,pool),options->pool?options->pool:"(Null)");
    printf("%*s   : %s\n",field,"group",options->group);
    printf("%*s   : %s\n",field,"user",options->user);
    printf("%*s %s : %s\n",field,"directories",DIFOPT(options,cmp,directories),options->directories?options->directories:"(Null)");
    printf("%*s %s : %s\n",field,"spacestr",DIFOPT(options,cmp,spacestr),options->spacestr?options->spacestr:"(Null)");
    printf("%*s %s : %s\n",field,"ratestr",DIFOPT(options,cmp,ratestr),options->ratestr?options->ratestr:"(Null)");
    printf("%*s %s : %s\n",field,"all",DIFOPT(options,cmp,all),itoynl(options->all));
    printf("%*s %s : %s\n",field,"left",DIFOPT(options,cmp,left),itoynl(options->left));
    printf("%*s %s : %s\n",field,"device",DIFOPT(options,cmp,device),itoynl(options->device));
    printf("%*s %s : %s\n",field,"inquire",DIFOPT(options,cmp,inquire),itoynl(options->inquire));
    printf("%*s %s : %s\n",field,"test",DIFOPT(options,cmp,test),itoynl(options->test));
    printf("%*s %s : %s\n",field,"check",DIFOPT(options,cmp,check),itoynl(options->check));
    printf("%*s %s : %d\n",field,"unmounted",DIFOPT(options,cmp,unmounted),options->unmounted);
    printf("%*s %s : %d\n",field,"factor",DIFOPT(options,cmp,factor),options->factor);
    printf("%*s %s : %s\n",field,"limit",DIFOPT(options,cmp,limit),itoynl(options->limit));
    printf("\n");
    printf("%*s %s : %s TIME\n",field,"timetouse",DIFOPT(options,cmp,timetouse),options->timetouse==MTIME?"MODIFY":"ACCESS");
    printf("%*s %s : %s\n",field,"space",DIFOPT(options,cmp,space),options->space>0?ftoanu(options->space):"undefined");
    printf("%*s %s : %s\n",field,"rate",DIFOPT(options,cmp,rate),options->rate>0?ftoanu(options->rate):"undefined");
    printf("%*s   : %d %d\n",field,"user-ids",options->usergid,options->useruid);
    printf("%*s   : %s %d %d\n",field,"client",options->client,options->clientgid,options->clientuid);
    printf("%*s %s : %s\n",field,"findargs",DIFOPT(options,cmp,findargs),options->findargs);
    printf("%*s %s : %d\n",field,"nodir",DIFOPT(options,cmp,nodir),options->nodir);
    printf("%*s %s : %d\n",field,"nofs",DIFOPT(options,cmp,nofs),options->nofs);
    printf("%*s %s : %s\n",field,"total",DIFOPT(options,cmp,total),ftoanu(options->total));
    printf("%*s %s : %s\n",field,"used",DIFOPT(options,cmp,used),ftoanu(options->used));
    printf("END\n");
}

#endif

int serrno,maxtmpattempts,tmpsleep;

#ifdef DPMAVAIL
boolean option_style;
#endif

proc_t proc[MAXFORK];
int noproc;

boolean died;

int quietmode;

list_t *listhead = NULL;
int listlength;
float listsize;

/*
 *  sfgc usage
 */
void usage(argv,help)
char *argv[];
boolean help;
{
  int field = strlen(argv[0]);

    if ( option_style ) {
        printf("usage: %s -help\n",argv[0]);
        printf("       %s [-p<name] [-g<name>] [-u<name>] [-d<path>] [-U<number>]\n",argv[0]);
        printf("%*s [-s<size>] [-r<rate>] [-l] [-D] [-m] [-a] [-w<number>] [-C]\n",field+7,"");
        printf("%*s [-link<path>] [-b] [-t] [-c] [-q] [-i] -- [find options]\n",field+7,"");
    }
    else {
        printf("usage: %s -help\n",argv[0]);
        printf("       %s [-pool <name>] [-group <name>] [-user <name>]",argv[0]);
        printf(" [-directories <path>]\n%*s [-unmounted <number>] [-space <size>]",field+7,"");
        printf(" [-rate <rate>] [-big] [-test]\n%*s [-device] [-modify] [-access]",field+7,"");
        printf(" [-weight <number>] [-left] [-check]\n%*s [-link <path>] [-collect]",field+7,"");
        printf(" [-quiet] [-inquiry] -- [find options]\n");
    }
    if ( help ) {
        printf("where:\n");
        printf("  find options %25s find is used to select files\n","");
        HELP_options();
    }
}

/*
 *
 */
void gc_printf(va_alist)
va_dcl
{
  va_list args;
  char *fmt;

    if ( !quietmode ) {
	va_start(args);
	fmt = va_arg(args,char*);
	vprintf(fmt,args);
	va_end(args);
    }
}

/*
 *  sfgc
 */
main(argc,argv)
int argc;
char *argv[];
{
#ifdef DPMAVAIL
  extern boolean reloadconfiguration;
#endif
  sfgcopt_t sfgcopt;
  sfgcopt_t *options			= &sfgcopt;
  int reply;

#ifdef DPMAVAIL
 /*
  *  Load the shift configuration
  */
    reloadconfiguration = FALSE;
    if ( load_configuration(TRUE,TRUE,TRUE) < 0 ) {
        vperror(0,"can't load the configuration");
        sfexit(EXCONF);
    }
#endif

 /*
  *  Get the sfgc options
  */
    if ( (reply = getsfgcoption(argc,argv,options)) < 0 )
	sfexit(reply);

    if ( options->pool ) {

     /*
      *  Get the pool file system list
      */
        if ( (reply = getnfspaths( options->pool,
				   *options->user ? options->useruid : -1,
				   *options->user || *options->group ? options->usergid : -1,
				   &options->nofs,
				   &options->poolfs )) < 0 )
	    sfexit(reply);

#ifdef TRACE
        { int k;

	    printf("nofs : %d\n",options->nofs);
	    for (k=0; k<options->nofs; k++) {
	        printf("mount : %s\n",options->poolfs[k].mount);
	        printf("dir   : %s\n",options->poolfs[k].dir);
	        printf("fsidx : %d - pidx : %d\n",options->poolfs[k].fsidx,options->poolfs[k].pidx);
	        printf("num   : %d - level : %d\n",options->poolfs[k].num,options->poolfs[k].level);
	    } /* for */
        }
#endif

	reply = foreachpool(options);

#ifdef TRACE
        { int k;

	    printf("nofs : %d\n",options->nofs);
	    for (k=0; k<options->nofs; k++) {
	        printf("mount : %s\n",options->poolfs[k].mount);
	        printf("dir   : %s\n",options->poolfs[k].dir);
	        printf("fsidx : %d - pidx : %d\n",options->poolfs[k].fsidx,options->poolfs[k].pidx);
	        printf("num   : %d - level : %d\n",options->poolfs[k].num,options->poolfs[k].level);
	    } /* for */
        }
#endif

	if ( options->link && reply >= 0 )
	    sfexit(collect_symbolic_links(options));
	else
	    sfexit(reply);

    } /* if pool is specified */

    else

    {
      sfgcopt_t newoptions;

	if ( (reply = getdirstat(options)) < 0 )
	    sfexit(reply);

	if ( (reply = getpoolspace(options,-1,&newoptions,options->collect?1:0)) < 0 )
	    sfexit(reply);

#ifdef TRACE_5
	printsfgcopt(options,NULL);
#endif

	if ( options->collect || ( reply == 1 && !options->check ) ) {

	    if ( (reply = collect(options,-1,&newoptions)) < 0 )
		sfexit(reply);

	    if ( options->collect ) {
		options->used = listsize;
		newoptions.used = listsize;
		if ( (reply = getpoolspace(options,-1,&newoptions,2)) < 0 )
		    sfexit(reply);
	    }

	    if ( ( !options->collect || ( reply == 1 && !options->check ) ) &&
			(reply = removegarbage(&newoptions,-1)) < 0 )
	    	sfexit(reply);
	}

    }

}

#define POOL_DESCR              "shift disk pool to be scanned"
#define GROUP_DESCR             "scan is restricted to the group"
#define USER_DESCR              "scan is restricted to the user"
#define DIRECTORIES_DESCR	"scan is restricted to the directories"
#define UNMOUNTED_DESCR         "expected number of unmounted filesystem"
#define ALL_DESCR		"remove all selected files"
#define BIG_DESCR		"file size limit"
#define SPACE_DESCR             "used space to deallocate"
#define RATE_DESCR              "percentage of used space to deallocate"
#define WEIGHT_DESCR            "tune the sorting algorithm [0..500]"
#define COLLECT_DESCR		"collect the used space"
#define MODIFY_DESCR            "use the last modify time to sort"
#define ACCESS_DESCR            "use the last access time to sort"
#define LEFT_DESCR              "rate and space specify the space left"
#define DEVICE_DESCR            "rate refers to the physical device size"
#define INQUIRE_DESCR           "ask whether to delete each file"
#define QUIET_DESCR             "quiet mode"
#define CHECK_DESCR             "just check if any file must be deleted"
#define TEST_DESCR              "the files are not really deleted"
#define PERMANENT_DESCR         "override the permanent pool attribute"
#define LINK_DESCR		"remove symbolic links"

/*
 *  Get the sfgc options
 */
int getsfgcoption(argc,argv,options)
int argc;
char *argv[];
sfgcopt_t *options;
{
#ifndef DPMAVAIL
  char *ent;
#endif
  boolean show_help;
  boolean show_options;
  boolean ismodifytime;
  boolean isaccesstime;
  int reply;

#ifdef DPMAVAIL
 /*
  *  Get the option style setup
  */
    getoptstyle(&option_style);
#else
    option_style = !(ent = getenv("DPMOPTIONSTYLE")) || 
                        !strcasecmp(options_style,"XWINDOW");
#endif

 /*
  *  Define the options available
  */
    INIT_options();
    if ( option_style )
        DEFAULT_mask(UNIX_MASK);
    else
        DEFAULT_mask(VMS_MASK);

    ADD_OPT_options(&show_help,&show_options);

    DEFAULT_mask(NMLIST | FILIST | EXTVAL | ALLOC | DESCR);

    ADD_options("pool",ENVIR | NAMENV,STRING,"DPMPOOL",&options->pool,POOL_DESCR);
    ADD_options("group",ENVIR | NAMENV | NOALLOC,STRING,"DPMGROUP",options->group,GROUP_DESCR);
    ADD_options("user",ENVIR | NAMENV | NOALLOC,STRING,"DPMUSER",options->user,USER_DESCR);
    ADD_options("directories",0,STRING,&options->directories,DIRECTORIES_DESCR);

    ADD_options("Unmounted",0,INT,&options->unmounted,UNMOUNTED_DESCR);
    ADD_options("space",0,STRING,&options->spacestr,SPACE_DESCR);
    ADD_options("rate",0,STRING,&options->ratestr,RATE_DESCR);
    ADD_options("weight",0,INT,&options->factor,WEIGHT_DESCR);
    ADD_options("link",NOSINGLE | NOPREFIX | ENVIR | NAMENV,STRING,"DPMLINKDIR",&options->link,LINK_DESCR);

    DEFAULT_mask(NOEXTVAL | EXTSEL);

    ADD_options("Collect",0,NONE,&options->collect,COLLECT_DESCR);
    ADD_options("All",0,NONE,&options->all,ALL_DESCR);
    ADD_options("big",0,NONE,&options->limit,BIG_DESCR);
    ADD_options("left",0,NONE,&options->left,LEFT_DESCR);
    ADD_options("Device",0,NONE,&options->device,DEVICE_DESCR);
    ADD_options("modify",0,NONE,&ismodifytime,MODIFY_DESCR);
    ADD_options("access",0,NONE,&isaccesstime,ACCESS_DESCR);
    ADD_options("inquire",0,NONE,&options->inquire,INQUIRE_DESCR);
    ADD_options("quiet",0,NONE,&quietmode,QUIET_DESCR);
    ADD_options("check",0,NONE,&options->check,CHECK_DESCR);
    ADD_options("test",0,NONE,&options->test,TEST_DESCR);

 /*
  *  Initialize the option values before calling READ_options()
  */
    options->pool = NULL;
    *options->group = EOS;
    *options->user = EOS;
    options->directories = NULL;
    options->spacestr = NULL;
    options->ratestr = NULL;
    options->link = NULL;

    options->linkscan = 0;	/* not modified by READ_options() */
    options->unmounted = 0;
    options->factor = 0;

 /*
  *  Get the option values
  */
    if ( READ_options(argc,argv) < 0 ) {
        usage(argv,FALSE);
        sfexit(EXOPT);
    }

    if ( show_help && NO_opts()==1 ) {
        usage(argv,TRUE);
        sfexit(EXHELP);
    }

    if ( show_options )
        LIST_options();

#ifdef TRACE
    printf("opts %d\n",NO_opts());
    printf("args %d\n",NO_args());
#endif

    if ( options->link && !options->pool ) {
	vperror(0,"pool required");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( !options->pool && !options->directories ) {
	vperror(0,"pool or directories required");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( *options->user && *options->group ) {
	vperror(0,"user name already implies a group name");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( (*options->user || *options->group) && !options->pool ) {
	vperror(0,"user and group can be specified only within a pool");
	usage(argv,FALSE);
	return(EXOPT);
    }
 
    if ( options->directories && options->pool && !*options->user ) {
	vperror(0,"directories within a pool require a user name");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( (options->directories || *options->group || *options->user) &&
			!options->spacestr && !options->ratestr &&!options->all ) {
	vperror(0,"either space or rate or all option required");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( options->left && !options->spacestr && ( !options->ratestr || !options->device) ) {
	vperror(0,"left option requires either space or rate and device options");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( options->device && (!options->ratestr || !options->left) ) {
	vperror(0,"device option requires left and rate options");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( (options->spacestr>0 + options->ratestr>0 + options->all>0) > 1 ) {
	vperror(0,"only one of the space, rate and all options can be specified");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( options->collect && !options->ratestr ) {
	vperror(0,"collect option requires the rate option\n");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( options->limit && !options->pool ) {
	vperror(0,"big option requires a pool specification");
	return(EXOPT);
    }

    if ( ismodifytime && isaccesstime ) {
	vperror(0,"modify time and access time options cannot be both specified");
	usage(argv,FALSE);
	return(EXOPT);
    }

    if ( ismodifytime || !isaccesstime )
	options->timetouse = MTIME;
    else
	options->timetouse = ATIME;

    options->factor = options->factor/100.0;

#ifndef TEST
    if ( options->pool && geteuid() != ROOTUID && !options->test ) {
	vperror(0,"Can't be root: root owner or set-bit required\nincomplete installation");
	return(EXCONF);
    }
#endif

    if ( (reply = convertoptions(options)) < 0 ) return(reply);

    if ( (reply = getdirectories(options)) < 0 ) return(reply);

    if ( (reply = buildfindargs(argc,argv,&options->findargs,(boolean)0)) < 0 ) return(reply);

#ifdef TRACE
    printf("find args : %s\n",options->findargs);
#endif

    return(1);
}

/*
 *  Process and convert some options
 */
int convertoptions(options)
sfgcopt_t *options;
{
  int inum;

 /*
  *  Get the group and/or user ids
  */
    if ( *options->group && get_groupbyname(options->group,&options->usergid) < 0 ) {
	vperror(0,"unknown group name <%s>",options->group);
	return(EXOPT);
    }

    if ( *options->user ) {

	if ( get_userbyname(options->user,&options->useruid,&options->usergid) < 0 ) {
	    vperror(0,"unknown user name <%s>",options->user);
	    return(EXOPT);
	}

	if ( get_groupbyid(options->group,options->usergid) < 0 ) {
	    vperror(1,"getgrgid(%d)",&options->usergid);
	    return(EXSYS);
	}

    }

 /*
  *  Get the group and user ids of the client and its name
  */
    options->clientuid = getuid();
    options->clientgid = getgid();
    if ( get_userbyid(options->client,options->clientuid,NULL) < 0 ) {
	vperror(1,"getpwuid(%d)",options->clientuid);
	return(EXSYS);
    }

 /*
  *  Convert the space option ( the string format is <number><unit> ) 
  */
    if ( !options->spacestr )
	options->space = -1;
    else
    if ( (options->space = anutof(options->spacestr)) < 0 ) {
	if ( options->space == -1.0 )
	    vperror(0,"invalid unit character in space option");
	else
	    vperror(0,"invalid number in space option");
	return(EXOPT);
    }

 /*
  *  Convert the rate option ( the string format is <non-negative number> in [0..100] )
  */
    if ( !options->ratestr )
	options->rate = -1;
    else
    if ( atoinum(options->ratestr,&inum) < 0 ) {
	vperror(0,"invalid rate specification");
	return(EXOPT);
    }
    else
	options->rate = (float)inum;

 /*
  *  Convert the weight option ( <number> in [0..500] )
  */
    if ( options->factor && ( options->factor < 0 || options->factor > 500 ) ) {
	vperror(0,"weight number is out of range [0..500]");
	return(EXOPT);
    }

    return(1);
}

#define DIRSEPCHAR	":"

/*
 *  Get the directory paths specified in the command line and store them into a directory table
 */
int getdirectories(options)
sfgcopt_t *options;
{
  extern fsys_t *fsys_table;
  extern index_t_s fsysidx;
  char *p;

    options->nodir = 0;
    if ( options->directories && strtok(options->directories,":") ) {

	do options->nodir++; while ( strtok(NULL,":") );

	if ( !(options->dir = (char**)malloc(sizeof(char*)*options->nodir)) ) {
	    vperror(1,"malloc(%d*%d)",sizeof(char*),options->nodir);
	    return(EXSYS);
	}

	options->nodir = 0;
	p = strtok(options->directories,DIRSEPCHAR);
	while ( p ) {

	    if ( !(options->dir[options->nodir] = strdup(p)) ) {
		vperror(1,"malloc(%d)",strlen(p)+1);
		return(EXSYS);
	    }

	    options->nodir++;
	    p = strtok(NULL,DIRSEPCHAR);

	} /* while */

    } /* if */

#ifdef TRACE
    { int k;

	printf("nodir : %d\n",options->nodir);
	for (k=0; k<options->nodir; k++)
	    printf("dir[%d] : %s\n",k,options->dir[k]);
    }
#endif

    return(1);
}

/*
 *
 */
void remove_brackets(str)
char *str;
{
  char* p;
    if ( (int)strlen(str) < 5 ) return;
    p = str+strlen(str)-1;
    if ( *p != ')' && *(--p) != '\\' ) return;
    while ( p-- != str ) {
        if ( *p == '(' ) {
            if ( *(--p) != '\\' ) return;
	*p = '\0';
        }
        else
        if ( !isspace(*p) ) return;
    }
}

#define FINDARGSLEN	200

/*
 *  Build the argument list to be passed to the find command - The find options generating 
 *  output are not allowed ( because '-print is already added ) - The quota and escape
 *  character are added to the characters that must be quoted or escaped ( like '*' and '(' )
 *
 *  The parameter link has been added later and the parameters argc and argv has been 
 *  renamed at the same time in order to store them and be able to call twice buildfindargs()
 *  (the first time to build the find string to search for files and the second to search for links)
 */
int buildfindargs(pargc,pargv,arguments,link)
int pargc;
char **pargv;
char **arguments;
boolean link;
{
  static int argc;
  static char **argv;
  string findargs;
  int argi,k;
  char *str1ch = " ";

    if ( !link ) {
        argc = pargc;
        argv = pargv;
    }

    INIT_string(&findargs,FINDARGSLEN);

    if ( !NO_args() )

     /*
      *  If no find command argument is specified then all files are selected
      */
	CPY_string(&findargs,"-name '*'");

    else {

     /*
      *  Scan the command line containing the find command arguments
      */
	argi = argc - NO_args() - 1;
	while ( ++argi < argc ) {

	 /*
	  *  The find command options generating output are not allowed
	  */
	    if ( !strcmp(argv[argi],"-exec") ||
		    !strcmp(argv[argi],"-ok") ||
		       !strcmp(argv[argi],"-print") ||
		          !strcmp(argv[argi],"-ls") ||
		             !strcmp(argv[argi],"-cpio") ||
			        !strcmp(argv[argi],"-ncpio") ) {
		    vperror(0,"find command argument <%s> not allowed",argv[argi]);
		    return(EXOPT);
                }

                if ( link )
                    if ( strcmp(argv[argi],"-name") && strcmp(argv[argi],"-user") && strcmp(argv[argi],"-group") &&
                            strcmp(argv[argi],"-atime") && strcmp(argv[argi],"-mtime") && strcmp(argv[argi],"-ctime") ) {
                        if ( strcmp(argv[argi-1],"-nouser") && strcmp(argv[argi-1],"-nogroup") )
                            continue;
                    }
                    else
                    if ( ++argi < argc) {
                        CAT_string(&findargs,argv[argi-1]);
                        CAT_string(&findargs," ");
                    }
                    else
                        continue;

	 /*
	  *  Scan the argument to look for character that must be quoted or escaped
	  */
	    for (k=0; k<(int)strlen(argv[argi]); k++)
		switch ( argv[argi][k] ) {
		    case '*' :  CAT_string(&findargs,"'*'");
				break;
		    case '?' :  CAT_string(&findargs,"'?'");
				break;
		    case '(' :  CAT_string(&findargs,"\\(");
				break;
		    case ')' :  CAT_string(&findargs,"\\)");
				remove_brackets(GET_string(&findargs));
				break;
		    default  :  str1ch[0] = argv[argi][k];
				CAT_string(&findargs,str1ch);
				break;
		} /* switch */

	 /*
	  *  Separate the arguments each other by a space
	  */
	    if ( argi+1 < argc ) CAT_string(&findargs," ");

	} /* while */

    } /* if */

 /*
  *  Check if any error occured during memory allocation
  */
    if ( LEN_string(&findargs) < 0 ) return(EXSYS);

 /*
  *  Output & Return
  */
    *arguments = GET_string(&findargs);
    return(1);
}

/*
 *
 */
int sfgc_authorization(pool,poolidx,overperm)
char *pool;
index_t_s poolidx;
boolean overperm;
{
  extern pool_t* pool_table;
  user_t client;

 /*
  *  Check the permanent attribute
  */
    if ( pool_table[poolidx].permanent && !overperm ) {
	vperror(0,"Pool <%s> is PERMANENT",pool);
	return(EXPERM);
    }

 /*
  *  Check the client be authorized to run the garbage collector on the pool
  */
    if ( look_account(poolidx,getuid(),getgid(),TRUE) < 0 ) {
	if ( get_userbyid(client,getuid(),NULL) < 0 )
	    sprintf(client,"uid %d",getuid());
	vperror(0,"You <%s> are not authorized to garbage the pool <%s>",client,pool);
	return(EXPERM);
    }
    return(TRUE);
}

/*
 *  For each pool specified in the command line run the garbage collector
 */
int foreachpool(options)
sfgcopt_t *options;
{
  extern pool_t *pool_table;
  sfgcopt_t newoptions;
  index_t_s pidx;
  int k,reply = -1;

#ifdef TRACE_3
    printsfgcopt(options,NULL);
#endif

    k = 0;
    while ( k < options->nofs ) {

	pidx = options->poolfs[k].pidx;

	if ( k ) gc_printf("\n");
	gc_printf("POOL %s\n",pool_table[pidx].name);

	if ( sfgc_authorization(pool_table[pidx].name,pidx,FALSE) != 1 ) {
	    k += options->poolfs[k].num;
	    continue;
	}

	if ( (reply = getpoolstat(options,k)) < 0 ) {
	    k += options->poolfs[k].num;
	    continue;
	}

#ifdef TRACE
	printf("mounted %d over %d\n",options->poolfs[k].num,options->poolfs[k].level);
	printf("total %s - used %s\n",ftoanu(options->total),ftoanu(options->used));
#endif

	if ( !options->poolfs[k].level ) {
	    vperror(0,"No file system accessible in pool <%s>",pool_table[pidx].name);
	    k += options->poolfs[k].num;
	    continue;
	}

	if ( options->poolfs[k].level < options->poolfs[k].num - options->unmounted ) {
	    vperror(0,"Not enough (%d over %d-%d) file systems accessible in pool <%s>",
		       options->poolfs[k].level,
		       options->poolfs[k].num,
		       options->unmounted,
		       pool_table[options->poolfs[k].pidx].name);
	    k += options->poolfs[k].num;
	    continue;
	}

        if ( (reply = getpoolspace(options,pidx,&newoptions,options->collect?1:0)) < 0 ) {
	    k += options->poolfs[k].num;
	    continue;
	}

#ifdef TRACE_3
	printsfgcopt(&newoptions,options);
#endif

	if ( options->collect || ( reply == 1 && !options->check ) ) {

	    if ( (reply = collect(options,k,&newoptions)) < 0 ) {
		k += options->poolfs[k].num;
		continue;
	    }

	    if ( options->collect ) {
		options->used = listsize;
		newoptions.used = listsize;
		if ( (reply = getpoolspace(options,pidx,&newoptions,2)) < 0 ) {
		    k += options->poolfs[k].num;
		    continue;
		}
	    }

	    if ( ( !options->collect || ( reply == 1 && !options->check ) ) )
		reply = removegarbage(&newoptions,options->poolfs[k].pidx);
	}

	k += options->poolfs[k].num;

    } /* while */

    return(reply);
}

/*
 *  RETURN
 *	1	garbage collection required ( newoptions contains the information )
 *	0	garbage collection NOT required
 *     < 0 	error occured
 */
int getpoolspace(options,pidx,newoptions,collect)
sfgcopt_t *options;
index_t_s pidx;
sfgcopt_t *newoptions;
int collect;
{
  extern pool_t *pool_table;
  long gclimit;
  int gcmax;
  int gcmin;

  if ( pidx > -1 ) {
	gclimit	= pool_table[pidx].size;
	gcmax = pool_table[pidx].max;
	gcmin = pool_table[pidx].min;
  }

  if ( collect != 2 ) {

 /*
  *  Copy the input option structure into the output option structure
  */
    memcpy((char*)newoptions,(char*)options,sizeof(sfgcopt_t));

 /*
  *  Print the total and used space in the pool
  */
    gc_printf("Total      :  %s\n",ftoanu(newoptions->total));
    gc_printf("Used       :  %s ",ftoanu(newoptions->used));
    gc_printf("(%s%%)\n",ftoanu(newoptions->used*100/newoptions->total));

 /*
  *  Print the file size limit
  */
  if ( pidx > -1 ) {
    gc_printf("Size limit :  %s",gclimit > 0 ? itoanmu(gclimit) : "NONE");
    if ( !newoptions->limit && gclimit > 0 )
	gc_printf(" -> NONE");
    gc_newline;
    if ( newoptions->limit )
	if ( gclimit > 0 )
	    sprintf(options->strlim,"%d",gclimit);
	else
	    newoptions->limit = FALSE;
  }

 /*
  *  Print the garbage collector thresholds
  */
  if ( pidx > -1 ) {
    gc_printf("Thresholds :  ");
    if ( !gcmax )
	gc_printf("NONE\n");
    else {
	gc_printf("%d%%-%d%%",gcmin,gcmax);
	if ( newoptions->space != -1 || newoptions->rate != -1 || newoptions->all )
	    gc_printf(" -> NONE");
	gc_newline;
    }
  }

  } /* if collect != 2 */

  if ( collect == 1 ) return(1);

  if ( collect == 2 )
	gc_printf("Selected   :  %s\n",ftoanu(options->used));

 /*
  *  Print the amount of space to be collected
  */
    gc_printf("Collect    :  ");

 /*
  *  By default the pool thresholds are used
  */
    if ( newoptions->rate == -1 && newoptions->space == -1 && !newoptions->all )
	if ( !gcmax || pidx < 0 ) {
	    gc_printf("no thresholds specified in the configuration\n");
	    return(0);
	}
	else {
	    newoptions->rate = newoptions->used*100/newoptions->total;
	    if ( newoptions->rate < (float)gcmax ) {
		gc_printf("not required\n");
		return(0);
	    }
	    else {
		newoptions->rate = newoptions->rate-(float)gcmin;
		newoptions->space = newoptions->total/100.0*newoptions->rate;
		gc_printf("%s ( %s%%",ftoanu(newoptions->space),ftoanu(newoptions->rate));
		gc_printf(" of the %s space )\n",collect==2?"selected":"used");
		newoptions->rate = -1;
		return(1);
	    }
	}

 /*
  *  Check the -all option ( -left is supported )
  */
    if ( newoptions->all ) {
	if ( newoptions->left )
	    gc_printf("all NOT selected files\n");
	else
	    gc_printf("all selected files\n");
	return(1);
    }

 /*
  *  Check the -rate option ( -left and/or -device is supported )
  */
    if ( newoptions->rate != -1 ) {
	if ( !newoptions->device ) {
	    if ( newoptions->left ) {
		newoptions->rate = 100.0-newoptions->rate;
		newoptions->left = FALSE;
	    }
	    newoptions->space = newoptions->used/100*newoptions->rate;
	    gc_printf("%s ( %0.0f%%",ftoanu(newoptions->space),newoptions->rate);
	    gc_printf(" of the %s space )\n",collect==2?"selected":"used");
	}
	else {
	    if ( !newoptions->left ) {
		newoptions->space = newoptions->total/100.0*newoptions->rate;
		gc_printf("%s ( %0.0f%%",ftoanu(newoptions->space),newoptions->rate);
	    }
	    else {
		newoptions->space = newoptions->used-newoptions->total/100.0*newoptions->rate;
		if ( newoptions->space < 0.0 ) {
		    gc_printf("not required\n");
		    return(0);
		}
		gc_printf("%s ( left %0.0f%%",ftoanu(newoptions->space),newoptions->rate);
		newoptions->left = FALSE;
	    }
	    gc_printf(" of the total space )\n");
	    newoptions->device = FALSE;
	}
	newoptions->rate = -1;
	return(1);
   }

 /*
  *  Check the -space option ( -left can be specified )
  */
    if ( newoptions->space != -1 ) {
	if ( !newoptions->left )
	    gc_printf("%s\n",ftoanu(newoptions->space));
	else {
	    newoptions->space = newoptions->used - newoptions->space;
	    if ( newoptions->space > 0 )
		gc_printf("%s\n",ftoanu(newoptions->space));
	    else {
		gc_printf("not required\n");
		return(0);
	    }
	}
	return(1);
    }

    vperror(0,"Internal : selection not handled by getpoolspace()\n");
    return(EXINT);
}

#undef SINGLEDEV
#define MAXDEV	     10

/*
 *  Get the total and used space of the specified directories
 */
int getdirstat(options)
sfgcopt_t *options;
{
  long	ptotal,pavail,bsize;
#ifndef SINGLEDEV
  int dev[MAXDEV];			/* device list			*/
  int idx;				/* device list index		*/
  int nodev		= 0;		/* number of devices		*/
#else
  int dev		= -1;		/* device number flag		*/
  int ddev;				/* device number		*/
#endif
  int k,reply;

 /*
  *  Initialize outputs
  */
    options->total = 0.0;
    options->used = 0.0;

    for (k=0; k<options->nodir; k++) {

	switch ( (reply = getfsystat(options->dir[k],&ptotal,&pavail,&bsize,
#ifndef SINGLEDEV
									    &dev[nodev]
#else
									    &ddev
#endif
										  )) ) {
	  case 1 :

#ifndef SINGLEDEV
	     /*
	      *  Check the directory path be in a new file system
	      */
		idx = 0;
		while ( idx < nodev )
		    if ( dev[nodev] == dev[idx] )
			break;
		    else
			idx++;

	     /*
	      *  If this is a new file system then update the total and used space
	      */
		if ( idx == nodev ) {
		    options->total += (float)ptotal*(float)bsize;
		    options->used += ((float)(ptotal-pavail))*(float)bsize;
		    nodev++;
		    if ( nodev == MAXDEV ) {
			vperror(0,"too many file systems");
			return(EXOPT);
		    }
		}
#else
	     /*
	      *  If this is the first directory path then store the device number
	      */
		if ( dev == -1 ) {
		    options->total = (float)ptotal*(float)bsize;
		    options->used = ((float)(ptotal-pavail))*(float)bsize;
		    dev = ddev;
		}
		else
	     /*
	      *  Check the directory path be in the same device as for the first path
	      */
		if ( dev != ddev ) {
		    vperror(0,"%s is on a different file systems",options->dir[k]);
		    return(EXOPT);
		}
#endif
		break;

	  case -1 :
		vperror(1,"stat(%s)",options->dir[k]);
		return(EXSYS);

	} /* switch */

    } /* for */

    return(1);
}

/*
 *  Get the total and used space of the current pool
 */
int getpoolstat(options,fsidx)
sfgcopt_t *options;
int fsidx;
{
  long	ptotal,pavail,bsize;
  int	mounted,idx,reply;

 /*
  *  Initialize outputs
  */
    options->total = 0.0;
    options->used = 0.0;

 /*
  *  Scan the file system list of the current pool
  */
    mounted = 0;
    idx = fsidx;
    while ( idx < fsidx + options->poolfs[fsidx].num ) {

	switch ( (reply = getfsystat( options->poolfs[idx].mount,
				      &ptotal,&pavail,&bsize,
				      (int*)NULL )) ) {

	 /*
	  *  getfsystat() succeeded
	  */
	    case 1 :
		switch ( is_filesystem(options->poolfs[idx].mount,NULL,0) ) {

		    case FSMNTD :
			(options->total) += (float)ptotal * (float)bsize ;
			(options->used) += ( (float)ptotal - (float)pavail ) * (float)bsize ;
			if ( idx > fsidx + mounted ) {
			    strcpy( options->poolfs[fsidx+mounted].mount,
				    options->poolfs[idx].mount );
			    strcpy( options->poolfs[fsidx+mounted].dir,
				    options->poolfs[idx].dir );
			}
			mounted++;
			break;

		    case FSUMNTD :
			vperror(0,"File system <%s> not mounted",options->poolfs[idx].mount);
			break;

		    default :
			vperror(1,"Can't access file system <%s>",options->poolfs[idx].mount);
			break;

		} /* switch - is_filesystem() reply */
		break;

	 /*
	  *  getfsystat() failure
	  */
	    case -1 :
		if ( is_filesystem(options->poolfs[idx].mount,NULL,errno) == FSUMNTD )
		    vperror(0,"File system <%s> not mounted",options->poolfs[idx].mount);
		else
		    vperror(1,"Can't access file system <%s>",options->poolfs[idx].mount);
		break;

	    default :
		vperror(0,"Internal: unknown getfsystat() reply (%d)",reply);
		return(EXINT);

	} /* switch - getfsystat() reply */

	idx++;

    } /* while - scan file system list */

    options->poolfs[fsidx].level = mounted;

    return(1);
}

#ifdef TRACE_2

void printproc(msg)
char *msg;
{
  int k;
    printf("PROCESS TABLE  -  %s\n",msg);
    for(k=0; k<MAXFORK; k++) {
	printf("pid        : %d\n",proc[k].pid);
	printf("terminated : %s\n",itoynl(proc[k].terminated));
	printf("closed     : %s\n",itoynl(proc[k].closed));
	printf("pipe	   : %d %d\n",proc[k].fd[0],proc[k].fd[1]);
    }
}

#endif

#ifdef TRACE_2

int print_termination_cause(status)
#if defined( ultrix ) || (defined(sgi)  && defined(__EXTENSIONS__))
union wait status;
#else
int status;
#endif
{
    if ( WIFEXITED(status) )
        printf("exit %d",WEXITSTATUS(status));
    else
    if ( WIFSIGNALED(status) )
        printf("signal %d",WTERMSIG(status));
    else
    if ( WIFSTOPPED(status) )
        printf("stopped by signal %d",WSTOPSIG(status));
}

#endif

/*
 *  SIGCHLD handler
 */
#if ( defined( sgi )  && !defined(IRIX5) )|| defined( apollo )
static int sigchld_handler()
#else
static void sigchld_handler()
#endif
{
#if defined( ultrix ) || ( defined(sgi) && defined(__EXTENSIONS__) && !defined(IRIX5) ) 
  union wait status;
#else
  int status;
#endif
  int slot,pid;

#ifdef TRACE_2
    printf("SIGCHLD received\n");
#endif
    while ( 
#if defined ( CRAY ) || defined (SOLARIS) || defined(IRIX5) || ( defined(__osf__) && defined(__alpha) )
	   (pid = waitpid(-1,&status,WNOHANG)) > 0
#else
	   (pid = wait3(&status,WNOHANG,NULL)) > 0
#endif
						   || ( pid < 0 && errno == EINTR ) ) {
        if ( pid > 0 ) {
            for (slot=0; slot<MAXFORK; slot++)
		if ( proc[slot].pid == pid ) break;
#ifdef TRACE_2
            printf("Process pid %d ( slot %d ) terminated - ",proc[slot].pid,slot);
            print_termination_cause(status);
            printf("\n");
#endif
            proc[slot].status = status;
            proc[slot].terminated = TRUE;
            if ( proc[slot].closed ) {
		noproc--;
		died = TRUE;
	    }
        }
        continue;
    }

#if defined( hpux )
    signal((int)SIGCHLD,sigchld_handler);    
#endif
}

/*
 *
 */
int collect(options,fsidx,newoptions)
sfgcopt_t *options;
int fsidx;
sfgcopt_t *newoptions;
{
  extern pool_t *pool_table;
  string shcommand;
  int k,slot,status,reply;
  char *path;
#if (defined(__osf__) && defined(__alpha))
  struct sigaction sa;
#endif


 /*
  *  Initialize data and process table
  */
    INIT_string(&shcommand,50+strlen(options->findargs));

    noproc = 0;

    for (k=0; k<MAXFORK; k++) { 
	proc[k].pid = 0;
	proc[k].closed = TRUE;
	proc[k].terminated = TRUE;
	proc[k].offset = 0;
    }

    if ( (reply = list_deallocate()) < 0 ) return(reply);

 /*
  *  Handle the SIGCHLD signal
  */
#ifdef CRAY
    bsdsignal((int)SIGCHLD,sigchld_handler);
#else
#if defined(SOLARIS)
    signal((int)SIGCHLD,(void (*)())sigchld_handler) ;
#else
#if ( defined(__osf__) && defined(__alpha) )
    sa.sa_handler = sigchld_handler;
    sa.sa_flags = SA_RESTART;
    sigaction (SIGCHLD, &sa, NULL);
#else
    signal((int)SIGCHLD,sigchld_handler);
#endif /* SOLARIS */
#endif /* CRAY */
#endif /* __osf__ && __alpha */

#ifdef TRACE_2
    printproc("BEFORE WHILE");
#endif

 /*
  *  Scan the file system list
  */
    k = 0;
    while ( ( fsidx > -1 && k < options->poolfs[fsidx].level ) ||
		( fsidx < 0 && k < options->nodir ) ) {

     /*
      *  If the process table is full then read data until a child dies
      */
	if ( noproc == MAXFORK ) {
	    if ( (reply = selectoutput(options)) < 0 ) return(reply);
	    continue;
	}

     /*
      *  Look for a free slot in the process table
      */
	for (slot=0; slot<MAXFORK; slot++)
	    if ( proc[slot].terminated && proc[slot].closed ) break;

    /*
     *  Build the complete find command line to pass to the system
     */
	CPY_string(&shcommand,"find ");
	path = fsidx > -1 ? options->poolfs[fsidx+k].dir : options->dir[k];
	CAT_string(&shcommand,path);
	if ( path[strlen(path)-1] != '/' ) CAT_string(&shcommand,"/.");
	if ( (int)strlen(options->findargs) > 0 ) {
	    CAT_string(&shcommand," \\( ");
	    CAT_string(&shcommand,options->findargs);
	    CAT_string(&shcommand," \\)");
	}
	if ( options->limit ) {
	    CAT_string(&shcommand," -size +");
	    CAT_string(&shcommand,options->strlim);
	    CAT_string(&shcommand,"c ");
	}
	if ( options->linkscan )
	    CAT_string(&shcommand," -type l ");
	CAT_string(&shcommand," -print");

    /*
     *  Create a pipe to communicate with the child
     */
	if ( pipe(proc[slot].fd) < 0 )
	    if ( noproc > 0 ) {
		if ( (reply = selectoutput(options)) < 0 ) return(reply);
		continue;
	    }
	    else {
		vperror(1,"pipe()");
		return(EXSYS);
	    }

    /*
     *  The process entry is marked 'not-free'
     */
	proc[slot].closed = FALSE;
	proc[slot].terminated = FALSE;
	proc[slot].offset = 0;

#ifdef TRACE_2
	printproc("BEFORE FORK");
#endif

	switch ( (proc[slot].pid = fork()) ) {

       /*
	*  The process entry is marked 'free' - The error is ignored unless there is no child
	*/
	  case -1 : proc[slot].closed = TRUE;
		    proc[slot].terminated = TRUE;
		    if ( noproc > 0 ) {
			if ( (reply = selectoutput(options)) < 0 ) return(reply);
			continue;
		    }
		    vperror(1,"fork()");
		    return(EXSYS);

       /*
	*  The child ignores the SIGCHLD generated by system() and closes a pipe channel
	*/
	  case  0 : 
#ifdef CRAY
		    bsdsignal((int)SIGCHLD,SIG_IGN);
#else
#if !defined(_AIX)
		/* On AIX systems, system() handles SIGCHLD */
		    signal((int)SIGCHLD,SIG_IGN);
#endif /* AIX */
#endif
		    close(proc[slot].fd[0]);
#ifdef TRACE_2
		    printf("executing command %s\n",GET_string(&shcommand));
#endif
		    if ( dup2(proc[slot].fd[1],1) < 0 ) exit(1);
		    status = system(GET_string(&shcommand));
		    exit(status>>8);

       /*
	*  The parent closes a pipe channel and increases the number of running processes
	*/
	  default : close(proc[slot].fd[1]);
		    noproc++;
#ifdef TRACE_2
		    printf("forked() process %d ( slot %d )\n",proc[slot].pid,slot);
#endif
		    break;

	} /* switch */

	k++;
    }

#ifdef TRACE_2
    printproc("AFTER WHILE");
#endif

 /*
  *  Wait for all processes terminate
  */
    for (;;) {

	reply = selectoutput(options);
#ifdef TRACE_2
	printproc("IN LOOP");
#endif
	if ( reply < 0 ) return(status); else 
	if ( reply == 0 ) break;
    }

#ifdef TRACE_3
    list_print();
#endif

    return(1);
}

/*
 *
 */
int selectoutput(options)
sfgcopt_t *options;
{
  fd_set readfds,writefds;
  boolean leave;
  int k,reply;

  died = FALSE;

  while ( !died ) {

    FD_ZERO(&readfds);
    FD_ZERO(&writefds);

    leave = TRUE;

    for (k=0; k<MAXFORK; k++)
	if ( proc[k].pid > 0 && !proc[k].closed ) {
	    leave = FALSE;
	    FD_SET(proc[k].fd[0],&readfds);
	}

    if ( leave ) return(0);

    switch (select(FD_SETSIZE+1,&readfds,(fd_set*)NULL,(fd_set*)NULL,(struct timeval*)NULL)) {

      case -1 : if ( errno == EINTR ) return(1);
		vperror(1,"select()");
		return(EXSYS);

      case  0 : vperror(0,"Internal : unexpected select() reply (0)");
		return(EXINT);

      default : for (k=0; k<MAXFORK; k++)
		   if ( FD_ISSET(proc[k].fd[0],&readfds) )
			if ( (reply = readoutput(options,k)) < 0 ) return(reply);
		break;

    } /* switch */

  } /* for */

  return(1);
}

/*
 *
 */
int readoutput(options,slot)
sfgcopt_t *options;
int slot;
{
  int nbytes;

    switch ( (nbytes = read( proc[slot].fd[0],
			     proc[slot].buf+proc[slot].offset,
			     PIPBUFSIZ-1-proc[slot].offset )) ) {

      case -1 : vperror(1,"read(%d,%x+%d,%d)",
			   proc[slot].fd[0],
			   proc[slot].buf,
			   proc[slot].offset,
			   PIPBUFSIZ-1-proc[slot].offset);
		return(EXSYS);

      case  0 : close(proc[slot].fd[0]);
#ifdef TRACE_2
		printf("zero-message from process pid %d ( slot %d )\n",proc[slot].pid,slot);
#endif
		proc[slot].closed = TRUE;
		if ( proc[slot].terminated ) {
		    noproc--;
		    died = TRUE;
		}
		break;

      default : proc[slot].buf[nbytes+proc[slot].offset] = EOS;
		storeoutput(options,slot);
		break;

    } /* switch */

    return(1);
}

/*
 *  Split in line (string terminated by a newline character) the output generated be a child
 *
 *  INPUT
 *	options		the garbage collector options
 *	slot		the process having generated the output
 */
int storeoutput(options,slot)
sfgcopt_t *options;
int slot;
{
  char *p,*l;
  int reply;

 /*
  *  Locate the lines in the output buffer of the process
  */
    l = proc[slot].buf;
    p = strchr(l,'\n');
    while ( p != NULL ) {

     /*
      *  Process the line
      */
	*p = EOS;
	if ( (reply = readline(options,l)) < 0 ) return(reply);
	*p = '\n';

	l = p+1;
	p = strchr(l,'\n');
    }

 /*
  *  Save the remaining output
  */
    proc[slot].offset = strlen(l);
    if ( proc[slot].offset > 0 && l != proc[slot].buf )
	strcpy(proc[slot].buf,l);

    return(1);
}

/*
 *  Read a line generated by the shell command executed by a child
 *
 *  INPUT
 *	options		the garbage collector options
 *	line		the line generated by the shell command ( find )
 *
 *  RETURN
 *	1		successful completion
 *     < 0		error
 */
int readline(options,line)
sfgcopt_t *options;
char *line;
{
  struct stat buffer;
  time_t rtime;
  int reply;

    if ( lstat(line,&buffer) < 0 ) {
	if ( errno != ENOENT && errno != ENOTDIR ) {
	    vperror(1,"stat(%s)",line);
	    return(EXSYS);
	}
	return(1);
    }

    if ( S_ISDIR(buffer.st_mode) ) return(1);

    if ( options->timetouse == MTIME ) 
              rtime =  buffer.st_mtime ;
    else
              rtime = maximum(buffer.st_atime,buffer.st_mtime) ;


    if ( (reply = list_insert(line,buffer.st_size,rtime,options->factor)) < 0 )
	return(reply);

    return(1);
}

/*
 *  Compute the key used to sort the file list
 *
 *  INPUT
 *	rtime		file reference time
 *	size		file total size in bytes
 *	factor		weight used in the computation 
 *
 *  RETURN
 *	sorting key of the input file
 */
double weight2(rtime,size,factor)
time_t	rtime;
long	size;
int	factor;
{
 /*
  * (1) :   f(t,s,k) = t * ( 1 - k/sqrt(s) )
  *	    where k is a real in [0,1] and s is an integer in [1,n]
  *
  *	    return((double)rtime*(1+factor/(double)sqrt(size<1024?(double)size/1024.0:1.0)));
  *
  * (2) :   f(t,s,k) = t - log((size/1024)**k)*86400
  *	    where k is a real in [0,n]  ( if k=0 then f(t,s,k) = t )
  */

    return( (double)rtime - 
		( size > 1024 && factor
	    ? 
		log(pow((double)size/1024.0,(double)factor))*86400.0
	    :
		0.0 )
	  );
}

/*
 *  Insert a shift file in the list
 *
 *  INPUT
 *	path		complete nfs-pathname
 *	size		total size in bytes
 *	rtime		reference time
 *	factor		weight used to compute the sorting key
 *
 *  RETURN
 *	1		successful completion
 *     < 0		error ( malloc failure )
 */
int list_insert(path,size,rtime,factor)
char *path;
long size;
time_t rtime;
int factor;
{
  list_t *ptr,*prv,*new;
  double key;

 /*
  *  Compute the sorting key of the shift file
  */
    key = weight2(rtime,size,factor);

 /*
  *  Initialize the list scan
  */
    prv = NULL;
    ptr = listhead;

    do {

	if ( !ptr || key < ptr->key ) {

	 /*
	  *  Allocate a new element and store the information
	  */
	    if ( !(new = (list_t*)malloc(sizeof(list_t))) ) {
		vperror(1,"malloc(%d)",sizeof(list_t));
		return(EXSYS);
	    }

	    if ( !(new->path = strdup(path)) ) {
		vperror(1,"malloc(%d)",strlen(path)+1);
		return(EXSYS);
	    }

	    new->size = size;
	    new->rtime = rtime;
	    new->key = key;

	 /*
	  *  Insert the element in the list
	  */
	    if ( prv == NULL ) {
		new->next = listhead;
		listhead = new;
	    }
	    else {
		new->next = ptr;
		prv->next = new;
	    }

	    listlength ++ ;
	    listsize += (float)size;
	    break;
	}

     /*
      *  Move to the next element in the list
      */
	prv = ptr;
	ptr = ptr ? ptr->next : NULL;

    } while ( prv != NULL );

    return(1);
}

/*
 *  Print the shift file list
 */
void list_print()
{
  list_t *p = listhead;
    while ( p ) {
	printf("%10.0f %-15d %-30s %s\n",p->key,p->size,ctimeln(&p->rtime),p->path);
	p = p->next;
    }
}

/*
 *  Deallocate the 'shift file' list
 */
int list_deallocate()
{
  list_t *m,*p = listhead;
    while ( p ) {
	if ( p->path != NULL ) free(p->path);
	m = p;
	p = p->next;
	free(m);
    }
    listlength = 0;
    listsize = 0.0;
    listhead = NULL;
    return(1);
}

/*
 *  Remove from disk the items that are in the 'shift file' list
 */
int removegarbage(options,pidx)
sfgcopt_t *options;
int pidx;
{
  extern pool_t *pool_table;
  list_t *p;
  int remove,nofiles;
  float space;
  char *pool,ch;

    if ( !options->linkscan ) 
	pool = pidx > -1 ? pool_table[pidx].name : options->directories ;

    if ( !listlength ) {
	if ( options->linkscan )
	    gc_printf("no symbolic link selected by 'find %s%s%s%s -type l' to be removed\n",
		       options->link,
		       (int)strlen(options->findargs) > 0 ? " \\( " : "",
		       options->findargs,
		       (int)strlen(options->findargs) > 0 ? " \\)" : "");
	else
	if ( !options->limit )
	    gc_printf("no file selected by find %s%s%s %s\n",
		       pidx > -1 ? "<pool " : "",
		       pool,
		       pidx > -1 ? ">" : "",
		       options->findargs);
	else
	    gc_printf("no file selected by find %s%s%s%s%s%s -size +%sc\n",
		       pidx > -1 ? "<pool " : "",
		       pool,
		       pidx > -1 ? ">" : "",
		       (int)strlen(options->findargs) > 0 ? " \\( " : "",
		       options->findargs,
		       (int)strlen(options->findargs) > 0 ? " \\)" : "",
		       ftoanu((float)pool_table[pidx].size));
	return(0);
    }

    if ( options->linkscan )
	gc_printf("%d symbolic link(s) selected by 'find %s%s%s%s -type l' to be removed\n",
		   listlength,
		   options->link,
		   (int)strlen(options->findargs) > 0 ? " \\( " : "",
		   options->findargs,
		   (int)strlen(options->findargs) > 0 ? " \\)" : "");
    else
    if ( !options->limit )
	gc_printf("%d file(s) / %s Bytes selected by find %s%s%s %s\n",
		   listlength,
		   ftoanu(listsize),
		   pidx > -1 ? "<pool " : "",
		   pool,
		   pidx > -1 ? ">" : "",
		   options->findargs);
    else
	gc_printf("%d file(s) / %s Bytes selected by find %s%s%s%s%s%s -size +%sc\n",
		   listlength,
		   ftoanu(listsize),
		   pidx > -1 ? "<pool " : "",
		   pool,
		   pidx > -1 ? ">" : "",
		   (int)strlen(options->findargs) > 0 ? " \\( " : "",
		   options->findargs,
		   (int)strlen(options->findargs) > 0 ? " \\)" : "",
		   ftoanu((float)pool_table[pidx].size));

#ifdef TRACE_4
    printsfgcopt(options,NULL);
#endif

 /*
  *  Scan the file list
  */
    space = 0.0;
    nofiles = 0;
    p = listhead;
    while ( p ) {

     /*
      *  Print the current file
      */
	gc_printf("%-26s %-7s %s\n",ctimeln(&p->rtime),ftoanu((float)p->size),p->path);

     /*
      *  Ask whether to delete the current file if the interactive mode is selected
      */
	if ( !options->inquire )
	    remove = 1;
	else {
	    printf("sfgc: remove %s ?",p->path);
	    remove = -1;
	    while ( (ch = getchar()) != '\n' ) if ( remove < 0 ) remove = ch == 'y' ;
	}

     /*
      *  Delete the file unless the test mode is selected
      */
	if ( remove > 0 )
	    if ( !options->test && unlink(p->path) < 0 )
		vperror(1,"sfgc: %s not removed",p->path);
	    else {
		space += (float)p->size;
		nofiles ++ ;
	    }

	if ( options->all || space < options->space )
	    p = p->next;
	else
	    break;

    } /* while */

    if ( options->linkscan )
	gc_printf("%d symbolic link(s) removed\n",nofiles);
    else
	gc_printf("%d file(s) / %s Bytes removed\n",nofiles,ftoanu(space));

    return(1);
}

/*
 *
 */
int collect_symbolic_links(options)
sfgcopt_t *options;
{
  sfgcopt_t newoptions;
  int reply;

#ifdef TRACE_6
    printf("garbage_symbolic_links() in %s\n",options->link);
#endif

    options->all = 1;  /* remove all links */

    options->space = options->rate = 0;

    options->linkscan = 1;
    options->nodir = 1;
    options->dir = &options->link;

    if ( (reply = buildfindargs((int)0,(char**)NULL,&options->findargs,(boolean)1)) < 0 )
	return(reply);

    if ( (reply = collect(options,-1,&newoptions)) < 0 )
	return(reply);

#ifdef TRACE_6
    printf("symbolic links selected by find\n");
    list_print();
#endif

    return(remove_symbolic_links(options));
}

/*
 *   First remove from the 'shift file' list the items ( links ) that must not be removed 
 *   from disk and then remove from disk all remaining items.
 */
int remove_symbolic_links(options)
sfgcopt_t *options;
{
  struct stat buf;
  list_t *p = listhead, *prv = NULL;
  path_t target;
  int length;

 /*
  *  Remove from the list the items that must not be removed from the disk
  *  ( in case of error just remove it from the list )
  */
    while ( p != NULL ) {

	if ( (length = readlink(p->path,target,(int)sizeof(path_t))) < 0 ) {
	    vperror(1,"readlink(%s,,)",p->path);
	    remove_list_element(&prv,&p);
	}
	else {
	    target[length] = EOS;
	    if ( ispathinpool(options,target) && stat(target,&buf) < 0 ) {
		if ( errno != ENOENT ) {
		    vperror(1,"stat(%s)",target);
		    remove_list_element(&prv,&p);
		}
		else {
#ifdef TRACE_6
		    printf("%s -> %s\n",p->path,target);
#endif
		    prv = p;
		    p = p->next;
		}
	    }
	    else
		remove_list_element(&prv,&p);
	}

    }

#ifdef TRACE_6
    printf("symbolic links to be deleted\n");
    list_print();
#endif

 /*
  *  Remove from disk the items left in the 'shift file' list
  */
    return(removegarbage(options,-1));
}

/*
 *  Remove one element from the 'shift file' list
 */
int remove_list_element(prv,p)
list_t **prv,**p;
{
  list_t *d = *p;

    if ( !(*prv) )
	listhead = *p = (*p)->next;
    else {
	(*prv)->next = (*p)->next;
	*p = (*p)->next;
    }

    listlength -- ;

    free(d);
}

/*
 *  Check the path be in one of the pools specified in options
 */
int ispathinpool(options,path)
sfgcopt_t *options;
char *path;
{
  int k = 0;
    while ( k < options->nofs ) {
	if ( (int)strlen(path) >= (int)strlen(options->poolfs[k].mount) &&
		!strncmp(options->poolfs[k].mount,path,strlen(options->poolfs[k].mount)) )
	    return(1);
	k++;
    }
    return(0);
}
