.\" @(#)sfgc.man	1.6 07/22/94 CERN-SW/DC Fabrizio Cane, Felix Hassine
.\ Copyright (C) 1993 by CERN/CN/SW/DC
.\ All rights reserved
.\"
.nh
.TH DPM l "07/22/94"
.SH NAME
sfgc \- Disk Pool Manager (DPM)
.SH SYNOPSIS
.B sfgc 
.B "  "\-help
\ | [
.BI \-pool " name"
] [
.BI \-user " name"
] [
.BI \-group " group"
] [
.B \-test
] [
.B \-directories " path"
] [
.B \-Unmounted " Number_of_file_systems"
] [
.B \-All
] [
.BI \-Link " linkdir"
] [
.B \-left
] [
.B \-big
] [
.B \-Collect
] [
.B \-Device
] [
.B \-modify
] [
.B \-access
] [
.B \-inquire
] [
.B \-quiet
]
.SH DESCRIPTION
This commands deletes files in order to 
.I deallocate space on disk .
The  command is issued by users on a disk server. The
users allowed to garbage the specified pool  are  registered
in  one  of  the  four disk pool manager (DPM) configuration
files: dpm.users. This file is accessible  for  modification
through the sfmake ascii output.
.br
The commands can be executed  locally  only  (by  opposition
with sfget, sfrm , or sfsh which can be executed remotely).
.br
.TP
.B \-pool name
.br
to specify the shift disk pool to be  used.  A  default
pool  name 
.I cannot
be provided by the DEFPOOL  attribute
in the configuration file of DPM: To  avoid  situations
in  which  someone sfgc's the pool by mistake, the pool
is to be specified at the command line, or  by  putting
the  pool  name  in  the  environment  attached  to the
variable name DPMPOOL, otherwise the sfgc would fail.
.br
.TP
.B \-user name
This is the name of the user issuing the  dpm  command.
.br
This  option  requires  the -p option is specified. The
file to be  garbaged  are  selected  among  the  user's
files.  If no user is specified  and user is allowed to
garbage the pool, then no matching on the file's  owner
is done: anybody's file might be deleted.
.br
.TP
.B \-help 
.br
to show the available options and a brief description ( sfoptions(1) ).
.TP
.B \-group name
The garbage collection is restricted to  the  files  in
the specified group sub-directory.
.br
.TP
.B \-directory directories
The garbage collection will concern only the  files  in
the  directories  specified. Several directories can be
specified in this quoted expression.
.br
.TP
.B \-test
to specify that no file should be erased. The output of
the command is the same as if -test was no specified.
.br
.TP
.B \-inquire
to specify that user should be prompted to confirm  the
erasing of each file.
.br
.TP
.B \-quiet
The command executes without generating  an  output  on
stderr or stdout, except in the case where the -inquire
option has been specified.
.br
.TP
.B \-check
Just check is file would be  deleted  if  an  effective
garbage collection was performed.
.br
The return code is 1 if there would be filed deleted, 0
otherwise.  In the latter case, if the -q(uiet) mode is
not set the string "not required" appears on  the  line
entry: "Collect :".
.br
.TP
.B \-access or -modify
to erase the files, the sfgc uses an elapsed time based
weight function, which measures the remaining
"importance" of a file: the higher the weight of a file
is, the more important it is and so the lower are its
chance to be selection to  be  erased  by the garbage
collection. The  function is the following: W= rtime -
A*k*log(size/1024) if size id greater than  1024
bytes, or W= rtime otherwise.  A is a constant set to
86400, k is a float constant (whose default value is 1)
which can be modified at run time with the command line
option 
.I -weight weight_factor:
in  the  command  line,
user  rtime  is  the  reference  time chosen: We always
have: mtime lower than atime. If if was not (in case, for
example, when the file is not yet closed after a long time), 
then atime is set to mtime.  The  reference  time  is
always  specified  on the sfgc output: The files listed
are listed upon their weight in growing order. Thus the
first  one  is the one with the least weight value, and
the last one has the highest value.
By default the reference time is set to the 
.I modification time
(rtime = mtime).
.br
.TP
.B \-rate  percent
will collect files to be garbaged until the space used 
on the pool decreases of "percent" %: Thus if 29 % of 
the space is  used and  an sfgc -r 10 command is issued
then after the sfgc completes, 19 % of the space will 
be used.
.br
.TP
.B \-size  size
will garbage size bytes among  the  total  used  space.
Size  can  be  specified  by  using  a  letter  such as
G(Gigabytes),   M(Megabytes),   or   K(Kilobytes).   By
default, the number is assumed to be a size in bytes.
.br
.TP
.B \-left
specifies  that  the  space  remaining  after  garbage
collection  is  specified either by the -size either by
the -rate option. Thus,the command:
sfgc -p test -r 40 -left means that  we  garbage  files
until no more than 40% of the total pool size is used.
sfgc -p test -r 40  means that we garbage files so that
the used spaces decreases by 40 %.
.br
.TP
.B \-D   specifies that the percentage  specified  with  the  -r
option  is  computed  as  a  percentage of the physical
devices that constitute the pool. This enables to  have
a  file system shared among 2 pools for example. If you
want to collect garbage from the pool "p1" so that this
pool uses a space lower than 40 % of the total space of
the devices, type: sfgc -p p1 -D -left -r 40
.br
.TP
.B \-link dir_path
this option specifies that  symbolic  links  should  be
collected  for  garbage too, and dir_path specifies the
directory where these links are located.
.br
.TP
.B \-Unmounted num
Specifies the  number  of  file  systems  possibly  not
mounted.
.br
.SH RETURN CODES
sfgc returns 0 when no file needs to  be  deleted,   1  when
some  files  were deleted, 2 when user made error at command
line options specification, 3 when the configuration of  the
dpm is uncorrect.
.br
.SH SEE ALSO
sfmake(1), sfsyntax(1), sfoptions(1), sfdpmd(1)
.SH AUTHOR
Fabrizio Cane, CERN-CN Division CH-1211 Geneva 23, Switzerland (cane@cernvm.cern.ch)
