/*
 * Copyright (C) 1990,1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sfgc_old.c	3.9 10/7/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#if defined( apollo )
#include <limits.h>
#else
#include <values.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <string.h>
#include <errno.h>
#ifndef apollo
#include <malloc.h>
#include <unistd.h>
#endif
#include <stdlib.h>
#include <varargs.h>
#include <shift_types.h>
#include <strutil.h>
#include <optutil.h>
#include <parser.h>
#include <table.h>
#include <config.h>
#include <user.h>
#include <dpmutil.h>
#include <getconfent.h>
#include <dosfgc.h>
#include <sfgc.h>

#define DPMAVAIL

#if defined( apollo )
#define MAX_FILESIZE            (int)INT_MAX
#else
#define MAX_FILESIZE		(int)MAXINT
#endif
#define	ROOT_UID	0

#define			gc_newline		gc_printf("\n")

extern boolean 		gc_quiet;

int serrno,maxtmpattempts,tmpsleep;

boolean  option_style;

/*
 *  sfgc usage
 */
void usage(argv,help)
char *argv[];
boolean help;
{
  int field = strlen(argv[0]);

    if ( option_style ) {
	printf("usage: %s -help\n",argv[0]);
	printf("       %s [-p<name] [-g<name>] [-u<name>] [-P] [-U<number>]\n",argv[0]);
	printf("       %*s [-s<size>] [-t<days:hours>] [-r<rate>] [-left] [-device]\n",field,"");
	printf("       %*s [-m] [-a] [-w<number>] [-b<size>] [-local]\n",field,"");
	printf("       %*s [-T] [-S] [-q] [-i] [-check] [directories]\n",field,"");
    }
    else {
	printf("usage: %s -help\n",argv[0]);
	printf("       %s [-pool <name] [-group <name>] [-user <name>]",argv[0]);
	printf(" [-permanent]\n%*s [-unmounted <number>] [-space <size>]",field+7,"");
	printf(" [-time <days:hours>]\n%*s [-rate <rate>] [-left] [-device]",field+7,"");
	printf(" [-modify] [-access]\n%*s [-weight <number>] [-big <size>]",field+7,"");
	printf(" [-local] [-test] [-statistics]\n%*s [-quiet] [-inquiry]",field+7,"");
	printf(" [-check] [directories]\n");
    }
    if ( help ) {
        printf("where:\n");
	printf("  directories %26s scan is restricted to the directories\n","");
        HELP_options();
    }
}

#define POOL_DESCR		"shift disk pool to be scanned"
#define GROUP_DESCR		"scan is restricted to the group"
#define USER_DESCR		"scan is restricted to the user"
#define UNMOUNTED_DESCR		"expected number of unmounted filesystem"
#define SPACE_DESCR		"used space to deallocate"
#define RATE_DESCR		"percentage of used space to deallocate"
#define TIME_DESCR		"remove files older than specified"
#define BIG_DESCR		"remove files bigger than specified"
#define WEIGHT_DESCR		"tune the sorting algorithm [0..500]"
#define LEFT_DESCR		"rate and space specify the space left"
#define DEVICE_DESCR		"rate refers to the physical device size"
#define LOCAL_DESCR		"the subdirectories are not scanned"
#define MODIFY_DESCR		"time uses the last modify time"
#define ACCESS_DESCR		"time uses the last access time"
#define INQUIRE_DESCR		"ask whether to delete each file"
#define QUIET_DESCR		"quiet mode"
#define CHECK_DESCR		"just check if any file must be deleted"
#define TEST_DESCR		"the files are not really deleted"
#define PERMANENT_DESCR		"override the permanent pool attribute"
#define STATISTICS_DESCR	"print a scan statistic"

#define ispool	(*options->pool != EOS)
#define isgroup	(*options->group != EOS)
#define isuser	(*options->user != EOS)

/*
 *  sfgc
 */
main(argc,argv)
int argc;
char *argv[];
{
#ifdef DPMAVAIL
  extern boolean reloadconfiguration;
  extern pool_t *pool_table;
  extern index_t_s poolidx;
  boolean ispoolany,ispoolall;
  index_t_s pidx;
  char *pool;
  int nopools;
  extern fsys_t *fsys_table;
  extern index_t_s fsysidx;
  index_t_s fidx;
  path_t fsys;
#endif
  gc_element_t  *filelist;
  sfgcopt_t  sfgcopt,newopt;
  sfgcopt_t  *options		= &sfgcopt;
  int	     ReturnCode;
  int	     reply,mult,i;
  time_t     timenow;

#ifdef DPMAVAIL
 /*
  *  Load the shift configuration
  */
    reloadconfiguration = FALSE;
    if ( load_configuration(TRUE,TRUE,TRUE) < 0 ) {
	vperror(0,"can't load the configuration");
	sfexit(EXCONF);
    }
#endif

    getsfgcopt(argc,argv,options);

#ifdef DPMAVAIL

    if ( ispool ) {  /*  pool option is specified  */

	ispoolany = !strcmp(options->pool,"any");
	ispoolall = !strcmp(options->pool,"all");

	pidx = 0;
        nopools = 0;
	mult = options->nodir > 0 ? options->nodir : 1;

	if ( !ispoolany && !ispoolall && (pidx = look_pool(options->pool)) < 0 ) {
	    vperror(0,"unknown pool name <%s>",options->pool);
	    sfexit(EXOPT);
	}

	while ( pidx < poolidx ) {

	    switch ( (reply = sfgc_authorization(pool_table[pidx].name,pidx,options->overperm)) ) {
		case TRUE : break;
		default   : if ( !ispoolany  ) sfexit(reply);
			    pidx++; 
			    continue;
	    }

	    nopools++;

	    timenow = time((time_t*)NULL);
	    gc_printf("\n%s\n",ctime(&timenow));
	    gc_printf("Pool       :  %s\n",pool_table[pidx].name);

	    options->nofs = 0;
	    for (fidx=0; fidx<fsysidx; fidx++)
		if ( fsys_table[fidx].poolidx == pidx )
		    options->nofs++;

	    options->nomnt = options->nofs;
	    if ( !(options->mntpath = (path_t*)malloc(sizeof(path_t)*options->nomnt)) ) {
		vperror(1,"malloc(%d*d)",sizeof(path_t),options->nomnt);
		sfexit(EXSYS);
	    }

	    options->nofs = options->nofs*mult;
	    if ( !(options->fspath = (path_t*)malloc(sizeof(path_t)*options->nofs)) ) {
		vperror(1,"malloc(%d*d)",sizeof(path_t),options->nofs);
		sfexit(EXSYS);
	    }

	    i = 0;
	    for (fidx=0; fidx<fsysidx; fidx++) {

		if ( fsys_table[fidx].poolidx != pidx )
		    continue;

		create_mountpath(fidx,fsys);
		strcpy(options->mntpath[i/mult],fsys);
		add_ugdir(options,fsys);
		if ( options->nodir > 0 )
		    add_lowdir(options->nodir,options->dirpath,fsys,options->fspath+i);
		else
		    strcpy(options->fspath[i],fsys);

		i += mult;
	    }

	    reply = get_pool_space( options,
				    &newopt,
				    pool_table[pidx].name,
				    pool_table[pidx].min,
				    pool_table[pidx].max,
				    pool_table[pidx].size );
       	    switch ( reply ) {

		case -1 :
		    fprintf(stderr,"Can't access pool <%s>\n",pool_table[pidx].name);
		    ReturnCode = EXCONF;
		    break;

		case 0 :
		    gc_printf("Needn't run on pool <%s>\n",pool_table[pidx].name);
		    ReturnCode = EXGCNONE;
		    break;

          	case 1 :
#if defined ( hpux )
		    setresuid(geteuid(),-1,-1);
		    setresgid(getegid(),-1,-1);
#else
		    setruid((int)geteuid());
		    setrgid((int)getegid());
#endif
		    if ( !options->check ) {
			gc_printf("Scanning pool <%s>\n",pool_table[pidx].name);
			ReturnCode =
	presfgc(&newopt,newopt.nofs,newopt.mntpath,newopt.fspath,&filelist);
		    }
		    else {
			ReturnCode = EXGCOK;
			filelist = NULL;
		    }
		    free(options->fspath);
		    break;

	    } /* switch */

	    if ( !ispoolany && !ispoolall )
		break;

	    pidx++;

	} /* while - scan pool table */

	sfexit(ReturnCode);
    }

#endif /* DPMAVAIL */

    if ( get_dir_space(options,&ReturnCode) > 0 ) {

#if defined ( hpux )
	setresuid(-1,getuid(),-1);
	setresgid(-1,getgid(),-1);
#else
	seteuid((int)getuid());
	setegid((int)getgid());
#endif
	gc_printf("Scanning\n");

       
sfexit(presfgc(options,options->nodir,options->dirpath,options->dirpath,(gc_element_t**)NULL));
    }

}

#define issize	(spacestr != NULL)
#define istime	(timestr != NULL)
#define israte	(ratestr != NULL)
#define isbig	(bigstr != NULL)

/*
 *
 */
int getsfgcopt(argc,argv,options)
int 	   argc;
char 	   *argv[];
sfgcopt_t  *options;
{
  boolean  show_help,show_options;
  int	   mask;
  char     *spacestr,*timestr,*ratestr,*bigstr;
  boolean  ismodiftime,isaccesstime;
  boolean  isfactor;
  int	   days,hours;
  int      idx,inum;
  float    fnum;
#ifndef DPMAVAIL
  char     *ent;
#endif

    clear_vperror();

#ifdef DPMAVAIL
 /*
  *  Get the option style setup
  */
    getoptstyle(&option_style);
#else
    option_style = !(ent = getenv("DPMOPTIONSTYLE")) || 
			!strcasecmp(options_style,"XWINDOW");
#endif

 /*
  *  Define the options available
  */
    INIT_options();
    if ( option_style ) {
        DEFAULT_mask(UNIX_MASK);
	mask = NOSINGLE;
    }
    else {
        DEFAULT_mask(VMS_MASK);
	mask = 0;
    }

    ADD_OPT_options(&show_help,&show_options);

    DEFAULT_mask(FILIST | EXTVAL | DESCR);
    ADD_options("pool",ENVIR | NAMENV,STRING,"DPMPOOL",options->pool,POOL_DESCR);
    ADD_options("group",ENVIR | NAMENV,STRING,"DPMGROUP",options->group,GROUP_DESCR);
    ADD_options("user",ENVIR | NAMENV,STRING,"DPMUSER",options->user,USER_DESCR);
    ADD_options("Unmounted",0,INT,&options->unmounted,UNMOUNTED_DESCR);

    DEFAULT_mask(ALLOC);
    ADD_options("space",0,STRING,&spacestr,SPACE_DESCR);
    ADD_options("rate",0,STRING,&ratestr,RATE_DESCR);
    ADD_options("time",0,STRING,&timestr,TIME_DESCR);
    ADD_options("big",0,STRING,&bigstr,BIG_DESCR);
    ADD_options("weight",EXTSEL,INT,&isfactor,&options->factor,WEIGHT_DESCR);

    DEFAULT_mask(NOEXTVAL | EXTSEL);
    ADD_options("left",mask,NONE,&options->left,LEFT_DESCR);
    ADD_options("device",mask,NONE,&options->disk,DEVICE_DESCR);
    ADD_options("local",mask,NONE,&options->local,LOCAL_DESCR);

    ADD_options("modify",0,NONE,&ismodiftime,MODIFY_DESCR);
    ADD_options("access",0,NONE,&isaccesstime,ACCESS_DESCR);

    ADD_options("inquire",0,NONE,&options->inq,INQUIRE_DESCR);
    ADD_options("quiet",0,NONE,&options->quiet,QUIET_DESCR);
    ADD_options("check",mask,NONE,&options->check,CHECK_DESCR);
    ADD_options("Test",0,NONE,&options->test,TEST_DESCR);

    ADD_options("Permanent",0,NONE,&options->overperm,PERMANENT_DESCR);
    ADD_options("Statistics",0,NONE,&options->statistics,STATISTICS_DESCR);

 /*
  *  Initialize the option values before calling READ_options()
  */
    *options->pool = EOS;
    *options->group = EOS;
    *options->user = EOS;

    spacestr = NULL;
    ratestr = NULL;
    timestr = NULL;
    bigstr = NULL;

    options->unmounted = 0;

 /*
  *  Get the option values
  */
    if ( READ_options(argc,argv) < 0 ) {
        usage(argv,FALSE);
        sfexit(EXOPT);
    }

    if ( show_help && NO_opts()==1 ) {
        usage(argv,TRUE);
        sfexit(EXHELP);
    }

    if ( show_options )
        LIST_options();

 /*
  *  Get the list of directories
  */
    options->nodir = NO_args();
    if ( options->nodir > 0 ) {
	if ( (options->dirpath = (path_t*)malloc(options->nodir*sizeof(path_t))) == NULL) {
	    vperror(1,"malloc(%d*%d)",options->nodir,sizeof(path_t));
	    sfexit(EXSYS);
	}
	idx = argc - options->nodir ;
	while ( idx < argc ) {
	    strcpy(options->dirpath[argc-idx-1],argv[idx]);
	    idx ++ ;
	}
    }

 /*
  *  Check that either the list of directories or the pool name be specified
  */
    if ( !options->nodir && !ispool ) {
	vperror(0,"pool or directories required");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

 /*
  *  Check that either the size or the time or the rate options be
  *  used if the default pool garbage collection is not selected
  */
    if ( ( options->nodir > 0 || isgroup || isuser ) && !issize && !istime && !israte ) {	
	vperror(0,"space or rate or time selection required");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

 /*
  *  A list of directories within a pool can be provided only if a user name is specified
  */
    if ( options->nodir > 0 && ispool && !isuser ) {
	vperror(0,"user required");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

 /*
  *  Get the right gc_select() function on the base of the directory paths to be scanned
  */
    if ( options->nodir > 0 || isuser )	
	options->select = gc_select_files;			   /* complete path */
    else
    if ( isgroup )
	options->select = gc_select_fsysgrp;			      /* group path */
    else
	options->select = gc_select_fsys;			/* file system path */

 /*
  *  The local option requires a list of directories
  */
    if ( options->local && !options->nodir ) {
	vperror(0,"local requires directories");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

 /*
  *  On a pool sfgc runs on behalf of root
  */
    if ( ispool && geteuid() != ROOT_UID && !options->test ) {
	vperror(0,"Can't be root: root owner or set-bit required\nincomplete installation");
	sfexit(EXCONF);
    }

 /*
  *  Check that the group and user names be not both specified
  */
    if ( isuser && isgroup ) {
	vperror(0,"user name alredy implies a group name");
	sfexit(EXOPT);
    }

 /*
  *  Check that the group and user name specified be locally known 
  */
    if ( isgroup && get_groupbyname(options->group,&options->usergid) < 0 ) {
	vperror(0,"unknown group name <%s>",options->group);
	sfexit(EXOPT);
    }
    if ( isuser ) {
	if ( get_userbyname(options->user,&options->useruid,&options->usergid) < 0 ) {
	    vperror(0,"unknown user name <%s>",options->user);
	    sfexit(EXOPT);
	}
	if ( get_groupbyid(options->group,options->usergid) < 0 ) {
	    vperror(1,"getgrgid(%d)",&options->usergid);
	    sfexit(EXSYS);
	}
    }

 /*
  *  Convert the size option ( the string format is <number><unit> ) 
  */
    if ( !issize )
	options->space = -1;
    else
    if ( (options->space = anutof(spacestr)) < 0 ) {
	if ( options->space == -1.0 )
	    vperror(0,"invalid unit character in option space");
	else
	    vperror(0,"invalid number in option space");
	sfexit(EXOPT);
    }

 /*
  *  Convert the time option ( the string format is <days>:<hours> )
  */
    if ( !istime )
	options->timeold = 0;
    else {
	if ( sscanf(timestr,"%d:%d",&days,&hours) != 2 || days < 0 || hours < 0 ) {
	    vperror(0,"invalid time specification");
	    sfexit(EXOPT);
	}
	if ( !days && !hours )
	    options->timeold = 1;
	else
	    options->timeold = time((time_t*)NULL) - days*86400 - hours*3600 ;
    }

 /*
  *  Convert the rate option ( the string format is <non-negative number> )
  */
    if ( !israte )
	options->rate = -1;
    else
    if ( atoinum(ratestr,&inum) < 0 ) {
	vperror(0,"invalid rate specification");
	sfexit(EXOPT);
    }
    else
	options->rate = (float)inum;

 /*
  *  Check that the left option be used only with either the size or rate options
  */
    if ( options->left && istime ) {
	vperror(0,"option left and time selection are incompatible");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

    if ( options->left && !issize && !israte ) {
	vperror(0,"option left requires either space or rate selection");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

 /*
  *  Check that the device option be used only with both the rate and left options
  */
    if ( options->disk && ( !israte || !options->left ) ) {
	vperror(0,"option device requires option left and rate selection");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

 /*
  *  Set the device option if the default garbage collection is selected
  */
    if ( ispool && !isgroup && !isuser && 
		      !options->nodir && !israte && !issize && !istime )
	options->disk = TRUE;

 /*
  *  Convert the big option
  */
    if ( !isbig )
	options->maxsize = -1;
    else {
	if ( (fnum = (float)anutof(bigstr)) < 0 || fnum > MAX_FILESIZE ) {
	    if ( fnum == -1.0 )
		vperror(0,"invalid unit character in option big");
	    else
		vperror(0,"invalid number in option big");
	    sfexit(EXOPT);
	}
	options->maxsize = (int)fnum;
    }

 /*
  *  Check that only one of the time, space and rate options be used
  */
    if ( istime && issize ) {
	vperror(0,"time and size selection are incompatible");
	sfexit(EXOPT);
    }
    if ( istime && israte ) {
	vperror(0,"time and rate selection are incompatible");
	sfexit(EXOPT);
    }
    if ( issize && israte ) {
	vperror(0,"size and rate selection are incompatible");
	sfexit(EXOPT);
    }

 /*
  *  Check the modification time and access time options
  */
    if ( ismodiftime  &&  isaccesstime ) {
	vperror(0,"options modify and access are incompatible");
	sfexit(EXOPT);
    }
    if ( ismodiftime )
	options->timetouse = MTIME;
    else
	options->timetouse = ATIME;

 /*
  *  Convert the factor option
  */
    if ( !isfactor ) 
	options->factor = -1;
    else
    if ( options->factor < 0 || options->factor > 500 ) {
	    vperror(0,"factor number is out of range [0..500]");
	    sfexit(EXOPT);
    }

    options->removedir = !ispool ? -1 : 0 ;
    options->statistics = options->statistics && !options->quiet;
    if ( options->unmounted < 0 ) options->unmounted = 0;
    gc_quiet = options->quiet;

    return(1);
}

/*
 *
 */
int presfgc(options,nopath,mountpath,dirpath,filelist)
sfgcopt_t     *options;
int	      nopath;
path_t	      *mountpath;
path_t	      *dirpath;
gc_element_t  **filelist;
{
  extern boolean gc_test;
  extern boolean gc_inquiry;
  extern boolean gc_inquirysub;	
  extern boolean gc_recursion;
  extern byte	 gc_timetouse;
  extern double  gc_factor;
  extern int	 gc_removedir;
  extern boolean gc_statistics;
  extern float	 total_device;

    gc_test 	  = options->test;
    gc_inquiry 	  = options->inq;
    gc_recursion  = !options->local;
    gc_timetouse  = (byte)options->timetouse;
    gc_removedir  = options->removedir;
    gc_statistics = options->statistics;
    total_device  = options->total;

    if ( options->factor != -1 )
	gc_factor = (double)options->factor/100.0;

    return( dosfgc( options->timeold,
		    &options->space,
		    options->rate,
		    options->maxsize,
		    options->left,
		    mountpath,
		    dirpath,
		    nopath,
		    options->select,
		    filelist )
	 );
}

/*
 *
 */
int print_sfgcopt(options)
sfgcopt_t    options;
{
  int  i;
	printf("space    : %0.0f\n",options.space);
	if ( (int)options.timeold > 0 ) 
		printf("timeold  : %s",ctime(&options.timeold));
	else
		printf("timeold  : 0\n");
	printf("rate     : %0.2f%%\n",options.rate);
	printf("left     : %s\n",itoyn(options.left));
	printf("disk     : %s\n",itoyn(options.disk));
	printf("max size : %s\n",itoanmu(options.maxsize));
	printf("factor k : %d\n",options.factor);
	printf("pool     : <%s>\n",options.pool);
	printf("group    : <%s>\n",options.group);
	printf("user     : <%s>\n",options.user);
	printf("local    : %s\n",itoyn(options.local));
	printf("select() : %s\n",
			options.select==gc_select_files ? "gc_select_files" : 
			(options.select==gc_select_fsys ? "gc_select_fsys" : 
			(options.select==gc_select_fsysgrp ? "gc_select_fsysgrp" : 
				"WRONG")) );
	printf("timeuse  : %s\n",
			options.timetouse==MTIME ? "MTIME" : 
			(options.timetouse==ATIME ? "ATIME" : "WRONG") );
	printf("inq      : %s\n",itoyn(options.inq));
	printf("test     : %s\n",itoyn(options.test));
	printf("overperm : %s\n",itoyn(options.overperm));
	printf("nodir    : %d\n",options.nodir);
	if ( options.nodir > 0 ) {
		printf("dirpath  : \n");
		for (i=0; i<options.nodir; i++) 
			printf("\t%s\n",options.dirpath[i]);
	}
	printf("nofs     : %d\n",options.nofs);
	if ( options.nofs > 0 ) { 
		printf("fspath   : \n");
		for (i=0; i<options.nofs; i++) 
			printf("\t%s\n",options.fspath[i]);
	}
	printf("removedir: %d\n",options.removedir);
	printf("statistic: %s\n",itoyn(options.statistics));
}

/*
 *
 */
int sfgc_authorization(pool,poolidx,overperm)
char *pool;
index_t_s poolidx;
boolean overperm;
{
  extern pool_t* pool_table;
  user_t client;

 /*
  *  Check the permanent attribute
  */
    if ( pool_table[poolidx].permanent && !overperm ) {
	vperror(0,"Pool <%s> is PERMANENT",pool);
	return(EXPERM);
    }

 /*
  *  Check the client be authorized to run the garbage collector on the pool
  */
    if ( look_account(poolidx,getuid(),getgid(),TRUE) < 0 ) {
	if ( get_userbyid(client,getuid(),NULL) < 0 )
	    sprintf(client,"uid %d",getuid());
	vperror(0,"You <%s> are not authorized to garbage the pool <%s>",client,pool);
	return(EXPERM);
    }
    return(TRUE);
}

#define SINGLEDEV

#ifndef SINGLEDEV
#define MAXDEV		50
#endif

/*
 *  Get space about the directory path list given in input
 *  ( options->dirpath , options->nodir ) when either -r <rate> -left -D options are 
 *  specified or -S options is specified.
 *
 *  This function is called when a list of directories is specified
 *  
 *  INPUT
 *	options		sfgc options
 *
 *  OUTPUT
 *	options		modified sfgc options
 *
 *  RETURN
 *	> 0		number of paths given in input
 *	-1		one of these errors :
 *			 - a path is not accessible or its file-system is not mounted
 *			 - get_fsys_stat() reply unknown
 */
int get_dir_space(options,ReturnCode)
sfgcopt_t    *options;
int	     *ReturnCode;
{
  long    ptotal,pavail,bsize;			/* getfsystat() parameters	*/
  float   total			= 0.0;		/* total space			*/
  float   used			= 0.0;		/* used space			*/
  int     mounted		= 0;		/* number of path accessible	*/
#ifndef SINGLEDEV
  int	  dev[MAXDEV];				/* device list			*/
  int	  idx;					/* device list index		*/
  int	  nodev			= 0;		/* number of devices		*/
#else
  int	  dev			= -1;		/* device number flag		*/
  int	  ddev;					/* device number		*/
#endif
  boolean needed;				/* flag				*/
  time_t  timenow;
  int	  reply;				/* getfsystat() reply		*/
  int     k;					/* path list index		*/

	needed = options->disk && options->left && options->rate >= 0 ;

     /*
      *  Scan the list of directories path specified by the
      *  user and compute the total and used space
      */
	for (k=0; k<options->nodir; k++) {

	    switch ( (reply = getfsystat(options->dirpath[k],&ptotal,&pavail,&bsize,
#ifndef SINGLEDEV
					 &dev[nodev]
#else
					 &ddev
#endif
					)) ) {
	   /*
	    *  getfsystat() failure
	    */
	      case -1 :
		if ( is_filesystem(options->dirpath[k],NULL,errno) != FSUMNTD ) {
		    vperror(0,"Cannot access file system <%s>",options->dirpath[k]);
#ifdef SINGLEDEV
		    *ReturnCode = CNTACCF;
#endif
		}
		else {
		    vperror(0,"File system <%s> is unmounted",options->dirpath[k]);
#ifdef SINGLEDEV
		    *ReturnCode = UNMOUNTF;
#endif
		}
#ifdef SINGLEDEV
		return(-1);
#else
		break;
#endif

	   /*
	    *  getfsystat() successful
	    */
	      case 1 :
#ifndef SINGLEDEV
	     /*
	      *  If multi-device is supported then a list of device number is kept.
	      *  Here it checks that the device just accessed has not been already 
	      *  encountered in order to not compute space more than once
	      */
		idx = 0 ;
		while ( idx < nodev )
		    if ( dev[nodev] == dev[idx] )
			break;
		    else
			idx++;
		if ( idx == nodev ) {
		    total += (float)ptotal*(float)bsize;
		    used += ((float)(ptotal-pavail))*(float)bsize;
		    nodev++;
		    if ( nodev == MAXDEV ) {
			vperror(0,"Error TOOMNYDIR");
			*ReturnCode = TOOMNYDIR;
			return(-1);
		    }
		}

	     /*
	      *  Rearrange the list of paths in order to remove paths of file 
	      *  system that are not accessible ( only if needed )
	      */
		if ( needed && k > mounted )
		    strcpy(options->dirpath[mounted],options->dirpath[k]);
#else
	     /*
	      *  If single-device is supported then check that all directory
	      *  paths be in the same device (i.e. same file system )
	      */
		if ( dev == -1 ) {
		    total = (float)ptotal*(float)bsize;
		    used = ((float)(ptotal-pavail))*(float)bsize;
		    dev = ddev;
		}

		if ( dev != -1  &&  dev != ddev ) {
		    vperror(0,"Error NOSAMEDEV");
		    *ReturnCode = NOSAMEDEV ;
		    return(-1);
		}
#endif
		mounted++;
		break;

	      default :
		vperror(0,"Internal: unknown getfsystat() reply (%d)\n",reply);
		*ReturnCode = UNKRPY;
		return(-1);

	    } /* switch - getfsystat() reply */

	} /* for - path list scan */

	if ( needed ) {
		options->space = total/100*options->rate;
		options->rate = -1;
		options->disk = FALSE;
		options->nodir = mounted;
	} /* if - needed */

	timenow = time(NULL);
	gc_printf("\n%s\n",ctime(&timenow));
	gc_printf("Total      :  %s\n",ftoanu(total));
	gc_printf("Used       :  %s ",ftoanu(used));
	gc_printf("(%s%%)\n",ftoanu(used*100.0/total));
	gc_printf("Size limit :  ");
	if ( options->maxsize > 0)
		gc_printf("%s",itoanmu(options->maxsize));
    	else
		gc_printf("NONE");
	gc_newline;

	gc_printf("Garbage    :  ");

	if ( options->rate != -1 )
	    if ( options->left )
		  gc_printf("%0.0f%%\n",options->rate < 0 ? 100.0 : 100-options->rate);
	    else
		  gc_printf("%0.0f%%\n",options->rate < 0 ? 0.0 : options->rate);

	if ( options->space != -1 )
	    if ( options->left )
		  gc_printf("%s left\n",ftoanu(options->space));
	    else
		  gc_printf("%s\n",ftoanu(options->space));

    	if ( options->timeold != 0 ) {
	    gc_printf("( LAST %s TIME ) ",options->timetouse==MTIME?"MODIFICATION":"ACCESS");
	    if ( options->timeold != 1 )
		  gc_printf("%s",ctime(&options->timeold));
	    else {
		  time(&timenow);
		  gc_printf("%s",ctime(&timenow));
	    }
	}

	options->total = total;

	*ReturnCode = 0;
	return(mounted);
}

#ifdef DPMAVAIL

/*
 *  Concatenate to a file system path the low directories path
 *
 *  INPUT
 *	nodir		number of low directories
 *	dirpath		low directories path
 *	filesystem	file system path
 *
 *  OUTPUT
 * 	fspath		list of complete pathnames to the low directories
 */
int add_lowdir(nodir,dirpath,filesystem,fspath)
int	nodir;
path_t	*dirpath;
path_t	filesystem;
path_t	*fspath;
{
  int idx;
    for (idx=0; idx<nodir; idx++) {
	strcpy(fspath[idx],filesystem);
	strcat(fspath[idx],"/");
	strcat(fspath[idx],dirpath[idx]);
    }
}

/*
 *  Concatenate to a file system path the group and user directory name as required
 *
 *  INPUT
 *	options	  sfgc options
 *	path	  file system path
 *
 *  OUTPUT
 *	path	  <file-system-path>/<group-name> (if the -g option is used)
 *		  <file-system-path>/<group-name>/<user-name> (if the -u option is used)
 */
int add_ugdir(options,path)
sfgcopt_t  *options;
char *path;
{
    if ( *options->group != EOS || *options->user != EOS ) {
	strcat(path,"/");
	strcat(path,options->group);
    }
    if ( *options->user != EOS ) {
	strcat(path,"/");
	strcat(path,options->user);
    }
}

/*
 *  Get the options value to pass to the garbage collector on the base of the options
 *  specified by the client.
 *
 *  This function is called when a pool name is specified in the sfgc options.
 *
 *  INPUT
 *	options		sfgc options
 *	pool		shift pool name
 *	gcmin,gcmax	garbage collector thresholds defined in the pool configuration
 *	maxsize		file size limit defined in the pool configuration
 *
 *  OUTPUT
 *	newopt		modified sfgc options
 *
 *  RETURN
 *	1		newopt contains the options to pass to the garbage collector
 *	0		the pool needn't to be cleaned (do not run the garbage collector)
 *      -1		not enough file system accessible in the specified pool
 */
int get_pool_space(options,newopt,pool,gcmin,gcmax,maxsize)
sfgcopt_t    *options;
sfgcopt_t    *newopt;
char	     *pool;
int	     gcmin;
int	     gcmax;
int	     maxsize;
{
  float   total,used,rate;
  int	  reply;		/* get_pool_stat() reply	*/
  time_t  timenow;

 /*
  *  Copy the input option structure into the output structure
  */
    memcpy((char*)newopt,(char*)options,sizeof(sfgcopt_t));

 /*
  *  Get the total and used space of the accessible file system
  */
    if ( (reply = get_pool_stat(&total,&used,newopt)) < 0 ) {
	vperror(0,"No file system accessible in pool <%s>",pool);
	return(-1);
    }

    if ( reply < options->nomnt - options->unmounted ) {
	vperror(0,"Not enough (%d/%d-%d) file system accessible in pool <%s>",
		  reply,options->nomnt,options->unmounted,pool);
	return(-1);
    }

    newopt->total = total;

 /*
  *  Print some statistics about the pool
  */
    gc_printf("Total      :  %s\n",ftoanu(total));
    gc_printf("Used       :  %s ",ftoanu(used));
    gc_printf("(%s%%)\n",ftoanu(used*100/total));
    gc_printf("Size limit :  %s",maxsize > 0 ? itoanmu(maxsize) : "NONE" );
    if ( options->maxsize == -1 )
	  newopt->maxsize = maxsize;
    else
    if ( options->maxsize != maxsize ) 
	if ( options->maxsize > 0 )
	    gc_printf(" -> %s",itoanmu(options->maxsize));
	else
	    gc_printf(" -> NONE");
    gc_newline;
    if ( gcmax > 0 )
	gc_printf("Thresholds :  %d%%-%d%%\n",gcmin,gcmax);
    else
	gc_printf("Thresholds :  NONE\n");

    gc_printf("Garbage    :  ");

    if ( options->rate == -1 && 
		options->space == -1 && 
			options->timeold == 0 && 
					gcmax == 0 ) {
	gc_printf("0\n");
	return(0);
    }

 /*
  *   command line options	effective rate		  new options value
  *
  *	-r <rate>		rate			  -r <rate>
  *	-r <rate> -left		100-rate		  -r <rate> -left
  */
    if ( options->rate != -1 && !newopt->disk )
	if ( !newopt->left )
	      gc_printf("%0.0f%%\n",options->rate < 0 ? 100.0 : options->rate );
	else
	      gc_printf("%0.0f%%\n",options->rate < 0 ? 0.0 : 100.0-options->rate );

    if ( options->space != -1 )
	if ( !newopt->left )
	      gc_printf("%s\n",ftoanu(options->space));
	else
	      gc_printf("%s left\n",ftoanu(options->space));

    if ( options->timeold != 0 ) {
	gc_printf("( LAST %s TIME ) ",options->timetouse==MTIME?"MODIFICATION":"ACCESS");
	if ( options->timeold != 1 ) 
	    gc_printf("%s",ctime(&options->timeold));
	else {
	    time(&timenow);
	    gc_printf("%s",ctime(&timenow));
	}
    }

 /*
  *   command line options	 effective rate		      new options value
  *
  *	-r <rate> -left -D	 100.0-total/used*rate		  -r <eff-rate> -left
  *	    no options 		 total/used*(rate-gcmin)  	  -r <eff-rate> -left
  *				 if  rate > gcmax where
  *				 rate = used*100/total
  */
    if ( newopt->space == -1 && newopt->timeold == 0 && newopt->disk ) {

	if ( *options->group == EOS && *options->user == EOS ) {

         /*
          *  Compute the new rate
          */
	    if ( newopt->rate >= 0 )
	        newopt->rate = total/used*newopt->rate;
	    else {
	        rate = used*100/total;
	        if ( rate >= (float)gcmax )
		    newopt->rate = total/used*(rate-(float)gcmin);
	        else {
		    gc_printf("0\n");
		    return(0);
	        }
	    }

         /*
          *  Print the new rate
          */
	    if ( newopt->left )
	          gc_printf("%0.0f%%\n",newopt->rate > 100 ? 0 : 100.0 - newopt->rate);
	    else
	          gc_printf("%0.0f%%\n",newopt->rate);

	    if ( (newopt->left && newopt->rate >= 100) || 
			  (!newopt->left && newopt->rate <= 0) )
		return(0);
	}
	else
	{

         /*
          *  If either -u or -g option is used then convert the rate to a space
	  *  value because you don't know how much space is used by a sub-group
	  *  of users before scanning their directories
          */
	    newopt->space = total/100*newopt->rate;
	    newopt->rate = -1;
	    if ( !newopt->left )
		  gc_printf("%s\n",ftoanu(newopt->space));
	    else
		  gc_printf("%s left\n",ftoanu(newopt->space));
	}

	newopt->disk = FALSE;
    }

    return(1);
}

/*
 *  Get the total and used space of a set of file systems
 *
 *  INPUT
 *	nofs 		number of file systems
 *	fspath		list of file system paths
 *
 *  OUTPUT
 *	nofs		number of accessible file systems
 *	fspath		list of accessible file system paths
 *	total		total space in the accessible file systems
 *	used		used space in the accessible file systems
 *
 *  RETURN
 *	> 0		number of accessible file systems
 *	-1		no file system is accessible
 */
int get_pool_stat(total,used,options)
float	  *total;
float	  *used;
sfgcopt_t *options;
{
  long	ptotal,pavail,bsize;		/* getfsystat() parameters		   */
  int	mounted			= 0;	/* number of accessible file systems	   */
  int   idx			= 0;	/* index in the input list of file systems */
  int	idx2;
  int   reply;
  int	mult			= options->nofs / options->nomnt;
  int   fsdir			= 0;
  struct stat buffer;

 /*
  *  Initialize output space values
  */
    *total = 0.0;
    *used = 0.0;

 /*
  *  Scan the input list of file systems
  */
    while ( idx < options->nomnt ) {

	switch ( (reply = getfsystat( options->mntpath[idx],
				      &ptotal,&pavail,&bsize,(int*)NULL)) ) {

	 /*
	  *  getfsystat() successful
	  */
	    case 1 :
		    if ( (reply = is_filesystem(options->mntpath[idx],NULL,0)) == FSMNTD ) {
			(*total) += (float)ptotal*(float)bsize ;
			(*used) += ((float)ptotal-(float)pavail)*(float)bsize ; 
			if ( idx > mounted )
			    strcpy(options->mntpath[mounted],options->mntpath[idx]);
			mounted++;
			for (idx2=0;idx2<mult;idx2++) {
			    if ( stat(options->fspath[idx*mult+idx2],&buffer) >= 0 &&
					    idx*mult+idx2 > fsdir )
				strcpy( options->fspath[fsdir],
					options->fspath[idx*mult+idx2]);
			    fsdir++;
			}
		    }
		    else
		    if ( reply == FSUMNTD )
			vperror(0,"File system <%s> not mounted",options->mntpath[idx]);
		    else
			vperror(1,"Can't access file system <%s>",options->mntpath[idx]);
		    break;

	 /*
	  *  getfsystat() failure
	  */
	    case -1 :
		    if ( is_filesystem(options->mntpath[idx],NULL,errno) == FSUMNTD )
			vperror(0,"File system <%s> not mounted",options->mntpath[idx]);
		    else
			vperror(1,"Can't access file system <%s>",options->mntpath[idx]);
		    break;

	    default :
		    vperror(0,"Internal: unknown getfsystat() reply (%d)",reply);
		    return(-1);

	} /* switch - getfsystat() reply */

	idx++;

    } /* while - scan file system list */

    options->nomnt = mounted;
    options->nofs = fsdir;

    return(mounted > 0 ? mounted : -1);
}

#endif

/*
 *
 */
/*VARARGS0*/
gc_printf(va_alist)
va_dcl
{
  va_list       args;
  char          *fmt;

        if ( !gc_quiet ) {
                va_start(args);
                fmt = va_arg(args,char*);
                vprintf(fmt,args);
                va_end(args);
        }
}

