/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sfget.c	3.7 10/28/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <shift_types.h>
#include <osdep.h>
#include <bits.h>
#include <strdup.h>
#include <optutil.h>
#include <strerror.h>
#include <parser.h>
#include <table.h>
#include <shiftconf.h>
#include <getconfent.h>
#include <dpmutil.h>
#ifndef vms
#include <serrno.h>                     /* Special Error numbers        */
#else
#include "serrno.h"                     /* Special Error numbers        */
#endif

#define POOL_DESCR		"name of the shift disk pool to be used"
#define USER_DESCR		"user name to be used searching the file"
#define SIZE_DESCR		"anticipated size of the file"
#define LOOK_DESCR		"the file is just searched"
#if defined( BACKCMPTB )
#define K_FLAG_DESCR		"old name of the look option"
#endif
#define TABLE_DESCR		"the file is not created on disk"
#define REMOVE_DESCR		"first the existing file is removed"
#define QUIET_DESCR		"the file nfs-pathname is not echoed"
#define LINKDIR_DESCR		"create a symbolic link to the file"

extern path_t shift_binary;

int serrno;		/* required because sfget is not linked to the shift library */
int maxtmpattempts;	/* attempts to read the tmp files */
int tmpsleep;		/* timeout used to read the tmp files */

char *shifthost;	/* hosts to connect when sfget is executed remotely ( test ) */
int shiftport;		/* port number to use when connecting remote hosts ( test )  */

boolean  option_style;	/* option style flag */

/*
 *  sfget usage
 */
void usage(argv,help)
char *argv[];
boolean help;
{
    if ( option_style ) {
	printf("usage: %s -help\n",argv[0]);
	printf("       %s -p<name> [-u<name>] [-s<size>] [-l]",argv[0]);
#if defined( BACKCMPTB )
	printf(" [-k]");
#endif
	printf(" [-t] [-r] \n");
	printf("       %*s [-link<path>] [-q] filename\n",strlen(argv[0]),"");
    }
    else {
	printf("usage: %s -help\n",argv[0]);
	printf("       %s -pool <name> [-user <name>] [-size <size>] [-look]");
#if defined( BACKCMPTB )
	printf(" [-k]");
#endif
	printf(" [-table]\n\t     [-remove] [-link <path>] [-quiet] filename\n");
    }
    if ( help ) {
	printf("where:\n");
	printf("  filename %29s user file name\n","");
	HELP_options();
    }
}

/*
 *  sfget
 */
main(argc,argv)
int argc;
char *argv[];
{
  extern boolean reloadconfiguration;
  boolean  show_help,show_options;
  char	   *pool,*user,*strsize,*filename,*linkdir;
  boolean  remove,look,table,quiet;
#if defined( BACKCMPTB )
  boolean  k_flag;
#endif
  boolean  local,atomic;
  int      client,uid;
  long     size;
  char     *ent;
  int      sfreply,reply;
  path_t   msg;

    clear_vperror();

 /*
  *  Load the DPM and PAIR configuration
  */
    reloadconfiguration = FALSE;
    if ( load_configuration(TRUE,TRUE,TRUE) < 0 ) {
	vperror(0,"can't load the configuration");
	sfexit(EXCONF);
    }

 /*
  *  Get the option style setup
  */
    getoptstyle(&option_style);

 /*
  *  Define the options available
  */
    INIT_options();
    if ( option_style )
        DEFAULT_mask(UNIX_MASK);
    else 
	DEFAULT_mask(VMS_MASK);

    DEFAULT_mask(FILIST | NMLIST);
    ADD_OPT_options(&show_help,&show_options);

    DEFAULT_mask(EXTVAL | ALLOC | DESCR);
    ADD_options("pool",ENVIR | NAMENV,STRING,"DPMPOOL",&pool,POOL_DESCR);
    ADD_options("user",ENVIR | NAMENV,STRING,"DPMUSER",&user,USER_DESCR);
    ADD_options("size",0,STRING,&strsize,SIZE_DESCR);
    ADD_options("link",NOPREFIX | NOSINGLE | ENVIR | NAMENV,STRING,"DPMLINKDIR",&linkdir,LINKDIR_DESCR);

    DEFAULT_mask(EXTSEL | NOEXTVAL);
    ADD_options("remove",0,NONE,&remove,REMOVE_DESCR);
    ADD_options("table",0,NONE,&table,TABLE_DESCR);
    ADD_options("look",0,NONE,&look,LOOK_DESCR);

#if defined( BACKCMPTB )
    ADD_options("k",0,NONE,&k_flag,K_FLAG_DESCR);
#endif
    ADD_options("quiet",0,NONE,&quiet,QUIET_DESCR);

    DEFAULT_mask(FIXED_MASK);
    DEFAULT_mask(EXTVAL | ALLOC | HIDDEN | FILIST | NMLIST);
#if defined( TRACE )
    ADD_options("trace",0,INT,&tracemode);
#endif
    ADD_options("shifthost",ENVIR | NAMENV,STRING,"SHIFTDPMHOST",&shifthost);
    ADD_options("shiftport",ENVIR | NAMENV,INT,"SHIFTDPMPORT",&shiftport);

 /*
  *  Initialize the option values before calling READ_options()
  */
    shifthost = NULL;
    shiftport = UNDEF_PORT;
    pool = NULL;
    user = NULL;
    strsize = NULL;
    linkdir = NULL;

 /*
  *  Get the option values
  */
    if ( READ_options(argc,argv) < 0 ) {
        usage(argv,FALSE);
        sfexit(EXOPT);
    }

    if ( show_help && NO_opts()==1 ) {
        usage(argv,TRUE);
        sfexit(EXHELP);
    }

    if ( show_options )
        LIST_options();

 /*
  *  The pool name must be supplied
  */
    getoptpool(&pool,argv,usage);

 /*
  *  Get the uid used to build the nfs-path
  */
    getoptuser(user,NULL,&uid,NULL);

 /*
  *  Get the anticipated file size
  */
    getoptsize(strsize,&size);

  /*
   *  Get the user filename
   */
    if ( !NO_args() ) {
	vperror(0,"filename required");
	usage(argv,FALSE);
        sfexit(EXOPT);
    }
    if ( NO_args() > 1 ) {
	vperror(0,"too many filenames besides <%s>",argv[argc-NO_args()]);
	usage(argv,FALSE);
        sfexit(EXOPT);
    }
    filename = argv[argc-1];

#if defined( BACKCMPTB )
 /*
  *  Either '-look' or '-k' could be used! not together anyway
  */
    if ( look && k_flag ) {
	vperror(0,"look option is the same as k option");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }
    look = look || k_flag;
#endif

 /*
  *  The options remove and look ( or k_flag ) cannot be used together
  */
    if ( look && remove ) {
	vperror(0,"remove and %s options are incompatible",
#if defined( BACKCMPTB )
		k_flag ? "k" :
#endif
		"look");
	usage(argv,FALSE);
	sfexit(EXOPT);
    }

 /*
  *  Get the local/remote and atomic/noatomic mode
  */
    getsfmode(2,&local,&atomic);

#if defined( CREATMP )
 /*
  *  Get the configuration parameters used reading the tmp files ( local mode only )
  */
    if ( atomic && local && getreadtmpmode() < 0 )
	sfexit(EXCONF);
#endif

 /*
  *  Locally execute sfget on behalf of root
  */
    client = getuid();
    if ( local && beroot() < 0 && !is_debug_mode() ) {
	vperror(1,"Can't be root");
	sfexit(EXCONF);
    }

 /*
  *  Do it
  */
    if ( local )
	sfreply = dosfget(pool,uid,client,look,table,remove,size,filename,atomic,msg);
    else
	sfreply = rpc_sfget(pool,uid,client,look,table,remove,size,filename,atomic,msg);

    if (linkdir != NULL && ((!look && sfreply==EXCREA) || sfreply==EXFND) && 
				(reply = symlinkop(0,filename,msg,linkdir)) < 0 )
	    sfexit(reply);

 /*
  *  Handle the sfget reply
  */
    switch ( sfreply ) {
	case EXFND  :
		if ( !quiet ) printf("%s\n",msg);
		break;
        case EXCREA :
		if ( !quiet && !look ) printf("%s\n",msg);
		break;
	default :
                break;
    }

    sfexit(sfreply);
}
