/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sfrm.c	3.6 10/28/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <shift_types.h>
#include <strdup.h>
#include <optutil.h>
#include <strutil.h>
#include <strerror.h>
#include <parser.h>
#include <table.h>
#include <shiftconf.h>
#include <getconfent.h>
#include <dpmutil.h>

#define POOL_DESCR		"name of the shift disk pool to be used"
#define USER_DESCR		"user name to be used searching the file"
#define VERBOSE_DESCR           "the file nfs-pathname is echoed"
#define LINKDIR_DESCR		"remove the symbolic link to the file"

int serrno;		/* required because sfrm is not linked to the correct library */
int maxtmpattempts;	/* not used but required to link */
int tmpsleep;		/* not used but required to link */

char *shifthost;	/* hosts to connect when sfrm is executed remotely ( test ) */
int shiftport;		/* port number to use when connecting remote hosts ( test )  */

boolean  option_style;	/* option style flag */

/*
 *  sfrm usage
 */
void usage(argv,help)
char *argv[];
boolean help;
{
    if ( option_style ) {
	printf("usage: %s -help\n",argv[0]);
	printf("       %s -p<name> [-u<name>] [-v] [-link<path>] filename\n",argv[0]);
    }
    else {
	printf("usage: %s -help\n",argv[0]);
	printf("       %s -pool <name> [-user <name>] [-verbose]",argv[0]);
	printf(" [-link <path>] filename\n");
    }
    if ( help ) {
	printf("where:\n");
	printf("  filename %29s user file name to be removed\n","");
	HELP_options();
    }
}

/*
 *  sfrm
 */
main(argc,argv)
int argc;
char *argv[];
{
  extern boolean reloadconfiguration;
  boolean  show_help,show_options;
  char     *pool,*user,*filename,*linkdir;
  boolean  verbose,local,atomic;
  int      client,uid;
  char     *ent;
  int      sfreply,reply;
  path_t   msg;

    clear_vperror();

 /*
  *  Load the DPM and PAIR configurations
  */
    reloadconfiguration = FALSE;
    if ( load_configuration(TRUE,TRUE,TRUE) < 0 ) {
	vperror(0,"can't load the configuration");
	sfexit(EXCONF);
    }

 /*
  *  Get the option style setup
  */
    getoptstyle(&option_style);

 /*
  *  Define the options available
  */
    INIT_options();
    if ( option_style )
        DEFAULT_mask(UNIX_MASK);
    else
	DEFAULT_mask(VMS_MASK);

    DEFAULT_mask(FILIST | NMLIST);
    ADD_OPT_options(&show_help,&show_options);

    DEFAULT_mask(EXTVAL | ALLOC | DESCR);
    ADD_options("pool",ENVIR | NAMENV,STRING,"DPMPOOL",&pool,POOL_DESCR);
    ADD_options("user",ENVIR | NAMENV,STRING,"DPMUSER",&user,USER_DESCR);
    ADD_options("link",NOPREFIX | NOSINGLE | ENVIR | NAMENV,STRING,"DPMLINKDIR",&linkdir,LINKDIR_DESCR);

    DEFAULT_mask(EXTSEL | NOEXTVAL);
    ADD_options("verbose",0,NONE,&verbose,VERBOSE_DESCR);

    DEFAULT_mask(FIXED_MASK);
    DEFAULT_mask(EXTVAL | ALLOC | HIDDEN | FILIST | NMLIST);
#if defined( TRACE )
    ADD_options("trace",0,INT,&tracemode);
#endif
    ADD_options("shifthost",ENVIR | NAMENV,STRING,"SHIFTDPMHOST",&shifthost);
    ADD_options("shiftport",ENVIR | NAMENV,INT,"SHIFTDPMPORT",&shiftport);

 /*
  *  Initialize the option values before calling READ_options()
  */
    shifthost = NULL;
    shiftport = UNDEF_PORT;
    pool = NULL;
    user = NULL;
    linkdir = NULL;

 /*
  *  Get the option values
  */
    if ( READ_options(argc,argv) < 0 ) {
        usage(argv,FALSE);
        sfexit(EXOPT);
    }

    if ( show_help && NO_opts()==1 ) {
        usage(argv,TRUE);
        sfexit(EXHELP);
    }

    if ( show_options )
        LIST_options();

 /*
  *  The pool name must be supplied
  */
    getoptpool(&pool,argv,usage);

 /*
  *  Get the uid used to build the nfs-path
  */
    getoptuser(user,NULL,&uid,NULL);

 /*
  *  Get the user filename
  */
    if ( !NO_args() ) {
	vperror(0,"filename required");
	usage(argv,FALSE);
        sfexit(EXOPT);
    }
    if ( NO_args() > 1 ) {
	vperror(0,"too many filenames besides <%s>",argv[argc-NO_args()]);
	usage(argv,FALSE);
        sfexit(EXOPT);
    }

    filename = argv[argc-1];

 /*
  *  Get the local/remote and atomic/noatomic mode
  */
    getsfmode(1,&local,&atomic);

 /*
  *  Locally execute sfrm on behalf of root
  */
    client = getuid();
    if ( local && beroot() < 0 && !is_debug_mode() ) {
	vperror(1,"Can't be root");
	sfexit(EXCONF);
    }

 /*
  *  Do it
  */
    if ( local )
	sfreply = dosfrm(pool,uid,client,filename,atomic,msg);
    else
	sfreply = rpc_sfrm(pool,uid,client,filename,atomic,msg);

    if (linkdir != NULL && (sfreply==EXFND || sfreply==EXNFND) && 
			    (reply = symlinkop(1,filename,msg,linkdir)) < 0 )
	sfexit(sfreply == EXNFND ? EXNFND : reply);

 /*
  *  Handle the sfrm reply
  */
    switch ( sfreply ) {
	case EXFND :
		if ( verbose ) printf("%s\n",msg);
		break;
	default :
		break;
    }

    sfexit(sfreply);
}
