/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)sfrpc.c	3.5 11/02/93 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/stat.h>
#if defined( _AIX ) && defined( _IBMR2 )
#include <sys/select.h>
#endif
#include <netinet/in.h>
#include <netdb.h>
#include <shift_types.h>
#include <strutil.h>
#include <strdup.h>
#include <strtok.h>
#include <osdep.h>
#include <sockutil.h>
#include <marshall.h>
#include <pktutil.h>
#include <parser.h>
#include <table.h>
#include <getconfent.h>
#include <dpmutil.h>
#include <strerror.h>
#include <sfdpmd.h>

#define MAX_NOSFDAEMON	32			     /* max number of sfdaemons */
#define SFRPY_TIMEOUT	300,0			         /* shift reply timeout */

/*
 *  sfdaemon connection structure
 */
typedef struct {
    host_t host;
    int sock;
    int sferrno;
} sfdaemon_t;

/*
 *  Send the connect request to the remote sfdaemons
 *
 *  OUTPUT
 *	sfdaemons	list of connection
 *	nosfdaemon	length of 'sfdaemons' ( at most MAX_NOSFDAEMON )
 *
 *  RETURN
 *	1		successful completion
 *     < 0		an error occured
 */
int connect_sfdaemons(sfdaemons,nosfdaemon)
sfdaemon_t **sfdaemons;
int *nosfdaemon;
{
  extern char *shifthost;	       /* external list of sfdaemons to connect	*/
  extern port_t shiftport;	  /* external port number used by the sfdaemons	*/
  struct servent *server;
  char *host;

 /*
  *  Allocate memory to store the connection structures
  */
    if ( (*sfdaemons=(sfdaemon_t*)malloc(sizeof(sfdaemon_t)*MAX_NOSFDAEMON)) == NULL ) {
	vperror(1,"malloc(%d*%d)",sizeof(sfdaemon_t),MAX_NOSFDAEMON);
	return(EXSYS);
    }

 /*
  *  Get the list of sfdaemons to connect
  */
    if ( shifthost == NULL && (shifthost = getconfent("DPM","SFDAEMONS",1)) == NULL ) {
	vperror(0,"getconfent(DPM,SFDAEMONS): not found\nincomplete installation");
	return(EXCONF);
    }

 /*
  *  Get the port number used by the sfdaemons
  */
    if ( shiftport == UNDEF_PORT ) {
	if ( (server = getservbyname("shiftdpm","tcp")) == NULL ) {
	    vperror(1,"getservbyname(shiftdpm,tcp)");
	    return(EXCONF);
	}
	shiftport = ntohs(server->s_port);
    }

 /*
  *  Connect
  */
    ctrl_vperror(VPDISABLE);
    *nosfdaemon = 0;
    host = strtok(shifthost," \t:");
    while ( host != NULL ) {
	if ( *nosfdaemon == MAX_NOSFDAEMON ) {
	    ctrl_vperror(VPENABLE);
	    vperror(0,"too many hosts (max %d)\nincorrect installation",MAX_NOSFDAEMON);
	    return(EXCONF);
	}
	strcpy((*sfdaemons)[*nosfdaemon].host,host);
	if ( ((*sfdaemons)[*nosfdaemon].sock = 
				connect_to(UNDEF_SOCK,host,shiftport,1)) < 0 )
	    (*sfdaemons)[*nosfdaemon].sferrno = errno;
	(*nosfdaemon)++;
	host = strtok(NULL," \t:");
    }

#if defined( TRACE )
    if ( TRACE_connect ) 
	printf("connection request sent to %d sfdaemons: %s\n",*nosfdaemon,shifthost);
#endif
    ctrl_vperror(VPENABLE);
    return(1);
}

/*
 *  Send the shift request to one of the sfdaemons connected
 *
 *  INPUT
 *	sfdaemons	list of connection
 *	nosfdaemons	length of 'sfdaemons'
 *	pkt		packet containing the shift request to send
 *
 *  OUTPUT
 *	msg		message received by the remote procedure
 *	sfreply		reply code received by the remote procedure
 *
 *  RETURN
 *	1		successful completion
 *     < 0		an error occured
 */
int sfdaemons_rpc(sfdaemons,nosfdaemon,pkt,msg,sfreply)
sfdaemon_t *sfdaemons;
int nosfdaemon;
pkt_t *pkt;
char *msg;
int *sfreply;
{
  fd_set rmask,wmask,fmask,cmask;
  int idx,noconnection;
  int sfdsock 			    = UNDEF_SOCK;
  int err,errlen;

 /*
  *  Set the shift request timeout
  */
    set_timeout(TIME,SFRPY_TIMEOUT);

 /*
  *  Initialize the loop ( connections failed or closed )
  */
    FD_ZERO(&fmask);
    FD_ZERO(&cmask);

    for(;;) {

     /*
      *  Exit the loop if the reply arrived
      */
	if ( sfdsock != UNDEF_SOCK && FD_ISSET(sfdsock,&rmask) ) break;

     /*
      *  Build the read and write mask for the select
      */
	FD_ZERO(&rmask);
	FD_ZERO(&wmask);
	noconnection = 0;
	for (idx=0; idx<nosfdaemon; idx++)
	    if ( sfdaemons[idx].sock > 0 && 
			!FD_ISSET(sfdaemons[idx].sock,&fmask) &&
				!FD_ISSET(sfdaemons[idx].sock,&cmask) ) {
		FD_SET(sfdaemons[idx].sock,&rmask);
		if ( sfdsock == UNDEF_SOCK ) 
		    FD_SET(sfdaemons[idx].sock,&wmask);
		noconnection++;
	    }

     /*
      *  Exit the loop unless at least one connection is still in progress
      */
	if ( !noconnection ) break;

     /*
      *  Select
      */
	switch ( select(FD_SETSIZE,&rmask,&wmask,(fd_set*)NULL,get_timeout()) ) {

	    case -1 :
		vperror(1,"select()");
		return(EXSYS);

	    case 0 :
		vperror(0,"%s timed out",sfdsock==UNDEF_SOCK ? "select" : "protocol");
		return(EXSYS);

	    default :
	     /*
              *  Discard the connections failed and get the remote reply
	      */
		for (idx=0; idx<nosfdaemon; idx++)
		    if ( sfdaemons[idx].sock > 0 && 
				FD_ISSET(sfdaemons[idx].sock,&rmask) ) {
			errlen = sizeof(err);
			getsockopt(sfdaemons[idx].sock,SOL_SOCKET,SO_ERROR,(char *)&err,&errlen);
			if ( err == 0 ) continue;
#if defined( TRACE )
			if ( TRACE_connect )
			    if ( sfdaemons[idx].sock != sfdsock )
				printf("connection to %s failed\n",sfdaemons[idx].host);
			    else
				printf("received remote reply\n");
#endif
			sfdaemons[idx].sferrno = err;
			FD_SET(sfdaemons[idx].sock,&fmask);
		    }

	     /*
	      *  Send the request to the first sfdaemon connected and
	      *  close the other connections established and unused
	      */
		for (idx=0; idx<nosfdaemon; idx++)
		    if ( sfdaemons[idx].sock > 0 && 
				    FD_ISSET(sfdaemons[idx].sock,&wmask) &&
						!FD_ISSET(sfdaemons[idx].sock,&fmask) )
			if ( sfdsock == UNDEF_SOCK ) {
#if defined( TRACE )
			    if ( TRACE_connect )
				printf("connected to %s\n",sfdaemons[idx].host);
#endif
			    sfdsock = sfdaemons[idx].sock;
			    if ( write_packet(sfdsock,pkt) != EPKTOK )
				return(EXSYS);
			}
			else {
#if defined( TRACE )
			    if ( TRACE_connect )
				printf("closed connection to %s\n",sfdaemons[idx].host);
#endif
			    FD_SET(sfdaemons[idx].sock,&cmask);
			    close(sfdaemons[idx].sock);
			}
		break;

	} /* switch */

    } /* loop */

 /*
  *  If no connection was established print the error messages
  */
    if ( !noconnection ) {
#if defined( TRACE )
	if ( TRACE_connect )
	    printf("no connection established\n");
#endif
	for (idx=0; idx<nosfdaemon; idx++)
	    vperror(0,"Can't connect %s: %s",
			sfdaemons[idx].host,
			strerror(sfdaemons[idx].sferrno));
	return(EXSYS);
    }

 /*
  *  A reply arrived from the remote sfdaemon
  */
#if defined( TRACE )
    if ( TRACE_connect )
	printf("reading remote reply\n");
#endif
    if ( read_packet(sfdsock,pkt) == EPKTOK ) {
	pkt->ptr = pkt->netbody;
	switch ( pkt->request ) {
	    case PKT_SFREPLY :
		    unmarshall_LONG(pkt->ptr,*sfreply);
		    unmarshall_STRING(pkt->ptr,msg);
#if defined( TRACE )
		    if ( TRACE_connect ) {
			printf("unmarshall sfreply : %d\n",*sfreply);
			printf("unmarshall message : %s\n",msg);
		    }
#endif
		    return(1);
	    case PKT_BADSTATUS :
		    unmarshall_STRING(pkt->ptr,msg);
#if defined( TRACE )
		    if ( TRACE_connect )
			printf("received error %s\n",msg);
#endif
		    vperror(0,"peer failure: (%s)",msg);
		    break;
	    default :
		    vperror(0,"unexpected packet (%d) received",pkt->request);
	}
    }

    return(EXSYS);
}

/*
 *  Call the remote dosfget()
 *
 *  INPUT
 *	same parameters as for the local dosfget()
 *
 *  RETURN
 *	same return values as for the local dosfget()
 */
int rpc_sfget(pool,pathuid,clientuid,look,table,remove,size,file,atomic,msg)
char *pool;
int pathuid,clientuid;
boolean look,table,remove;
long size;
char *file;
boolean atomic;
char *msg;
{
  sfdaemon_t *sfdaemons;
  int nosfdaemon,reply,sfreply;
  pkt_t pkt;
  int mask;

 /*
  *  Connect the remote sfdaemons
  */
    if ( (reply = connect_sfdaemons(&sfdaemons,&nosfdaemon)) < 0 )
	return(reply);

 /*
  *  Initialize the packet structure
  */
    pktinit(&pkt);

 /*
  *  Build the SFGET packet
  */
    pkt.request = PKT_SFGET;

    pkt.length = sizeof(LONG)*4+strlen(pool)+strlen(file)+6;
    if ( (pkt.ptr = pktalloc(&pkt,pkt.length)) == NULL )
	return(EXSYS);

    mask = umask(0);
    umask(mask);

#if defined( TRACE )
    if ( TRACE_connect ) {
	printf("marshall pathuid   : %d\n",pathuid);
	printf("marshall clientuid : %d\n",clientuid);
	printf("marshall size      : %d\n",size);
	printf("marshall mask      : %o\n",mask);
	printf("marshall pool      : %s\n",pool);
	printf("marshall file      : %s\n",file);
	printf("marshall look      : %s\n",look ? "yes" : "no");
	printf("marshall table     : %s\n",table ? "yes" : "no");
	printf("marshall remove    : %s\n",remove ? "yes" : "no");
	printf("marshall atomic    : %s\n",atomic ? "yes" : "no");
    }
#endif
    marshall_LONG(pkt.ptr,pathuid);
    marshall_LONG(pkt.ptr,clientuid);
    marshall_LONG(pkt.ptr,size);
    marshall_LONG(pkt.ptr,mask);
    marshall_STRING(pkt.ptr,pool);
    marshall_STRING(pkt.ptr,file);
    marshall_BYTE(pkt.ptr,look);
    marshall_BYTE(pkt.ptr,table);
    marshall_BYTE(pkt.ptr,remove);
    marshall_BYTE(pkt.ptr,atomic);

 /*
  *  Send the SFGET packet and wait for the SFREPLY packet
  */
    if ( (reply = sfdaemons_rpc(sfdaemons,nosfdaemon,&pkt,msg,&sfreply)) < 0 )
	return(reply);

 /*
  *  Emulate locally the output of the remote dosfget()
  */
    switch ( sfreply ) {
	case EXFND  :
		break;
	case EXCREA :
		if ( !look ) break;
	default :
		vperror(0,"%s",msg);
		break;
    }

    return(sfreply);
}

/*
 *  Call the remote dosfrm()
 *
 *  INPUT
 *	same parameters as for the local dosfrm()
 *
 *  RETURN
 *	same return values as for the local dosfrm()
 */
int rpc_sfrm(pool,pathuid,clientuid,file,atomic,msg)
char *pool;
int pathuid;
int clientuid;
char *file;
boolean atomic;
char *msg;
{
  sfdaemon_t *sfdaemons;
  int nosfdaemon,reply,sfreply;
  pkt_t pkt;

 /*
  *  Connect the remote sfdaemons
  */
    if ( (reply = connect_sfdaemons(&sfdaemons,&nosfdaemon)) < 0 )
	return(reply);

 /*
  *  Initialize the packet structure
  */
    pktinit(&pkt);

 /*
  *  Build the SFRM packet
  */
    pkt.request = PKT_SFRM;

    pkt.length = sizeof(LONG)*2+strlen(pool)+strlen(file)+3;
    if ( (pkt.ptr = pktalloc(&pkt,pkt.length)) == NULL )
	return(EXSYS);

#if defined( TRACE )
    if ( TRACE_connect ) {
	printf("marshall pathuid   : %d\n",pathuid);
	printf("marshall clientuid : %d\n",clientuid);
	printf("marshall pool      : %s\n",pool);
	printf("marshall file      : %s\n",file);
	printf("marshall atomic    : %s\n",atomic ? "yes" : "no");
    }
#endif
    marshall_LONG(pkt.ptr,pathuid);
    marshall_LONG(pkt.ptr,clientuid);
    marshall_STRING(pkt.ptr,pool);
    marshall_STRING(pkt.ptr,file);
    marshall_BYTE(pkt.ptr,atomic);

 /*
  *  Send the SFRM packet and wait for the SFREPLY packet
  */
    if ( (reply = sfdaemons_rpc(sfdaemons,nosfdaemon,&pkt,msg,&sfreply)) < 0 )
	return(reply);

 /*
  *  Emulate locally the output of the remote dosfrm()
  */
    switch ( sfreply ) {
	case EXFND :
		break;
	default :
		vperror(0,"%s",msg);
		break;
    }

    return(sfreply);
}
