/*
 * @(#)bits.h	3.1 06/16/92 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __BITS_H__
#define __BITS_H__

/*
**
**    B I T S . H   -   bits manipulation
**
*/





#include <osdep.h>





#define  BITSOFBYTE		NBBY			/* number of bits in a byte */


#define  bitsof(t)		sizeof(t)*BITSOFBYTE    /* number of bits in a type */


typedef  char*			bitvct;			/* bit vector type definition */


/*
**  Allocate enough memory for a 'bitvct' type variable containing 'size' bits
*/
#define  bitalloc(size)		(bitvct)malloc(size/BITSOFBYTE + \
						((size%BITSOFBYTE) ? 1 : 0))


/*
**  Set the bit 'bit-th' starting from the byte pointed to by 'ptr'
*/ 
#define  BIT_SET(ptr,bit)	{ char *p = (char*)(ptr) + (bit)/8; \
				  *p = *p | (1 << (7-(bit)%8)) ; \
				}
 

/*
**  Clear the bit 'bit-th' starting from the byte pointed to by 'ptr'
*/ 
#define  BIT_CLR(ptr,bit)	{ char *p = (char*)(ptr) + (bit)/8; \
				  *p = *p & ~(1 << (7-(bit)%8)); \
				}


/*
**  Test the bit 'bit-th' starting from the byte pointed to by 'ptr'
*/ 
#define  BIT_ISSET(ptr,bit)	(*(char*)((char*)(ptr)+(bit)/8) & (1 << (7-(bit)%8)))
					  




#endif




