/*
 * @(#)config.h	3.3 05/28/93 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __CONFIG_H__
#define __CONFIG_H__

#define HOSTSEPSET	" :"
#define HOSTSEP		" "

#define HOSTS_OFFSET	sizeof(int)+sizeof(time_t)

/*
 *  Access modes for the open_binary()
 */
#define ACCESS_READ	0
#define ACCESS_UPDATE	1
#define ACCESS_WRITE	2
#define ACCESS_NEW	3

/*
 *  Lock modes for the lock_binary()
 */
#define LOCK_LEAVE	0
#define LOCK_READ	1
#define LOCK_WRITE	2
#define LOCK_EXREAD	3
#define UNLOCK		4

#if !defined( NOAUTHORIZE )

/*
 *  Authorization codes for is_host_authorized()
 */
#define BINARYAUTHORIZE 	0
#define ASCIIAUTHORIZE  	1
#define EXPORTAUTHORIZE		2
#define REXPORTAUTHORIZE	3
#define RIMPORTAUTHORIZE	4

#endif

/*
 *  Error codes for some basic stream operations
 */
#if defined( sun ) || defined( apollo ) || defined( ultrix ) || defined( hpux ) || ( defined(__osf__) && defined(__alpha) )

#define fseek_ERROR	== -1
#define fread_ERROR	== 0
#define fwrite_ERROR	== 0
#define fflush_ERROR	== EOF
#define fclose_ERROR	== EOF

#endif

#if defined( sgi ) || defined( _AIX ) || defined( CRAY )

#define fseek_ERROR	!= 0
#define fread_ERROR	< 1
#define fwrite_ERROR	< 1
#define fflush_ERROR	== EOF
#define fclose_ERROR	== EOF

#endif

/*
 *  Function prototypes
 */
int 	make_binary_copy();
int 	recover_binary_copy();
boolean is_binary_corrupted();
int 	lock_file(
#ifdef __STDC__
		 char*,int,int
#endif
		 );
int 	lock_binary(
#ifdef __STDC__
		    int
#endif
		    );
int 	open_binary(
#ifdef __STDC__
		    int,int
#endif
		    );
int 	close_binary(
#ifdef __STDC__
		    boolean,int
#endif
		    );
int 	remove_ascii_files();
int 	getshifthosts(
#ifdef __STDC__
		     boolean
#endif
		     );
boolean merge_hosts(
#ifdef __STDC__
		    char*
#endif
		    );
int	read_binary_file(
#ifdef __STDC__
			 boolean,boolean
#endif
			);
int 	write_binary_file();
int 	marshall_binary_file();
int 	unmarshall_binary_file();
void 	print_versions();
void 	print_environment();
void 	print_configuration(
#ifdef __STDC__
			    int
#endif
			    );
int	free_configuration();
void	build_shift_paths(
#ifdef __STDC__
			 char*,char*,char*
#endif
			 );
boolean is_host_authorized(
#ifdef __STDC__
			  int,char*
#endif
			  );

#endif

