/*
 * @(#)dosfgc.h	3.1 06/16/92 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved 
 */

#ifndef __SFGC_UTIL_H__
#define __SFGC_UTIL_H__

/*
**
*/



#define MTIME	0
#define ATIME	1



/*
**   Structure of elements in the GC List 
**   It contains information about one file
*/
typedef struct gc_element_t {
	path_t			path;
	int			size;
	time_t			creatime;
	char			linktype;
        short			uid,gid;
	struct gc_element_t	*younger;
	struct gc_element_t	*older;
} gc_element_t ;



/*
**   Structure of the GC List
*/
typedef struct gc_list_t {
	gc_element_t	*oldest;
	gc_element_t	*youngest;
	gc_element_t	*tbgoldest;
	gc_element_t	*tbgyoungest;
	float		space;
} gc_list_t ;



#ifndef __SFGC_UTIL_C__

extern boolean gc_select_files();
extern boolean gc_select_fsys();
extern boolean gc_select_fsysgrp();

#endif



#endif


