/*
 * @(#)dpmutil.h	3.9 05/07/93  CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __DPMUTIL_H__
#define __DPMUTIL_H__

#define CREATMP
#define TRACE

#if defined( TRACE )

extern int tracemode;

#define TRACE_dosfget		tracemode & 0x1
#define TRACE_dosfrm		tracemode & 0x1
#define TRACE_sfdpmd		tracemode & 0x1
#define TRACE_write_tmps	tracemode & 0x2
#define TRACE_read_tmps		tracemode & 0x4
#define TRACE_remove_tmps	tracemode & 0x8
#define TRACE_scan_pool		tracemode & 0x10
#define TRACE_connect		tracemode & 0x20

#endif

#define EXNFND		1
#define EXCREA		1
#define EXGCOK		1
#define EXHELP          0
#define EXFND           0
#define EXGCNONE	0
#define EXOPT		-1
#define EXCONF          -2
#define EXPERM  	-3
#define EXSEL		-4
#define EXSYS		-5
#define EXINT		-6

#define UNDEF_IDX	-1
#define MAXLOOPS	20

#define SHIFTSYMLINKDIR	"DPMLINKDIR"

/*
 *  Pool graph node structure
 */
typedef struct pnode_t {
    char *pname;
    char *penv;
    struct pnode_t *pexp,*plist,*pback;
    int pidx;
    int skip;
    int lev;
} pnode_t;

#define INIT_pnode(p)	memset((char*)p,(int)0,(int)sizeof(pnode_t))

#define PSPCH	'+'
#define PSCCH	':'
#define PSPCD	0
#define PSCCD	1

typedef struct poolfs_t {
    index_t_s fsidx,pidx;
    path_t  mount,dir;
    int level;
    int num;
} poolfs_t;

typedef struct scanp_t {
    path_t p_file,p_tmp;
    struct stat stat;
    int file,tmp,perm,error;
    int scerrno;
    int fd;
    int offset;
} scanp_t ;

/*
 *  dpmutil.c
 */
void	create_mountpath(
#ifdef __STDC__
			index_t_s,char*
#endif
			);
int 	create_nfspath(
#ifdef __STDC__
		      index_t_s,int,int,char*,char*
#endif
		      );
void 	printgraph(
#ifdef __STDC__
		  pnode_t*,boolean
#endif
		  );
void	loadgraphinfo(
#ifdef __STDC__
		     pnode_t*,int*,index_t_s*,int*
#endif
		     );
void	freegraph( 
#ifdef __STDC__
		 pnode_t*
#endif
		 );
void    detect_cycle(
#ifdef __STDC__
		    pnode_t*,pnode_t*,int*,string*
#endif
		    );
int	detect_copy(
#ifdef __STDC__
		   pnode_t*,pnode_t*
#endif
		  );
pnode_t *allocate_pnode();
int	buildgraph(
#ifdef __STDC__
		  pnode_t*,pnode_t*,char*,string*
#endif
		  );
int 	getpoollist(
#ifdef __STDC__
		   char*,index_t_s**,int**,int*
#endif
		   );
int     getnfspaths(
#ifdef __STDC__
		   char*,int,int,int*,poolfs_t**
#endif
		   );
int	authorized_to_remove(
#ifdef __STDC__
			    int,int,int,struct stat*
#endif
			    );
int	authorized_to_create(
#ifdef __STDC__
			    int,int,int
#endif
			    );
int	scandiskpool(
#ifdef __STDC__
		    int,int,int,int,char*,int,poolfs_t*,scanp_t**,boolean,int*
#endif
		    );
int 	beroot();
int	beclient();
int	getgroupids(
#ifdef __STDC__
		    int,int*,char*,int,int*,char*
#endif
		   );
void	sfexit(
#ifdef __STDC__
		int
#endif
		);

/*
 *  disk.c
 */
#define FSMNTD		1
#define FSUMNTD		-1
#define FSUNACC		-2
#define FSERROR		-3

int 	create_dirname(
#ifdef __STDC__
			char*,int,int,int
#endif
		      );
int 	create_dirpath(
#ifdef __STDC__
		      char*,int,int,int,int
#endif
		      );
int 	create_file(
#ifdef __STDC__
		    char*,int,int,int,int,int
#endif
		    );
int 	remove_file(
#ifdef __STDC__
		    char*
#endif
		    );
int	is_file_there(
#ifdef __STDC__
		    char*,struct stat*
#endif
		    );
int 	is_device_mounted(
#ifdef __STDC__
			  char*,struct stat*
#endif
			  );
int	is_filesystem(
#ifdef __STDC__
			  char*,struct stat*,int
#endif
			  );
void 	filesystem_error(
#ifdef __STDC__
			char*,int,int
#endif
			);
int	getfsystat(
#ifdef __STDC__
		   char*,long*,long*,long*,int*
#endif
		  );

/*
 *  option.c
 */
void 	getoptstyle(
#ifdef __STDC__
		    int*
#endif
		    );
typedef void 	(*void_function)();
void 	getoptpool(
#ifdef __STDC__
		   char**,char**,void_function
#endif
		   );
void 	getoptuser(
#ifdef __STDC__
		   char*,char*,int*,int*
#endif
		  );
void 	getoptsize(
#ifdef __STDC__
		   char*,long*
#endif
		  );
int 	is_debug_mode();
int 	getselectlock(
#ifdef __STDC__
		      char*,char*,char*
#endif
		     );
void 	getmode(
#ifdef __STDC__
		char*,boolean*,boolean*
#endif
		);
void 	getsfmode(
#ifdef __STDC__
		  int,boolean*,boolean*
#endif
		 );
int 	getreadtmpmode();

/*
 *  dosfget.c - dosfrm.c - dosfsh.c
 */
int 	dosfsh(
#ifdef __STDC__
		char*,int,int,char*,boolean,boolean,boolean,boolean,boolean,char*,boolean
#endif
		);
int	dosfrm(
#ifdef __STDC__
		char*,int,int,char*,boolean,char*
#endif
		);
int	rpc_sfrm(
#ifdef __STDC__
		char*,int,int,char*,boolean,char*
#endif
		);
int	dosfget(
#ifdef __STDC__
		char*,int,int,boolean,boolean,boolean,long,char*,boolean,char*
#endif
		);
int	rpc_sfget(
#ifdef __STDC__
		char*,int,int,boolean,boolean,boolean,long,char*,boolean,char*
#endif
		);
int	symlinkop(
#ifdef __STDC__
		  int,char*,char*,char*
#endif
		 );
boolean issamelink(
#ifdef __STDC__
		   char*,char*
#endif
		  );
int	lookforfile(
#ifdef __STDC__
		    int,scanp_t*,scanp_t*,boolean*,boolean,char*,char*
#endif
		   );
int	remove_files(
#ifdef __STDC__
		     int,scanp_t*
#endif
		    );

/*
 *  select.c
 */
int	select_file_system(
#ifdef __STDC__
			  long,int,poolfs_t*,scanp_t*,int*,int*
#endif
			  );

/*
 *  tmps.c
 */
int 	tmpfread(
#ifdef __STDC__
		scanp_t*,char*,int
#endif
		);
void 	remove_tmps(
#ifdef __STDC__
		    int,scanp_t*,scanp_t*,boolean
#endif
		   );
int 	write_tmp(
#ifdef __STDC__
		  char*,int,scanp_t*,scanp_t*
#endif
		 );
int 	open_tmp(
#ifdef __STDC__
		 scanp_t*
#endif
		);
int 	read_tmps(
#ifdef __STDC__
		  int,poolfs_t*,scanp_t*,scanp_t*,int*,int*
#endif
		 );

#endif
