/*
 * @(#)marshall.h	3.2 10/01/92 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef _MARSHALL_H_INCLUDED_
#define _MARSHALL_H_INCLUDED_

#include <osdep.h>              /* Operating system dependencies        */
#include <bits.h>               /* memory operations definition         */

#define SHORT			WORD
#define SHORTSIZE		WORDSIZE
#define SHORTADDR		WORDADDR
#define U_SHORT			U_WORD

#define marshall_WORD		marshall_SHORT
#define unmarshall_WORD		unmarshall_SHORT
#define marshall_U_WORD		marshall_SHORT
#define unmarshall_U_WORD	unmarshall_SHORT

#define INC_PTR(ptr,n)		(ptr) = (char*)(ptr) + (n)
#define DIFF_PTR(ptr,base)      (char*)(ptr) - (char*)(base)

/*
 *    B Y T E
 */
#define marshall_BYTE(ptr,n)	{ BYTE n_ = n; \
				  (void)memcpy((ptr),BYTEADDR(n_),BYTESIZE); \
				  INC_PTR(ptr,BYTESIZE); \
				}

#define unmarshall_BYTE(ptr,n)  { BYTE n_; \
				  (void)memcpy(BYTEADDR(n_),(ptr),BYTESIZE); \
				  n = n_; \
				  INC_PTR(ptr,BYTESIZE); \
				}

/*
 *    S H O R T
 */
#define marshall_SHORT(ptr,n)	{ SHORT n_ = htons(n); \
				  (void)memcpy((ptr),SHORTADDR(n_),SHORTSIZE); \
				  INC_PTR(ptr,SHORTSIZE); \
				}

#define unmarshall_SHORT(ptr,n)	{ SHORT n_ = 0;  \
				  (void)memcpy(SHORTADDR(n_),(ptr),SHORTSIZE); \
                                  n = ntohs(n_); \
				  if ( BIT_ISSET(ptr,(sizeof(SHORT)-SHORTSIZE)*8) ) \
					 (void)memset(&n,255,sizeof(SHORT)-SHORTSIZE); \
				  INC_PTR(ptr,SHORTSIZE); \
				}

/*
 *    U N S I G N E D   S H O R T
 */
#define marshall_U_SHORT(ptr,n)		marshall_SHORT(ptr,n)

#define unmarshall_U_SHORT(ptr,n) 	{ U_SHORT n_ = 0;  \
				  	  (void)memcpy(SHORTADDR(n_),(ptr),SHORTSIZE); \
                                  	  n = ntohs(n_); \
				  	  INC_PTR(ptr,SHORTSIZE); \
					}

/*
 *    L O N G
 */
#define marshall_LONG(ptr,n)	{ LONG n_ = htonl(n); \
				  (void)memcpy((ptr),LONGADDR(n_),LONGSIZE); \
				  INC_PTR(ptr,LONGSIZE); \
				}

#define unmarshall_LONG(ptr,n)	{ LONG n_ = 0;  \
				  (void)memcpy(LONGADDR(n_),(ptr),LONGSIZE); \
                                  n = ntohl(n_); \
				  if ( BIT_ISSET(ptr,(sizeof(LONG)-LONGSIZE)*8) ) \
					 (void)memset(&n,255,sizeof(LONG)-LONGSIZE); \
				  INC_PTR(ptr,LONGSIZE); \
				}

/*
 *    U N S I G N E D   L O N G
 */
#define marshall_U_LONG(ptr,n)		marshall_LONG(ptr,n)

#define unmarshall_U_LONG(ptr,n)	{ U_LONG n_ = 0;  \
				  	  (void)memcpy(LONGADDR(n_),(ptr),LONGSIZE); \
                                	  n = ntohl(n_); \
					  INC_PTR(ptr,LONGSIZE); \
					}

/*
 *    S T R I N G
 */
#define  marshall_STRING(ptr,str)	{ (void)strcpy((char*)(ptr),(char*)(str)); \
					  INC_PTR(ptr,strlen(str)+1); \
					}

#define  unmarshall_STRING(ptr,str)	{ (void)strcpy((char*)(str),(char*)(ptr)); \
					  INC_PTR(ptr,strlen(str)+1); \
					}

#endif

