/*
 * @(#)mknet.h	3.1 06/16/92 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __MKNET_H__
#define __MKNET_H__

/*
 *  Packet request codes
 */
#define PKT_EXPORT	0x0101
#define PKT_IMPORT	0x0202
#define PKT_NOVERSION	0x0303
#define PKT_SENDVERSION	0x0404
#define PKT_ENDEXPORT	0x0505
#define PKT_ENDIMPORT	0x0606
#define PKT_SENDBINARY	0x0707
#define PKT_ENDBINARY	0x0808
#define PKT_REQBINARY	0x0909
#define PKT_ACKNOWLEDGE	0x0A0A
#define PKT_BADSTATUS	0x0B0B

/*
 *  Connection state codes
 *
 *  The format is 0x???? where starting from the Most Significant Digit :
 *
 *	- the first two digits specify the state number
 *	- the third digit can be zero or non-zero to specify the it is a good
 *	  or erroneous state
 *	- the fourth digit is 1 if messages can be received, 2 if messages can be
 *	  sent and 3 if both 1 and 2
 */
typedef enum {
	  ST_ACCEPT	  = 0x0001,
	  ST_CONNECTING	  = 0x0103,
	  ST_EXPORT	  = 0x0201,
	  ST_IMPORT	  = 0x0301,
	  ST_EXPBINARY	  = 0x0403,
	  ST_IMPBINARY	  = 0x0501,
	  ST_CHECKVERS	  = 0x0601,
	  ST_ACKSEND	  = 0x0703,
	  ST_ACKRECV	  = 0x0801,
	  ST_END	  = 0x0900,
	  ST_FAILURE	  = 0x0A10,
	  ST_ZEROMSG	  = 0x0B10,
	  ST_IMPOSSIBLE	  = 0x0C10,
	  ST_PEERFAILURE  = 0x0D10,
	  ST_TIMEDOUT	  = 0x0E10,
	  ST_SEQUENCE	  = 0x0F10
	} status_t ;

/*
 *  Masks for the connection states
 */
#define READMASK	0x0001
#define WRITEMASK	0x0002
#define ERRORMASK	0x0010

/*
 *  Connection structure
 */
typedef struct remote_t {
    host_t host;		/*  remote host name			*/
    int sock;			/*  socket descriptor			*/
    status_t status;		/*  connection status			*/
    char *strerr;		/*  error message			*/
    FILE *fd;			/*  binary network file descriptor 	*/
    int size; 			/*  binary network size			*/
    time_t version;		/*  configuration version		*/
    boolean imported;
    boolean printed;
    status_t oper;
} remote_t;

/*
 *  Function prototypes
 */
port_t 	getdpmconfport();
int 	handle_read_packet(
#ifdef __STDC__
			  int,remote_t*,pkt_t*,int,int*
#endif
			  );
int 	handle_writepacket(
#ifdef __STDC__
			  int,remote_t*
#endif
			  );
int 	send_request(
#ifdef __STDC__
		     remote_t*,int,int
#endif
		     );
int 	send_badstatus(
#ifdef __STDC__
		      remote_t*,char*
#endif
		      );
void 	recv_error(
#ifdef __STDC__
		  remote_t*
#endif
		  );
void 	send_binary(
#ifdef __STDC__
		    remote_t*
#endif
		   );
void 	recv_binary(
#ifdef __STDC__
		    remote_t*,pkt_t*
#endif
		   );
int 	connect_copies(
#ifdef __STDC__
			char*,remote_t**,int*
#endif
			);
typedef void	(*voidfunc)();
int 	netdialog(
#ifdef __STDC__
		  remote_t*,int,voidfunc,voidfunc,boolean
#endif
		 );
char 	*strnull(
#ifdef __STDC__
		char*
#endif
		);
void	print_connection_header();
int	print_connection_status(
#ifdef __STDC__
			     remote_t*
#endif
			     );
int 	print_connection_results(
#ifdef __STDC__
			     remote_t*,int
#endif
			     );

#endif
