/*
 *  @(#)optutil.h	3.3 05/12/93  CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __OPTUTIL_H__
#define __OPTUTIL_H__

#include <strutil.h>

/*
 *
 */
#define SINGLE          0x1 
#define NOSINGLE        0x10000 
#define BLANK           0x2
#define NOBLANK         0x20000 
#define CASESN          0x4
#define NOCASESN        0x40000 
#define PREFIX          0x8
#define NOPREFIX        0x80000
#define EXTSEL          0x10
#define NOEXTSEL        0x100000
#define EXTVAL          0x20
#define NOEXTVAL        0x200000
#define ALLOC           0x40
#define NOALLOC         0x400000
#define FILIST          0x80
#define NOFILIST        0x800000
#define DSLIST          0x100
#define NODSLIST        0x1000000
#define NMLIST          0x200
#define NONMLIST        0x2000000
#define ENVIR           0x400
#define NOENVIR         0x4000000
#define PRENV           0x800
#define NOPRENV         0x8000000
#define NAMENV          0x1000
#define NONAMENV        0x10000000
#define DESCR           0x2000 
#define NODESCR         0x20000000
#define HIDDEN          0x4000 
#define NOHIDDEN        0x40000000
#define OPTVAL_S        0x8000 
#define NOOPTVAL        0x80000000

typedef int option_bits ;

/*
 *
 */
#define COMM_MASK	NOFILIST | DSLIST | NONMLIST | NOEXTSEL | NOEXTVAL | \
			NOENVIR | NOPRENV | NONAMENV | NODESCR | NOHIDDEN | \
			NOOPTVAL | NOALLOC

#define UNIX_MASK	CASESN | SINGLE | NOBLANK | NOPREFIX | COMM_MASK

#define VMS_MASK	NOCASESN | NOSINGLE | BLANK | PREFIX | COMM_MASK

#define FIXED_MASK	CASESN | NOSINGLE | NOBLANK | NOPREFIX | COMM_MASK

typedef enum { NONE, CHAR, SHORTI, INT, LONGI, STRING, DSTR } option_types ;

#define MNEMO_option_type(type)		mnemo_option_types[type]

/*
 *  Structure definitions
 */
typedef struct {
	string		name;
	string		namenv;
	long 		mask;
	option_types	type;
	union {
	   char	   c;
	   short   h;
	   int	   i;
	   long	   l;
	   string  s;
	} 		value ;
	char		*extvalue;
	int		selected;
	char		*extselected;
	int		isvalue;
	string		description;
} option_item ;

/*
 *  Exported variables
 */
extern char *mnemo_option_types[];
extern int  opt_quiet;
#define SILENT_options		opt_quiet
extern char opt_error[256];
#define ERRORMSG_options	opt_error
extern int  help_mode;
extern int  mask_mode;

/*
 *  Exported functions
 */
extern int	DEFAULT_mask(
#ifdef __STDC__
		int
#endif
);
extern int	ADD_options(
#ifdef __STDC__
/*      the varargs is used and I can't write the prototype!    */
#endif
);
extern int	READ_options(
#ifdef __STDC__
		int,char**
#endif
);
extern int	IS_option(
#ifdef __STDC__
		char*
#endif
);
extern char	*VAL_option(
#ifdef __STDC__
		char*
#endif
);
extern int 	NO_opts();
extern int 	NO_args();
extern int 	NO_envs();

/*
 *
 */
extern int	INIT_option_item(
#ifdef __STDC__
		option_item*
#endif
);
extern int	DUP_option_item(
#ifdef __STDC__
		option_item*,option_item*
#endif
);
extern void	FREE_option_item(
#ifdef __STDC__
		option_item*
#endif
);
extern char	*VALUE_optio_item(
#ifdef __STDC__
		option_item*
#endif
);
extern void	PRINT_options();
extern void	LIST_options();
extern int	INIT_options();
extern void	FREE_options();
extern void	opt_print(
#ifdef __STDC__
/*      the varargs is used and I can't write the prototype!    */
#endif
);
static void ERR_ambiguous(
#ifdef __STDC__
		char*, int, int
#endif
);
static void ERR_unknown(
#ifdef __STDC__
		char*
#endif
);
static void ERR_novalue(
#ifdef __STDC__
		char*
#endif
);
static void ERR_internal(
#ifdef __STDC__
		char*, char*
#endif
);
static void ERR_extrargument(
#ifdef __STDC__
		int, char**, int
#endif
);
static void ERR_dashargument(
#ifdef __STDC__
		char*
#endif
);
static void ERR_optargument(
#ifdef __STDC__
		char*, int
#endif
);
static void ERR_doublematch(
#ifdef __STDC__
		char*, int
#endif
);
static void ERR_boolenv(
#ifdef __STDC__
		char*, char*
#endif
);
static void ERR_missenv(
#ifdef __STDC__
		char*, char*
#endif
);
static int	VERIFY_mask(
#ifdef __STDC__
		char*, int
#endif
);
static option_item *to_option_item(
#ifdef __STDC__
/*      the varargs is used and I can't write the prototype!    */
#endif
);
static option_item *GET_options(
#ifdef __STDC__
			char*
#endif
);
static int	MATCH_option(
#ifdef __STDC__
		int, char*, string*
#endif
);
static int	CONVERT_option(
#ifdef __STDC__
		int, string*
#endif
);
static int	VALUE_option(
#ifdef __STDC__
		int, char**, int, int, string*, int*
#endif
);
static int	ENVIR_option(
#ifdef __STDC__
		int
#endif
);

#endif
