/*
 * @(#)pktutil.h	3.2 10/01/92 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __PKTUTIL_H__
#define __PKTUTIL_H__

#define HEADER_NETSIZE		LONGSIZE*3
#define MAXPKTALLOC		10240 
#define PKTUTILTRACE

/*
 *  ERRORS
 */
#define EPKTOK		1
#define EPKTFAIL	-1
#define EPKTZERO	-2
#define EPKTWAIT	-3
#define EPKTPIPE	-4
#define EPKTSIZE	-5
#define EPKTVERS	-6

/*
 *  TRACE
 */
#ifdef PKTUTILTRACE
extern boolean pktutiltrace;
extern boolean pktutildump;
#endif

/*
 *  Type definition
 */
typedef struct pkt_t {
    int version;
    int request;
    int length;
    char *ptr;
    char nethdr[HEADER_NETSIZE];
    char *netbody;
    int allocated;
} pkt_t ;

/*
 *  Function prototypes
 */
extern int sread(
#ifdef __STDC__
		 int,char*,int,int
#endif
		);
extern int swrite(
#ifdef __STDC__
		 int,char*,int,int
#endif
		);
extern void pktinit(
#ifdef __STDC__
		    pkt_t*
#endif
		   );
extern char *pktalloc(
#ifdef __STDC__
		      pkt_t*,int
#endif
		     );
extern void pktfree(
#ifdef __STDC__
		    pkt_t*
#endif
		   );
extern int read_pkthdr(
#ifdef __STDC__
		       int,pkt_t*,int
#endif
		      );
extern int read_pktbody(
#ifdef __STDC__
		        int,pkt_t*,int
#endif
			);
extern int read_packet(
#ifdef __STDC__
			int,pkt_t*
#endif
			);
extern int write_packet(
#ifdef __STDC__
			int,pkt_t*
#endif
			);

#endif
