/*
 * @(#)sfgc.h	3.2 06/23/92 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991,1992 by CERN/CN/SW/DC
 * All rights reserved 
 */

#ifndef __SFGC_H__
#define __SFGC_H__

#define NOSAMEDEV	48
#define CNTACCF		54
#define UNMOUNTF	55
#define UNKRPY		56

typedef struct fsys_list_t {
	host_t		hostname;
	path_t		prefix;
	path_t		fsysname;
} fsys_list_t ;

typedef struct gcp_t {
	char		*name;
	int		nodir;
	fsys_list_t	*dir;
        struct gcp_t 	*next;
	int		gcmin,gcmax;
	int		maxsize;
} gcp_t ;

typedef struct sfgcopt_t {
	pool_name_t	pool;			/*  pool name			*/
	group_t		group;			/*  group name			*/
	user_t		user;			/*  user name			*/
	byte		timetouse;		/*  access/modify time		*/
	time_t		timeold;		/*  time value			*/
	float   	space;			/*  space value			*/
	float		rate;			/*  rate value			*/
	boolean 	left;			/*  left option flag		*/
	boolean 	disk;			/*  device option flag		*/
	boolean 	local;			/*  local option flag		*/
	boolean 	inq;			/*  inquiry option flag		*/
	boolean 	test;			/*  test option flag		*/
	boolean		overperm;		/*  permanent option flag	*/
	boolean		statistics;		/*  statistics option flag	*/
	boolean		quiet;			/*  quiet option flag		*/
	boolean		check;			/*  check option flag		*/
	int		maxsize;		/*  file size limit		*/
	int		unmounted;		/*  unmounted option value	*/
	int		factor;			/*  factor number		*/
	int		nodir;			/*  number of directories	*/
	path_t		*dirpath;		/*  list of directories	path	*/

	boolean 	(*select)();		/*  scan selection function	*/
	int		nopools;		
	int		nofs;
	int		nomnt;
	path_t		*fspath,*mntpath;
	int		removedir;
	float		total;			/* not used */
        int		useruid;		/* uid of the user name		*/
	int		usergid;		/* gid of the user name		*/
} sfgcopt_t ;

#endif

