/*
 *  @(#)sfgc2.h	1.11 10/28/93  CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved 
 */

#ifndef __SFGC2_H__
#define __SFGC2_H__

#define ROOTUID		0

#define MTIME		0
#define ATIME		1

#define                  gc_newline              gc_printf("\n")

/*
 *  Garbage Collector structure 
 */
typedef struct sfgcopt_t {
    char     *pool;
    group_t  group;
    user_t   user;
    char     *directories;
    char     *spacestr;
    char     *ratestr;
    boolean  all;
    boolean  left;
    boolean  device;
    boolean  inquire;
    boolean  test;
    boolean  check;
    boolean  limit;
    boolean  collect;
    char     *link;
    boolean  linkscan;
    int      unmounted;
    int      factor;

    byte     timetouse;
    float    space;
    float    rate;
    char     strlim[12];
    int	     useruid,usergid;
    int	     clientuid,clientgid;
    user_t   client;
    char     *findargs;
    int	     nodir;
    char     **dir;
    int	     nofs;
    poolfs_t *poolfs;
    float    total;
    float    used;

} sfgcopt_t ;

/*
 *  Shift file list structure
 */
typedef struct list_t {
    char *path;			/* complete nfs-pathname     */
    long size;			/* total size in bytes       */
    time_t rtime;		/* reference time 	     */
    double key;			/* key used to sort the list */
    struct list_t *next;	/* pointer to the next file  */
} list_t ;

#define MAXFORK	  	10
#define PIPBUFSIZ	10240

typedef struct proc_t {
    pid_t pid;
    int fd[2];
    boolean closed;
    boolean terminated;
    char buf[PIPBUFSIZ];
    int offset;
#if defined( ultrix ) || (defined(sgi) && defined(__EXTENSIONS__) && !defined(IRIX5) )
  union wait status;
#else
  int status;
#endif
} proc_t ;

void 	usage(
#ifdef __STDC__
	      char**,boolean
#endif
	     );
int 	getsfgcoption(
#ifdef __STDC__
		      int,char**,sfgcopt_t*
#endif
		     );
int 	convertoptions(
#ifdef __STDC__
		       sfgcopt_t*
#endif
		      );
int 	getdirectories(
#ifdef __STDC__
		       sfgcopt_t*
#endif
		      );
int 	buildfindargs(
#ifdef __STDC__
		      int,char**,char**,boolean
#endif
		     );
int	sfgc_authorization(
#ifdef __STDC__
			   char*,index_t_s,boolean
#endif
			  );
int 	foreachpool(
#ifdef __STDC__
		    sfgcopt_t*
#endif
		   );
int 	getpoolspace(
#ifdef __STDC__
		     sfgcopt_t*,index_t_s,sfgcopt_t*,int
#endif
		    );
int 	getdirstat(
#ifdef __STDC__
		    sfgcopt_t*
#endif
		   );
int 	getpoolstat(
#ifdef __STDC__
		    sfgcopt_t*,int
#endif
		   );
int 	collect(
#ifdef __STDC__
		sfgcopt_t*,int,sfgcopt_t*
#endif
		);
int 	selectoutput(
#ifdef __STDC__
		     sfgcopt_t*
#endif
		    );
int 	readoutput(
#ifdef __STDC__
		   sfgcopt_t*,int
#endif
		  );
int 	storeoutput(
#ifdef __STDC__
		    sfgcopt_t*,int
#endif 
		   );
int 	readline(
#ifdef __STDC__
		    sfgcopt_t*,char*
#endif 
		   );
double weight2(
#ifdef __STDC__
	      time_t,long,int
#endif
	     );
int	list_insert(
#ifdef __STDC__
		    char*,long,time_t,int
#endif
		   );
void 	list_print();
int 	list_deallocate();
int 	removegarbage(
#ifdef __STDC__
		      sfgcopt_t*,int
#endif 
		     );

#endif
