/*
 * @(#)strutil.h	3.2 08/11/93 CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __STRING_UTIL_H__
#define __STRING_UTIL_H__

/*
**
**    S T R I N G _ U T I L . H
**
*/



#include <shift_types.h>



/*
**  Structure definitions
*/

typedef struct {
	char	*data;
	int	len;
} string ;

#define GET_string(str)		((str)->len>0 ? (str)->data : "(undef)")
#define LEN_string(str)		((str)->len-1)

#define INIT_LEN_STRING		-1



/*
**  Exported functions
*/

#define itoynl	itoyn

#if ( defined( sun ) && !defined(SOLARIS) )

extern int	strcasecmp(
#ifdef __STDC__
		char*, char*
#endif
);
extern int	strncasecmp(
#ifdef __STDC__
		char*, char*, int
#endif
);

#endif

extern boolean  compare_strings(
#ifdef __STDC__
		char*, char*, boolean, boolean
#endif
);

extern char	*remalloc(
#ifdef __STDC__
		char*, int
#endif
);

#if defined( sgi )

extern int	getmallocspace(
#ifdef __STDC__
#endif
);

#endif
 
extern char     *strmcat(
#ifdef __STDC__
		char**, int*, char*
#endif
);
extern char	*strmcpy(
#ifdef __STDC__
		char**, int*, char*
#endif
);

extern int	INIT_string(
#ifdef __STDC__
		string*, int
#endif
);
extern int	DUP_string(
#ifdef __STDC__
		string*, string*
#endif
);
extern void	FREE_string(
#ifdef __STDC__
		string*
#endif
);
extern void	PRINT_string(
#ifdef __STDC__
		string*
#endif
);
extern int	CPY_string(
#ifdef __STDC__
		string*, char*
#endif
);
extern int	CAT_string(
#ifdef __STDC__
		string*, char*
#endif
);

extern char	*mkfield(
#ifdef __STDC__
		char*, int
#endif
);
extern char	*itoyn(
#ifdef __STDC__
		boolean
#endif
);
extern char	*itoyns(
#ifdef __STDC__
		boolean
#endif
);

extern char	*ctimeln(
#ifdef __STDC__
		time_t*
#endif
);
extern char	*ctimeyear(
#ifdef __STDC__
		time_t*
#endif
);
extern char	*ctimeweek(
#ifdef __STDC__
		time_t*
#endif
);
extern char	*ctimeweeksec(
#ifdef __STDC__
		time_t*
#endif
);
extern char	*ctimeday(
#ifdef __STDC__
		time_t*
#endif
);

extern char	*itoa(
#ifdef __STDC__
		int
#endif
);
extern char	*itoanmu(
#ifdef __STDC__
		int
#endif
);
#if !defined( apollo ) || !defined( __STRING_UTIL_C__ )
extern float	anutof(
#ifdef __STDC__
		char*
#endif
);
#endif
extern char	*cfloat(
#ifdef __STDC__
		double, int, int
#endif
);
extern char	*ftoanu(
#ifdef __STDC__
		double
#endif
);



#endif





