/*
 *  @(#)table.h	3.5 05/07/93  CERN-SW/DC Fabrizio Cane
 */

/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef __TABLE_H__
#define __TABLE_H__

#define INIT_TABLESIZE	20
#define STEP_TABLESIZE	20

#if !defined( NCHKPHOST ) && !defined( CHKPHOST )
#define UNKPHOST	"__"
#endif

#if !defined( sgi )
typedef int index_t_s;
#else
#define index_t_s int
#endif

/*
 *  Disk Server table entry structure
 */
typedef struct {
    host_t  host;
    path_t  mount;
} disk_t ;

/*
 *  Pool table entry structure
 */
typedef struct {
    pool_name_t  name;
    boolean      permanent;
    boolean      private;
    int          min;
    int          max;
    long         size;
} pool_t ;

/*
 *  Super Pool table entry structure
 */
typedef struct {
    pool_name_t name;
    index_t_s     idx;
} supool_t ;

#define FSYSWLOCK	0x1

/*
 *  File system table entry structure 
 */
typedef struct {
    filesys_name_t  name;
    index_t_s         diskidx;
    index_t_s         poolidx;
    int             bits;
} fsys_t ;

/*
 *  Account table entry structure
 */
typedef struct {
    index_t_s  poolidx;
    int      uid;
    int      gid;
    boolean  garbage;
} accs_t ;

/*
 *  Pair table entry structure
 */
typedef struct {
    pair_name_t  name;
    int		 next;
    char	 *value;
} pair_t ;

/*
 *  Function prototypes
 */
int 	alloc_disk(
#ifdef __STDC__
		disk_t**,int
#endif
		   );
void 	free_disk();
int	alloc_pool(
#ifdef __STDC__
		pool_t**,int
#endif
		   );
void	free_pool();
int	alloc_fsys(
#ifdef __STDC__
		fsys_t**,int
#endif
		   );
void	free_fsys();
int	alloc_accs(
#ifdef __STDC__
		accs_t**,int
#endif
		   );
void	free_accs();
int	alloc_host(
#ifdef __STDC__
		host_t**,int
#endif
		   );
void	free_host();
int	alloc_pair_tbl(
#ifdef __STDC__
                pair_t**,int
#endif
                   );
void	free_pair_tbl();
int	alloc_pair(
#ifdef __STDC__
		pair_t**,int
#endif
		   );
void	free_pair();

#ifdef MKTBL_TRACE

void	print_disk_table();
void	print_fsys_table(
#ifdef __STDC__
			boolean
#endif
			);
void 	print_pool_table();
void	print_accs_table(
#ifdef __STDC__
			boolean
#endif
			);
void 	print_pair_table();

#endif

int 	add_server(
#ifdef __STDC__
		  char*,char*
#endif
		  );
index_t_s	look_disk(
#ifdef __STDC__
		 char*
#endif
		 );
int	add_filesystosrv(
#ifdef __STDC__
			char*,int
#endif
			);
index_t_s	look_fsys(
#if !defined( sgi )
#ifdef __STDC__
		 index_t_s,char*
#endif
#endif
		 );
int	add_pool(
#ifdef __STDC__
		char*
#endif
		);
int	add_filesystopool(
#ifdef __STDC__
			 char*,char*,int
#endif
			 );
index_t_s	look_pool(
#ifdef __STDC__
		 char*
#endif
		 );
int	add_permanent();
int	add_temporary();
int	add_private();
int	add_public();
int	add_collect(
#ifdef __STDC__
		    collect_t*
#endif
		    );
int	add_size(
#ifdef __STDC__
		char*
#endif
		);
int	add_poolaccount(
#ifdef __STDC__
			char*
#endif
			);
int	add_groupaccount(
#ifdef __STDC__
			char*,boolean
#endif
			);
int	add_useraccount(
#ifdef __STDC__
			char*,boolean
#endif
			);
index_t_s look_account(
#if !defined( sgi )
#ifdef __STDC__
		    index_t_s,int,int,boolean
#endif
#endif
		    );
int	add_category(
#ifdef __STDC__
		    char*
#endif
		    );
int	add_item(
#ifdef __STDC__
		char*,char*
#endif
		);
int	add_hostvalue(
#ifdef __STDC__
		     char*,char*
#endif
		     );
#if !defined( NCHKPHOST ) && !defined( CHKPHOST )
boolean is_unknown_host(
#ifdef __STDC__
			char**,boolean
#endif
		       );
#endif
index_t_s look_pair(
#ifdef __STDC__
		  char*,char*,char*
#endif
		  );
int	check_tables();
void	print_pool_attribute(
#ifdef __STDC__
			    FILE*,pool_t*
#endif
			    );
void	print_tables(
#ifdef __STDC__
		     FILE*,FILE*,FILE*,FILE*
#endif
		     );

#endif
