/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)client.c	3.4 04/11/94  CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <shift_types.h>
#include <strerror.h>
#include <osdep.h>
#include <marshall.h>
#include <sockutil.h>
#include <pktutil.h>
#include <mknet.h>
#include <config.h>
#include <client.h>

extern time_t config_version;
extern char *shifthosts;
remote_t *copy = NULL ;

#define CONNECTION_TIMEOUT	TIME,120,0

/*
 *  This function handles the state ST_ACKRECV
 *
 *  INPUT
 *	copy		the connection structure
 */
void recv_acknowledge(copy)
remote_t *copy;
{
  pkt_t pkt;
  int req[1];

    req[0] = PKT_ACKNOWLEDGE;
    pktinit(&pkt);
    if ( handle_read_packet(read_packet(copy->sock,&pkt),copy,&pkt,1,req) == EPKTOK )
	switch ( pkt.request ) {
	    case PKT_ACKNOWLEDGE:
		copy->status = ST_END;
		close(copy->sock);
		break;
	}
    pktfree(&pkt);
}

/*
 *  This function handles the states ST_EXPORT and ST_IMPORT
 *
 *  INPUT
 *	copy		the connection structure
 */
void recv_version(copy)
remote_t *copy;
{
  pkt_t pkt;
  time_t remote_version;
  int req[2];

    req[0] = PKT_SENDVERSION;
    req[1] = PKT_NOVERSION;
    pktinit(&pkt);
    if ( handle_read_packet(read_packet(copy->sock,&pkt),copy,&pkt,2,req) == EPKTOK ) {
	switch ( pkt.request ) {

	    case PKT_SENDVERSION :
	     /*
	      *  Get from the packet and store the remote version
	      */
		pkt.ptr = pkt.netbody;
		unmarshall_LONG(pkt.ptr,remote_version);
		copy->version = remote_version;
		if ( copy->status == ST_EXPORT )
		 /*
		  *  If the local version is more recent than the remote version
		  *  then export the local binary file otherwise close the connection
		  */
		    if ( config_version > remote_version )
			copy->status = ST_EXPBINARY;
		    else
			send_request(copy,PKT_ENDEXPORT,ST_END);		  
		else
		 /*
		  *  If the remote version is not more recent than the local version then
		  *  close the connection otherwise check if import the remote binary file
		  */
		    if ( remote_version > config_version )
			copy->status = ST_CHECKVERS;
		    else
			send_request(copy,PKT_ENDIMPORT,ST_END);
		break;

	    case PKT_NOVERSION :
	     /*
              *  If there is not the remote binary file then export it (ST_EXPORT)
	      *  or close the connection because it can't import (ST_IMPORT)
	      */
		copy->version = 0;
		if ( copy->status == ST_EXPORT )
		    copy->status = ST_EXPBINARY;
		else
		    send_request(copy,PKT_ENDIMPORT,ST_END);
		break;

	} /* switch - request */

	if ( copy->status == ST_END )
	    close(copy->sock);
    }
    pktfree(&pkt);
}

/*
 *  This function handles state ST_CHECKVERS in order to import the binary file 
 *  as soon as all connections are either waiting for it or closed
 *
 *  INPUT
 *	copy		connection list
 */
void check_version(copies,length)
remote_t *copies;
int length;
{
  int idx;
  int impidx;
  pkt_t pkt;

    impidx = -1;

 /*
  *  If there is still a connection that is neither failed nor terminated
  *  nor waiting for the import start then return in order to wait it move
  *  to one of the above listed status
  */
    for (idx=0;idx<length;idx++) {
	if ( !(copies[idx].status & ERRORMASK) && 
		copies[idx].status != ST_CHECKVERS && copies[idx].status != ST_END )
	    return;
	if ( copies[idx].status == ST_CHECKVERS && copies[idx].version > 0 && 
		(impidx < 0 || copies[idx].version > copies[impidx].version) )
	    impidx = idx;
    }

 /*
  *  Connections are either failed or terminated or in status CHECKVERS
  *  and impidx specifies either which remote host has the most recent
  *  version or that the local configuration is the most recent
  *
  *  Connections that are in status CHECK must be terminated except that
  *  connected to the host having the most recent configuration (unless
  *  the local host has the most recent configuration!)
  */
    pktinit(&pkt);
    for (idx=0;idx<length;idx++)

	if ( copies[idx].status == ST_CHECKVERS )

	 /*
	  *  If this is not the host specified by impidx
	  *  then close the connection and set state ST_END
	  */
	    if ( idx != impidx ) {
		send_request(&copies[idx],PKT_ENDIMPORT,ST_END);
		if ( copies[idx].status == ST_END )
		    close(copies[idx].sock);
	    }

	 /*
	  *  If this is the host specified by the impidx then
	  *  requests the remote binary file be send
	  */
	    else {
		send_request(&copies[idx],PKT_REQBINARY,ST_IMPBINARY);
		copies[idx].imported = 1;
	    }
}

/*
 *  This function handles the state ST_IMPBINARY
 *
 *  INPUT
 *	copy		the connection structure
 */
void receive_binary(copy)
remote_t *copy;
{
  int req[2];
  pkt_t pkt;
  host_t localhost;
  time_t impversion;

    pktinit(&pkt);
    req[0] = PKT_SENDBINARY;
    req[1] = PKT_ENDBINARY;
    if ( handle_read_packet(read_packet(copy->sock,&pkt),copy,&pkt,2,req) == EPKTOK ) {
	recv_binary(copy,&pkt);
	if ( copy->status == ST_END ) {
	    gethostname(localhost,sizeof(host_t));
	    switch ( merge_hosts(localhost) ) {
		case ERROR :
		    exception(e1);
		    break;
		case FALSE :
		    if ( write_binary_file() < 0 )
			exception(e1);
		    break;
		case TRUE :
		    impversion = config_version;
		    time(&config_version);
		    if ( write_binary_file() < 0 )
			exception(e1);
		    config_version = impversion;
		    copy->imported = 2;
		    break;
	    } /* switch */
	}
    }
    pktfree(&pkt);
    return;

handle_exception(e1) :  copy->status = ST_FAILURE;
			copy->strerr = strdup_vperror();
			close(copy->sock);
}

/*
 *
 */
int send_request_host(copy,request,status)
remote_t *copy;
int request;
int status;
{
  pkt_t pkt;
  host_t host;
  int len;

    len = sizeof(host_t);
    gethostname(host,len);
    pkt.netbody = host;
    pkt.length = strlen(pkt.netbody)+1;
    pkt.request = request;
    copy->status = status;
    return(handle_writepacket(write_packet(copy->sock,&pkt),copy));
}

/*
 *  Handles the select() read mask events
 */
void import_netread(copies,length,copy)
remote_t *copies;
int length;
remote_t *copy;
{
    switch ( copy->status ) {
	case ST_IMPORT :
		recv_version(copy);
		check_version(copies,length);
		break;
	case ST_IMPBINARY :
		receive_binary(copy);
		break;
     /*
      *  Error
      */
	case ST_CONNECTING :
		recv_error(copy);
		check_version(copies,length);
		break;
	default :
		vperror(0,"import_netread(): status (%d) not handled",copy->status);
		copy->status = ST_FAILURE;
		copy->strerr = strdup_vperror();
		close(copy->sock);
    } /* switch */
}

/*
 *  Handles the select() write mask events
 */
void import_netwrite(copies,length,copy)
remote_t *copies;
int length;
remote_t *copy;
{
    switch ( copy->status ) {
	case ST_CONNECTING :
		copy->oper = ST_IMPORT;
		send_request_host(copy,PKT_IMPORT,ST_IMPORT);
		break;
	default :
		vperror(0,"import_netwrite(): status (%d) not handled",copy->status);
		copy->status = ST_FAILURE;
		copy->strerr = strdup_vperror();
		close(copy->sock);
    } /* switch */
}

/*
 *  Handles the select() read mask events
 */
void export_netread(copies,length,copy)
remote_t *copies;
int length;
remote_t *copy;
{
    switch ( copy->status ) {
	case ST_EXPORT :
		recv_version(copy);
		break;
	case ST_ACKRECV :
		recv_acknowledge(copy);
		break;
     /*
      *  Error
      */
	case ST_CONNECTING :
	case ST_EXPBINARY :
		recv_error(copy);
		break;
	default :
		vperror(0,"export_netread(): status (%d) not handled",copy->status);
		copy->status = ST_FAILURE;
		copy->strerr = strdup_vperror();
		close(copy->sock);
    } /* switch */
}

/*
 *  Handles the select() write mask events
 */
void export_netwrite(copies,length,copy)
remote_t *copies;
int length;
remote_t *copy;
{
    switch ( copy->status ) {
	case ST_CONNECTING :
		copy->oper = ST_EXPORT;
		send_request_host(copy,PKT_EXPORT,ST_EXPORT);
		break;
	case ST_EXPBINARY :
		send_binary(copy);
		break;
	default :
		vperror(0,"export_netwrite(): status (%d) not handled",copy->status);
		copy->status = ST_FAILURE;
		copy->strerr = strdup_vperror();
		close(copy->sock);
    } /* switch */
}

/*
 *  Connect the remote hosts and import the most recent version
 *
 *  INPUT
 *	hostlist 	list of host to connect
 */
int import_binary_file(hostlist)
char *hostlist;
{
  int counter,idx,reply;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() < 0 )
	return(1);

 /*
  *  Disable the vperror() output
  */
    ctrl_vperror(VPDISABLE);

 /*
  *  Connect to the remote sfmake copies
  */
    copy = NULL ;
    if ( connect_copies(hostlist,&copy,&counter) < 0 )
	exception(evp);

    if ( !counter ) {
	ctrl_vperror(VPENABLE);
	vperror(0,"import host list is empty");
	return(1);
    }

 /*
  *  Set the timeout used by netdialog()
  */
    set_timeout(CONNECTION_TIMEOUT);

 /*
  *  Dialog with the remote copies
  */
    if ( netdialog(copy,counter,import_netread,import_netwrite,TRUE) < 0 )
	exception(evp);

 /*
  *  Enable the vperror() output
  */
    ctrl_vperror(VPENABLE);

 /*
  *  Print connection results
  */
    reply = print_connection_results(copy,counter);

 /*
  *  Remove the ascii files if the configuration was successfully imported
  *  Export the local configuration if the local host wasn't originally included
  */
    for (idx=0;idx<counter;idx++)
	if ( copy[idx].imported && copy[idx].status == ST_END ) {
	    remove_ascii_files();
	    if ( copy[idx].imported == 2 ) {
		printf("Added local host to the shift environment\n");
		open_binary(ACCESS_READ,LOCK_EXREAD);
		read_version();
		read_hosts();
		print_versions();
		print_environment();
		export_binary_file(shifthosts);
		close_binary(FALSE,UNLOCK);
	    }
	    else {
		print_versions();
		print_environment();
	    }
	    break;
	}

  /*
   *  Deallocate memory
   */
    if ( copy ) free(copy);

    return(reply);

handle_exception(evp) :	ctrl_vperror(VPENABLE);
			if ( copy ) free(copy);
			return(1);
}

/*
 *  Export the local configuration to the remote hosts having an older version
 *
 *  INPUT
 *	hostlist	list of host to connect
 */
int export_binary_file(hostlist)
char *hostlist;
{
  int counter,idx,reply;

/*
 *  Initialize pointer for further test
 */ 
    copy = NULL;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() < 0 )
	return(1);

 /*
  *  Produce the network binary file 
  */
    if ( marshall_binary_file() < 0 )
	return(1);

 /*
  *  Disable the vperror() output
  */
    ctrl_vperror(VPDISABLE);

 /*
  *  Connect to the remote sfmake copies
  */
   if ( connect_copies(hostlist,&copy,&counter) < 0 )
	exception(evp);

   if ( !counter )
	exception(evp);

 /*
  *  Set the timeout used by netdialog()
  */
    set_timeout(CONNECTION_TIMEOUT);

 /*
  *  Dialog with the remote copies
  */
   if ( netdialog(copy,counter,export_netread,export_netwrite,TRUE) < 0 )
	exception(evp);

 /*
  *  Enable the vperror() output
  */
    ctrl_vperror(VPENABLE);

 /*
  *  Remove the ascii files if the local configuration was
  *  successfully exported to at least one host
  */
    for (idx=0;idx<counter;idx++)
	if ( copy[idx].status == ST_END ) {
	    remove_ascii_files();
	    break;
	}

 /*
  *  Print connection results
  */
    reply = print_connection_results(copy,counter);

  /*
   *  Deallocate memory
   */
    if ( copy != NULL ) free(copy);

    return(reply);

handle_exception(evp) :	ctrl_vperror(VPENABLE);
			if ( copy != NULL ) free(copy);
			return(1);
}
