/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)data.c	3.7 05/28/93  CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#ifndef apollo
#include <malloc.h>
#endif
#if ( defined( _AIX ) && defined( _IBMESA ) ) || (defined(__osf__) && defined(__alpha) )
char *malloc();
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <shift_types.h>
#include <osdep.h>
#include <marshall.h>
#include <strerror.h>
#include <strutil.h>
#include <parser.h>
#include <table.h>
#include <config.h>
#include <data.h>

extern path_t shift_binary,shift_binary_net;
extern FILE *fd_binary,*fd_binary_net;

extern int code_version;
extern time_t config_version;

extern index_t_s diskidx,poolidx,supoolidx,fsysidx,accsidx,hostidx,pairidx;
extern disk_t *disk_table;
extern pool_t *pool_table;
extern supool_t *supool_table;
extern fsys_t *fsys_table;
extern accs_t *accs_table;
extern host_t *host_table;
extern pair_t *pair_table;

/*
 *  Load the code and configuration version from the binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int read_version()
{
 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the correct position
  */
    if ( fseek(fd_binary,0,0) fseek_ERROR ) {
	vperror(1,"fseek(%s[%d],0,0)",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }

 /*
  *  Read the code and configuration version
  */
    fread(&code_version,sizeof(int),1,fd_binary);
    fread(&config_version,sizeof(time_t),1,fd_binary);

    if ( ferror(fd_binary) ) {
	vperror(1,"fread(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }

    return(OK);
}

/*
 *  Write the code and configuration version to the binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int write_version()
{
 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the correct position
  */
    if ( fseek(fd_binary,0,0) fseek_ERROR ) {
	vperror(1,"fseek(%s[%d],0,0)",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }

 /*
  *  Write the code and configuration version
  */
    fwrite(&code_version,sizeof(int),1,fd_binary);
    fwrite(&config_version,sizeof(time_t),1,fd_binary);

    if ( ferror(fd_binary) ) {
	vperror(1,"fwrite(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }

    return(OK);
}

/*
 *  Load and unmarshall the code and configuration version from the network binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int unmarshall_version()
{
  LONG version;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Read and unmarshall the code and configuration version
  */
    if ( fread_LONG(&version) < 0 ) return(ERROR);
    code_version = version;
    if ( fread_LONG(&version) < 0 ) return(ERROR);
    config_version = version;

    return(OK);
}

/*
 *  Marshall and write the configuration and code version to the network binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int marshall_version()
{
 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Marshall and write the code and configuration version
  */
    if ( fwrite_LONG((LONG)code_version) < 0 ) return(ERROR);
    if ( fwrite_LONG((LONG)config_version) < 0 ) return(ERROR);

    return(OK);
}

/*
 *  Load the shift environment host table from the binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int read_hosts()
{
  index_t_s maxidx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the correct position
  */
    if ( fseek(fd_binary,HOSTS_OFFSET,0) fseek_ERROR ) {
	vperror(1,"fseek(%s[%d],%d,0)",shift_binary,fdtono(fd_binary),HOSTS_OFFSET);
	return(ERROR);
    }

 /*
  *  Read the Shift Environment host table
  */
    if ( fread(&maxidx,sizeof(index_t_s),1,fd_binary) fread_ERROR ) {
	vperror(1,"fread(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }
    if ( alloc_host(&host_table,maxidx) < 0 )
	return(ERROR);
    if ( fread(host_table,sizeof(host_t)*maxidx,1,fd_binary) fread_ERROR ) {
	vperror(1,"fread(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }
    hostidx = maxidx;

 /*
  *  Build the shift hosts list
  */
    if ( getshifthosts(FALSE) < 0 )
	return(ERROR);

    return(OK);
}

/*
 *  Write the shift environment host table to the binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int write_hosts()
{
 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the correct position
  */
    if ( fseek(fd_binary,HOSTS_OFFSET,0) fseek_ERROR ) {
	vperror(1,"fseek(%s[%d],%d,0)",shift_binary,fdtono(fd_binary),HOSTS_OFFSET);
	return(ERROR);
    }

 /*
  *  Write the Shift Environment host table
  */
    fwrite(&hostidx,sizeof(index_t_s),1,fd_binary);
    fwrite(host_table,sizeof(host_t)*hostidx,1,fd_binary);

    if ( ferror(fd_binary) ) {
	vperror(1,"fwrite(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }

    return(OK);
}

/*
 *  Load and unmarshall the shift environment host table from the network binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int unmarshall_hosts()
{
  LONG longval;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Read and unmarshall the Shift Environment host table
  */
    if ( fread_LONG(&longval) < 0 )
	return(ERROR);
    if ( alloc_host(&host_table,(int)longval) < 0 )
	return(ERROR);
    hostidx = (index_t_s)longval;
    if ( fread(host_table,sizeof(host_t)*hostidx,1,fd_binary_net) fread_ERROR ) {
	vperror(1,"fread(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
	return(ERROR);
    }

 /*
  *  Build the shift hosts list
  */
    if ( getshifthosts(FALSE) < 0 )
	return(ERROR);

    return(OK);
}

/*
 *  Marshall and write the shift environment host table to the network binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int marshall_hosts()
{
 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Marshall and write the Shift Environment host table
  */
    if ( fwrite_LONG((LONG)hostidx) < 0 )
	return(ERROR);
    if ( fwrite(host_table,sizeof(host_t)*hostidx,1,fd_binary_net) fwrite_ERROR ) {
	vperror(1,"fwrite(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
	return(ERROR);
    }

    return(OK);
}

/*
 *  Seek to the beginning of the Disk Pool Manager (DPM) tables in the binary file
 */
int seek_tables()
{
  index_t_s hostlength;

    if ( fseek(fd_binary,HOSTS_OFFSET,0) fseek_ERROR ) {
	vperror(1,"fseek(%s[%d],%d,0)",shift_binary,fdtono(fd_binary),HOSTS_OFFSET);
	return(ERROR);
    }

    if ( fread(&hostlength,sizeof(index_t_s),1,fd_binary) fread_ERROR ) {
	vperror(1,"fread(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
    }

    if ( fseek(fd_binary,sizeof(host_t)*hostlength,1) fseek_ERROR ) {
	vperror(1,"fseek(%s[%d],%d*sizeof(host_t),1)",
		shift_binary,fdtono(fd_binary),hostlength);
	return(ERROR);
    }

    return(OK);
}

/*
 *  Load the Disk Pool Manager (DPM) tables from the binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int read_tables()
{
  index_t_s maxidx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the beginning of the Disk Pool Manager tables
  */
    if ( seek_tables() < 0 )
	return(ERROR);

 /*
  *  Load the Disk Server Table
  */
    if ( fread(&maxidx,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( alloc_disk(&disk_table,maxidx) < 0 )
	return(ERROR);
    if ( fread(disk_table,sizeof(disk_t),maxidx,fd_binary) fread_ERROR )
	exception(eread);
    diskidx = maxidx;

 /*
  *  Load the Shift Pool Table
  */
    if ( fread(&maxidx,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( alloc_pool(&pool_table,maxidx) < 0 )
	return(ERROR);
    if ( fread(pool_table,sizeof(pool_t),maxidx,fd_binary) fread_ERROR )
	exception(eread);
    poolidx = maxidx;

 /*
  *  Load the Shift Super Pool table
  */
    if ( fread(&maxidx,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( maxidx > 0 ) {
	if ( alloc_supool(&supool_table,maxidx) < 0 )
	    return(ERROR);
	if ( fread(supool_table,sizeof(supool_t),maxidx,fd_binary) fread_ERROR )
	    exception(eread);
    }
    supoolidx = maxidx;

 /*
  *  Load the File System Table
  */
    if ( fread(&maxidx,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( alloc_fsys(&fsys_table,maxidx) < 0 )
	return(ERROR);
    if ( fread(fsys_table,sizeof(fsys_t),maxidx,fd_binary) fread_ERROR )
	exception(eread);
    fsysidx = maxidx;

 /*
  *  Load the Shift Pool Account Table
  */
    if ( fread(&maxidx,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( alloc_accs(&accs_table,maxidx) < 0 )
	return(ERROR);
    if ( fread(accs_table,sizeof(accs_t),maxidx,fd_binary) fread_ERROR )
	exception(eread);
    accsidx = maxidx;

    return(OK);

handle_exception(eread):
	vperror(1,"fread(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
}

/*
 *  Write the Disk Pool Manager (DPM) tables to the binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int write_tables()
{
  int hostlen;
  index_t_s maxidx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the beginning of the Disk Pool Manager configuration
  */
    if ( seek_tables() < 0 )
	return(ERROR);

 /*
  *  Write the Disk Server table
  */
    if ( fwrite(&diskidx,sizeof(index_t_s),1,fd_binary) fwrite_ERROR )
	exception(ewrite);
    if ( fwrite(disk_table,sizeof(disk_t)*diskidx,1,fd_binary) fwrite_ERROR )
	exception(ewrite);

 /*
  *  Write the Shift Pool table
  */
    if ( fwrite(&poolidx,sizeof(index_t_s),1,fd_binary) fwrite_ERROR )
	exception(ewrite);
    if ( fwrite(pool_table,sizeof(pool_t)*poolidx,1,fd_binary) fwrite_ERROR )
	exception(ewrite);

 /*
  *  Write the Shift Super Pool table
  */
    if ( fwrite(&supoolidx,sizeof(index_t_s),1,fd_binary) fwrite_ERROR )
	exception(ewrite);
    if ( supoolidx > 0 && 
	      fwrite(supool_table,sizeof(supool_t)*supoolidx,1,fd_binary) fwrite_ERROR )
	exception(ewrite);

 /*
  *  Write the File System table
  */
    if ( fwrite(&fsysidx,sizeof(index_t_s),1,fd_binary) fwrite_ERROR )
	exception(ewrite);
    if ( fwrite(fsys_table,sizeof(fsys_t)*fsysidx,1,fd_binary) fwrite_ERROR )
	exception(ewrite);

 /*
  *  Write the Shift Pool Account table
  */
    if ( fwrite(&accsidx,sizeof(index_t_s),1,fd_binary) fwrite_ERROR )
	exception(ewrite);
    if ( fwrite(accs_table,sizeof(accs_t)*accsidx,1,fd_binary) fwrite_ERROR )
	exception(ewrite);

    return(OK);

handle_exception(ewrite):
	vperror(1,"fwrite(,,,%s[%d])",shift_binary,fdtono(fd_binary));
	return(ERROR);
}

/*
 *  Load and unmarshall a LONG integer from the network binary file
 */
int fread_LONG(val)
LONG *val;
{
  char *ptr = (char*)val;

    if ( fread(ptr,LONGSIZE,1,fd_binary_net) fread_ERROR ) {
	vperror(1,"fread(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
	return(ERROR);
    }
    unmarshall_LONG(ptr,*val);
    return(OK);
}

/*
 *  Load and unmarshall the Disk Pool Manager (DPM) tables from the network binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 *
 *  BUG
 *	the shift environment host list stored in the binary file must be correct
 */
int unmarshall_tables()
{
  LONG longval;
  int idx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Unmarshall the Disk Server table
  */
    if ( fread_LONG(&longval) < 0 ) return(ERROR);
    if ( alloc_disk(&disk_table,(int)longval) < 0 )
	return(ERROR);
    diskidx = (index_t_s)longval;
    for (idx=0; idx<diskidx; idx++) {
	if ( fread(disk_table[idx].host,sizeof(host_t),
					1,fd_binary_net) fread_ERROR )
	    exception(eread);
	if ( fread(disk_table[idx].mount,sizeof(path_t),
					1,fd_binary_net) fread_ERROR )
	    exception(eread);
    }

 /*
  *  Unmarshall the Shift Pool table
  */
    if ( fread_LONG(&longval) < 0 ) return(ERROR);
    if ( alloc_pool(&pool_table,(int)longval) < 0 )
	return(ERROR);
    poolidx = (index_t_s)longval;
    for (idx=0; idx<poolidx; idx++) {
	if ( fread(pool_table[idx].name,sizeof(pool_name_t),
					1,fd_binary_net) fread_ERROR )
	    exception(eread);
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	pool_table[idx].permanent = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	pool_table[idx].private = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	pool_table[idx].min = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	pool_table[idx].max = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	pool_table[idx].size = longval;
    }

 /*
  *  Unmarshall the Shift Super Pool table
  */
    if ( fread_LONG(&longval) < 0 ) return(ERROR);
    if ( longval > 0 && alloc_supool(&supool_table,(int)longval) < 0 )
	return(ERROR);
    supoolidx = (index_t_s)longval;
    for (idx=0; idx<supoolidx; idx++) {
	if ( fread(supool_table[idx].name,sizeof(pool_name_t),
					1,fd_binary_net) fread_ERROR )
	    exception(eread);
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	supool_table[idx].idx = (index_t_s)longval;
    }

 /*
  *  Unmarshall the File System table
  */
    if ( fread_LONG(&longval) < 0 ) return(ERROR);
    if ( alloc_fsys(&fsys_table,(int)longval) < 0 )
	return(ERROR);
    fsysidx = (index_t_s)longval;
    for (idx=0; idx<fsysidx; idx++) {
	if ( fread(fsys_table[idx].name,sizeof(filesys_name_t),
					1,fd_binary_net) fread_ERROR )
	    exception(eread);
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	fsys_table[idx].diskidx = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	fsys_table[idx].poolidx = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	fsys_table[idx].bits = longval;
    }

 /*
  *  Unmarshall the Shift Pool Account table
  */
    if ( fread_LONG(&longval) < 0 ) return(ERROR);
    if ( alloc_accs(&accs_table,(int)longval) < 0 )
	return(ERROR);
    accsidx = (index_t_s)longval;
    for (idx=0; idx<accsidx; idx++) {
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	accs_table[idx].poolidx = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	accs_table[idx].uid = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	accs_table[idx].gid = longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	accs_table[idx].garbage = longval;
    }

    return(OK);

handle_exception(eread):
	vperror(1,"fread(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
	return(ERROR);
}

/*
 *  Marshall and write a LONG integer to the network binary file
 */
int fwrite_LONG(val)
LONG val;
{
  char *ptr = (char*)&val;

    marshall_LONG(ptr,val);
    if ( fwrite((char*)&val,LONGSIZE,1,fd_binary_net) fwrite_ERROR ) {
	vperror(1,"fwrite(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
	return(ERROR);
    }
    return(OK);
}

/*
 *  Marshall and write the Disk Pool Manager (DPM) tables to the network binary file
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 *
 *  BUG
 *	the shift environment host list stored in the binary file must be correct
 */
int marshall_tables()
{
  int idx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Marshall the Disk Server table
  */
    if ( fwrite_LONG((LONG)diskidx) < 0 ) return(ERROR);
    for (idx=0; idx<diskidx; idx++) {
	if ( fwrite(disk_table[idx].host,sizeof(host_t),
					1,fd_binary_net) fwrite_ERROR )
	    exception(ewrite);
	if ( fwrite(disk_table[idx].mount,sizeof(path_t),
					1,fd_binary_net) fwrite_ERROR )
	    exception(ewrite);
    }

 /*
  *  Marshall the Shift Pool table
  */
    if ( fwrite_LONG((LONG)poolidx) < 0 ) return(ERROR);
    for (idx=0; idx<poolidx; idx++) {
	if ( fwrite(pool_table[idx].name,sizeof(pool_name_t),
					1,fd_binary_net) fwrite_ERROR )
	    exception(ewrite);
	if ( fwrite_LONG((LONG)pool_table[idx].permanent) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)pool_table[idx].private) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)pool_table[idx].min) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)pool_table[idx].max) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)pool_table[idx].size) < 0 ) return(ERROR);
    }

 /*
  *  Marshall the Shift Super Pool table
  */
    if ( fwrite_LONG((LONG)supoolidx) < 0 ) return(ERROR);
    for (idx=0; idx<supoolidx; idx++) {
	if ( fwrite(supool_table[idx].name,sizeof(pool_name_t),
					1,fd_binary_net) fwrite_ERROR )
	    exception(ewrite);
	if ( fwrite_LONG((LONG)supool_table[idx].idx) < 0 ) return(ERROR);
    }

 /*
  *  Marshall the File System table
  */
    if ( fwrite_LONG((LONG)fsysidx) < 0 ) return(ERROR);
    for (idx=0; idx<fsysidx; idx++) {
	if ( fwrite(fsys_table[idx].name,sizeof(filesys_name_t),
					1,fd_binary_net) fwrite_ERROR )
	    exception(ewrite);
	if ( fwrite_LONG((LONG)fsys_table[idx].diskidx) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)fsys_table[idx].poolidx) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)fsys_table[idx].bits) < 0 ) return(ERROR);
    }

 /*
  *  Marshall the Shift Pool Account table
  */
    if ( fwrite_LONG((LONG)accsidx) < 0 ) return(ERROR);
    for (idx=0; idx<accsidx ;idx++) {
	if ( fwrite_LONG((LONG)accs_table[idx].poolidx) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)accs_table[idx].uid) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)accs_table[idx].gid) < 0 ) return(ERROR);
	if ( fwrite_LONG((LONG)accs_table[idx].garbage) < 0 ) return(ERROR);
    }

    return(OK);

handle_exception(ewrite):
	vperror(1,"fwrite(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
	return(ERROR);
}

/*
 *  Seek to the beginning of the pair table 
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int seek_pairs()
{
  index_t_s length;

    if ( seek_tables() < 0 )
	return(ERROR);

    if ( fread(&length,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( fseek(fd_binary,length*sizeof(disk_t),1) fseek_ERROR )
	exception(eseek);

    if ( fread(&length,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( fseek(fd_binary,length*sizeof(pool_t),1) fseek_ERROR )
	exception(eseek);

    if ( fread(&length,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( fseek(fd_binary,length*sizeof(supool_t),1) fseek_ERROR )
	exception(eseek);

    if ( fread(&length,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( fseek(fd_binary,length*sizeof(fsys_t),1) fseek_ERROR )
	exception(eseek);

    if ( fread(&length,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( fseek(fd_binary,length*sizeof(accs_t),1) fseek_ERROR )
	exception(eseek);

    return(1);

handle_exception(eread) : vperror(1,"fread(,,,%s[%d])",shift_binary,fdtono(fd_binary));
			  return(ERROR);
handle_exception(eseek) : vperror(1,"fseek(%s[%d],,1)",shift_binary,fdtono(fd_binary));
			  return(ERROR);
}

/*
 *  Load the pair table
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int read_pairs()
{
  int length;
  int totlength;
  index_t_s maxidx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the beginning of the pair table
  */
    if ( seek_pairs() < 0 )
	return(ERROR);

 /*
  *  Load the pair table
  */
    if ( fread(&totlength,sizeof(int),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( fread(&maxidx,sizeof(index_t_s),1,fd_binary) fread_ERROR )
	exception(eread);
    if ( alloc_pair(&pair_table,maxidx) < 0 )
	return(ERROR);
    for (pairidx=0; pairidx<maxidx && !ferror(fd_binary); pairidx++) {
	fread(pair_table[pairidx].name,sizeof(pair_name_t),1,fd_binary);
	fread(&pair_table[pairidx].next,sizeof(int),1,fd_binary);
	fread(&length,sizeof(int),1,fd_binary);
	if ( ferror(fd_binary) )
	    break;
	if ( !length )
	    pair_table[pairidx].value = NULL;
	else {
	    if ( (pair_table[pairidx].value = malloc(length+1)) == NULL ) {
		vperror(1,"malloc(%d)",length);
		return(ERROR);
	    }
	    fread(pair_table[pairidx].value,length,1,fd_binary);
	    pair_table[pairidx].value[length] = EOS;
	}
    }

 /*
  *  Check if an error occured
  */
    if ( ferror(fd_binary) ) exception(eread);

    return(1);

handle_exception(eread) : vperror(1,"fread(,,,%s[%d])",shift_binary,fdtono(fd_binary));
			  return(ERROR);
}

/*
 *  Write the pair table
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int write_pairs()
{
  int length;
  int offset;
  int totlength;
  index_t_s idx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Seek to the beginning of the pair table
  */
    if ( seek_pairs() < 0 )
	return(ERROR);

 /*
  *  Get the length of the pair table
  */
    totlength = sizeof(int)+sizeof(index_t_s);
    for (idx=0; idx<pairidx; idx++) {
	length = pair_table[idx].value == NULL ? 0 : strlen(pair_table[idx].value) ;
	totlength += sizeof(pair_name_t)+2*sizeof(int)+length;
    }

 /*
  *  Write the pair table
  */
    fwrite(&totlength,sizeof(int),1,fd_binary);
    fwrite(&pairidx,sizeof(index_t_s),1,fd_binary);

    for (idx=0; idx<pairidx && !ferror(fd_binary); idx++) {
	fwrite(pair_table[idx].name,sizeof(pair_name_t),1,fd_binary);
	fwrite(&pair_table[idx].next,sizeof(int),1,fd_binary);
	length = pair_table[idx].value == NULL ? 0 : strlen(pair_table[idx].value) ;
	fwrite(&length,sizeof(int),1,fd_binary);
	if ( length ) fwrite(pair_table[idx].value,length,1,fd_binary);
    }

 /*
  *  Check if an error occured
  */
    if ( ferror(fd_binary) ) exception(ewrite);

    return(1);

handle_exception(ewrite): vperror(1,"fwrite(,,,%s[%d])",shift_binary,fdtono(fd_binary));
			  return(ERROR);
}

/*
 *  Load and unmarshall the pair table
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int unmarshall_pairs()
{
  LONG longval;
  int length;
  int totlength;
  index_t_s maxidx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Load the table
  */
    if ( fread_LONG(&longval) < 0 ) return(ERROR);
    totlength = longval;
    if ( fread_LONG(&longval) < 0 ) return(ERROR);
    maxidx = longval;
    if ( alloc_pair(&pair_table,(int)maxidx) < 0 )
	return(ERROR);
    for (pairidx=0; pairidx<maxidx && !ferror(fd_binary_net); pairidx++) {
	fread(pair_table[pairidx].name,sizeof(pair_name_t),1,fd_binary_net);
	if ( ferror(fd_binary_net) )
	    break;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	pair_table[pairidx].next = (int)longval;
	if ( fread_LONG(&longval) < 0 ) return(ERROR);
	length = (int)longval;
	if ( !length )
	    pair_table[pairidx].value = NULL;
	else {
	    if ( (pair_table[pairidx].value = malloc(length+1)) == NULL ) {
		vperror(1,"malloc(%d)",length);
		return(ERROR);
	    }
	    fread(pair_table[pairidx].value,length,1,fd_binary_net);
	    pair_table[pairidx].value[length] = EOS;
	}
    }

 /*
  *  Check if an error occured
  */
    if ( ferror(fd_binary_net) ) exception(eread);

    return(1);

handle_exception(eread) : vperror(1,"fread(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
			  return(ERROR);
}

/*
 *  Marshall and write the pair table
 *
 *  RETURN
 *	OK		successful completion
 *	ERROR		error
 */
int marshall_pairs()
{
  int offset;
  int length;
  int totlength;
  index_t_s idx;

 /*
  *  Return if an error occured
  */
    if ( get_vperror() == ERROR )
	return(ERROR);

 /*
  *  Get the length of the pair table
  */
    totlength = 2*LONGSIZE;
    for (idx=0; idx<pairidx; idx++) {
	length = pair_table[idx].value == NULL ? 0 : strlen(pair_table[idx].value) ;
	totlength += sizeof(pair_name_t)+2*LONGSIZE+length;
    }

 /*
  *  Marshall and write the pair table
  */
    if ( fwrite_LONG((LONG)totlength) < 0 ) return(ERROR);
    if ( fwrite_LONG((LONG)pairidx) < 0 ) return(ERROR);

    for (idx=0; idx<pairidx && !ferror(fd_binary_net); idx++) {
	fwrite(pair_table[idx].name,sizeof(pair_name_t),1,fd_binary_net);
	if ( fwrite_LONG((LONG)pair_table[idx].next) < 0 ) return(ERROR);
	length = pair_table[idx].value == NULL ? 0 : strlen(pair_table[idx].value) ;
	if ( fwrite_LONG((LONG)length) < 0 ) return(ERROR);
	if ( length ) fwrite(pair_table[idx].value,length,1,fd_binary_net);
    }

 /*
  *  Check if an error occured
  */
    if ( ferror(fd_binary_net) ) exception(ewrite);

    return(1);

handle_exception(ewrite):
	vperror(1,"fwrite(,,,%s[%d])",shift_binary_net,fdtono(fd_binary_net));
	return(ERROR);
}
