# @(#)dpm.lex	3.5 05/07/93 CERN-SW/DC Fabrizio Cane
#
# Copyright (C) 1991,1992 by CERN/CN/SW/DC
# All rights reserved
#

%{

int lexline = 1;

%}

delim		[ \t]
letter		[A-Za-z]
digit		[0-9]
number		[+-]?{digit}+
id		({digit}|[-])*({letter}|[_])+({letter}|{digit}|[_-])*
other		("#"|"*"|","|"+"|":"|"("|")"|"/")

%%

{delim}		{ }
\n		{ lexline++; return NEWLINE ; }

"SERVER"	{ return SERVER ;	}
"POOL"		{ return POOL ;		}
"PRIVATE"	{ return PRIVATE ;	}
"PUBLIC"	{ return PUBLIC ;	}
"TEMPORARY"	{ return TEMPORARY ;	}
"PERMANENT"	{ return PERMANENT ;	}
"COLLECT"	{ return COLLECT ;	}
"SIZE"		{ return SIZE ;		}
"CATEGORY"	|
"category"	{ return CATEGORY ;	}
"END"		{ return END ;		}
"WLOCK"		{ return WLOCK ;	}
"READ"		{ return READ ;		}
"WRITE"		{ return WRITE ;	}
"SUPERPOOL"	{ return SUPERPOOL ;	}

{id}		{ strncpy(yylval.yyid,yytext,sizeof(id_t_s)); return ID ;	} 
{number}	{ sscanf(yytext,"%d",&yylval.yynum); return NUMBER ; }
{other}		{ return yytext[0] ;	}

.		{ return EOF ;		}

%%
