/*
 * Copyright (C) 1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

%{

#ifndef lint
static char sccsid[] = " @(#)dpm.yacc	3.8 05/07/93  CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <shift_types.h>
#include <parser.h>
#include <table.h>

/*
 *  yyparse()
 *
 *  RETURN
 *	0	successful completion
 *	1	error
 *
 *  OUTPUT TRACE
 *	the input stream can be copied in output through yyprintf()
 */

%}

%union
{
    id_t_s     yyid;
    long       yynum;
    collect_t  yycollect;
    struct yyname {
	id_t_s yyid;
	char   *yylp;
    } yyname;
}

%token SERVER
%token POOL
%token PRIVATE
%token PUBLIC
%token TEMPORARY
%token PERMANENT
%token COLLECT
%token SIZE
%token CATEGORY
%token END
%token WLOCK
%token READ
%token WRITE
%token SUPERPOOL
%token ID
%token NUMBER
%token NEWLINE

%type <yyid> ID servername poolname username groupname mountpath filesystempath path superpoolname attrsize
%type <yynum> NUMBER filesysattrlist filesysattr superpoolaccess superpoolprty
%type <yycollect> attrcollect
%type <yyname> itemname hostname

%%

dpmconfig	:		{ if ( set_shift_defaults() < 0 ) return( 1 ); }
			shiftdefaults
				{ if ( set_shift_pools() < 0 ) return( 1 ); }
			shiftpools
				{ if ( set_shift_users() < 0 ) return( 1 );
				  if ( init_poolaccount() < 0 ) return( 1 ); }
			shiftusers
				{ if ( set_shift_conf() < 0 ) return( 1 ); }
			shiftconf
				{ return(0); }
		;

shiftpools	: 	newlinestar
			serverconfig
			poolconfig
			superpoolconfig
			END
				{ yyprintf("END\n"); }
		;

serverconfig 	: 	serverdcl
		| 	serverconfig serverdcl
		| 	error
				{ yyerror("server configuration required");
				  return(1); }
		;

poolconfig	: 	pooldcl
		| 	poolconfig pooldcl
		|	END
				{ yyerror("syntax error");
				  yyerror("pool configuration required");
				  return(1); }
		;

serverdcl 	: 	serverhdr
			newline
			serverbody
				{ yyprintf("\n"); }
		|	serverhdr
				{ yyprintf("\n"); }
			error
				{ yyerror("new line expected");
				  return(1); }
		;

serverhdr	:	SERVER
				{ yyprintf("SERVER  "); }
			servername
			mountpath
				{ if ( add_server($3,$4) < 0 ) return(1); }
		;

pooldcl		: 	POOL
				{ yyprintf("POOL  "); }
			poolname
				{ if ( add_pool($3) < 0 ) return(1); }
			poolattribute
			poolbody
				{ yyprintf("\n"); }
		;

serverbody 	: 		{ yyprintf("  "); }
			filesystempath
			filesysattrlist
				{ if ( add_filesystosrv($2,(int)$3) < 0 ) return(1); }
		| 	serverbody
				{ yyprintf("  "); }
			filesystempath
			filesysattrlist
				{ if ( add_filesystosrv($3,(int)$4) < 0 ) return(1); }
		| 	SERVER
				{ yyerror("syntax error");
				  yyerror("empty file system list");
				  return(1); }
		| 	POOL
				{ yyerror("syntax error");
				  yyerror("empty file system list");
				  return(1); }
		| 	END
				{ yyerror("syntax error");
				  yyerror("empty file system list");
				  return(1); }
		;

poolbody 	: 		{ yyprintf("  "); }
			servername
			filesystempath
			filesysattrlist
				{ if ( add_filesystopool($2,$3,$4) < 0 ) return(1); }
		| 	poolbody
				{ yyprintf("  "); }
			servername
			filesystempath
			filesysattrlist
				{ if ( add_filesystopool($3,$4,$5) < 0 ) return(1); }
		| 	POOL
				{ yyerror("syntax error");
				  yyerror("empty file system list");
				  return(1); }
		| 	END
				{ yyerror("syntax error");
				  yyerror("empty file system list");
				  return(1); }
		;

filesysattrlist	: 	newline
				{ $$ = 0; }
		| 	filesysattr
			filesysattrlist
				{ $$ = $1 | $2; }
		;

filesysattr 	: 	WLOCK
				{ $$ = FSYSWLOCK; }
		;

poolattribute	: 	newline
		| 	attributelist newline
		|	attributelist
		 		{ yyprintf("\n"); }
			error
				{ yyerror("pool attribute or new line expected");
				  return(1); }
		| 		{ yyprintf("\n"); }
			error
				{ yyerror("pool attribute or new line expected");
				  return(1); }
		;

attributelist 	: 	attributes
		| 	attributelist attributes
		;

attributes 	: 	PERMANENT
				{ yyprintf("%-12s","PERMANENT");
				  if ( add_permanent() < 0 ) return(1); }
		| 	TEMPORARY
				{ yyprintf("%-12s","TEMPORARY");
				  if ( add_temporary() < 0 ) return(1); }
		| 	PUBLIC
				{ yyprintf("%-10s","PUBLIC");
				  if ( add_public() < 0 ) return(1); }
		| 	PRIVATE
				{ yyprintf("%-10s","PRIVATE");
				  if ( add_private() < 0 ) return(1); }
		| 	attrcollect
				{ if ( add_collect(&$1) < 0 ) return(1); }
		| 	attrsize
				{ if ( add_size($1) < 0 ) return(1); }
		| 	ID
				{ yyprintf("%s\n",$1);
				  yyerror("unknown pool attribute <%s>",$1);
				  return(1); }
		;

attrcollect 	: 	COLLECT
			'('
			NUMBER
			':'
			NUMBER
			')'
				{ $$.min = $3; $$.max = $5;
				  yyprintf("COLLECT(%d:%d)  ",$3,$5); }
		| 	COLLECT
			'('
			NUMBER
			':'
			NUMBER
				{ yyprintf("COLLECT(%d:%d\n",$3,$5); }
			error
				{ yyerror("close round bracket expected");
				  return(1); }
		| 	COLLECT
			'('
			NUMBER
			':'
				{ yyprintf("COLLECT(%d:\n",$3); }
			error
				{ yyerror("second threshold expected");
				  return(1); }
		| 	COLLECT
			'('
			NUMBER
				{ yyprintf("COLLECT(%d\n",$3); }
			error
				{ yyerror("colon expected");
				  return(1); }
		| 	COLLECT
			'('
				{ yyprintf("COLLECT(\n"); }
			error
				{ yyerror("first threshold expected");
				  return(1); }
		| 	COLLECT
				{ yyprintf("COLLECT\n"); }
			error
				{ yyerror("open round bracket expected");
				  return(1); }
		;

attrsize 	: 	SIZE
			'('
			NUMBER
			ID
			')'
				{ sprintf($$,"%d",$3); strcat($$,$4);
				  yyprintf("SIZE(%s)   ",$$); }
		| 	SIZE
			'('
			NUMBER
			')'
				{ sprintf($$,"%d",$3);
				  yyprintf("SIZE(%s)   ",$$); }
		| 	SIZE
			'('
			ID
			')'
				{ strcpy($$,$3);
				  yyprintf("SIZE(%s)   ",$$); }
		| 	SIZE
			'('
			NUMBER
			ID
				{ yyprintf("SIZE(%d%s\n",$3,$4); }
			error
				{ yyerror("close round bracket expected");
				  return(1); }
		| 	SIZE
			'('
			NUMBER
				{ yyprintf("SIZE(%d\n",$3); }
			error
				{ yyerror("close round bracket expected");
				  return(1); }
		| 	SIZE
			'('
			ID
				{ yyprintf("SIZE(%s\n",$3); }
			error
				{ yyerror("close round bracket expected");
				  return(1); }
		| 	SIZE
			'('
				{ yyprintf("SIZE(\n"); }
			error
				{ yyerror("number expected"); return(1); }
		| 	SIZE
				{ yyprintf("SIZE\n");  }
			error
				{ yyerror("open round bracket expected");
				  return(1); }
		;

servername 	: 	ID
				{ strcpy($$,$1); yyprintf("%-12s ",$$); }
		|		{ yyprintf("\n"); }
			error
				{ yyerror("server name expected");
				  return(1); }
		;

poolname 	: 	ID
				{ strcpy($$,$1); yyprintf("%-15s ",$$); }
		|		{ yyprintf("\n"); }
			error
				{ yyerror("pool name expected");
				  return(1); }
		;

mountpath 	: 	path
				{ strcpy($$,$1); yyprintf("%s",$$); }
		| 		{ yyprintf("\n"); }
			error
				{ yyerror("mount path expected");
				  return(1); }
		;

filesystempath	: 	path
				{ strcpy($$,$1); yyprintf("%s",$$); }
		| 		{ yyprintf("\n"); }
			error
				{ yyerror("file system path expected");
				  return(1); }
		;

/*
 *  Super Pool declaration rules
 */

superpoolconfig : 		/* empty */
		|	superpoollist
		;

superpoollist	:	superpooldcl
		| 	superpoollist superpooldcl
		;

superpooldcl	:	SUPERPOOL
				{ yyprintf("SUPERPOOL  "); }
			superpoolname
				{ yyprintf("%-12s ",$3); }
			superpoolaccess
				{ if ( add_superpool($3,$5) < 0 ) return(1); }
			superpooldef
			newline
				{ yyprintf("\n"); }
		;

superpoolname	:	ID
				{ strcpy($$,$1); }
		|		{ yyprintf("\n"); }
			error
				{ yyerror("super pool name expected");
				  return(1); }
		;

superpoolaccess	:		{ $$ = 2; }
		|	READ
				{ yyprintf("READ   "); $$ = 0; }
		|	WRITE
				{ yyprintf("WRITE  "); $$ = 1; }
/*
		|		{ yyprintf("\n"); }
			error
				{ yyerror("access mode READ or WRITE expected");
				  return(1); }
*/
		;

superpooldef	:	ID
				{ yyprintf("%s",$1);
				  if ( add_superpoolelement($1,-1) < 0 ) return(1); }
		|	ID
				{ yyprintf("%s",$1); }
			superpoolprty
				{ if ( add_superpoolelement($1,$3) < 0 ) return(1); }
			superpooldef
		|		{ yyprintf("\n"); }
			error
				{ yyerror("pool or super pool name expected");
				  return(1); }
		;

superpoolprty	:	'+'
				{ yyprintf("+"); $$ = 0; }
		|	':'
				{ yyprintf(":"); $$ = 1; }
		|		{ yyprintf("\n"); }
			error
				{ yyerror("priority + or : expected");
				  return(1); }
		;

/*
 *  Shift USERS rules
 */

shiftusers 	: 	newlinestar
			END
				{ yyprintf("END\n"); }
		| 	newlinestar
			poolaccountlist
			END
				{ yyprintf("END\n"); }
		| 	error
				{ yyerror("keyword POOL or END expected");
				  return(1); }
		;

poolaccountlist : 	poolaccount
		| 	poolaccountlist poolaccount
		;

poolaccount 	: 	poolaccounthdr
			newline
			accountlist
				{ yyprintf("\n"); }
		|	poolaccounthdr
				{ yyprintf("\n"); }
			error
				{ yyerror("new line expected");
				  return(1); }
		;

poolaccounthdr	:	POOL
				{ yyprintf("POOL  "); }
			poolname
				{ if ( add_poolaccount($3) < 0 ) return(1); }
		;

accountlist 	: 	account
		| 	accountlist account
		| 	POOL
				{ yyerror("syntax error");
				  yyerror("empty account list");
				  return(1); }
		;

account 	: 	group
			':'
				{ yyprintf(" : "); }
			userlist
			newline
		| 	group
				{ yyprintf("\n"); }
			error
				{ yyerror("colon expected");
				  return(1); }
		| 	error
				{ yyerror("group name expected");
				  return(1); }
		;

userlist 	: 	user
		|	user
			','
				{ yyprintf(","); }
			userlist
		|	user
				{ yyprintf("\n"); }
			error
				{ yyerror("comma or new line expected");
				  return(1); }
		|		{ yyprintf("\n"); }
			error
				{ yyerror("user name expected");
				  return(1); }
		;

group 		: 	groupname
				{ if ( add_groupaccount($1,FALSE) < 0 ) return(1); }
		| 	groupname
			garbage
				{ if ( add_groupaccount($1,TRUE) < 0 ) return(1); }
		;

groupname 	: 	ID
				{ strcpy($$,$1); yyprintf("  %-2s",$$); }
		| 	'*'
				{ strcpy($$,"*"); yyprintf("  *"); }
		;

user 		: 	username
				{ if ( add_useraccount($1,FALSE) < 0 ) return(1); }
		| 	username
			garbage
				{ if ( add_useraccount($1,TRUE) < 0 ) return(1); }
		;

username 	: 	ID
				{ strcpy($$,$1); yyprintf("%s",$$); }
		| 	'*'
				{ strcpy($$,"*"); yyprintf("*"); }
		;

garbage 	: 	'('
			ID
				{ yyprintf("(%s",$2);
				  if ( strcmp($2,"G") ) {
				    yyprintf("\n");
				    yyerror("syntax error");
				    yyerror("wrong garbage collector authorization");
				    return(1);
				  }
				}
			')'
				{ yyprintf(")"); }
		|	'('
			ID
				{ yyprintf("(%s\n",$2); }
			error
				{ yyerror("close bracket expected");
				  return(1); }
		|	'('
				{ yyprintf("(\n"); }
			error
				{ yyerror("garbage collector authorization expected");
				  return(1); }
		;

/*
 *  Shift DEFAULTS rules
 */

shiftdefaults 	: 	newlinestar
			END
				{ yyprintf("\nEND\n"); }
		| 	newlinestar
			defaultlist
			END
				{ yyprintf("\nEND\n"); }
		|	error
				{ yyerror("keyword END or pool attribute expected");
				  return(1); }
		;

defaultlist 	:	attributes newline
		| 	defaultlist attributes newline
		|	attributes
				{ yyprintf("\n"); }
			error
				{ yyerror("new line expected");
				  return(1); }
		;

/*
 *  Shift CONF rules
 */

shiftconf 	: 	newlinestar
			categorylist
				{ yyprintf("\n"); }
		| 	error
				{ yyerror("keyword CATEGORY expected");
				  return(1); }
		;

categorylist 	: 	categoryhdr itemlist
		| 	categorylist categoryhdr itemlist
		;

categoryhdr	:	categoryname
			newline
		|	categoryname
				{ yyprintf("\n"); }
			error
				{ yyerror("new line expected");
				  return(1); }
		;

categoryname 	: 	CATEGORY
				{ yyprintf("\ncategory  "); }
			ID
				{ yyprintf("%s",$3);
				  if ( add_category($3) < 0 ) return(1); }
		| 	CATEGORY
				{ yyprintf("\ncategory  \n"); }
			error
				{ yyerror("category name expected");
				  return(1); }
		;

itemlist 	: 	itemvalue
		| 	itemvalue hostlist
		| 	itemlist itemvalue
		| 	itemlist itemvalue hostlist
		;

itemvalue	: 	itemname
			':'
				{ yyprintf(" : ");
				  if ( get_line(&$1.yylp) < 0 ) return(1); }
			newline
				{ if ( add_item($1.yyid,$1.yylp) < 0 ) return(1); }
		| 	itemname
				{ yyprintf("\n"); }
			error
				{ yyerror("colon expected");
				  return(1); }
		| 	error
				{ yyerror("item name expected");
				  return(1); }
		;

itemname 	: 	ID
				{ strcpy($$.yyid,$1); yyprintf("  %-12s",$1); }
		;

hostlist 	: 	'('
				{ yyprintf("  (\n"); }
			hostvalue
			')'
				{ yyprintf("  )"); }
			newline
		| 	'('
				{ yyprintf("  ("); }
			newline
			hostvalue
			')'
				{ yyprintf("  )"); } 
			newline
		| 	'('
			')'
				{ yyprintf("  (\n");
				  yyerror("syntax error");
				  yyerror("empty host list");
				  return(1); }
			;

hostvalue 	: 	hostvalue
			hostname
			':'
				{ yyprintf(" : "); 
				  if ( get_line(&$2.yylp) < 0 ) return(1); }
			newline
				{ if ( add_hostvalue($2.yyid,$2.yylp) < 0 ) return(1); }
		| 	hostname
			':'
				{ yyprintf(" : ");
				  if ( get_line(&$1.yylp) < 0 ) return(1); }
			newline
				{ if ( add_hostvalue($1.yyid,$1.yylp) < 0 ) return(1); }
		| 	hostvalue
			hostname
				{ yyprintf("\n"); }
			error
				{ yyerror("colon expected");
				  return(1); }
		| 	hostname
				{ yyprintf("\n"); }
			error
				{ yyerror("colon expected");
				  return(1); }
		;

hostname 	: 	ID
				{ strcpy($$.yyid,$1); yyprintf("    %-10s",$1); }
		|	error
				{ yyerror("host name or close bracket expected");
				  return(1); }
		;

/*
 *  path, newline and newlinestar rules
 */

path 		: 	'/'
			ID
				{ strcpy($$,"/"); strcat($$,$2); }
		| 	path
			'/'
			ID
				{ strcat($$,"/"); strcat($$,$3); }
		|	'/'
				{ strcat($$,"/"); yyprintf("/\n"); }
			error
				{ yyerror("wrong path format");
				  return(1); }
		;

newlinestar	:		/* empty */
		|	newline
		;

newline		: 	NEWLINE
				{ yyprintf("\n"); }
		| 	newline
			NEWLINE
		| 	newline
			'#'
				{ yyprintf("#");
				  if ( skip_comment_line() < 0 ) return(1); }
		;

%%

#include "lex.yy.c"
