/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)getconfent.c	3.2 05/12/93 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <shift_types.h>
#include <strtok.h>
#include <shiftconf.h>
#include <parser.h>
#include <table.h>
#ifndef vms
#include <serrno.h>                     /* Special Error numbers        */
#else
#include "serrno.h"                     /* Special Error numbers        */
#endif

#define DPM_CONF	FALSE
#define SHIFT_CONF	TRUE

#define ENV_SHIFTBINARY	"SHIFTBINARY"

char *extfilepath = NULL;		/* extern shift binary file path 	*/
char *extdirpath = NULL;		/* extern shift binary directory path	*/
boolean reloadconfiguration = TRUE;

/*
 *  Load the configuration stored in the binary file unless it's already
 *  in memory and the file on disk was not modified and reload is true
 *
 *  INPUT
 *	dpmconf		if true	the DPM configuration is loaded
 *	shiftconf	if true the PAIR configuration is loaded (the old shift.conf)
 *	reload		if true the configuration in memory can be reloaded
 *
 *  RETURN
 *	1		successful completion
 *	0		successful completion ( already loaded )
 *	-1		an error occured
 */
int load_configuration(dpmconf,shiftconf,reload)
boolean dpmconf,shiftconf,reload;
{
  extern path_t shift_binary;		/*  shift binary file path		 */
  static time_t mtime = 0;		/*  last modify time of the binary file  */
  struct stat buf;
  static boolean dpmconf_init = FALSE;
  static boolean shiftconf_init = FALSE;

    clear_vperror();

 /*
  *  If this is the first call then build the shift binary file path
  */
    if ( !mtime ) {
	if ( extfilepath )
	    strcpy(shift_binary,extfilepath);
	else {
	    if ( !extdirpath && (extdirpath = getenv(ENV_SHIFTBINARY)) == NULL &&
		    getshiftconf((char**)NULL,&extdirpath,NULL,NULL,NULL,NULL,(char**)NULL) < 0 ) {
		vperror(0,"shift binary directory required\nincomplete installation");
		return(-1);
	    }
	    build_shift_paths((char*)NULL,extdirpath,(char*)NULL);
	}
    }

 /*
  *  Get the last modify time of the file on disk 
  */
    if ( stat(shift_binary,&buf) < 0 ) {
	vperror(1,"stat()");
	return(-1);
    }

 /*
  *  Check if the file on disk must be loaded
  */
    if ( ( reload && buf.st_mtime > mtime ) ||
		( ((dpmconf>0) > dpmconf_init) || ((shiftconf>0) > shiftconf_init) ) ) {
	if ( mtime )
	    free_configuration();
	if ( read_binary_file(dpmconf_init || dpmconf,shiftconf_init || shiftconf) < 0 )
	    return(-1);
	mtime = buf.st_mtime;
	dpmconf_init = dpmconf_init || dpmconf;
	shiftconf_init = shiftconf_init || shiftconf;
	return(1);
    }

 /*
  *  Configuration in memory is up to date
  */
    return(0);
}

/*
 *  Get the item entry from the configuration file
 *
 *  INPUT
 *	category	category name
 *	item		item name
 *	flags		reply mode
 *
 *  RETURN
 *	NULL		either not found or an error occured (see serrno)
 *    otherwise		the item value string
 */
char *getconfent(category,item,flags)
char *category,*item;
int flags;
{
  extern pair_t *pair_table;		/*  pair table pointer		*/
  extern index_t_s pairidx;		/*  pair table length		*/
  host_t localhost;
  index_t_s idx;
  static char reply[BUFSIZ];		/*  static reply buffer		*/

    clear_vperror();

 /*
  *  Load the required configuration
  */
    if ( load_configuration(DPM_CONF,SHIFT_CONF,reloadconfiguration) < 0 ) {
	serrno = SENOCONFIG;
	return((char*)NULL);
    }

 /*
  *  Get the local host name
  */
    gethostname(localhost,sizeof(host_t));

 /*
  *  Look for the item value (first the host value otherwise the default item value)
  */
    if ( (idx = look_pair(category,item,localhost)) < 0 )
	idx = look_pair(category,item,(char*)NULL);

 /*
  *  Return NULL if no item value is defined
  */
    if ( idx < 0 || pair_table[idx].value == NULL ) {
	serrno = SEENTRYNFND;
	return((char*)NULL);		/*  return a NULL pointer		    */
    }

 /*
  *  Build the reply
  */
    strcpy(reply,pair_table[idx].value);
    if ( flags )
	return(reply);			/*  return the full string matched	    */
    else
	return(strtok(reply," \t"));	/*  return the first blank separated token  */
}
