/*
 * Copyright (C) 1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)parser.c	3.2 08/06/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <varargs.h>
#include <shift_types.h>
#include <parser.h>

extern FILE	*yyin;
extern char	yytext[];
extern int	lexline;

extern path_t	shift_pools;
extern path_t	shift_users;
extern path_t	shift_defaults;
extern path_t	shift_pairs;

static boolean	shift_silent;
static FILE	*shift_output;
static char	*lexname;

/*
 *  Print a yacc message unless the silent mode is selected
 *
 *  INPUT
 *	format string
 *	argument list
 */
void yyprintf(va_alist)
  va_dcl
{
  va_list  args;
  char     *fmt;

    if ( !shift_silent ) {
	va_start(args);
	fmt = va_arg(args,char*);
	vfprintf(shift_output,fmt,args);
	va_end(args);
    }
}

/*
 *  Print a yacc error message
 *
 *  INPUT
 *	format string
 *	argument list
 */
void yyerror(va_alist)
  va_dcl
{
  static char yystring[BUFSIZ];
  va_list  args;
  char     *fmt;

    va_start(args);
    fmt = va_arg(args,char*);
    if ( !shift_silent ) fflush(shift_output);
    vfprintf(stderr,fmt,args);
    if ( !strcmp(fmt,"syntax error") )
	fprintf(stderr," at line %d of file %s",lexline,lexname);
    fprintf(stderr,"\n");
    if ( !strcmp(fmt,"syntax error") && sscanf(yytext,"%[^\n\t ]",yystring) > 0 ) 
	yyprintf("%s\n",yytext);
    va_end(args);
}

/*
 *  Set the shift defaults configuration input for yyparse()
 */
int set_shift_defaults()
{
    if ( (yyin = fopen(shift_defaults,"r")) == NULL )
	vperror(1,"fopen(%s,r)",shift_defaults);
    lexline = 0;
    lexname = shift_defaults;
    return( yyin != NULL ? 1 : -1 );
}

/*
 *  Set the shift servers and pools configuration input for yyparse()
 */
int set_shift_pools()
{
    if ( (yyin = freopen(shift_pools,"r",yyin)) == NULL )
	vperror(1,"fopen(%s,r)",shift_pools);
    lexline = 0;
    lexname = shift_pools;
    return( yyin != NULL ? 1 : -1 );
}

/*
 *  Set the shift account configuration input for yyparse()
 */
int set_shift_users()
{
    if ( (yyin = freopen(shift_users,"r",yyin)) == NULL )
	vperror(1,"fopen(%s,r)",shift_users);
    lexline = 0;
    lexname = shift_users;
    return( yyin != NULL ? 1 : -1 );
}

/*
 *  Set the shift pair configuration input for yyparse()
 */
int set_shift_conf()
{
    if ( (yyin = freopen(shift_pairs,"r",yyin)) == NULL )
	vperror(1,"fopen(%s,r)",shift_pairs);
    lexline = 0;
    lexname = shift_pairs;
    return( yyin != NULL ? 1 : -1 );
}

/*
 *  Skip a comment line
 */
int skip_comment_line()
{
  static char comment[BUFSIZ];
  int curs;
  char ch;

    do {
	curs = 0;
	while ( !feof(yyin) && (ch=getc(yyin)) != 10 && curs < BUFSIZ-1 ) 
	    comment[curs++] = ch;
	comment[curs] = '\0';
	yyprintf("%s\n",comment);
    } while ( curs == BUFSIZ-1 && ch != 10 && !feof(yyin) );
    if ( feof(yyin) ) 
	yyerror("unexpected end of file");
    return( feof(yyin) ? -1 : 1 );
}

/*
 *  Get the rest of the current line
 */
int get_line(lineptr)
char **lineptr;
{
  static char line[BUFSIZ];
  int curs;
  char ch;

    curs = 0;
    while ( !feof(yyin) && ( (ch=getc(yyin)) == ' ' || ch == '\t') ) ;
    ungetc(ch,yyin);
    while ( !feof(yyin) && (ch=getc(yyin)) != 10 && curs < BUFSIZ-1 ) 
	line[curs++] = ch;
    line[curs] = '\0';
    yyprintf("%s",line);
    if ( ch == 10 )
	ungetc(ch,yyin);
    if ( curs == BUFSIZ-1 )
	yyerror("line too long");
    if ( feof(yyin) )
	yyerror("unexpected end of file");
    *lineptr = line;
    return( feof(yyin) || curs == BUFSIZ ? -1 : 1 );
}

/*
 *  Interface to the yacc parser
 *
 *  INPUT
 *	output		output file descriptor to be used by yyprintf()
 *			(if NULL the silent mode is selected)
 *
 *  RETURN
 *	0	successful completion
 *	1	yyparser error
 */
int shift_parser(output)
FILE    *output;
{
    if ( !(shift_silent = (output == NULL)) )
	shift_output = output;

    if ( yyparse() == 0 ) {
	printf("Configuration ascii files correct\n");
	return(0);
    }
    else {
	yyerror("Shift parser failed");
	return(1);
    }
}
