/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)server.c	3.5 07/12/93 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#if defined( _AIX ) && defined( _IBMR2 )
#include <sys/select.h>
#endif
#include <netinet/in.h>
#include <netdb.h>
#include <shift_types.h>
#include <osdep.h>
#include <marshall.h>
#include <strerror.h>
#include <sockutil.h>
#include <pktutil.h>
#include <config.h>
#include <mknet.h>
#include <server.h>

extern time_t config_version;
extern path_t shift_log;
extern int shift_log_size;

#define ACCEPT_TIMEOUT		TIME,5,0	/*  5 seconds		*/
#define HANDLE_TIMEOUT		TIME,180,0	/*  3 minutes 		*/

/*
 *  This function handles state ST_ACCEPT
 *
 *  INPUT
 *	copy		the connection structure
 */
void recv_command(copy)
remote_t *copy;
{
  pkt_t pkt;
  int req[2];
  int lock;
#if !defined( NOAUTHORIZE )
  int auth;
#endif

    req[0] = PKT_EXPORT;
    req[1] = PKT_IMPORT;
    pktinit(&pkt);
    if ( handle_read_packet(read_packet(copy->sock,&pkt),copy,&pkt,2,req) == EPKTOK )
	switch ( pkt.request ) {

	    case PKT_EXPORT :
	    case PKT_IMPORT :

	     /*
	      *  Set the next state
	      */
		if ( pkt.request == PKT_EXPORT ) {
		    copy->status = ST_EXPORT;
		    lock = LOCK_EXREAD;
		    auth = REXPORTAUTHORIZE;
		}
		else {
		    copy->status = ST_IMPORT;
		    lock = LOCK_READ;
		    auth = RIMPORTAUTHORIZE;
		}

	     /*
	      *  Get the local binary file version
	      */
		errno = 0;
		open_binary(ACCESS_READ,lock);
		read_version();

#if !defined( NOAUTHORIZE )
	     /*
	      *  Check the authorization to export/import 
	      */
		read_hosts();
		is_host_authorized(auth,pkt.netbody);
#endif

		close_binary(FALSE,LOCK_LEAVE);

	     /*
	      *  Send back BADSTATUS if an error occurs
	      */
		if ( (get_vperror() < 0 && errno != ENOENT) ||
			  (pkt.ptr = pktalloc(&pkt,pkt.length=sizeof(LONG))) == NULL ) {
		    copy->status = ST_FAILURE;
		    copy->strerr = strdup_vperror();		    
		    handle_writepacket(send_badstatus(copy,str_vperror()),copy);
		}
		else

	     /*
	      *  Send back NOVERSION if the local binary file doesn't exist
	      */
		if ( get_vperror() < 0 ) {
		    clear_vperror();
		    send_request(copy,PKT_NOVERSION,copy->status);
		}
		else {

	     /*
	      *  Otherwise send back the version number
	      */
		    pkt.request = PKT_SENDVERSION;
		    marshall_LONG(pkt.ptr,config_version);
		    handle_writepacket(write_packet(copy->sock,&pkt),copy);
		}
		break;

	} /* switch */
    pktfree(&pkt);
}

/*
 *  This function handles states ST_EXPORT and ST_IMPBINARY
 *
 *  INPUT
 *	copy		the connection structure
 */
void recv_export(copy)
remote_t *copy;
{
  pkt_t pkt;
  int req[3];
  int len;

    req[0] = PKT_SENDBINARY;
    req[1] = PKT_ENDBINARY;
    len = 2;
    if ( copy->status == ST_EXPORT )
	req[len++] = PKT_ENDEXPORT;
    pktinit(&pkt);
    if ( handle_read_packet(read_packet(copy->sock,&pkt),copy,&pkt,len,req) == EPKTOK )
	switch ( pkt.request ) {
	    case PKT_ENDEXPORT :
		copy->status = ST_END;
		close(copy->sock);
		break;
	    case PKT_SENDBINARY :
	    case PKT_ENDBINARY :
		recv_binary(copy,&pkt);
		if ( copy->status == ST_END ) {
		    if ( write_binary_file() < 0 ) {
			copy->status = ST_FAILURE;
			copy->strerr = strdup_vperror();
			send_badstatus(copy,str_vperror());
			close(copy->sock);
		    }
		    copy->status = ST_ACKSEND;
		}
		else
		if ( !(copy->status & ERRORMASK) )
		    copy->status = ST_IMPBINARY;
		break;
	} /* switch */
    pktfree(&pkt);
}

/*
 *  This function handles state ST_IMPORT
 *
 *  INPUT
 *	copy		the connection structure
 */
void recv_import(copy)
remote_t *copy;
{
  pkt_t pkt;
  int req[2];
  char *oldshiftenvironment;

    req[0] = PKT_REQBINARY;
    req[1] = PKT_ENDIMPORT;
    pktinit(&pkt);
    if ( handle_read_packet(read_packet(copy->sock,&pkt),copy,&pkt,2,req) == EPKTOK )
	switch ( pkt.request ) {
	    case PKT_ENDIMPORT :
		copy->status = ST_END;
		close(copy->sock);
		break;
	    case PKT_REQBINARY :
		copy->status = ST_EXPBINARY;
	     /*
	      *  Load and lock the local configuration
	      */
		open_binary(ACCESS_READ,LOCK_EXREAD);
		read_version();
		read_hosts();
		read_tables();
		read_pairs();
		marshall_binary_file();
		close_binary(FALSE,LOCK_LEAVE);
		if ( get_vperror() < 0 ) {
		    copy->status = ST_FAILURE;
		    copy->strerr = strdup_vperror();
		    send_badstatus(copy,str_vperror());
		    close(copy->sock);
		}
		break;
	} /* switch */
    pktfree(&pkt);
}

/*
 *  Handles the select() read mask events
 */
void server_netread(copies,counter,copy)
remote_t *copies;
int counter;
remote_t *copy;
{
    switch ( copy->status ) {
	case ST_ACCEPT :
		recv_command(copy);
		break;
	case ST_IMPBINARY :
	case ST_EXPORT :
		recv_export(copy);
		break;
	case ST_IMPORT :
		recv_import(copy);
		break;
     /*
      *  Error
      */
	case ST_EXPBINARY :
	case ST_ACKSEND :
		recv_error(copy);
		break;
	default :
		vperror(0,"server_netread(): status (%d) not handled",copy->status);
		copy->status = ST_FAILURE;
		copy->strerr = strdup_vperror();
		close(copy->sock);
    } /* switch */
}

/*
 *  Handles the select() write mask events
 */
void server_netwrite(copies,counter,copy)
remote_t *copies;
int counter;
remote_t *copy;
{
    switch ( copy->status ) {
	case ST_EXPBINARY :
		send_binary(copy);
		if ( copy->status == ST_ACKRECV ) {
		    copy->status = ST_END;
		    close(copy->sock);
		}
		break;
	case ST_ACKSEND :
		send_request(copy,PKT_ACKNOWLEDGE,ST_END);
		if ( copy->status == ST_END ) {
		    close(copy->sock);
		    lock_binary(UNLOCK);
		    remove_ascii_files();
		}
		break;
	default :
		vperror(0,"server_netwrite(): status (%d) not handled",copy->status);
		copy->status = ST_FAILURE;
		copy->strerr = strdup_vperror();
		close(copy->sock);
    } /* switch */
}

/*
 *  Handle an accepted connection
 *
 *  INPUT
 *	sock		socket created by accept()
 *	name		peer address
 *	namelen		peer address length
 *
 *  RETURN
 *	0		successful completion
 *	1		an error occured
 */
int handle_connection(sock,name,namelen)
int sock;
struct sockaddr_in *name;
int namelen;
{
  host_t host;
  port_t port;
  remote_t copy;
  int reply;

    clear_vperror();

 /*
  *  Get host and port of the peer address
  */
    if ( get_sockaddr_in(name,host,&port) < 0 )
	return(1);

 /*
  *  Log error messages on disk
  */
    if ( shift_log_size > 0 )
	ctrl_vperror(VPLOGFILE,shift_log,shift_log_size);

 /*
  *  Initialize the connection structure
  */
    strcpy(copy.host,host);
    copy.sock = sock;
    copy.status = ST_ACCEPT;
    copy.fd = NULL;
    copy.strerr = NULL;
    copy.printed = 0;

 /*
  *  Set the timeout used by netdialog()
  */
    set_timeout(HANDLE_TIMEOUT);

 /*
  *  Dialog with the remote copy
  */
    reply = netdialog(&copy,1,server_netread,server_netwrite,FALSE);

 /*
  *  Deallocate memory used by the configuration ( free_pair() should be enough )
  */
    free_configuration();

    return( copy.status != ST_END || reply < 0 ? 1 : 0 );
}

/*
 *  Bind sfmake to the local host and assigned port number
 *
 *  OUTPUT
 *	localhost	local host name
 *	port		assigned port number
 *
 *  RETURN
 *	ERROR		an error occured
 *    otherwise		the socket created
 */
int bind_sfmake(localhost,port)
char *localhost;
port_t *port;
{
  struct sockaddr_in name;
  int sock;
  int optval = 1;

 /*
  *  Create the socket
  */
    if ( (sock = socket(AF_INET,SOCK_STREAM,0)) < 0 ) {
        vperror(1,"socket()");
        return(ERROR);
    }

 /*
  *  Set the REUSEADDR socket option
  */
    if ( setsockopt(sock,SOL_SOCKET,SO_REUSEADDR,(char*)&optval,sizeof(int)) < 0 ) {
	vperror(1,"setsockopt()");
	return(ERROR);
    }

 /*
  *  Get the local host name and assigned port number
  */
    gethostname(localhost,sizeof(host_t));

    if ( (*port = getdpmconfport()) < 0 )
	return(ERROR);

 /*
  *  Bind the socket
  */
    if ( create_sockaddr_in(localhost,*port,&name) < 0 )
	return(ERROR);

    if ( bind(sock,(struct sockaddr *)&name,sizeof(struct sockaddr_in)) < 0 ) {
        vperror(1,"bind()");
        return(ERROR);
    }

 /*
  *  Return the socket
  */
    return(sock);
}

/*
 *  Listen on the network
 *
 *  INPUT
 *	daemon		daemon mode
 *	multithread	multi-thread mode
 *
 *  RETURN
 *	0		successful completion
 *	1		an error occured
 */
int loop_network(multithread)
boolean multithread;
{
  host_t host;
  port_t port;
  fd_set rmask;
  struct sockaddr_in name;
  int sock,newsock;
  int namelen;

 /*
  *  Bind the program to the local host and assigned port number
  */
    if ( (sock = bind_sfmake(host,&port)) < 0 ) {
	vperror(0,"bind_sfmake() failed");
	return(1);
    }

 /*
  *  Listen
  */
    if ( listen(sock,5) < 0 ) {
	vperror(1,"listen()");
	return(1);
    }
    printf("Listening on ip:%s[%d]\n",host,port);

 /*
  *  Loop
  */
    FD_ZERO(&rmask);
    FD_SET(sock,&rmask);

    for (;;) {

     /*
      *  Set the timeout
      */
	set_timeout(BLOCKING);

     /*
      *  Wait for a connection request
      */
	switch ( select(sock+1,&rmask,(fd_set*)NULL,(fd_set*)NULL,get_timeout()) )  {

	  case -1 :
		vperror(1,"select()");
		return(1);

	  case 0 :
		vperror(0,"unexpected select() reply");
		return(1);

	  case 1 :
	     /*
	      *  Accept a new connection
	      */
		namelen = sizeof(struct sockaddr_in);
		if ( (newsock = accept(sock,(struct sockaddr *)&name,&namelen)) < 0 ) {
		    vperror(1,"accept()");
		    return(1);
		}

	     /*
	      *  If single-thread mode then handle the connection
	      *  otherwise fork a child to do it
	      */
		if ( !multithread ) {
		    handle_connection(newsock,&name,namelen);
   		    lock_binary(UNLOCK);
		}
		else
		    switch ( fork() ) {
			case -1 :
			    vperror(1,"fork()");
			    handle_connection(newsock,&name,namelen);
   			    lock_binary(UNLOCK);
			    break;
			case 0 :
			    handle_connection(newsock,&name,namelen);
			    exit(0);
			default :
			    close(newsock);
		    } /* switch - fork() */
		break;

        } /* switch - select() */

    } /* loop */

}
