.\"@(#)sfmake.man	3.2 10/20/92 CERN-SW/DC Fabrizio Cane
.\ Copyright (C) 1992 by CERN/CN/SW/DC
.\ All rights reserved
.\"
.nh
.TH SFMAKE l "20/10/92"
.SH NAME
sfmake sfmaked \- Shift Disk Pool Manager (DPM) configurator
.SH SYNOPSIS
.B sfmake 
.B "  "\-help
\ [
.BI \-shiftascii " path"
] [
.BI \-shiftbinary " path"
] [
.BI \-shiftport " port"
]
.br
.B "               " \-read
[
.B \-list
] [
.B \-pools
] [
.B \-users
] [
.B \-conf
] |
.B \-binary
[
.B \-list
] [
.B \-remove 
]
.br
.B "               " \-ascii
.B \-export
[
.RI "[:-|:+]" "host" "{:[-|+]" "host" "}" 
] [
.B \-touch
]
.B \-import
[
.IR "host" "{:" "host" "}" 
]
.br
.B "               " \-wlock
.RI "[" "filesystem" "{," "filesystem" "}]"
.B \-wunlock
.IR "all" "|" "filesystem" "{" ",filesystem" "}"
.br
.B sfmaked 
.B " "\-help
\ | [
.BI \-shiftascii " path"
] [
.BI \-shiftbinary " path"
] [
.BI \-shiftport " port"
]
.SH DESCRIPTION
The Shift DPM configuration can be provided in two different formats: - the 
.B ascii format 
used by the administrator to either change or create a configuration - and the 
.B binary format 
required by 
.BR "sfget, sfrm, sfsh, sfgc" " and" " sfdpmd" " ( DPM(1) )." 
.LP
While a copy of the binary format must be provided wherever
the DPM is installed ( 
.I the shift environment
) usually only one copy of the ascii format
exists for the short term required by the administrator to edit the ascii files.
.LP
.B sfmake 
reads and writes both formats locally and through the network while
.B sfmaked 
starts the daemon handling remote sfmake operations.
.LP
.SH OPTIONS
.TP
.B \-help 
.br
to show the available options and a brief description ( sfoptions(1) ).
.TP
.B "\-read [ \-list ] [ \-pools ] [ \-users ] [ \-conf ]"
to read the binary configuration and print the version number and 
the shift environment host list. If 
.B pools 
is specified the disk server and pool configuration is printed. If 
.B users 
is specified the pool access configuration is printed. If 
.B conf 
is specified the shift processes configuration is printed. If
.B list 
is specified the whole shift configuration is printed ( see sfsyntax(1) ).
.TP
.BR \-binary " [ " \-list " ] [ " \-remove " ]"
.br
to produce a new binary configuration from an existing ascii configuration. The new
binary configuration is automatically exported. If 
.B remove 
is specified then first the existing binary configuration is removed so that a new 
shift environment host list will be created including the local host only. If
.B list
is specified the parser input is echoed.
.TP
.B \-ascii
.br
to produce the ascii configuration from an existing binary configuration.
The ascii configuration is automatically removed when the binary configuration
is either successfully exported to at least one remote host or successfully imported.
.TP
.BR \-export " [ [:-|:+]host{:[-|+]host} ] [ " \-touch " ]"
.br
to export the binary configuration to the shift environment. The latter
can be also modified providing a list of hosts. If the host name is preceded by a dash
then it is removed from the shift environment otherwise it is added unless 
already included. If the host name is preceded by a plus then, if 
added, it will not be authorized to modify and export the configuration.
In case the shift environment is modified the local binary file
is updated before being transfered. The binary file is effectively exported only
to the remote hosts having a less recent binary configuration. An attemp to export
the configuration to a host having a more recent version produces the 
.BI WARNING " too recent."
If
.B touch 
is specified
then the local version number is first changed. This should force sfmake to
effectively export the file avoiding the warning just described.
.TP
.BR \-import " [ host{:host} ]"
.br
to update the local binary configuration importing the most recent version available in
the shift environment. The binary file is effectively imported only if the remote
version is more recent than the local. An attempt to import the configuration from
a host having a less recent version produces the 
.BI WARNING " too old."
If the shift environment cannot be loaded from the binary configuration 
then the optional host list is used.
.TP
.BR \-wlock " [ filesystem{,filesystem} ]"
.br
to either write-lock one or more file systems or get the list of write-locked file systems.
The file system path can be either the complete nfs-pathname as returned by sfget or
in the format <host>:<path>. sfget cannot create files in write-locked file systems.
.TP
.BR \-wunlock " all | filesystem{,filesystem}
.br
to write-unlock one or more file system. If all is specified then all write-locked file systems
are unlocked.
.LP
.SH ENVIRONMENT
.BR sfmake " and " sfmaked 
need to know the location of the ascii and binary configuration and 
the socket port number to connect the remote sfmake daemons.
.TP
.RB The " shift ascii directory path" " is searched in the following places and order:"
 - the command line ( shiftascii option )
 - the shell environment ( setenv SHIFTASCII <path> )
 - the file /etc/shift.conf ( SHIFT ASCII <path> )
.TP
.RB The " shift binary directory path" " is searched in the follwing places and order:"
 - the command line ( shiftbinary option )
 - the shell environment ( setenv SHIFTBINARY <path> )
 - the file /etc/shift.conf ( SHIFT BINARY <path> )
.TP
.RB The " shift port number" " is searched in the following places and order:"
 - the command line ( shiftport option )
 - the shell environment ( setenv SHIFTMAKEPORT <path> )
 - the file /etc/shift.conf ( SHIFT MAKEPORT <number> )
 - the Internet Services data base ( shiftmake <number>/tcp )
.LP
.SH FILES
.BR "/etc/shift.conf" "\t\t\t\t\tthe installation setup file"
.LP
The following files are produced by sfmake and placed in the shift binary directory
.LP
.BR shiftdb "\t\t\t\t\t\tthe binary shift configuration"
.br
.BR shiftdb.lock "\t\t\t\t\tthe binary configuration lock"
.br
shiftdb.net
.br
shiftdb.copy
.LP
The following files are placed in the shift ascii directory ( see sfsyntax(1) )
.LP
.BR shift.defaults "\t\t\t\t\tthe shift defaults file"
.br
.BR shift.pools "\t\t\t\t\tthe shift resource configuration file"
.br
.BR shift.users "\t\t\t\t\tthe shift pool access control file"
.br
.BR shift.pairs "\t\t\t\t\tthe shift process configuration file"
.br
.SH EXAMPLES
.TP
Creation of a new shift configuration and environment
\ - move to the shift ascii directory
.br
\ - edit the shift configuration ascii files and write the configuration
.br
.RB " - " "sfmake -binary" " to create the local binary configuration"
.br
.RB " - " "sfmake -export hostname" " when a new host is added to the shift environment"
.TP
Modification of the current shift configuration
.br
.RB " - " "sfmake -ascii" " to produce the ascii files containing the current"
configuration
.br
\ - move to the shift ascii directory
.br
\ - edit and modify the configuration as required
.br
.RB " - " "sfmake -binary" " to update and export the local binary configuration"
.TP
Modification of the current shift environment
.br
.RB " - " "sfmake -export :-host1:-host2:host3:-host4:+host4" " to remove host1 and "
host2, to add host3 and to reduce the authorization of host4. 
.br
.SH INSTALLATION
The /etc/shift.conf file, the shell environment and the Internet Services data base 
should be setup following the section ENVIRONMENT. Moreover if the shift 
environment doesn't include only the local host then 
at system startup an sfmake daemon must be started and an import should be executed 
in order to update the local configuration in case some modifications were propagated
from a remote host while the local machine was not accessible.
.SH ACCESS & PROBLEMS
The access to the binary configuration file is protected by a lock file (shiftdb.lock) 
in order to suspend the sfget, sfrm, sfsh and sfdpmd 
while the configuration is being modified. The lock mechanism 
guarantee that a process can upgrade a 
shared lock to an exclusive lock, and vice versa, without releasing the 
previous lock.
There is no deadlock in the sfmake operations but there is 
no guarantee
that the shift environment have the same configuration if two different modifications
are propagated at the same time from two different hosts.
.br
.LP
Let 
.I \s9delta-t\s0 
be the positive time difference between to hosts named 
.IR "A" " and" " B" "." 
If the last configuration was created on 
.IR "A" " at time" " \s9t\s0"
then the new configuration created on 
.I B 
will be exported to 
.I A 
only if its creation time is more recent than 
.IR "\s9t\s0" " +" " \s9delta-t\s0"
otherwise the warning 
.I too recent
will be printed as described for the 
.I export
option.
.SH RETURN CODES
0\ \ \ \ \ \ \ successful completion
.br
1\ \ \ \ \ \ \ failure
.br
.SH SEE ALSO
sfsyntax(1), sfget(1), sfsh(1), sfrm(1), sfgc(1), sfdpmd(1), sfoptions(1)
.SH AUTHOR
Fabrizio Cane, CERN-CN Division CH-1211 Geneva 23, Switzerland (cane@cernvm.cern.ch)
