/*
 * Copyright (C) 1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = " @(#)sfmakem.c	3.5 08/24/93 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <signal.h>
#include <shift_types.h>
#include <parser.h>
#include <command.h>
#include <optutil.h>
#include <shiftconf.h>
#include <getconfent.h>

#define SHIFTASCII_DESCR	"ascii configuration directory"
#define SHIFTBINARY_DESCR	"binary configuration directory"
#define SHIFTPORT_DESCR		"service port number"
#define SHIFTLOG_DESCR		"max log file size"

#if !defined( DAEMON )

#if defined( TEST )
#define SYNTAX_DESCR		"parse the ascii configuration"
#endif
#define READ_DESCR		"read the binary configuration"
#define BINARY_DESCR		"produce the binary configuration"
#define ASCII_DESCR		"produce the ascii configuration"
#define EXPORT_DESCR		"export the binary configuration"
#define IMPORT_DESCR		"import the binary configuration"
#define LIST_DESCR		"show the whole shift declaration"
#define REMOVE_DESCR		"remove the binary configuration"
#define TOUCH_DESCR		"touch the version number"
#define POOLS_DESCR		"show the shift pools configuration"
#define USERS_DESCR		"show the shift users account"
#define CONF_DESCR		"show the shift configuration"
#define WLOCK_DESCR		"write lock a file system"
#define WUNLOCK_DESCR		"write unlock a file system"

#else

#define MULTI_THREAD		FALSE

#endif

extern port_t shift_port;
extern boolean locktrace;
int shift_log_size;

/*
 *  sfmake / sfmaked usage
 */
void usage(argv,help)
char *argv[];
boolean help;
{
#if !defined( DAEMON )
    printf("usage: %s -help\n",argv[0]);
    printf("       %s -ascii\n",argv[0]);
#if defined( TEST )
    printf("       %s -syntax [ -list ]\n",argv[0]);
#endif
    printf("       %s -binary [ -list ] [ -remove ]\n",argv[0]);
    printf("       %s -read [ -list ] [ -pools ] [ -users ] [ -conf ]\n",argv[0]);
    printf("       %s -import [ <hosts> ]\n",argv[0]);
    printf("       %s -export [ <hosts> ] [ -touch ]\n",argv[0]);
    printf("       %s -wlock [ <filesystem> ]\n",argv[0]);
    printf("       %s -wunlock <filesystem>\n",argv[0]);
#else
    printf("usage: %s -help | [ -options ]\n",argv[0]);
#endif
    if ( help ) {
	printf("where:\n");
	HELP_options();
    }
}

/*
 *  sfmake / sfmaked
 *
 *  RETURN
 *	0	successful completion
 *	1	error
 */
main(argc,argv)
int argc;
char *argv[];
{
  boolean show_help,show_options;
#if !defined( DAEMON )
#if defined( TEST )
  boolean syntax;
#endif
  boolean binary,read,ascii,export,import,wlock,wunlock;
  boolean list,remove,touch,pools,users,conf;
  char	  *exporthosts,*importhosts,*wlockstr,*wunlockstr;
#endif
  char	  *shiftascii,*shiftbinary;
  FILE	  *fd;
  int	  counter;

#if !defined( DAEMON )
    locktrace = TRUE;
#endif

 /*
  *  Define the options available
  */
    INIT_options();
    DEFAULT_mask(VMS_MASK);
    DEFAULT_mask(EXTVAL | ENVIR | NAMENV | ALLOC | DESCR | NOPREFIX | HIDDEN);

    ADD_OPT_options(&show_help,&show_options);

    ADD_options("shiftascii",0,STRING,"SHIFTASCII",&shiftascii,SHIFTASCII_DESCR);
    ADD_options("shiftbinary",0,STRING,"SHIFTBINARY",&shiftbinary,SHIFTBINARY_DESCR);
    ADD_options("shiftport",0,INT,"SHIFTMAKEPORT",&shift_port,SHIFTPORT_DESCR);
    ADD_options("shiftlog",0,INT,"SHIFTMAKELOG",&shift_log_size,SHIFTLOG_DESCR);

#if !defined( DAEMON )

    DEFAULT_mask(VMS_MASK);
    DEFAULT_mask(EXTSEL | DESCR);

#if defined( TEST )
    ADD_options("syntax",0,NONE,&syntax,SYNTAX_DESCR);
#endif
    ADD_options("read",0,NONE,&read,READ_DESCR);
    ADD_options("ascii",0,NONE,&ascii,ASCII_DESCR);
    ADD_options("binary",0,NONE,&binary,BINARY_DESCR);
    ADD_options("list",0,NONE,&list,LIST_DESCR);
    ADD_options("remove",NOPREFIX,NONE,&remove,REMOVE_DESCR);
    ADD_options("touch",0,NONE,&touch,TOUCH_DESCR);
    ADD_options("pools",0,NONE,&pools,POOLS_DESCR);
    ADD_options("users",0,NONE,&users,USERS_DESCR);
    ADD_options("conf",0,NONE,&conf,CONF_DESCR);

    DEFAULT_mask(EXTVAL | ALLOC | DESCR);

    ADD_options("export",OPTVAL_S,STRING,&export,&exporthosts,EXPORT_DESCR);
    ADD_options("import",OPTVAL_S,STRING,&import,&importhosts,IMPORT_DESCR);

    ADD_options("wlock",OPTVAL_S,STRING,&wlock,&wlockstr,WLOCK_DESCR);
    ADD_options("wunlock",0,STRING,&wunlock,&wunlockstr,WUNLOCK_DESCR);

#endif

 /*
  *  Initialize the options value before calling READ_options()
  */
    shiftascii = NULL;
    shiftbinary = NULL;
    shift_port = 0;
    shift_log_size = -1;
 /*
  * Trap signal SIGHUP for DAEMON
  */
#if defined(hpux) || ( defined(__osf__) && defined(__alpha) )
        if ( signal(SIGHUP,SIG_IGN) == SIG_ERR) {
                vperror(0,"signal (SIGHUP)");
                sfexit(1);
        }
#endif

#if !defined( DAEMON )

    exporthosts = NULL;
    importhosts = NULL;
    wlockstr = NULL;
    wunlockstr = NULL;

#endif

 /*
  *  Get the option values
  */
    if ( READ_options(argc,argv) < 0 ) {
        usage(argv,FALSE);
	exit(1);
    }

    if ( show_help && NO_opts()==1 ) {
        usage(argv,TRUE);
        exit(0);
    }

    if ( show_options )
        LIST_options();

 /*
  *  Load some missing options from the "/etc/shift.conf" file
  */
    getshiftconf(&shiftascii,&shiftbinary,&shift_port,NULL,&shift_log_size,NULL,(char**)NULL);

 /*
  *  Analyse the user options
  */
    if ( shiftascii == NULL ) {
	fprintf(stderr,"shiftascii missing\nincomplete installation\n");
	exit(1);
    }
    if ( shiftbinary == NULL ) {
	fprintf(stderr,"shiftbinary missing\nincomplete installation\n");
	exit(1);
    }

#if !defined( DAEMON )

  /*
   *  One of these options must be defined
   */
    counter = 0;
#if defined( TEST )
    counter += (syntax?1:0);
#endif
    counter += (read?1:0)+(binary?1:0)+(ascii?1:0)+(export?1:0)+(import?1:0);
    counter += (wlock?1:0)+(wunlock?1:0);

    if ( counter < 1 ) {
	fprintf(stderr,"at least one option missing\n");
        usage(argv,FALSE);
	exit(1);
    }

    if ( counter > 1 ) {
	fprintf(stderr,"too many options\n");
        usage(argv,FALSE);
	exit(1);
    }

    if ( list && !read && 
#if defined( TEST )
			  !syntax && 
#endif
				     !binary ) {
#if defined( TEST )
	fprintf(stderr,"list available with syntax/read/binary options only\n");
#else
	fprintf(stderr,"list available with read/binary options only\n");
#endif
        usage(argv,FALSE);
	exit(1);
    }

    if ( pools && !read ) {
	fprintf(stderr,"pools available with read option only\n");
        usage(argv,FALSE);
	exit(1);
    }

    if ( users && !read ) {
	fprintf(stderr,"users available with read option only\n");
        usage(argv,FALSE);
	exit(1);
    }

    if ( conf && !read ) {
	fprintf(stderr,"conf available with read option only\n");
        usage(argv,FALSE);
	exit(1);
    }

    if ( touch && !export ) {
	fprintf(stderr,"touch available with export option only\n");
        usage(argv,FALSE);
	exit(1);
    }

    if ( remove && !binary ) {
	fprintf(stderr,"remove available with binary option only\n");
        usage(argv,FALSE);
	exit(1);
    }

#endif

    build_shift_paths(shiftascii,shiftbinary,shiftbinary);

#if !defined( DAEMON ) && defined( TEST )

    if ( syntax )
	return( shift_parser(list?stdout:(FILE*)NULL) );

#endif

#if !defined( DAEMON )

    if ( read )
	return( read_binary((list?7:0) | (pools?1:0) | (users?2:0) | (conf?4:0)) );

    if ( binary )
	return( produce_binary(list?stdout:(FILE*)NULL,remove) );

    if ( ascii )
	return( produce_ascii(NULL) );

    if ( export )
	return( export_binary(exporthosts,touch) );

    if ( import )
	return( import_binary(importhosts) );

    if ( wlock || wunlock )
	return( lock_filesystem(wunlock?0:1,wunlock?wunlockstr:wlockstr) );

    return(1);

#else

    return( loop_network(MULTI_THREAD) );

#endif

}
