.\"@(#)sfsyntax.man	3.6 08/20/93  CERN-SW/DC Fabrizio Cane
.\ Copyright (C) 1992 by CERN/CN/SW/DC
.\ All rights reserved
.\"
.nh
.TH SFSYNTAX l "20/10/92"
.SH NAME
sfsyntax \- Shift DPM configuration syntax
.SH DESCRIPTION
The Shift DPM configuration is defined in five ascii configuration files:
.br
.LP
.RB " 1. The" " Resource Configuration File"
, which defines disk pools and their attributes.
.br
.RB " 2. The" " Pool Access Control File"
, which may restrict pool access to specific users and groups.
.br
.RB " 3. The" " Defaults File"
, which is used to define global defaults for the other DPM configuration files.
.br
.RB " 4. The" " Process Configuration file"
, which defines the DPM processes configuration ( sfget(1), sfrm(1), sfsh(1), sfgc(1), 
sfdpmd(1) ).
.br
.RB " 5. The " " shift configuration file",
, which is used to store all the SHIFT parameters for the whole SHIFT software.
.br
.SH 1- RESOURCE CONFIGURATION FILE
This file ( shift.pools ) defines the 
.I shift
disk servers, file systems and pools. There are three types of entry: 
.BR SERVER ", " POOL " and " SUPERPOOL "."
The SERVER entry defines the name of a disk server and its 
.I shift 
file systems. The POOL entry specifies the name of a disk pool, whether it is temporary 
(garbage-collected) or not, whether it is public or private, and specifies the list of 
file systems which form the pool. If the pool is temporary the garbage collector policy 
is defined by specifying two space thresholds to the 
.B COLLECT 
parameter. 
.I gcmax 
defines the maximum space utilisation of the pool as a percentage of its total 
capacity. If the space usage rises above this level when the garbage collector 
executes, files will be removed from the pool until the utilisation level falls 
below the 
.I gcmin 
threshold. A 
.B SIZE 
parameter may also be specified, which defines a maximum size for
any individual file in the pool. The SUPERPOOL entry specifies the name of a pool set
and its access policy. The access to the superpool is defined by two binary operators:
the union operator (
.B +
) specifies that the left element has the same access priority as for 
the right element; the sequence operator (
.B :
) specifies that the left element has a higher priority than
the right element.
.LP
.B BNF Syntax
.LP
shiftconfig 	::=  serverconfig { serverconfig } poolconfig { poolconfig } { superpoolconfig }
.B END
.br
serverconfig	::= 
.B \ SERVER 
servername mountpath filesystem { filesystem }
.br
poolconfig	::=  
.B \ POOL
poolname poolattribute poolfilesystem { poolfilesystem }
.br
superpoolconfig	::=  
.B \ SUPERPOOL
superpoolname superpoolelem { superpoolprty superpoolelem }
.br
poolfilesystem	::=  servername filesystem
.br
filesystem	::=  filesystempath | filesystempath filesystemattr
.br
filesystemattr	::=  
.B \ WLOCK
.br
poolattribute	::=  { timeattribute | accessattribute | collectattribute |
sizeattribute }
.br
timeattribute	::=  
.BR \ PERMANENT "  |  " TEMPORARY
.br
accessattribute	::=  
.BR \ PRIVATE "  |  " PUBLIC
.br
collectattribute	::=  
.BR " COLLECT ( " gcmin " : " gcmax " )"
.br
sizeattribute	::=  
.BR " SIZE ( " non-negative-number " )"
\ |
.BR " SIZE ( " "non-negative-number unitcharacter" " )"
.br
unitcharacter	::=  
.BR " M" " | " K
.br
superpoolelem	::=  superpoolname | poolname
.br
superpoolprty	::=  + | :
.br
servername	::=  id
.br
poolname	::=  id
.br
superpoolname	::=  id
.br
mountpath	::=  path
.br
filesystempath	::=  path
.br
path		::=  / id { / id }
.br
id		::=  { digit | \- } ( letter | _ ) { letter | digit | \- | _ }
.br
.LP
where the following constraints are added:
.br
.LP
 - servername must be a valid host name
.br
 - either 0 <= gcmin < gcmax <= 100 or 0 = gcmin = gcmax (no default garbage 
collection policy)
.br
 - any of the poolattribute cannot be repeated even if specified in the defaults file
.br
 - poolfilesystem must be a valid tuple (i.e the server and its filesystem must be
previously declared)
.br
.LP
The full pathname of a file system is generated as the concatenation of 
mountpath + filesystem.
.LP
.BR "* The tokens PRIVATE/PUBLIC :"
.br
.LP
These words specify the access rights to the pool: 
All the users cannot garbage a pool or get a file path in any pool without beeing 
explicitly authorized in the configuration file listing the authorized users 
(see "POOL ACCESS CONTROL FILE", chapter 2 of this manual).
When a pool is declared PRIVATE, this file will be consulted before any access is allowed. The default is specified in the "default" file. When a pool is declared PUBLIC, it is equivalent to authorizing anyone to create or delete files into it.
.LP
.BR "* The tokens TEMPORARY/PERMANENT :"
The only kinds of pools which can be "garbage collected" are the TENPORARY pools,
because they contain data wich is not permanent: When a pool is "PERMANENT" the
garbage collector cannot be activated.
.LP
.BR "* The token WLOCK: "
.br
.LP
it can either be placed in front of a subdirectory of a pool, such as:
.LP
SERVER shift1 /shift/shift1
 /data1		WLOCK
 /data2
.LP 
either into the POOL declaration, such as:
.LP
POOL test 
shift1 	/data2
shift1 	/data1 	WLOCK
.LP
In both cases, it specifies that no file can be created or deleted
in this pool. So the sfget  and sfgc commands would not work. We point out
on the fact the double specification syntax mentionned above enables
to specify that a file system can be part of 2 different pools, and only in 
"read" mode for one of them.
.br
.LP
.B EXAMPLE:
.LP
.ps -2
SERVER  shift1  /shift/shift1
.br
    /data1
.br
    /data2
.br
    /data3
.br
SERVER  shd01  /shift1/shd01
.br
    /data1
.br
    /data4
.br
    /data5
.br
POOL  public  TEMPORARY  PUBLIC  COLLECT(50:80)  SIZE(250M)
.br
    shift1	/data1
.br
    shd01	/data4
.br
    shd01	/data5
.br
POOL  test  PERMANENT  PRIVATE  COLLECT(0:0)  SIZE(50K)
.br
    shd01	/data1
.br
    shift1	/data3
.br
POOL  shift1  TEMPORARY  PRIVATE
.br
    shift1	/data2
.br
SUPERPOOL  cern  public+shift1+test
.br
SUPERPOOL  opal  shift1:public
.br
END
.ps +2
.LP
.br
.SH 2- POOL ACCESS CONTROL FILE 
.br
This file ( shift.users ) defines the users who are permitted to allocate files in private pools. 
Each entry consists of a pool name and a list of group/user names. Each group and 
user name must be able to be translated into a Unix 
.IR gid " or " uid
by the 
.IR getgrnam " and " getpwnam 
functions. A groupname of 
.B *
means that the following list of users may belong to any group. If a groupname is 
specified a check will be performed that each user belongs to the specified group. 
All users in a group may be selected by means of an 
.BR * .
Users who are authorized to initiate the garbage collector for a pool are specified
by means of the 
.B G 
option.
.LP
.B BNF Syntax
.LP
shiftaccount	::=  poolaccount { poolaccount }
.B END
.br
poolaccount	::= 
.B \ POOL 
poolname account { account }
.br
poolname	::=  ( see the resource configuration syntax )
.br
account		::= 
.RB " groupaccount" " : " useraccount
.br
groupaccount	::= 
.BR " *" " | groupname |" " *(G)" " | groupname" "(G)"
.br
useraccount	::= 
.BR " *" " | username |" " *(G)" " | username" "(G)"
.br
groupname	::=  id
.br 
username	::=  id
.br
id		::=  ( see the resource configuration syntax )
.br
.LP
where the following constraints are added:
.br
.LP
 - poolname must be a valid pool (i.e. previously declared in the shift resource
configuration)
 - groupname must be a valid group name on the local host
 - username must be a valid user name on the local host
.br
.LP
.B EXAMPLE
.LP
.ps -2
POOL  public
.br
  ws : * , panzer(G)
.br
    * : root(G)
.br
POOL  public
.br
    * : *
.br
POOL  shift1
.br
  ws : *
.br
  c3 : acher, gordon , cane , hemmer , les
.br
    * : root(G)
.br
END
.ps +2
.LP
.SH 3- DEFAULTS FILE
This file ( shift.defaults ) specifies default values for the above configuration 
files. At present defaults may be specified only for the pool attributes.
.LP
.B BNF Syntax
.LP
shiftdefaults	::=  poolattribute 
.B END
.br
poolattribute	::=  ( see the resource configuration syntax )
.br
.LP
.B EXAMPLE
.LP
.ps -2
PERMANENT
.br
PRIVATE
.br
SIZE(0)
.br
END
.ps +2
.LP
.SH 4- PROCESS CONFIGURATION FILE
This file ( shift.pairs ) defines the configuration of the DPM processes. 
The configuration is a 
set of values identified by an item name and a category name ( see getconfent(2) ).
.LP
.B BNF Syntax
.LP
shiftpair		::=  categorylist
.br
categorylist	::= 
.B \ CATEGORY 
categoryname itemlist { 
.B CATEGORY 
categoryname itemlist }
.br
categoryname	::=  id
.br
itemlist		::=  itemvalue hostlist { itemvalue hostlist }
.br
itemvalue	::=
.RB " itemname" " :" " | itemname" " : " value
.br
itemname	::=  id
.br
hostlist    	::= 
.BR " (" " hostvalue { hostvalue } " )
.br
hostvalue	::= 
.RB " hostname" " :" " | hostname" " : " value
.br
hostname	::=  id
.br
value		::=  the sequence of ascii-character until the end of line
.br
id		::=  ( see the resource configuration syntax )
.br
.LP
.B EXAMPLE
.LP
.ps -2
category  DPM
  OPTIONSTYLE : unix
  DEFPOOL    : public
  (
    rigel    : test
  )
  DEFSIZE    : 200M

category  RFIO
  IOBUFSIZ   : 131072
  NDPRIORITY : 30
.br
.LP
.BR "CATEGORY DPM"
.br
.LP
This is the list of items required by the dpm processes. Each line shows the item name
followed by the value syntax and a reference to other manual pages.
.br
.LP
.ta 1.5iC 4.0iC
OPTIONSTYLE	
.BR xwindow " | " unix	
sfoptions(1)
.br
DEFPOOL	
poolname	
sfget(1), sfrm(1), sfsh(1)
.br
DEFSIZE	
( see sfget size option )	
sfget(1) 
.br
SFGETMODE	  (
.BR remote " | " local
) (
.B atomic " | " noatomic
)    sfdpmd(1), sfget(1)
.br
SFRMMODE	
.BR remote " | " local	
sfdpmd(1) 
.br
SFSHMODE	
.BR remote " | " local	
.br
SFDAEMONS	
.RB "hostname {" " : " "hostname }"	
sfdpmd(1) 
.br
REMOTESFSH	
.BR yes " | " no	
sfdpmd(1) 
.br
RHOSTSFSH	
hostname	
sfdpmd(1) 
.br
.LP
.br
.LP
.ta 1.5iC 3.5iC
TMPTIMEOUT	
positive-integer	
1
.br
TMPRETRY	
non-negative-integer	
10
.br
SFDEBUG	
.BR yes " | " no	
no
.br
RESIDENT	
.BR yes " | " no	
no
.br
.nh
.LP
We comment below some of these parameters with details and examples:
.LP
.BR "* RESIDENT :"
.br
.LP
This is to be set only for SGI machines, on which a simple call 
enables to lock into memory the daemon code and avoid it to be swapped.
.nh
.LP
.BR "* TMPTIMEOUT <integer> :"
.br
.LP
This is the number of seconds that sfget  leaves between two open() of some file
that sfget temporary creates to store internal information. 
.br
.nh
.LP
.BR "* TMPRETRY <integer> :"
.br
.LP
For an sfget command, wether it is local or remote (performed by sfdpmd), this 
is the number of times that sfget retries to open() the temporary files mentioned
( see TMPTIMEOUT) before sending a message of failure.
.br
.nh
.LP
.BR "* SFDEBUG <string>: "
.br
.LP
The following string is "yes" or "no". When an sfget or sfrm command is issued, the dpm
checks that the user is allowed to request the dpm service on this pool, by a check in
the configuration files. If the user is not allowed and the SFDEBUG is set no "yes",
then this user can perform his request.
.br
.nh
.LP
.BR "* OPTIONSTYLE <string> : "
.br
.LP
This option is specifying the type of cammands accepted by the dpm tools. The string 
cant take the value "xwindow" or "unix". The unix style means that the options are
short: for example: sfget -s 10 filename, where -s replaces -size. In "xwindow" style
the command would have been: sfget -size 10 filename.
.br
.nh
.LP
.BR "* DEFPOOL <string> :"
.br
.LP
this option specifies the default pool to be used when the pool is not specified.
It is active only for sfrm, sfget, and sfsh. It has to be specified inside the
"shift.pairs" configuration file. Exceptions can be mentioned with the usual dpm syntax:
.LP
.ps -2
category  DPM
  DEFPOOL    : public
  (
    rigel    : test
  )
.br
This means that the default pool is always "public" except on the machine named 
"rigel", it is the pool "test".
.br
.nh
.LP
.BR "* DEFSIZE <string> :"
.br
.LP
The DEFSIZE entry specifies the default size chosen for a file when an sfget is 
issued and the -s(ize) option is not specified in the command line. It has to be 
specified inside the
.I "shift.pairs" 
configuration file. Exceptions can be mentioned with the usual dpm syntax:
.LP
.ps -2
category  DPM
  DEFSIZE    : 10M
  (
    rigel    : 100M
  )
.br
This means that an "sfget filename" command will search for a path allowing 
to store 10 Megabytes on any machine, except 100 Megabytes if the sfget is executed
on the machine named rigel.
.br
.nh
.LP
.BR "* SFGETMODE <string> : "
.br
.LP
It specifies where and how the command will be issued. The wildcard like value of this
entry is:
.br
(
.I remote
|
.I local
)
(
.I atomic
|
.I noatomic
). 
.br
It has a meaning only for the sfget command. If remote is specified, the command will be
performed on the host declared by the entry SFDAEMONS of the configuration file, and the 
result will be returned to the caller. "atomic" specifies that only one sfget can be performed
at a given time. This implies setting a lock of the configuration files until the sfget is
complete. It garanties that no peer of user can create the same file name in two parts of a 
pool in the same time. The "noatomic" option disables the lock on configuration files, and 
collision might happen in case of an intensive use. We have to point out that the lock file generated for preventing these problems of concurrency is located in the file path specified in the /etc/shift.conf file by the entry SHIFT BINARY <path> (See chapter 5 of this manual). If a pool is NFS-visible from several machines, it is strongly recommanded to concentrate all the sfget commands on one host only, by using the SFGETMODE atrtribute on the other machines. This way, the sfget commands would be always executed 
on one host, and concurrency problems would be reduced.
.br
.nh
.LP
.BR "* SFRMMODE <string> : "
.br
.LP
The string takes two values: "remote" or "local".
If remote is specified, the command will be
performed on the host declared by the entry SFDAEMONS of the configuration file, and the
result will be returned to the caller.
.br
.nh
.LP
.ul
.BR "* SFSHMODE <string> : "
.br
.LP
This SFSHMODE value concerns only sfsh commands not having the -s(pace) option
( requests for remaining disk space are performed locally as the file systems are
NFS-visible ).
That command specifies that the sfsh command is  executed either locally 
(SFSHMODE : local) either remotely using the locally
available remote shell. If REMOTESFSH is  not set to "yes" then the local shell
executes the requested command.  In this case, IF REMOTESHSH is set to "yes" and:
.LP
-either the option -r(sh) is set,
.LP
-either the SFSHMODE is set to "remote", 
.LP
then the server specified by RHOSTSFSH (or by the environment variable SHIFTRHOSTSFSH if it 
is set)  will be called with the rsh command: "rsh <HOST> <COMMAND>". On the opposite of the
sfrm and sfget commands, the sfdpmd daemon is never called for a sfsh command. requestors
should be aware that if the rsh is called (see above the different cases), the sfsh command 
will only return its output of rsh.
.LP
.br
.nh
.BR "* SFDAEMONS <string1> <string2> ....<stringN>"
.br
.LP
N is bound by 32. When a command sfrm, sfget, or sfsh is performed, if the command is 
declared "remote", then it is executed on the first available sfdpmd daemon of the list.
An exception syntax is suppoted:
.LP
.ps -2
category  DPM
   SFDAEMONS: shift1 shift2 shift3
  (
    rigel    : shift3
  )
.br
It means that in all cases, the sfdpmd used is going to be the one from shift1, or if unavailable the one from shift2, etc. Except in the case where the command is issued on rigel,
the remote sfdpmd started is the one from shift3.
.br
.LP
.SH 5- THE CONFIGURATION FILE FOR SHIFT
.br
.LP
This  part is a catalog for all the parameters that the dpm software is
loading at run-time in the /etc/shift.conf file.
.LP
.br
.RB "* SHIFT ASCII < path > :" 
.br
This entry specifies the path for the ascii files of the configuration of the DPM
software. When a " "sfmake -a(scii)" is performed, the sfmake looks in the
directory specified for the ascii files.
.br
.nh
.LP
.RB "* SHIFT BINARY < path >"
.br
This entry specifies the path to store the binary files when exported/imported by the
sfmaked daemon, the log files for the sfdpmd if any, and the temporary files created
for the needs of the concurency handling when several sfget or sfmake commands are
likely to start at the same time.
.LP
.br
.RB "* SHIFT DPMLOG < int > : "
.br
This entry specifies the maximum size in bytes for the log file of the sfdpmd daemon.
if unspecified, no log is generated.
.LP
.br
.RB "* SHIFT MAKELOG <int > : "
.br
This entry specifies the maximum size in bytes for the log file of the sfmaked daemon.
if unspecified, no log is generated.
.LP
.br
.RB "* SHIFT DPMPORT <Port_number>: "
.LP
.br
This entry in the file can be set to modify the PORT on which the sfdpmd listens. It should be specified before starting the daemon.
.LP
.RB "* SHIFT MAKEPORT <Port_number>: "
.LP
.br
this entry in the file can be set to modify the PORT on which the sfmaked listens. It should be specified before starting the daemon.
.LP
.br
.RB "* SHIFT LOCALHOST < string >: "
.br
.LP
It is used to overide the local host name. When this name does not correspond to any
host name having received the configuration, all the commands needing to load the 
configuration would fail.

.LP
.br

.br
.br
.SH SEE ALSO
sfmake(1), sfget(1), sfsh(1), sfrm(1), sfgc(1), sfdpmd(1), sfoptions(1)
.SH AUTHORS
Fabrizio Cane, CERN-CN Division CH-1211 Geneva 23, Switzerland (cane@cernvm.cern.ch)
.LP
Felix Hassine, CERN-CN Division CH-1211 Geneva 23, Switzerland (acher@sun2.cern.ch)


