/*
 * Copyright (C) 1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)user.c	3.1 06/16/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <pwd.h>
#include <grp.h>
#include <user.h>

/*
 *
 */
int get_userbyname(name,uid,gid)
char  *name;
int   *uid,*gid;
{
  static struct passwd  *useri;

    if ( (useri = (struct passwd *)getpwnam(name)) == NULL )
               return( -1 );

    if ( uid != NULL )   *uid = useri->pw_uid;

    if ( gid != NULL )   *gid = useri->pw_gid;

    return( 1 );
}

/*
 *
 */
int get_userbyid(name,uid)
char  *name;
int   uid;
{
  static struct passwd  *useri;

    if ( (useri = (struct passwd *)getpwuid(uid)) == NULL )
	return( -1 );

    strcpy(name,useri->pw_name);

    return( 1 );
}

/*
 *
 */
int get_groupbyname(name,gid)
char  *name;
int   *gid;
{
  static struct group  *groupi;

    if ( (groupi = (struct group*)getgrnam(name)) == NULL )
	return( -1 );

    *gid = groupi->gr_gid;

    return( 1 );
}

/*
 *
 */
int get_groupbyid(name,gid)
char  *name;
int   gid;
{
  static struct group  *groupi;

    if ( (groupi = (struct group*)getgrgid(gid)) == NULL )
	return( -1 );

    strcpy(name,groupi->gr_name);

    return( 1 );
}

/*
 *
 */
int get_allbyuid(user,group,gid,uid)
char  *user;
char  *group;
int   *gid;
int   uid;
{
  static struct passwd  *useri;

    if ( (useri = (struct passwd *)getpwuid(uid)) == NULL )
	return( -1 );

    if ( user != NULL )   strcpy(user,useri->pw_name);

    if ( gid != NULL )   *gid = useri->pw_gid;

    if ( group != NULL )   return( get_groupbyid(group,useri->pw_gid) );

    return( 1 );
}

/*
 *
 */
int get_shiftuserbyname(user,uid)
char  *user;
int   *uid;
{
    if ( !strcmp(user,ANY_USER) ) {
	*uid = ANY_UID;
	return( 1 );
    }
    else
	return( get_userbyname(user,uid,NULL) );
}

/*
 *
 */
int get_shiftuserbyid(user,uid)
char  *user;
int   uid;
{
    if ( uid == ANY_UID ) {
	strcpy(user,ANY_USER);
	return( 1 );
    }
    else
	return( get_userbyid(user,uid) );
}

/*
 *
 */
int get_shiftgroupbyname(group,gid)
char  *group;
int   *gid;
{
    if ( !strcmp(group,ANY_GROUP) ) {
	*gid = ANY_GID;
	return( 1 );
    }
    else
	return( get_groupbyname(group,gid) );
}

/*
 *
 */
int get_shiftgroupbyid(group,gid)
char  *group;
int   gid;
{
    if ( gid == ANY_GID ) {
	strcpy(group,ANY_GROUP);
	return( 1 );
    }
    else
	return( get_groupbyid(group,gid) );
}

