/*
 * Copyright (C) 1990,1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)dump.c	3.2 11/02/93 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <shift_types.h>

#define BYTEPERLINE	8

/*
 *
 */
int sxtoi(s)
char  *s;
{
  int n;
  char c;

    if ( (int) strlen(s) > 0 ) {
	if ( (c=s[strlen(s)-1]) <= '9' )
	    n = c - '0';
	else
	    n = c - 'a' + 10;
	if ( (int)strlen(s) > 1 )
	    if ( (c=s[strlen(s)-2]) <= '9' )
		n += (c - '0')*16; 
	    else
		n += (c - 'a' + 10)*16;
	return(n);
    }
    return(-1);
}     

#if defined( cray )

/*
 *
 */
void printcrayptr(p)
char  *p;
{
  int base;
  int offset;
  
    offset = (((int)p) & (0xFFFFFFFF << 32)) >> 61;
    base = ((int)p) & 0xFFFFFFFF;
    printf("%10d:%d",base,offset);
}

#endif

/*
 *  Convert a pointer to an integer
 */
int pointertoi(p)
char *p;
{
#if defined( cray )

  int base;
  int offset;

    offset = (((int)p) & (0xFFFFFFFF << 32)) >> 61;
    base = ((int)p) & 0xFFFFFFFF;
    return( base*8+offset );

#else

  return( (int)p );

#endif
}

/*
 *  Dump a memory area
 */
print_dumpmem(buff,len_buff)
char  *buff;
int   len_buff;
{
  int i,l;
  char *p = buff;
  char s[10];


#if defined( cray )

  printf("DUMP at ");
  printcrayptr(buff);
  printf(" -> ");
  printcrayptr(buff+len_buff);
  printf(" (len:%d)\n",len_buff);

#else

  printf("DUMP at %x -> %x (len:%d)\n",buff,buff+len_buff,len_buff);

#endif

  l = 0;
  while ( l < len_buff )
  {

#ifndef cray
    printf("%12x - ",p);
#else
    printcrayptr(p); printf(" - ");
#endif

    i = 0;
    while ( i <  BYTEPERLINE  &&  i+l < len_buff )
    {  

#ifndef cray
        	sprintf(s,"%x",buff[i+l]); 
        printf("%4d",sxtoi(s));
#else
       printf("%4d",buff[i+l]);
#endif
       i++;

    }

    printf("\n%15s","");

    i = 0;
    while ( i <  BYTEPERLINE  &&  i+l < len_buff )
    {  

        if ( isprint(buff[i+l]) )  {
                 printf("%4c",buff[i+l]);
	}
        else {
                 printf("%4s","");
	}
       i++;

    }

    printf("\n");


    l += i;
    for (i=0; i<l; i++) p++;

  }

  printf("\n");

}

