/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = " @(#)flock.c	3.2 05/07/93  CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#if defined (SOLARIS)
extern int errno;
#endif

#if defined(SOLARIS)
#include <sys/types.h>
#include <unistd.h>
#endif

#if defined( hpux ) || defined (SOLARIS)

#include <fcntl.h>
#include <errno.h>
#include <flock.h>

/*
 *  flock() missing on the HP
 */
int flock(fd,operation)
int fd,operation;
{
  static struct flock lock = { 0, SEEK_SET, 0, 0,
#ifdef _CLASSIC_ID_TYPES
						  0, 0
#else
						  0
#endif
							} ;

    switch ( operation & ~LOCK_NB ) {
	case LOCK_SH :
		lock.l_type = F_RDLCK;
		return( fcntl(fd,operation & LOCK_NB ? F_SETLK : F_SETLKW,&lock) );
	case LOCK_EX :
		lock.l_type = F_WRLCK;
		return( fcntl(fd,operation & LOCK_NB ? F_SETLK : F_SETLKW,&lock) );
	case LOCK_UN :
		lock.l_type = F_UNLCK;
		return( fcntl(fd,operation & LOCK_NB ? F_SETLK : F_SETLKW,&lock) );
	default :
		errno = EINVAL;
		return(-1);
    }
}

#endif
