/*
 * Copyright (C) 1990,1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)futil.c	3.2 06/24/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <shift_types.h>

static struct stat stat_buffer;

/*
 *
 */
int fdtono(fd)
FILE *fd;
{
  int nd;
    return( ( fd != NULL && (nd = fileno(fd)) > -1 && fd->_flag > 0 ) ? nd : -1 );
}

#if defined ( __INT_FDTONO__ )

#if defined( ultrix ) || defined( sun )
static int nofile = 0;
#else
static int nofile = NOFILE;
#endif

/*
 *  Returns the integer file descriptor associated with the stream.
 *
 *  The subroutine fileno() does the same but this function doesn't crash 
 *  when the argument is invalid and returns error when the stream is closed
 *
 *	SYSTEM			WORKING RANGE
 *
 *	 SGI			ok ( in 0..19 )
 *	 ULTRIX			ok ( in 0..63 )
 *	 APOLLO (DN10K)		ok ( in 0..127 )
 *	 SUN			ok in 0..31 and error in 32..63
 *	 HP-UX			ok in 0..7 and error in 8..59
 *	 IBM (RS6000)		
 *
 *  INPUT
 *	fd			stream descriptor address
 *
 *  RETURN
 *	ERROR			invalid stream descriptor / stream closed
 *	otherwise		the stream descriptor index
 */
int fdtono(fd)
FILE *fd;
{
  static int idx;
#if defined( ultrix )
  extern FILE **_iob_start;
  extern FILE **_iob_end;
#endif

    if ( fd == NULL ) return(-1);

#if defined( ultrix ) || defined( sun )
    if ( !nofile ) 
	nofile = getdtablesize();
#endif

#if defined( ultrix )
    if ( _iob_start == NULL ) {
	for(idx=0; idx<_N_STATIC_IOBS; idx++)
	    if ( &_iob[idx] == fd && fd->_flag > 0 )
		return(_iob[idx]._file);
    }
    else
	for(idx=0; idx<nofile; idx++)
	    if ( _iob_start[idx] == fd && fd->_flag > 0 )
                return(_iob_start[idx]->_file);
#else
    for(idx=0; idx<nofile; idx++)
	if ( &_iob[idx] == fd && fd->_flag > 0 )
#if defined( hpux )
	    return(_iob[idx].__fileL);
#else
	    return(_iob[idx]._file);
#endif
#endif
    return(-1);
}

/*
 *  Do the opposite of notofd()
 *
 *  INPUT
 *	idx		stream descriptor index
 *
 *  RETURN
 *	NULL		invalid stream descriptor index
 *	otherwise	the stream descriptor address
 */
FILE *notofd(idx)
int idx;
{
#if defined( ultrix ) || defined( sun )
    if ( !nofile ) 
	nofile = getdtablesize();
#endif
#if defined( ultrix )
    if ( _iob_start == NULL )
	return(idx < _N_STATIC_IOBS ? &_iob[idx] : (FILE*)NULL);
    else
	return(idx < nofile ? _iob_start[idx] : (FILE*)NULL);
#else
    return(idx < nofile ? &_iob[idx] : NULL);
#endif
}

#endif

/*
 *
 */
long filesize(path)
char *path;
{
    return( stat(path,&stat_buffer) < 0 ? ERROR : (long)stat_buffer.st_size );
}

/*
 *
 */
long fsize(fd)
FILE *fd;
{
  static long size;
  static long pos;

    pos = ftell(fd);
    fseek(fd,0,2);
    size = ftell(fd);
    fseek(fd,pos,0);
    return( size );
}

