/*
 * Copyright (C) 1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)pktutil.c	3.5 05/28/93  CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#if defined( _AIX ) && defined( _IBMR2 )
#include <sys/select.h>
#endif
#include <netinet/in.h>
#include <errno.h>
#if !defined( sgi )
#include <signal.h>
#else
#define _BSD_SIGNALS
#if defined( __STDC__ )
#undef __STDC__
#include <signal.h>
#define __STDC__
#else
#include <signal.h>
#endif
#endif
#include <shift_types.h>
#include <strerror.h>
#include <osdep.h>
#include <marshall.h>
#include <sockutil.h>
#include <strutil.h>
#include <pktutil.h>
#if defined(SOLARIS)
#include <sys/filio.h>
#endif

#ifdef PKTUTILTRACE

boolean pktutiltrace = FALSE;
boolean pktutildump = FALSE;

#endif

#if defined(_AIX) || defined(ultrix) || defined(sgi) || defined(sun) || defined(hpux)

static boolean signal_pipe_flag = FALSE;

#if defined ( _SIGPIPE_HANDLER_ )

/*
 *  SIGPIPE handler
 */ 
#if defined( sgi ) || defined( apollo )
static int 
#else
static void
#endif
SIGPIPE_handler()
{
#if defined( hpux )
        signal((int)SIGPIPE,SIGPIPE_handler);
#endif
 /*
  *  Do nothing
  */
}

#endif /* _SIGPIPE_HANDLER_ */

/*
 *  Ignore or handle the signal SIGPIPE
 */
static void set_signal_pipe()
{
#if defined( _SIGPIPE_HANDLER_ )
#if defined( cray )
        sigctl(SCTL_REG,SIGPIPE,SIGPIPE_handler);
#else
        signal((int)SIGPIPE,SIGPIPE_handler);
#endif
#endif

#if !defined( _SIGPIPE_HANDLER_ )
#if defined( cray )
        sigctl(SCTL_IGN,SIGPIPE,NULL);
#else
        signal((int)SIGPIPE,SIG_IGN);
#endif
#endif
        signal_pipe_flag = TRUE;
}

#endif /* systems having a killing SIGPIPE */

/*
 *  Read length bytes from the socket descriptor sock using a timeout
 *
 *  INPUT
 *	sock            the socket descriptor
 *	buffer          pointer to an allocated buffer
 *	length          number of bytes to read
 *	flags           recv() flags
 *
 *  RETURN
 *	EPKTOK		successful completion (bytes copied in the buffer)
 *	EPKTZERO	received a zero-message
 *	EPKTWAIT	the timeout expired
 *	EPKTFAIL	an error occured
 *
 *  ERRORS
 *			see ioctl() errors
 *			see recv() errors
 */
int sread(sock,buffer,length,flags)
int sock;
char *buffer;
int length;
int flags;
{
  fd_set rmask;
  int read;
  int nbytes;
  int blocking = 0 ;
  int nonblocking = 1;
  boolean timedout = FALSE;
  boolean zeromsg = FALSE;
  boolean error = FALSE;

 /*
  *  Set the socket for non-blocking I/O
  */
    if ( ioctl(sock,(int)FIONBIO,&nonblocking) < 0 ) {
	vperror(1,"ioctl(%d)",sock);
	return(EPKTFAIL);
    }

 /*
  *  Initialize the sread loop
  */
    read = 0;
    FD_ZERO(&rmask);
    FD_SET(sock,&rmask);

    do {

	nbytes = recv(sock,buffer+read,length,flags);

     /*
      *  If a zero-message is received then exit the loop and return EPKTZERO
      */
	if ( zeromsg = !nbytes )
	    vperror(0,"recv(%d): zero-message received",sock);

     /*
      *  If an error occured then check the errno
      */
	if ( nbytes < 0 ) {

	    switch ( errno ) {

	     /*
	      *  If there is no data in the socket queue then wait on the select()
	      */
#if !defined( _IBMESA ) 
		case EAGAIN :			/* System V-style  -  stream */
#endif
#if !defined(SOLARIS) && !defined(IRIX5) && ! ( defined(__osf__) && defined(__alpha) )
#if !defined( _AIX ) || !defined( _ALL_SOURCE ) 
		case EWOULDBLOCK :		/* 4.2BSD-style    -  stream */
#endif
#endif /* ! SOLARIS */
			switch ( select(sock+1,
					&rmask,
					(fd_set*)NULL,
					(fd_set*)NULL,
					get_timeout()) ) {
			    case -1 :
				vperror(1,"select(%d)",sock);
				error = TRUE;
				break;
			    case 0 :
				vperror(0,"sread(%d): select timed out",sock);
				timedout = TRUE;
				break;
			} /* switch - select()'s reply */
			break;

	     /*
              *  If an interrupt stopped the recv() then call it again
              */
		case EINTR :
			break;

	     /*
	      *  If an error occured during the recv() call then
	      *  exit the loop and return EPKTFAIL
	      */
		default :
			vperror(1,"recv(%d)",sock);
			error = TRUE;
                        break;

	    } /* switch - errno */

	}

     /*
      *  If some data was received
      */
        if ( nbytes > 0 ) {
	    length -= nbytes;
            read += nbytes;
	}

 /*
  *  Loop until either the timeout expires or sread() reads all data requested or
  *  a zero-message is received or an error occured
  */
    } while ( length > 0  &&  !error  &&  !zeromsg  &&  !timedout );

 /*
  *  Set the socket for blocking I/O
  */
    if ( ioctl(sock,(int)FIONBIO,&blocking) < 0 )
	vperror(1,"ioctl(%d)",sock);

 /*
  *  Return the appropriate value
  */
    if ( error ) return(EPKTFAIL);

    if ( timedout ) return(EPKTWAIT);

    if ( zeromsg ) return(EPKTZERO);

    return(EPKTOK);
}

/*
 *  Write length bytes to the socket descriptor sock using a timeout
 *
 *  INPUT
 *	sock            the socket descriptor
 *	buffer          pointer to the data
 *	length          number of bytes to write
 *	flags           send() flags
 *
 *  RETURN
 *	EPKTOK		successful completion (bytes written to the socket)
 *	EPKTPIPE	the socket stream is closed (EPIPE)
 *	EPKTWAIT	the timeout expired
 *	EPKTFAIL	an error occured
 *
 *  ERRORS
 *			see ioctl() errors
 *			see send() errors
 */
int swrite(sock,buffer,length,flags)
int sock;
char *buffer;
int length;
int flags;
{
  fd_set wmask;
  int written;
  int nbytes;
  int blocking = 0 ;
  int nonblocking = 1;
  boolean timedout = FALSE;
  boolean error = FALSE;
  boolean pipe = FALSE;

#if defined(_AIX) || defined(ultrix) || defined(sgi) || defined(sun) || defined(hpux)
 /*
  *  On some Systems you need to ignore or handle the signal SIGPIPE
  */
    if ( !signal_pipe_flag )   set_signal_pipe();
#endif

 /*
  *  Set the socket for non-blocking I/O
  */
    if ( ioctl(sock,(int)FIONBIO,&nonblocking) < 0 ) {
	vperror(1,"ioctl(%d)",sock);
	return(EPKTFAIL);
    }

 /*
  *  Initialize the swrite loop
  */
    written = 0;
    FD_ZERO(&wmask);
    FD_SET(sock,&wmask);

    do {

	nbytes = send(sock,buffer+written,length,flags);

     /*
      *  If an error occured then check the errno
      */
	if ( nbytes < 0 ) {

	    switch ( errno ) {

	     /*
	      *  If no data could be written immediately then wait on the select()
	      */
#if !defined( _IBMESA )
		case EAGAIN :			/* System V-style  -  stream */
#endif
#if !defined(SOLARIS) && !defined(IRIX5) && ! ( defined(__osf__) && defined(__alpha) )
#if !defined( _AIX ) || !defined( _ALL_SOURCE )
		case EWOULDBLOCK :		/* 4.2BSD-style    -  stream */
#endif
#endif /* SOLARIS */
			switch ( select(sock+1,
					(fd_set*)NULL,
					&wmask,
					(fd_set*)NULL,
					get_timeout()) ) {
			    case -1 :
				vperror(1,"select(%d)",sock);
				error = TRUE;
				break;
			    case 0 :
				vperror(0,"swrite(%d): select timed out",sock);
				timedout = TRUE;
				break;
			} /* switch - select()'s reply */
			break;

	     /*
	      *  If the socket stream is closed (EPIPE) then
	      *  exit the loop and return EPKTPIPE
	      */
		case EPIPE :
			vperror(0,"send(%d): signal SIGPIPE received",sock);
			pipe = TRUE;

	     /*
              *  If an interrupt stopped the send() then call it again
              */
		case EINTR :
			break;

	     /*
	      *  If an error occured during the send() call then
	      *  exit the loop and return EPKTFAIL
	      */
		default :
			vperror(1,"send(%d)",sock);
			error = TRUE;
                        break;

	    } /* switch - errno */

	}

     /*
      *  If some data was written on success
      */
        if ( nbytes > 0 ) {
	    length -= nbytes;
            written += nbytes;
	}

 /*
  *  Loop until either the timeout expires or swrite() writes all
  *  data requested or an error occured or the socket stream is closed
  */
    } while ( length > 0  &&  !error  &&  !timedout  &&  !pipe );

 /*
  *  Set the socket for blocking I/O
  */
    if ( ioctl(sock,(int)FIONBIO,&blocking) < 0 )
	vperror(1,"ioctl(%d)",sock);

 /*
  *  Return the appropriate value
  */
    if ( error ) return(EPKTFAIL);

    if ( timedout ) return(EPKTWAIT);

    if ( pipe ) return(EPKTPIPE);

    return(EPKTOK);
}

/*
 *  Initialize a packet structure
 */
void pktinit(pkt)
pkt_t *pkt;
{
    pkt->allocated = 0;
}

/*
 *  Allocate/Reallocate memory for the packet body
 *
 *  INPUT
 *	pkt		packet containing the body to allocate/reallocate
 *	size		memory size required
 *
 *  RETURN
 *	NULL		malloc/realloc() failed
 *	> 0		body address
 */
char *pktalloc(pkt,size)
pkt_t *pkt;
int size;
{
    if ( !pkt->allocated )
	pkt->netbody = (char*)NULL;

    if ( pkt->allocated < size )
	if ( !(pkt->allocated = (pkt->netbody=remalloc(pkt->netbody,size)) ? size : 0) )
	    vperror(1,"malloc/realloc(%d)",size);

    return(pkt->netbody);
}

/*
 *  Free memory allocated for the packet body
 *
 *  INPUT
 *	pkt		packet containing the body to deallocate
 */
void pktfree(pkt)
pkt_t *pkt;
{
    if ( pkt->allocated > 0 ) {
	pkt->allocated = 0;
	free(pkt->netbody);
    }
}

/*
 *  Read the packet header
 *
 *  INPUT
 *	sock		the socket descriptor to read from
 *	pkt		the packet where to store the header
 *
 *  RETURN
 *	EPKTOK		successful completion
 *	EPKTZERO	received a zero-message
 *	EPKTWAIT	the timeout expired
 *	EPKTFAIL	an error occured
 *	EPKTVERS	invalid version number
 */
int read_pkthdr(sock,pkt,flags)
int sock;
pkt_t *pkt;
int flags;
{
  static int reply;

    if ( (reply = sread(sock,pkt->nethdr,HEADER_NETSIZE,flags)) != EPKTOK )
	return(reply);

    pkt->ptr = pkt->nethdr;
    unmarshall_LONG(pkt->ptr,pkt->version);
    if ( pkt->version != SHIFT_VERSION ) {
	vperror(0,"read_pkthdr(%d): invalid packet version (%x)",sock,pkt->version);
	return(EPKTVERS);
    }
    unmarshall_LONG(pkt->ptr,pkt->request);
    unmarshall_LONG(pkt->ptr,pkt->length);

    return(reply);
}

/*
 *  Read the packet body 
 *
 *  INPUT
 *	sock		the socket descriptor to read from
 *	pkt		the packet where to store the body
 *
 *  RETURN
 *	EPKTOK		successful completion
 *	EPKTZERO	received a zero-message
 *	EPKTWAIT	the timeout expired
 *	EPKTSIZE	invalid packet size
 *	EPKTFAIL	an other error occured
 */
int read_pktbody(sock,pkt,flags)
int sock;
pkt_t *pkt;
int flags;
{
    if ( pkt->length < 1  ||  pkt->length > MAXPKTALLOC ) {
	vperror(0,"read_pktbody(%d): invalid packet size (%d)",sock,pkt->length);
	return(EPKTSIZE);
    }

    if ( pktalloc(pkt,pkt->length) == NULL )
	return(EPKTFAIL);

    return(sread(sock,pkt->netbody,pkt->length,flags));
}

/*
 *  Read a packet
 *
 *  INPUT
 *	sock		the socket descriptor
 *
 *  OUTPUT
 *	pkt		the packet received from the socket
 *
 *  RETURN
 *	EPKTOK		successful completion
 *	EPKTZERO	received a zero-message
 *	EPKTWAIT	the timeout expired
 *	EPKTSIZE	invalid packet size
 *	EPKTVERS	invalid version number
 *	EPKTFAIL	an other error occured
 */
int read_packet(sock,pkt)
int sock;
pkt_t *pkt;
{
  static int reply;

    if ( (reply = read_pkthdr(sock,pkt,0)) != EPKTOK )
	return(reply);

    if ( pkt->length && (reply = read_pktbody(sock,pkt,0)) != EPKTOK )
	return(reply);

#ifdef PKTUTILTRACE
    if ( pktutiltrace) {
	printf("read_packet(%d): request %x/%d\n",sock,pkt->request,pkt->length);
	if ( pktutildump ) {
	    print_dumpmem(pkt->nethdr,HEADER_NETSIZE);
	    if ( pkt->length )
		print_dumpmem(pkt->netbody,pkt->length);
	}
    }
#endif

    return(reply);
}

/*
 *  Write a packet to a socket
 *
 *  INPUT
 *	sock		the socket descriptor
 *	pkt		the packet to write
 *
 *  RETURN
 *	EPKTOK		successful completion
 *	EPKTPIPE	the socket stream is closed (EPIPE)
 *	EPKTWAIT	the timeout expired
 *	EPKTFAIL	an other error occured
 */
int write_packet(sock,pkt)
int sock;
pkt_t *pkt;
{
  static int reply;

    pkt->ptr = pkt->nethdr;
    marshall_LONG(pkt->ptr,SHIFT_VERSION);
    marshall_LONG(pkt->ptr,pkt->request);
    marshall_LONG(pkt->ptr,pkt->length);

#ifdef PKTUTILTRACE
    if ( pktutiltrace) {
	printf("write_packet(%d): request %x/%d\n",sock,pkt->request,pkt->length);
	if ( pktutildump )
	    print_dumpmem(pkt->nethdr,HEADER_NETSIZE);
    }
#endif

    if ( (reply = swrite(sock,pkt->nethdr,HEADER_NETSIZE,0)) != EPKTOK )
	return(reply);

#ifdef PKTUTILTRACE
    if ( pktutiltrace && pktutildump && pkt->length )
	print_dumpmem(pkt->netbody,pkt->length);
#endif

    if ( pkt->length && (reply = swrite(sock,pkt->netbody,pkt->length,0)) != EPKTOK )
	return(reply);

    return(reply);
}
