/*
 * Copyright (C) 1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)shiftconf.c	3.1 06/16/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <string.h>
#include <shift_types.h>
#include <strdup.h>
#include <shiftconf.h>

#define NAMELENGTH	40
#define VTYINT		1
#define VTYSTR		2

#define NOPARAMS	7

struct params {

    char module[NAMELENGTH];
    char attribute[NAMELENGTH];
    char type;
    char **value;
    boolean req;

} params[NOPARAMS] = {

	{ "SHIFT",  "ASCII",	 VTYSTR,  NULL,  0 },
	{ "SHIFT",  "BINARY",	 VTYSTR,  NULL,  0 },
	{ "SHIFT",  "MAKEPORT",	 VTYINT,  NULL,  0 },
	{ "SHIFT",  "DPMPORT",	 VTYINT,  NULL,  0 },
	{ "SHIFT",  "MAKELOG",	 VTYINT,  NULL,  0 },
	{ "SHIFT",  "DPMLOG",	 VTYINT,  NULL,  0 },
	{ "SHIFT",  "LOCALHOST", VTYSTR,  NULL,  0 }	};

/*
 *  Parser macros
 */
#define MODULE		"%[A-Za-z0-9_]"
#define ATTRIBUTE	"%*[\t ]%[A-Za-z0-9_]"
#define VALUE		"%*[\t ]%[A-Za-z0-9_/.-]"
#define SKIPLINE	fscanf(fd,"%*[^\n]\n");fscanf(fd," ")

/*
 *  Read the "/etc/shift.conf" file and load the required information
 *
 *  OUTPUT
 *	ascii		the shift ascii directory path
 *	binary		the shift binary directory path
 *	makeport	the shift make internet service port
 *	dpmport		the shift dpm internet service port
 *	makelog		the shift make log file size limit
 *	dpmlog		the shift dpm log file size limit
 *	localhost	the shift local host name ( used by shift_gethostname() )
 *
 *  RETURN
 *	1		successful completion
 *	-1		error
 */
int getshiftconf(ascii,binary,makeport,dpmport,makelog,dpmlog,localhost)
char **ascii,**binary;
port_t *makeport,*dpmport;
int *makelog,*dpmlog;
char **localhost;
{
  FILE *fd;
  char module[NAMELENGTH];
  char attribute[NAMELENGTH];
  char value[NAMELENGTH];
  int idx;

 /*
  *  See which values are required
  */
    params[0].req = (ascii!=NULL && *(params[0].value=ascii)==NULL);
    params[1].req = (binary!=NULL && *(params[1].value=binary)==NULL);
    params[2].req = (makeport!=NULL && *((int*)(params[2].value=(char**)makeport))<=0);
    params[3].req = (dpmport!=NULL && *((int*)(params[3].value=(char**)dpmport))<=0);
    params[4].req = (makelog!=NULL && *((int*)(params[4].value=(char**)makelog))<0);
    params[5].req = (dpmlog!=NULL && *((int*)(params[5].value=(char**)dpmlog))<0);
    params[6].req = (localhost!=NULL && *(params[6].value=localhost)==NULL);

 /*
  *  If no value is required return
  */
    for (idx=0;idx<NOPARAMS;idx++)
	if ( params[idx].req )
	    break;
    if ( idx == NOPARAMS )
	return(1);

 /*
  *  Open the "/etc/shift.conf" file
  */
    if ( (fd = fopen("/etc/shift.conf","r")) == NULL )
	return(-1);

    while ( !feof(fd) ) {

      /*
       *  Scan the file until either eof or a pair <module,attribute> is reached 
       */
	if ( fscanf(fd,MODULE,module) != 1 ) {
	    SKIPLINE;
	    continue;
	}

	if ( fscanf(fd,ATTRIBUTE,attribute) != 1 ) {
	    SKIPLINE;
	    continue;
	}

     /*
      *  Look for the pair <module,attribute> in the table
      */
	for (idx=0;idx<NOPARAMS;idx++)
	    if ( params[idx].req && 
			!strcasecmp(module,params[idx].module) &&
				!strcasecmp(attribute,params[idx].attribute) )
		break;
     /*
      *  Continue to loop if the pair is either unknown or not required
      */
	if ( idx == NOPARAMS ) {
	    SKIPLINE;
	    continue;
	}

     /*
      *  Get the pair's value
      */
	if ( fscanf(fd,VALUE,value) != 1 ) {
	    SKIPLINE;
	    continue;
	}

     /*
      *  Convert and copy-out the value
      */
	if ( params[idx].type == VTYINT )
		*((int*)params[idx].value) = (int)atoi(value);
	else
		*(params[idx].value) = strdup(value);

	SKIPLINE;
    }

    fclose(fd);
    return(1);
}
