/*
 * Copyright (C) 1990,1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)strerror.c	3.2 03/21/94 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <varargs.h>
#ifndef apollo
#include <unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <shift_types.h>
#include <strdup.h>
#include <flock.h>
#include <strerror.h>

static FILE *vperror_stream = { stderr };
static path_t vperror_file;
static int vperror_size;
static long vperror_offset;
static int vperror_state = OK;
static char vperror_msg[VPERROR_MSGLENGTH]; 
static boolean vperror_silent = FALSE;

#define BIT_ERRNO   0x1
#define BIT_TIME    0x2
#define EOF_STR	    "END LOG FILE\n"
	
#if defined( sun )  ||  defined( apollo )

extern int sys_nerr;
extern char *sys_errlist[];

/*
 *  The strerror() is missing on the Sun and Apollo System
 *
 *  INPUT
 *	errno		an error number
 *
 *  RETURN
 *	the message string corresponding to the given errno
 */
char *strerror(errno)
int errno;
{
  static char *zero_error = "Error 0";
  static char unknwon_error[30];

    if ( errno < sys_nerr  &&  errno > 0 )
	return(sys_errlist[errno]);
    else
    if ( errno == 0 )
	return(zero_error);
    else {
	sprintf(unknwon_error,"Unknown error: %d",errno);
	return(unknwon_error);
    }
}

#endif

/*
 *  Extension of the perror() accepting a variable argument list
 *
 *  INPUT
 *	va_alist	variable argument list 
 *			(int , format string , argument list)
 *
 *  OUTPUT
 *	the input message is written to the selected stream preceded, only if
 *	required, by a time stamp and followed, only if required, by a colon
 *      and the message string associated to the global variable errno
 */
void vperror(va_alist)
 va_dcl
{
  va_list args;
  char *fmt;
  int flag,vperrno;
  time_t timenow;

 /*
  *  Initialization
  */
    vperrno = errno;
    vperror_state = ERROR;
    time((time_t*)&timenow);

 /*
  *  Get the flag and the format string from the argument list
  */
    va_start(args);
    flag = va_arg(args,int);
    fmt = va_arg(args,char*);

 /*
  *  Write the time stamp ( only if required ) and the error message given in input
  */
    if ( !(flag & BIT_TIME) )
	vsprintf(vperror_msg,fmt,args);
    else {
	sprintf(vperror_msg,"%s  ",ctimeln(&timenow));
	vsprintf(vperror_msg+strlen(vperror_msg),fmt,args);
    }

 /*
  *  Append the error message associated to the errno ( only if required )
  */
    if ( flag & BIT_ERRNO ) {
	strcat(vperror_msg,": ");
	strcat(vperror_msg,strerror(vperrno));
    }

 /*
  *  Write the complete message to the error stream unless the silent mode is selected
  */
    if ( !vperror_silent ) {

     /*
      *  Lock and seek to the correct position ( only if a disk file is selected )
      */
	if ( fdtono(vperror_stream) > STDERR_FILENO ) {
	    flock(fdtono(vperror_stream),LOCK_EX);
	    fseek(vperror_stream,-strlen(EOF_STR), 2);
	}

	fprintf(vperror_stream,"%s\n",vperror_msg);
	ctrl_vperror(VPLOGCTRL);

     /*
      *  Unlock the file ( only if a disk file is selected )
      */
	if ( fdtono(vperror_stream) > STDERR_FILENO ) {
            fflush(vperror_stream);
	    flock(fdtono(vperror_stream),LOCK_UN);
	}
    }

 /*
  *  Restore the global error number
  */
    errno = vperrno;
    va_end(args);
}

/*
 *  Return and clear the vperror state
 */
int clear_vperror()
{
    if ( vperror_state > 0 )
	return(OK);
    else {
	vperror_state = OK;
	return(ERROR);
    }
}

/*
 *  Return the vperror state
 */
int get_vperror()
{
    return(vperror_state);
}

/*
 *  Return the last vperror message
 */
char *str_vperror()
{
    return(vperror_msg);
}

/*
 *  Return a copy of the last vperror message
 */
char *strdup_vperror()
{
    return(strdup(vperror_msg));
}

/*
 *
 *  VALID CALLS
 *	ctrl_vperror( VPDISABLE 		   )
 *	ctrl_vperror( VPENABLE  		   )
 *	ctrl_vperror( VPISENABLED 	 	   )
 *	ctrl_vperror( VPLOGERR 			   )
 *	ctrl_vperror( VPLOGFILE, filename, maxsize )
 *	ctrl_vperror( VPLOGCTRL 		   )
 */
int ctrl_vperror(va_alist)
 va_dcl
{
  va_list args;

    va_start(args);
    switch ( va_arg(args,int) ) {
	case VPDISABLE :
		vperror_silent = TRUE;
		break;
	case VPENABLE :
		vperror_silent = FALSE;
		break;
	case VPISENABLED :
		return(vperror_silent);
	case VPLOGERR :
		if ( fdtono(vperror_stream) > STDERR_FILENO )
		    fclose(vperror_stream);
		vperror_stream = stderr;
		break;
	case VPLOGFILE :
		strcpy(vperror_file,va_arg(args,char*));
		vperror_size = va_arg(args,int);
		if ( (vperror_stream = fopen(vperror_file,"r+")) == NULL ) {
		    if ( (vperror_stream = fopen(vperror_file,"w+")) == NULL ) {
			vperror_stream = stderr;
			vperror(1,"fopen(%s)",vperror_file);
			return(-1);
		    }
		}
		break;
	case VPLOGCTRL :
		if ( fdtono(vperror_stream) > STDERR_FILENO ) {
		    fprintf(vperror_stream,"%s",EOF_STR);
		    fflush(vperror_stream);
		}
		break;
	default :
		return(-1);
    } /* switch - ctrl code */
    va_end(args);
    return(1);
}
