/*
 * Copyright (C) 1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)strtok.c	3.1 06/16/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <string.h>
#include <strdup.h>

/*
 *  SGI bug :   the gethostbyname() cannot be called during a strtok() call sequence!
 *		after such a call the strtok() doesn't return the next token even if
 *		if exists
 *
 *  GENERIC :   (noticed on SunOS) the strtok() destroies the original string
 *		because it doesn't resume the separator characters deleted by 
 *		the End of String 
 */
char *sgi_strtok(s1,s2)
char *s1,*s2;
{
  static char *strtok_s1;
  static int  strtok_s1_len = -1;
  static char *ptr;
  static int  ptr_len;

    if ( s1 != NULL ) {
	if ( strtok_s1_len > -1 ) free(strtok_s1);
	strtok_s1 = strdup(s1);
	strtok_s1_len = strlen(strtok_s1);
	ptr = s1;
	return( strtok(s1,s2) );
    }
    else {
	if ( strtok_s1_len < 0 )
	    return( strtok(s1,s2) );
	ptr_len = strlen(ptr);
	if ( ptr_len < strtok_s1_len ) {
	    ptr[ptr_len] = strtok_s1[ptr_len];
	    return( strtok(ptr+ptr_len,s2) );
	}
	else
	    return( (char*)NULL );
    }
}


