/*
 * Copyright (C) 1990-1995 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)strutil.c	3.4 12/18/95 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#define __STRING_UTIL_C__

#define MULT_INPRINTF

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#ifndef apollo
#include <malloc.h>
#endif
#include <ctype.h>
#include <shift_types.h>
#include <strdup.h>
#include <strutil.h>

/*
 *  If MULTI_INPRINTF is defined then MAX_INPRINTF calls 
 *  in the same printf are allowed
 */

#ifdef MULT_INPRINTF

#define	MAX_INPRINTF		5
#define DEC_INPRINTF		[MAX_INPRINTF]
#define IDX(idx)		[idx]
#define INC_IDX(idx)		[idx++]
#define ROUND_IDX(idx)		if ( idx == MAX_INPRINTF )   idx = 0 

#else

#define DEC_INPRINTF
#define IDX(idx)
#define INC_IDX(idx)
#define ROUND_IDX(idx)

#endif

#define YNLEN		5
#define TIMELEN_DPM	30
#define INTLEN		20
#define FLOATLEN	40

#define MAXUNIT		5
static char		*unitmnemo[MAXUNIT] = { "", "K", "M", "G", "T" } ;

static char		stryn DEC_INPRINTF [YNLEN];
static char		strtime DEC_INPRINTF [TIMELEN_DPM];
static char		strint DEC_INPRINTF [INTLEN];
static char		strfloat DEC_INPRINTF [FLOATLEN];

#ifdef MULT_INPRINTF

static int		idxyn		= 0 ;
static int		idxtime		= 0 ;
static int		idxint		= 0 ;
static int		idxfloat	= 0 ;

#endif

#if defined( sun ) && !defined(SOLARIS)

/*
 *  Compare two strings and ignore differences in case
 *
 *  RETURN
 *	it returns an integer greater than, equal to, or less than 0, according
 *	as 'str' is lexicographically greater than, equal to, or less than 'cmp'
 */
int strcasecmp(str,cmp)
char  *str;
char  *cmp;
{
    while ( *str != EOS && *cmp != EOS ) {
	if ( uppercase(*str) != uppercase(*cmp) ) return((*str)-(*cmp));
	str++;
	cmp++;
    }

    if ( *str != *cmp ) return((*str)-(*cmp));

    return(0);
}

/*
 *  Compare at most `len` characters of two strings and ignore differences in case
 *
 *  RETURN
 *	it returns an integer greater than, equal to, or less than 0, according
 *	as 'str' is lexicographically greater than, equal to, or less than 'cmp'
 */
int strncasecmp(str,cmp,len)
char  *str;
char  *cmp;
int   len;
{
    while ( *str != EOS && *cmp != EOS && len > 0 ) {
	if ( uppercase(*str) != uppercase(*cmp) ) return((*str)-(*cmp));
	str++; 
	cmp++;
	len--;
    }

    if ( len > 0 && *str != *cmp ) return((*str)-(*cmp));

    return(0);
}

#endif

/*
 *  Compare two strings. If the case sensitive mode is selected then it ignores 
 *  differences in case. If the prefix mode is selected then the 'cmp' string can
 *  be a prefix of 'str'.
 *
 *  INPUT
 *	str		comparative string
 *	cmp		string to compare
 *	casesn		case sensitive mode
 *	prefix		prefix mode
 *
 *  RETURN
 *	it returns an integer greater than, equal to, or less than 0, according
 *	as 'str' is lexicographically greater than, equal to, or less than 'cmp'
 */ 
int cmpstrings(str,cmp,casesn,prefix)
char     *str;
char	 *cmp;
boolean  casesn;
boolean  prefix;
{
    if ( casesn )
	if ( prefix )
	    return(strncmp(str,cmp,strlen(cmp)));
	else
	    return(strcmp(str,cmp));
    else
	if ( prefix )
	    return(strncasecmp(str,cmp,strlen(cmp)));
	else
	    return(strcasecmp(str,cmp));
}

/*
 *  INPUT
 *	ptr	either a pointer to memory or NULL
 *	size	size in bytes of the required allocation
 *
 *  RETURN
 *	if it succeed then it returns the pointer to the allocated memory otherwise NULL
 */
char *remalloc(ptr,size)
char  *ptr;
int   size;
{
  static char  *new;

    if ( ptr == NULL )
	ptr = (char*)malloc((size_t)size);
    else {
	if ( (new=(char*)realloc(ptr,(size_t)size)) != NULL ) 
	    ptr = new;
	else {
	    free(ptr);
	    ptr = (char*)NULL;
	}
    }

    return(ptr);
}

/*
 *
 */
char *strmcpy(ptr,len,str)
char  **ptr;
int   *len;
char  *str;
{
    if ( *len < 0 )
	return( (char*)NULL );

    if ( str == NULL ) {
	if ( *ptr ) free(*ptr);
	*len = -1;
	return( (char*)NULL );
    }

    if ( *len == 0 ) {
	if ( (*ptr = strdup(str)) != NULL ) {
		*len = strlen(str)+1;
		return( *ptr);
	}
    }
    else
    if ( *len > (int)strlen(str) ) {
	strcpy(*ptr,str);
	return( *ptr);
    }
    else {
	*len = strlen(str)+1;
	if ( (*ptr = (char*)remalloc(*ptr,(size_t)*len)) != NULL ) {
		strcpy(*ptr,str);
		return( *ptr);
	}
    }

    *len = -1;

    return( (char*)NULL );
}

/*
 *
 */
char *strmcat(ptr,len,str)
char  **ptr;
int   *len;
char  *str;
{
    if ( *len < 0 )
	return( (char*)NULL );

    if ( str == NULL ) {
	if ( *ptr ) free(*ptr);
	*len = -1;
	return( (char*)NULL );
    }

    if ( *len == 0 ) {
	if ( (*ptr = strdup(str)) != NULL ) {
		*len = strlen(str)+1;
		return( *ptr);
	}
    }
    else
    if ( *len > (int)strlen(*ptr)+ (int)strlen(str) ) {
	strcat(*ptr,str);
	return( *ptr );
    }
    else {
	*len = strlen(*ptr)+strlen(str)+1;
	if ( (*ptr = (char*)remalloc(*ptr,(size_t)*len)) != NULL ) {
		strcat(*ptr,str);
		return( *ptr );
	}
    }

    *len = -1;

    return( (char*)NULL );
}

/*
 *
 */
int INIT_string(str,len)
string  *str;
int	len;
{
/* I: { ALLOC(str) } */

    str->len = len > 0 ? len+1 : INIT_LEN_STRING+1 ;
    if ( str->len > 0 ) {
	if ( (str->data=(char*)malloc((size_t)str->len)) == NULL ) {
		str->len = -1;
		return( ERROR );
	}
	*str->data = EOS;
    }
    else
	str->data = NULL;
    return( TRUE );    	

/* O: { I & (str->len<=0 | (str->len>0 & ALLOC(str->data) & ZERO(str->data))) }  */
}

/*
 *  Not Correct!!
 */
int DUP_string(dst,src)
string  *dst,*src;
{
/* I: { src->len<=0 | (src->len>0 & ALLOC(src->data)) } */

    if ( src->len > 0 ) {
	if ( CPY_string(dst,src->data) < 0 )
	    return( ERROR );
    }
    else
	dst->len = src->len;

    return( TRUE );
}

/*
 *
 */
void FREE_string(str)
string  *str;
{
/* I: { str->len<=0 | (str->len>0 & ALLOC(str->data)) } */

    if ( str->len > 0 ) {
	str->len = 0;
	free(str->data);
    }

/* O: { str->len<=0 } */
}

/*
 *
 */
void PRINT_string(str)
string  *str;
{
    if ( LEN_string(str) < 0 )
	printf("()[-1]\n");
    else
	printf("%s(%d)[%d]\n",GET_string(str),strlen(GET_string(str)),LEN_string(str));
}

/*
 *
 */
int CPY_string(str,s)
string  *str;
char	*s;
{
/* I: { str->len<=0 | ( str->len > 0  &  ALLOC(str->data) ) } */
    return( strmcpy(&str->data,&str->len,s) == NULL ? ERROR : TRUE );
}

/*
 *
 */
int CAT_string(str,s)
string  *str;
char	*s;
{
/* I: { str->len<=0 | ( str->len > 0  &  ALLOC(str->data) ) } */
    return( strmcat(&str->data,&str->len,s) == NULL ? ERROR : TRUE );
}

/*
 *
 */
char *mkfield(str,length)
char  *str;
int   length;
{
  static char  *ptr = NULL ;
  static int   plen;
  static char  *blanks = NULL ;
  static int   blen    = 0 ;
  static int   flen;

    plen = 0;

    if ( ptr )   free(ptr);

    if ( (flen = abs(length) - strlen(str)) > 0 ) {
	    if ( flen > blen )
		    if ( (blanks = remalloc(blanks,flen+1)) == NULL ) {
			    blen = 0;
			    return( (char*)NULL );
		    }
		    else
			    blen = flen;
	    memset(blanks,(char)32,(size_t)flen);
	    blanks[flen] = EOS;
    }
    else
	    return( strmcat(&ptr,&plen,str) );


    if ( length > 0 ) {
	    strmcat(&ptr,&plen,str);
    	    return( strmcat(&ptr,&plen,blanks) );
    }
    else {
	    strmcat(&ptr,&plen,blanks);
	    return( strmcat(&ptr,&plen,str) );
    }


/*NOTREACHED*/
#ifdef lint
    return( (char*)NULL );
#endif

}

/*
 *  Convert a boolean value into a string YES / NO or Y / N
 */
char *itoyn(n)
boolean  n;
{
	ROUND_IDX(idxyn);
	if ( n ) 
		return( strcpy(stryn INC_IDX(idxyn) ,"YES") );
	else 
		return( strcpy(stryn INC_IDX(idxyn) ,"NO") );
}

char *itoyns(n)
boolean  n;
{
	ROUND_IDX(idxyn);
	if ( n ) 
		return( strcpy(stryn INC_IDX(idxyn) ,"Y") );
	else 
		return( strcpy(stryn INC_IDX(idxyn) ,"N") );
}

/*
 *  Convert a time value into a string
 */
char *ctimeln(vtime)
time_t  *vtime;
{
	ROUND_IDX(idxtime);

	strcpy(strtime IDX(idxtime) ,ctime(vtime));
	strtime IDX(idxtime) [strlen(strtime IDX(idxtime) )-1] = EOS;

	return( strtime INC_IDX(idxtime)  );
}

char *ctimeyear(vtime)
time_t  *vtime;
{
	ROUND_IDX(idxtime);

	strcpy(strtime IDX(idxtime) ,ctime(vtime));
	strtime IDX(idxtime) [19] = EOS;

	return( strtime INC_IDX(idxtime)  );
}

char *ctimeweek(vtime)
time_t  *vtime;
{
	ROUND_IDX(idxtime);

	strcpy(strtime IDX(idxtime) ,ctime(vtime));
	strtime IDX(idxtime) [19] = EOS;

	return( strtime INC_IDX(idxtime) +4 );
}

char *ctimeweeksec(vtime)
time_t  *vtime;
{
	ROUND_IDX(idxtime);

	strcpy(strtime IDX(idxtime) ,ctime(vtime));
	strtime IDX(idxtime) [16] = EOS;

	return( strtime INC_IDX(idxtime) +4 );
}

char *ctimeday(vtime)
time_t  *vtime;
{
	ROUND_IDX(idxtime);

	strcpy(strtime IDX(idxtime) ,ctime(vtime));
	strtime IDX(idxtime) [19] = EOS;

	return( strtime INC_IDX(idxtime) +11 );
}

/*
 *  Convert an integer to string
 */
char *itoa(num)
int	num;
{
	ROUND_IDX(idxint);

	sprintf(strint IDX(idxint) ,"%d",num);

	return( strint INC_IDX(idxint)  );
}	

/*
 *  Convert an integer to a string of the form <number><unit> where unit
 *  can be (G)iga (M)ega (K)ilo or an empty string for byte unit and where 
 *  number is a multiple of unit
 */
char *itoanmu(inum)
int  inum;
{
  static int	ord;

	ord = 0;
	while ( inum > 0  &&  inum%1024 == 0  &&  ord < MAXUNIT-1 ) {
		  inum = inum/1024;
		  ord++;
	}
	return( strcat(itoa(inum),unitmnemo[ord]) );
}

/*
 *  Convert a string of type <number><unit> to a float
 */
float anutof(afloat)
char  *afloat;
{
  char	 unitch;			/* unit character 		*/
  float	 ord;				/* unit value			*/
  int	 value;				/* string value			*/
  char   str[FLOATLEN];			/* local copy of strfloat	*/
  char   *ptr;
      /*
      **  Make the local copy of the string
      */
	strcpy(str,afloat);

      /*
      **  Get the unit character and its value
      */
	ord = 1.0; 
	switch ( ( unitch = str[strlen(str)-1] ) ) {
	    case 'G' :  ord = ord * 1024.0;	
	    case 'M' :  ord = ord * 1024.0;
	    case 'K' :  ord = ord * 1024.0;
			str[strlen(str)-1] = EOS;
			break;
	    default  :  if ( !isdigit(unitch) )	
				return( (float)-1 );
	} /* switch - unit */

	if ( (value=strtol(str,&ptr,10)) < 0  ||  *ptr != EOS )
			 return( (float)-2 );

	return( ord*value );

}

/*
 *  Convert a float to string
 *
 *  INPUT
 *	fnum		the float number to convert
 *	significant	max number of significant digits ( the first zero before the
 *			decimal point is not a significant digit if the float is less
 *			then 1 ) to compute the remaining decimal digits
 *	decimal		max number of decimal digits
 *
 *  RETURN
 *	pointer to the string
 */
char *cfloat(fnum,significant,decimal)
double	fnum;
int	significant;
int	decimal;
{
  static int	digits;
  static int	idx,idxpoint;

	ROUND_IDX(idxfloat);

        digits = fabs((double)fnum) < 1.0 ? 0 : (int)log10(fabs((double)fnum))+1 ;

	if ( digits > significant )
		digits = 0;
	else
	if ( significant - digits > decimal )
		digits = decimal;
	else
		digits = significant - digits ;

	sprintf(strfloat IDX(idxfloat) ,"%f",fnum);

	for (;;) {

	      /*
	      **  Skip zero characters from the rigth
	      */
		idx = strlen(strfloat IDX(idxfloat) ) - 1 ;
		while ( strfloat IDX(idxfloat) [idx] == '0' ) idx-- ;

	      /*
	      **  If the dot character has been reached then return otherwise
	      **  see if there are too many decimal digits
	      */
		if ( strfloat IDX(idxfloat) [idx] == '.' ) {
			strfloat IDX(idxfloat) [idx] = EOS;
			return( strfloat INC_IDX(idxfloat)  );
		}
		else {
			idxpoint = idx - 1;
			while ( strfloat IDX(idxfloat) [idxpoint] != '.' ) idxpoint-- ;
			if ( idxpoint+digits >= idx ) {
				strfloat IDX(idxfloat) [idx+1] = EOS;
				return( strfloat INC_IDX(idxfloat)  );
			}
			else
				strfloat IDX(idxfloat) [idxpoint+digits+1] = EOS;
		}

	} /* loop */
}

/*
 *  Convert a float to a string of the form <number><unit> where unit
 *  can be (G)iga (M)ega (K)ilo or an empty string for byte unit
 *
 *  INPUT
 *	fnum		the float to convert
 */
char *ftoanu(fnum)
double fnum;
{
  static int	ord; 

	ord = 0; 
	while ( fnum >= 1024.0  &&  ord < MAXUNIT-1 ) {
		  fnum = fnum/1024.0;
		  ord++;
	}
	return( strcat(cfloat(fnum,3,2),unitmnemo[ord]) );
}

int atoinum(str,inum)
char  *str;
int   *inum;
{
  int  k;

    for ( k=0;  k< (int)strlen(str);  k++ )
	if (!isdigit(str[k]))
	    return ( ERROR );

    *inum = atoi(str);

    return( TRUE );
}


