/*
 * Copyright (C) 1991,1992 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)user.c	3.1 06/16/92 CERN-SW/DC Fabrizio Cane";
#endif /* not lint */

#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <grp.h>
#include <user.h>

/*
 *  INPUT
 *	name		user name
 *
 *  OUTPUT
 *	uid		the user uid ( if required )
 *	gid		the user gid ( if required )
 *
 *  RETURN
 *	1		successful completion
 *	-1		getpwnam() failed
 */
int get_userbyname(name,uid,gid)
char  *name;
int   *uid,*gid;
{
  static struct passwd  *useri;

    if ( (useri = (struct passwd *)getpwnam(name)) == NULL ) return(-1);
    if ( uid != NULL )   *uid = useri->pw_uid;
    if ( gid != NULL )   *gid = useri->pw_gid;
    return(1);
}

/*
 *  INPUT
 *	uid		user uid
 *
 *  OUTPUT
 *	name		the user name ( if required )
 *	gid		the user gid ( if required )
 *
 *  RETURN
 *	1		successful completion
 *	-1		getpwuid() failed
 */
int get_userbyid(name,uid,gid)
char  *name;
int   uid,*gid;
{
  static struct passwd  *useri;

    if ( (useri = (struct passwd *)getpwuid(uid)) == NULL ) return(-1);
    if ( name != NULL )   strcpy(name,useri->pw_name);
    if ( gid != NULL )   *gid = useri->pw_gid;
    return(1);
}

/*
 *  INPUT
 *	name		group name
 *
 *  OUTPUT
 *	gid		the group gid ( if required )
 *
 *  RETURN
 *	1		successful completion
 *	-1		getgrnam() failed
 */
int get_groupbyname(name,gid)
char  *name;
int   *gid;
{
  static struct group  *groupi;

    if ( (groupi = (struct group*)getgrnam(name)) == NULL ) return(-1);
    *gid = groupi->gr_gid;
    return(1);
}

/*
 *  INPUT
 *	gid		group gid
 *
 *  OUTPUT
 *	name		the group name ( if required )
 *
 *  RETURN
 *	1		successful completion
 *	-1		getgrgid() failed
 */
int get_groupbyid(name,gid)
char  *name;
int   gid;
{
  static struct group  *groupi;

    if ( (groupi = (struct group*)getgrgid(gid)) == NULL ) return(-1);
    strcpy(name,groupi->gr_name);
    return(1);
}

/*
 *  INPUT
 *	uid		user uid
 *
 *  OUTPUT
 *	user		the user name ( if required )
 *	group		the group name ( if required )
 *	gid		the user gid ( if required )
 *
 *  RETURN
 *	1		successful completion
 *	-1		either getpwuid() or get_groupbyid() failed
 */
int get_allbyuid(user,group,gid,uid)
char  *user;
char  *group;
int   *gid;
int   uid;
{
  static struct passwd  *useri;

    if ( (useri = (struct passwd *)getpwuid(uid)) == NULL ) return(-1);
    if ( user != NULL )   strcpy(user,useri->pw_name);
    if ( gid != NULL )   *gid = useri->pw_gid;
    if ( group != NULL )   return( get_groupbyid(group,useri->pw_gid) );
    return(1);
}

/*
 *  The shift user/group name and uid/gid are an extension of the system accounts.
 *  
 *	USER NAME / GROUP NAME		UID / GID
 *     ---------------------------------------------------
 *	user 	 / group		uid     / gid		system accounts
 *	ANY_USER / ANY_GROUP		ANY_UID / ANY_GID	any accounts
 *	UNKSHFUSER + <number>		number			unknown accounts
 */

/*
 *  INPUT
 *	user		shift user name
 *
 *  OUTPUT
 *	uid		the shift user uid
 *	gid		the user gid unless the type is not 0
 *	type		the user name type (0/user name - 1/any user - 2/_<user id>)
 *
 *  RETURN
 *	1		successful completion
 *	-1		get_userbyname() failed
 */
int get_shiftuserbyname(user,uid,gid,type)
char  *user;
int   *uid;
int   *gid;
int   *type;
{
  static char *ptr;

    if ( !strcmp(user,ANY_USER) ) {
	*uid = ANY_UID;
        *type = 1;
	return(1);
    }

    if ( !strncmp(user,UNKSHFUSER,strlen(UNKSHFUSER)) && strcmp(user,UNKSHFUSER) ) {
	*uid = (int)strtol(user+strlen(UNKSHFUSER),&ptr,10);
	if ( ptr == user+strlen(user) ) {
	    *type = 2;
	    return(1);
	}
    }

    *type = 0;
    return(get_userbyname(user,uid,gid));
}

/*
 *  INPUT
 *	uid		shift user uid
 *
 *  OUTPUT
 *	user		the shift user name
 *
 *  RETURN
 *	1		successful completion
 *	-1		get_userbyid()
 */
int get_shiftuserbyid(user,uid)
char  *user;
int   uid;
{
    if ( uid == ANY_UID )
	strcpy(user,ANY_USER);
    else
    if ( get_userbyid(user,uid,(int*)NULL) < 0 )
	sprintf(user,"%s%d",UNKSHFUSER,uid);

    return(1);
}

/*
 *  INPUT
 *	group		shift group name
 *
 *  OUTPUT
 *	gid		the shift group gid
 *	type		the group name type (0/group name - 1/any group - 2/_<group id>)
 *
 *  RETURN
 *	1		successful completion
 *	-1		get_groupbyname() failed
 */
int get_shiftgroupbyname(group,gid,type)
char  *group;
int   *gid;
int   *type;
{
  static char *ptr;

    if ( !strcmp(group,ANY_GROUP) ) {
	*gid = ANY_GID;
	*type = 1;
	return(1);
    }

    if ( !strncmp(group,UNKSHFUSER,strlen(UNKSHFUSER)) && strcmp(group,UNKSHFUSER) ) {
	*gid = (int)strtol(group+strlen(UNKSHFUSER),&ptr,10);
	if ( ptr == group+strlen(group) ) {
	    *type = 2;
	    return(1);
	}
    }

    *type = 0;
    return(get_groupbyname(group,gid));
}

/*
 *  INPUT
 *	gid		shift group gid
 *
 *  OUTPUT
 *	group		the shift group name
 *
 *  RETURN
 *	1		successful completion
 *	-1		get_groupbyid()
 */
int get_shiftgroupbyid(group,gid)
char  *group;
int   gid;
{
    if ( gid == ANY_GID )
	strcpy(group,ANY_GROUP);
    else
    if ( get_groupbyid(group,gid) < 0 )
	sprintf(group,"%s%d",UNKSHFUSER,gid);

    return(1);
}

